/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import android.graphics.Rect;
import android.os.Handler;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.Window;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class PixelCopy {
    public static final int SUCCESS = 0;
    public static final int ERROR_UNKNOWN = 1;
    public static final int ERROR_TIMEOUT = 2;
    public static final int ERROR_SOURCE_NO_DATA = 3;
    public static final int ERROR_SOURCE_INVALID = 4;
    public static final int ERROR_DESTINATION_INVALID = 5;

    public static void request(SurfaceView source, Bitmap dest, OnPixelCopyFinishedListener listener, Handler listenerThread) {
        PixelCopy.request(source.getHolder().getSurface(), dest, listener, listenerThread);
    }

    public static void request(SurfaceView source, Rect srcRect, Bitmap dest, OnPixelCopyFinishedListener listener, Handler listenerThread) {
        PixelCopy.request(source.getHolder().getSurface(), srcRect, dest, listener, listenerThread);
    }

    public static void request(Surface source, Bitmap dest, OnPixelCopyFinishedListener listener, Handler listenerThread) {
        PixelCopy.request(source, null, dest, listener, listenerThread);
    }

    public static void request(Surface source, Rect srcRect, Bitmap dest, final OnPixelCopyFinishedListener listener, final Handler listenerThread) {
        PixelCopy.validateBitmapDest(dest);
        if (!source.isValid()) {
            throw new IllegalArgumentException("Surface isn't valid, source.isValid() == false");
        }
        if (srcRect != null && srcRect.isEmpty()) {
            throw new IllegalArgumentException("sourceRect is empty");
        }
        HardwareRenderer.copySurfaceInto(source, new HardwareRenderer.CopyRequest(srcRect, dest){

            @Override
            public void onCopyFinished(int result) {
                listenerThread.post(() -> listener.onPixelCopyFinished(result));
            }
        });
    }

    public static void request(Window source, Bitmap dest, OnPixelCopyFinishedListener listener, Handler listenerThread) {
        PixelCopy.request(source, null, dest, listener, listenerThread);
    }

    public static void request(Window source, Rect srcRect, Bitmap dest, OnPixelCopyFinishedListener listener, Handler listenerThread) {
        PixelCopy.validateBitmapDest(dest);
        Rect insets = new Rect();
        Surface surface = PixelCopy.sourceForWindow(source, insets);
        PixelCopy.request(surface, PixelCopy.adjustSourceRectForInsets(insets, srcRect), dest, listener, listenerThread);
    }

    private static void validateBitmapDest(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap cannot be null");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled");
        }
        if (!bitmap.isMutable()) {
            throw new IllegalArgumentException("Bitmap is immutable");
        }
    }

    private static Surface sourceForWindow(Window source, Rect outInsets) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (source.peekDecorView() == null) {
            throw new IllegalArgumentException("Only able to copy windows with decor views");
        }
        Surface surface = null;
        ViewRootImpl root = source.peekDecorView().getViewRootImpl();
        if (root != null) {
            surface = root.mSurface;
            Rect surfaceInsets = root.mWindowAttributes.surfaceInsets;
            outInsets.set(surfaceInsets.left, surfaceInsets.top, root.mWidth + surfaceInsets.left, root.mHeight + surfaceInsets.top);
        }
        if (surface == null || !surface.isValid()) {
            throw new IllegalArgumentException("Window doesn't have a backing surface!");
        }
        return surface;
    }

    private static Rect adjustSourceRectForInsets(Rect insets, Rect srcRect) {
        if (srcRect == null) {
            return insets;
        }
        if (insets != null) {
            srcRect.offset(insets.left, insets.top);
        }
        return srcRect;
    }

    public static void request(Request request, Executor callbackExecutor, Consumer<Result> listener) {
        request.request(callbackExecutor, listener);
    }

    private PixelCopy() {
    }

    public static interface OnPixelCopyFinishedListener {
        public void onPixelCopyFinished(int var1);
    }

    public static class Request {
        private final Surface mSource;
        private final Rect mSourceInsets;
        private Rect mSrcRect;
        private Bitmap mDest;

        private Request(Surface source, Rect sourceInsets) {
            this.mSource = source;
            this.mSourceInsets = sourceInsets;
        }

        public Bitmap getDestinationBitmap() {
            return this.mDest;
        }

        public Rect getSourceRect() {
            return this.mSrcRect;
        }

        public void request(final Executor callbackExecutor, final Consumer<Result> listener) {
            if (!this.mSource.isValid()) {
                callbackExecutor.execute(() -> listener.accept(new Result(4, null)));
                return;
            }
            HardwareRenderer.copySurfaceInto(this.mSource, new HardwareRenderer.CopyRequest(PixelCopy.adjustSourceRectForInsets(this.mSourceInsets, this.mSrcRect), this.mDest){

                @Override
                public void onCopyFinished(int result) {
                    callbackExecutor.execute(() -> listener.accept(new Result(result, this.mDestinationBitmap)));
                }
            });
        }

        public static class Builder {
            private Request mRequest;

            private Builder(Request request) {
                this.mRequest = request;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            public static Builder ofWindow(Window source) {
                Rect insets = new Rect();
                Surface surface = PixelCopy.sourceForWindow(source, insets);
                return new Builder(new Request(surface, insets));
            }

            @SuppressLint(value={"BuilderSetStyle"})
            public static Builder ofWindow(View source) {
                if (source == null || !source.isAttachedToWindow()) {
                    throw new IllegalArgumentException("View must not be null & must be attached to window");
                }
                Rect insets = new Rect();
                Surface surface = null;
                ViewRootImpl root = source.getViewRootImpl();
                if (root != null) {
                    surface = root.mSurface;
                    insets.set(root.mWindowAttributes.surfaceInsets);
                }
                if (surface == null || !surface.isValid()) {
                    throw new IllegalArgumentException("Window doesn't have a backing surface!");
                }
                return new Builder(new Request(surface, insets));
            }

            @SuppressLint(value={"BuilderSetStyle"})
            public static Builder ofSurface(Surface source) {
                if (source == null || !source.isValid()) {
                    throw new IllegalArgumentException("Source must not be null & must be valid");
                }
                return new Builder(new Request(source, null));
            }

            @SuppressLint(value={"BuilderSetStyle"})
            public static Builder ofSurface(SurfaceView source) {
                return Builder.ofSurface(source.getHolder().getSurface());
            }

            private void requireNotBuilt() {
                if (this.mRequest == null) {
                    throw new IllegalStateException("build() already called on this builder");
                }
            }

            public Builder setSourceRect(Rect srcRect) {
                this.requireNotBuilt();
                this.mRequest.mSrcRect = srcRect;
                return this;
            }

            public Builder setDestinationBitmap(Bitmap destination) {
                this.requireNotBuilt();
                if (destination != null) {
                    PixelCopy.validateBitmapDest(destination);
                }
                this.mRequest.mDest = destination;
                return this;
            }

            public Request build() {
                this.requireNotBuilt();
                Request ret = this.mRequest;
                this.mRequest = null;
                return ret;
            }
        }
    }

    public static class Result {
        private int mStatus;
        private Bitmap mBitmap;

        private Result(int status, Bitmap bitmap) {
            this.mStatus = status;
            this.mBitmap = bitmap;
        }

        public int getStatus() {
            return this.mStatus;
        }

        private void validateStatus() {
            if (this.mStatus != 0) {
                throw new IllegalStateException("Copy request didn't succeed, status = " + this.mStatus);
            }
        }

        public Bitmap getBitmap() {
            this.validateStatus();
            return this.mBitmap;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CopyResultStatus {
    }
}

