/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ActivityManager;
import android.app.WindowConfiguration;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.GraphicsProtos;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import android.view.SurfaceControl;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RemoteAnimationTarget
implements Parcelable {
    public static final int MODE_OPENING = 0;
    public static final int MODE_CLOSING = 1;
    public static final int MODE_CHANGING = 2;
    @UnsupportedAppUsage
    public final int mode;
    @UnsupportedAppUsage
    public final int taskId;
    @UnsupportedAppUsage
    public final SurfaceControl leash;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final SurfaceControl startLeash;
    @UnsupportedAppUsage
    public final boolean isTranslucent;
    @UnsupportedAppUsage
    public final Rect clipRect;
    @UnsupportedAppUsage
    public final Rect contentInsets;
    @Deprecated
    @UnsupportedAppUsage
    public final int prefixOrderIndex;
    @Deprecated
    @UnsupportedAppUsage
    public final Point position;
    public final Rect localBounds;
    @Deprecated
    @UnsupportedAppUsage
    public final Rect sourceContainerBounds;
    public final Rect screenSpaceBounds;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final Rect startBounds;
    @UnsupportedAppUsage
    public final WindowConfiguration windowConfiguration;
    @UnsupportedAppUsage
    public boolean isNotInRecents;
    public ActivityManager.RunningTaskInfo taskInfo;
    @UnsupportedAppUsage
    public boolean allowEnterPip;
    public final int windowType;
    public boolean hasAnimatingParent;
    public boolean showBackdrop;
    public int backgroundColor;
    public boolean willShowImeOnTarget;
    public int rotationChange;
    public static final Parcelable.Creator<RemoteAnimationTarget> CREATOR = new Parcelable.Creator<RemoteAnimationTarget>(){

        @Override
        public RemoteAnimationTarget createFromParcel(Parcel in) {
            return new RemoteAnimationTarget(in);
        }

        public RemoteAnimationTarget[] newArray(int size) {
            return new RemoteAnimationTarget[size];
        }
    };

    public RemoteAnimationTarget(int taskId, int mode, SurfaceControl leash, boolean isTranslucent, Rect clipRect, Rect contentInsets, int prefixOrderIndex, Point position, Rect localBounds, Rect screenSpaceBounds, WindowConfiguration windowConfig, boolean isNotInRecents, SurfaceControl startLeash, Rect startBounds, ActivityManager.RunningTaskInfo taskInfo, boolean allowEnterPip) {
        this(taskId, mode, leash, isTranslucent, clipRect, contentInsets, prefixOrderIndex, position, localBounds, screenSpaceBounds, windowConfig, isNotInRecents, startLeash, startBounds, taskInfo, allowEnterPip, -1);
    }

    public RemoteAnimationTarget(int taskId, int mode, SurfaceControl leash, boolean isTranslucent, Rect clipRect, Rect contentInsets, int prefixOrderIndex, Point position, Rect localBounds, Rect screenSpaceBounds, WindowConfiguration windowConfig, boolean isNotInRecents, SurfaceControl startLeash, Rect startBounds, ActivityManager.RunningTaskInfo taskInfo, boolean allowEnterPip, int windowType) {
        this.mode = mode;
        this.taskId = taskId;
        this.leash = leash;
        this.isTranslucent = isTranslucent;
        this.clipRect = new Rect(clipRect);
        this.contentInsets = new Rect(contentInsets);
        this.prefixOrderIndex = prefixOrderIndex;
        this.position = position == null ? new Point() : new Point(position);
        this.localBounds = new Rect(localBounds);
        this.sourceContainerBounds = new Rect(screenSpaceBounds);
        this.screenSpaceBounds = new Rect(screenSpaceBounds);
        this.windowConfiguration = windowConfig;
        this.isNotInRecents = isNotInRecents;
        this.startLeash = startLeash;
        this.taskInfo = taskInfo;
        this.allowEnterPip = allowEnterPip;
        this.windowType = windowType;
        this.startBounds = startBounds == null ? new Rect(screenSpaceBounds) : new Rect(startBounds);
    }

    public RemoteAnimationTarget(Parcel in) {
        this.taskId = in.readInt();
        this.mode = in.readInt();
        this.leash = in.readTypedObject(SurfaceControl.CREATOR);
        if (this.leash != null) {
            this.leash.setUnreleasedWarningCallSite("RemoteAnimationTarget[leash]");
        }
        this.isTranslucent = in.readBoolean();
        this.clipRect = in.readTypedObject(Rect.CREATOR);
        this.contentInsets = in.readTypedObject(Rect.CREATOR);
        this.prefixOrderIndex = in.readInt();
        this.position = in.readTypedObject(Point.CREATOR);
        this.localBounds = in.readTypedObject(Rect.CREATOR);
        this.sourceContainerBounds = in.readTypedObject(Rect.CREATOR);
        this.screenSpaceBounds = in.readTypedObject(Rect.CREATOR);
        this.windowConfiguration = in.readTypedObject(WindowConfiguration.CREATOR);
        this.isNotInRecents = in.readBoolean();
        this.startLeash = in.readTypedObject(SurfaceControl.CREATOR);
        if (this.startLeash != null) {
            this.startLeash.setUnreleasedWarningCallSite("RemoteAnimationTarget[startLeash]");
        }
        this.startBounds = in.readTypedObject(Rect.CREATOR);
        this.taskInfo = in.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
        this.allowEnterPip = in.readBoolean();
        this.windowType = in.readInt();
        this.hasAnimatingParent = in.readBoolean();
        this.backgroundColor = in.readInt();
        this.showBackdrop = in.readBoolean();
        this.willShowImeOnTarget = in.readBoolean();
        this.rotationChange = in.readInt();
    }

    public void setShowBackdrop(boolean shouldShowBackdrop) {
        this.showBackdrop = shouldShowBackdrop;
    }

    public void setWillShowImeOnTarget(boolean showImeOnTarget) {
        this.willShowImeOnTarget = showImeOnTarget;
    }

    public boolean willShowImeOnTarget() {
        return this.willShowImeOnTarget;
    }

    public void setRotationChange(int rotationChange) {
        this.rotationChange = rotationChange;
    }

    public int getRotationChange() {
        return this.rotationChange;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.taskId);
        dest.writeInt(this.mode);
        dest.writeTypedObject(this.leash, 0);
        dest.writeBoolean(this.isTranslucent);
        dest.writeTypedObject(this.clipRect, 0);
        dest.writeTypedObject(this.contentInsets, 0);
        dest.writeInt(this.prefixOrderIndex);
        dest.writeTypedObject(this.position, 0);
        dest.writeTypedObject(this.localBounds, 0);
        dest.writeTypedObject(this.sourceContainerBounds, 0);
        dest.writeTypedObject(this.screenSpaceBounds, 0);
        dest.writeTypedObject(this.windowConfiguration, 0);
        dest.writeBoolean(this.isNotInRecents);
        dest.writeTypedObject(this.startLeash, 0);
        dest.writeTypedObject(this.startBounds, 0);
        dest.writeTypedObject(this.taskInfo, 0);
        dest.writeBoolean(this.allowEnterPip);
        dest.writeInt(this.windowType);
        dest.writeBoolean(this.hasAnimatingParent);
        dest.writeInt(this.backgroundColor);
        dest.writeBoolean(this.showBackdrop);
        dest.writeBoolean(this.willShowImeOnTarget);
        dest.writeInt(this.rotationChange);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mode=");
        pw.print(this.mode);
        pw.print(" taskId=");
        pw.print(this.taskId);
        pw.print(" isTranslucent=");
        pw.print(this.isTranslucent);
        pw.print(" clipRect=");
        this.clipRect.printShortString(pw);
        pw.print(" contentInsets=");
        this.contentInsets.printShortString(pw);
        pw.print(" prefixOrderIndex=");
        pw.print(this.prefixOrderIndex);
        pw.print(" position=");
        RemoteAnimationTarget.printPoint(this.position, pw);
        pw.print(" sourceContainerBounds=");
        this.sourceContainerBounds.printShortString(pw);
        pw.print(" screenSpaceBounds=");
        this.screenSpaceBounds.printShortString(pw);
        pw.print(" localBounds=");
        this.localBounds.printShortString(pw);
        pw.println();
        pw.print(prefix);
        pw.print("windowConfiguration=");
        pw.println(this.windowConfiguration);
        pw.print(prefix);
        pw.print("leash=");
        pw.println(this.leash);
        pw.print(prefix);
        pw.print("taskInfo=");
        pw.println(this.taskInfo);
        pw.print(prefix);
        pw.print("allowEnterPip=");
        pw.println(this.allowEnterPip);
        pw.print(prefix);
        pw.print("windowType=");
        pw.println(this.windowType);
        pw.print(prefix);
        pw.print("hasAnimatingParent=");
        pw.println(this.hasAnimatingParent);
        pw.print(prefix);
        pw.print("backgroundColor=");
        pw.println(this.backgroundColor);
        pw.print(prefix);
        pw.print("showBackdrop=");
        pw.println(this.showBackdrop);
        pw.print(prefix);
        pw.print("willShowImeOnTarget=");
        pw.println(this.willShowImeOnTarget);
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, this.taskId);
        proto.write(1120986464258L, this.mode);
        this.leash.dumpDebug(proto, 1146756268035L);
        proto.write(1133871366148L, this.isTranslucent);
        this.clipRect.dumpDebug(proto, 1146756268037L);
        this.contentInsets.dumpDebug(proto, 1146756268038L);
        proto.write(1120986464263L, this.prefixOrderIndex);
        GraphicsProtos.dumpPointProto(this.position, proto, 1146756268040L);
        this.sourceContainerBounds.dumpDebug(proto, 1146756268041L);
        this.screenSpaceBounds.dumpDebug(proto, 1146756268046L);
        this.localBounds.dumpDebug(proto, 1146756268045L);
        this.windowConfiguration.dumpDebug(proto, 1146756268042L);
        if (this.startLeash != null) {
            this.startLeash.dumpDebug(proto, 0x10B0000000BL);
        }
        this.startBounds.dumpDebug(proto, 1146756268044L);
        proto.end(token);
    }

    private static void printPoint(Point p, PrintWriter pw) {
        pw.print("[");
        pw.print(p.x);
        pw.print(",");
        pw.print(p.y);
        pw.print("]");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

