/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.view.AttachedSurfaceControl;
import android.view.Display;
import android.view.ISurfaceControlViewHost;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerImpl;
import android.view.WindowlessWindowLayout;
import android.view.WindowlessWindowManager;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import android.window.ISurfaceSyncGroup;
import android.window.WindowTokenClient;
import dalvik.system.CloseGuard;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SurfaceControlViewHost {
    private static final String TAG = "SurfaceControlViewHost";
    private final ViewRootImpl mViewRoot;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private WindowlessWindowManager mWm;
    private SurfaceControl mSurfaceControl;
    private IAccessibilityEmbeddedConnection mAccessibilityEmbeddedConnection;
    private boolean mReleased = false;
    private ISurfaceControlViewHost mRemoteInterface = new ISurfaceControlViewHostImpl();
    private ViewRootImpl.ConfigChangedCallback mConfigChangedCallback;

    public SurfaceControlViewHost(Context c, Display d, WindowlessWindowManager wwm, String callsite) {
        this.mSurfaceControl = wwm.mRootSurface;
        this.mWm = wwm;
        this.mViewRoot = new ViewRootImpl(c, d, this.mWm, new WindowlessWindowLayout());
        this.mCloseGuard.openWithCallSite("release", callsite);
        this.setConfigCallback(c, d);
        WindowManagerGlobal.getInstance().addWindowlessRoot(this.mViewRoot);
        this.mAccessibilityEmbeddedConnection = this.mViewRoot.getAccessibilityEmbeddedConnection();
    }

    public SurfaceControlViewHost(Context context, Display display, IBinder hostToken) {
        this(context, display, hostToken, "untracked");
    }

    public SurfaceControlViewHost(Context context, Display display, IBinder hostToken, String callsite) {
        this.mSurfaceControl = new SurfaceControl.Builder().setContainerLayer().setName(TAG).setCallsite("SurfaceControlViewHost[" + callsite + "]").build();
        this.mWm = new WindowlessWindowManager(context.getResources().getConfiguration(), this.mSurfaceControl, hostToken);
        this.mViewRoot = new ViewRootImpl(context, display, this.mWm, new WindowlessWindowLayout());
        this.mCloseGuard.openWithCallSite("release", callsite);
        this.setConfigCallback(context, display);
        WindowManagerGlobal.getInstance().addWindowlessRoot(this.mViewRoot);
        this.mAccessibilityEmbeddedConnection = this.mViewRoot.getAccessibilityEmbeddedConnection();
    }

    private void setConfigCallback(Context c, Display d) {
        IBinder token = c.getWindowContextToken();
        this.mConfigChangedCallback = conf -> {
            if (token instanceof WindowTokenClient) {
                WindowTokenClient w = (WindowTokenClient)token;
                w.onConfigurationChanged(conf, d.getDisplayId(), true);
            }
        };
        ViewRootImpl.addConfigCallback(this.mConfigChangedCallback);
    }

    protected void finalize() throws Throwable {
        if (this.mReleased) {
            return;
        }
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.doRelease(false);
    }

    public SurfacePackage getSurfacePackage() {
        if (this.mSurfaceControl != null && this.mAccessibilityEmbeddedConnection != null) {
            return new SurfacePackage(new SurfaceControl(this.mSurfaceControl, "getSurfacePackage"), this.mAccessibilityEmbeddedConnection, this.getFocusGrantToken(), this.mRemoteInterface);
        }
        return null;
    }

    public AttachedSurfaceControl getRootSurfaceControl() {
        return this.mViewRoot;
    }

    public void setView(View view, int width, int height) {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(width, height, 2, 0, -2);
        this.setView(view, lp);
    }

    public void setView(View view, WindowManager.LayoutParams attrs) {
        Objects.requireNonNull(view);
        attrs.flags |= 0x1000000;
        this.addWindowToken(attrs);
        view.setLayoutParams(attrs);
        this.mViewRoot.setView(view, attrs, null);
    }

    public View getView() {
        return this.mViewRoot.getView();
    }

    public IWindow getWindowToken() {
        return this.mViewRoot.mWindow;
    }

    public WindowlessWindowManager getWindowlessWM() {
        return this.mWm;
    }

    public void relayout(WindowManager.LayoutParams attrs, WindowlessWindowManager.ResizeCompleteCallback callback) {
        this.mViewRoot.setLayoutParams(attrs, false);
        this.mViewRoot.setReportNextDraw(true, "scvh_relayout");
        this.mWm.setCompletionCallback(this.mViewRoot.mWindow.asBinder(), callback);
    }

    public void relayout(WindowManager.LayoutParams attrs) {
        this.mViewRoot.setLayoutParams(attrs, false);
    }

    public void relayout(int width, int height) {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(width, height, 2, 0, -2);
        this.relayout(lp);
    }

    public void release() {
        this.doRelease(true);
    }

    private void doRelease(boolean immediate) {
        if (this.mConfigChangedCallback != null) {
            ViewRootImpl.removeConfigCallback(this.mConfigChangedCallback);
            this.mConfigChangedCallback = null;
        }
        this.mViewRoot.die(immediate);
        WindowManagerGlobal.getInstance().removeWindowlessRoot(this.mViewRoot);
        this.mReleased = true;
        this.mCloseGuard.close();
    }

    public IBinder getFocusGrantToken() {
        return this.mWm.getFocusGrantToken(this.getWindowToken().asBinder());
    }

    private void addWindowToken(WindowManager.LayoutParams attrs) {
        WindowManagerImpl wm = (WindowManagerImpl)this.mViewRoot.mContext.getSystemService("window");
        attrs.token = wm.getDefaultToken();
    }

    public boolean transferTouchGestureToHost() {
        if (this.mViewRoot == null) {
            return false;
        }
        IWindowSession realWm = WindowManagerGlobal.getWindowSession();
        try {
            return realWm.transferEmbeddedTouchFocusToHost(this.mViewRoot.mWindow);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
            return false;
        }
    }

    private class ISurfaceControlViewHostImpl
    extends ISurfaceControlViewHost.Stub {
        private ISurfaceControlViewHostImpl() {
        }

        @Override
        public void onConfigurationChanged(Configuration configuration) {
            if (SurfaceControlViewHost.this.mViewRoot == null) {
                return;
            }
            SurfaceControlViewHost.this.mViewRoot.mHandler.post(() -> {
                if (SurfaceControlViewHost.this.mWm != null) {
                    SurfaceControlViewHost.this.mWm.setConfiguration(configuration);
                }
                if (SurfaceControlViewHost.this.mViewRoot != null) {
                    SurfaceControlViewHost.this.mViewRoot.forceWmRelayout();
                }
            });
        }

        @Override
        public void onDispatchDetachedFromWindow() {
            if (SurfaceControlViewHost.this.mViewRoot == null) {
                return;
            }
            SurfaceControlViewHost.this.mViewRoot.mHandler.post(() -> SurfaceControlViewHost.this.release());
        }

        @Override
        public void onInsetsChanged(InsetsState state, Rect frame) {
            if (SurfaceControlViewHost.this.mViewRoot != null) {
                SurfaceControlViewHost.this.mViewRoot.mHandler.post(() -> SurfaceControlViewHost.this.mViewRoot.setOverrideInsetsFrame(frame));
            }
            SurfaceControlViewHost.this.mWm.setInsetsState(state);
        }

        @Override
        public ISurfaceSyncGroup getSurfaceSyncGroup() {
            CompletableFuture surfaceSyncGroup = new CompletableFuture();
            if (Thread.currentThread() == SurfaceControlViewHost.this.mViewRoot.mThread) {
                return SurfaceControlViewHost.this.mViewRoot.getOrCreateSurfaceSyncGroup().mISurfaceSyncGroup;
            }
            SurfaceControlViewHost.this.mViewRoot.mHandler.post(() -> surfaceSyncGroup.complete(SurfaceControlViewHost.this.mViewRoot.getOrCreateSurfaceSyncGroup().mISurfaceSyncGroup));
            try {
                return (ISurfaceSyncGroup)surfaceSyncGroup.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Log.e(SurfaceControlViewHost.TAG, "Failed to get SurfaceSyncGroup for SCVH", e);
                return null;
            }
        }
    }

    public static class SurfacePackage
    implements Parcelable {
        private SurfaceControl mSurfaceControl;
        private final IAccessibilityEmbeddedConnection mAccessibilityEmbeddedConnection;
        private final IBinder mInputToken;
        private final ISurfaceControlViewHost mRemoteInterface;
        public static final Parcelable.Creator<SurfacePackage> CREATOR = new Parcelable.Creator<SurfacePackage>(){

            @Override
            public SurfacePackage createFromParcel(Parcel in) {
                return new SurfacePackage(in);
            }

            public SurfacePackage[] newArray(int size) {
                return new SurfacePackage[size];
            }
        };

        SurfacePackage(SurfaceControl sc, IAccessibilityEmbeddedConnection connection, IBinder inputToken, ISurfaceControlViewHost ri) {
            this.mSurfaceControl = sc;
            this.mAccessibilityEmbeddedConnection = connection;
            this.mInputToken = inputToken;
            this.mRemoteInterface = ri;
        }

        public SurfacePackage(SurfacePackage other) {
            SurfaceControl otherSurfaceControl = other.mSurfaceControl;
            if (otherSurfaceControl != null && otherSurfaceControl.isValid()) {
                this.mSurfaceControl = new SurfaceControl(otherSurfaceControl, "SurfacePackage");
            }
            this.mAccessibilityEmbeddedConnection = other.mAccessibilityEmbeddedConnection;
            this.mInputToken = other.mInputToken;
            this.mRemoteInterface = other.mRemoteInterface;
        }

        private SurfacePackage(Parcel in) {
            this.mSurfaceControl = new SurfaceControl();
            this.mSurfaceControl.readFromParcel(in);
            this.mSurfaceControl.setUnreleasedWarningCallSite("SurfacePackage(Parcel)");
            this.mAccessibilityEmbeddedConnection = IAccessibilityEmbeddedConnection.Stub.asInterface(in.readStrongBinder());
            this.mInputToken = in.readStrongBinder();
            this.mRemoteInterface = ISurfaceControlViewHost.Stub.asInterface(in.readStrongBinder());
        }

        public SurfaceControl getSurfaceControl() {
            return this.mSurfaceControl;
        }

        public IAccessibilityEmbeddedConnection getAccessibilityEmbeddedConnection() {
            return this.mAccessibilityEmbeddedConnection;
        }

        public ISurfaceControlViewHost getRemoteInterface() {
            return this.mRemoteInterface;
        }

        public void notifyConfigurationChanged(Configuration c) {
            try {
                this.getRemoteInterface().onConfigurationChanged(c);
            }
            catch (RemoteException e) {
                e.rethrowAsRuntimeException();
            }
        }

        public void notifyDetachedFromWindow() {
            try {
                this.getRemoteInterface().onDispatchDetachedFromWindow();
            }
            catch (RemoteException e) {
                e.rethrowAsRuntimeException();
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            this.mSurfaceControl.writeToParcel(out, flags);
            out.writeStrongBinder(this.mAccessibilityEmbeddedConnection.asBinder());
            out.writeStrongBinder(this.mInputToken);
            out.writeStrongBinder(this.mRemoteInterface.asBinder());
        }

        public void release() {
            if (this.mSurfaceControl != null) {
                this.mSurfaceControl.release();
            }
            this.mSurfaceControl = null;
        }

        public IBinder getInputToken() {
            return this.mInputToken;
        }
    }
}

