/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BLASTBufferQueue;
import android.graphics.FrameInfo;
import android.graphics.HardwareRenderer;
import android.graphics.Picture;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.View;
import android.view.WindowManagerGlobal;
import android.view.animation.AnimationUtils;
import com.android.internal.R;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ThreadedRenderer
extends HardwareRenderer {
    public static final String PROFILE_PROPERTY = "debug.hwui.profile";
    public static final String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    static final String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    static final String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    public static final String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static final String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static final String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static final String OVERDRAW_PROPERTY_SHOW = "show";
    public static final String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    public static final String DEBUG_FPS_DIVISOR = "debug.hwui.fps_divisor";
    public static final String DEBUG_FORCE_DARK = "debug.hwui.force_dark";
    public static int EGL_CONTEXT_PRIORITY_REALTIME_NV = 13143;
    public static int EGL_CONTEXT_PRIORITY_HIGH_IMG = 12545;
    public static int EGL_CONTEXT_PRIORITY_MEDIUM_IMG = 12546;
    public static int EGL_CONTEXT_PRIORITY_LOW_IMG = 12547;
    public static boolean sRendererEnabled = true;
    private static final String[] VISUALIZERS = new String[]{"visual_bars"};
    private int mWidth;
    private int mHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mInsetTop;
    private int mInsetLeft;
    private final float mLightY;
    private final float mLightZ;
    private final float mLightRadius;
    private boolean mInitialized = false;
    private boolean mRootNodeNeedsUpdate;
    private boolean mEnabled;
    private boolean mRequested = true;
    private final WebViewOverlayProvider mWebViewOverlayProvider = new WebViewOverlayProvider();
    private boolean mWebViewOverlaysEnabled = false;
    private ArrayList<HardwareRenderer.FrameDrawingCallback> mNextRtFrameCallbacks;

    public static void enableForegroundTrimming() {
    }

    public static void initForSystemProcess() {
        if (!ActivityManager.isHighEndGfx()) {
            sRendererEnabled = false;
        }
        ThreadedRenderer.setIsSystemOrPersistent();
    }

    public static ThreadedRenderer create(Context context, boolean translucent, String name) {
        return new ThreadedRenderer(context, translucent, name);
    }

    ThreadedRenderer(Context context, boolean translucent, String name) {
        this.setName(name);
        this.setOpaque(!translucent);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = a.getDimension(3, 0.0f);
        this.mLightZ = a.getDimension(4, 0.0f);
        this.mLightRadius = a.getDimension(2, 0.0f);
        float ambientShadowAlpha = a.getFloat(0, 0.0f);
        float spotShadowAlpha = a.getFloat(1, 0.0f);
        a.recycle();
        this.setLightSourceAlpha(ambientShadowAlpha, spotShadowAlpha);
    }

    @Override
    public void destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        super.destroy();
    }

    boolean isEnabled() {
        return this.mEnabled;
    }

    void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    boolean isRequested() {
        return this.mRequested;
    }

    void setRequested(boolean requested) {
        this.mRequested = requested;
    }

    private void updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.mInitialized);
        }
    }

    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        boolean status = !this.mInitialized;
        this.mInitialized = true;
        this.updateEnabledState(surface);
        this.setSurface(surface);
        return status;
    }

    boolean initializeIfNeeded(int width, int height, View.AttachInfo attachInfo, Surface surface, Rect surfaceInsets) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(width, height, attachInfo, surfaceInsets);
            return true;
        }
        return false;
    }

    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        this.setSurface(surface);
    }

    @Override
    public void setSurface(Surface surface) {
        if (surface != null && surface.isValid()) {
            super.setSurface(surface);
        } else {
            super.setSurface(null);
        }
    }

    void registerRtFrameCallback(HardwareRenderer.FrameDrawingCallback callback) {
        if (this.mNextRtFrameCallbacks == null) {
            this.mNextRtFrameCallbacks = new ArrayList();
        }
        this.mNextRtFrameCallbacks.add(callback);
    }

    void unregisterRtFrameCallback(HardwareRenderer.FrameDrawingCallback callback) {
        if (this.mNextRtFrameCallbacks == null) {
            return;
        }
        this.mNextRtFrameCallbacks.remove(callback);
    }

    void destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        this.clearContent();
    }

    private static void destroyResources(View view) {
        view.destroyHardwareResources();
    }

    void setup(int width, int height, View.AttachInfo attachInfo, Rect surfaceInsets) {
        this.mWidth = width;
        this.mHeight = height;
        if (surfaceInsets != null && (surfaceInsets.left != 0 || surfaceInsets.right != 0 || surfaceInsets.top != 0 || surfaceInsets.bottom != 0)) {
            this.mInsetLeft = surfaceInsets.left;
            this.mInsetTop = surfaceInsets.top;
            this.mSurfaceWidth = width + this.mInsetLeft + surfaceInsets.right;
            this.mSurfaceHeight = height + this.mInsetTop + surfaceInsets.bottom;
            this.setOpaque(false);
        } else {
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        this.setLightCenter(attachInfo);
    }

    public boolean rendererOwnsSurfaceControlOpacity() {
        return this.mWebViewOverlayProvider.mSurfaceControl != null;
    }

    public boolean setSurfaceControlOpaque(boolean opaque) {
        return this.mWebViewOverlayProvider.setSurfaceControlOpaque(opaque);
    }

    private void updateWebViewOverlayCallbacks() {
        boolean shouldEnable = this.mWebViewOverlayProvider.shouldEnableOverlaySupport();
        if (shouldEnable != this.mWebViewOverlaysEnabled) {
            this.mWebViewOverlaysEnabled = shouldEnable;
            if (shouldEnable) {
                this.setASurfaceTransactionCallback(this.mWebViewOverlayProvider);
                this.setPrepareSurfaceControlForWebviewCallback(this.mWebViewOverlayProvider);
            } else {
                this.setASurfaceTransactionCallback(null);
                this.setPrepareSurfaceControlForWebviewCallback(null);
            }
        }
    }

    @Override
    public void setSurfaceControl(SurfaceControl surfaceControl, BLASTBufferQueue blastBufferQueue) {
        super.setSurfaceControl(surfaceControl, blastBufferQueue);
        this.mWebViewOverlayProvider.setSurfaceControl(surfaceControl);
        this.mWebViewOverlayProvider.setBLASTBufferQueue(blastBufferQueue);
        this.updateWebViewOverlayCallbacks();
    }

    @Override
    public void notifyCallbackPending() {
        if (this.isEnabled()) {
            super.notifyCallbackPending();
        }
    }

    @Override
    public void notifyExpensiveFrame() {
        if (this.isEnabled()) {
            super.notifyExpensiveFrame();
        }
    }

    void setLightCenter(View.AttachInfo attachInfo) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        attachInfo.mDisplay.getRealMetrics(displayMetrics);
        float lightX = (float)displayMetrics.widthPixels / 2.0f - (float)attachInfo.mWindowLeft;
        float lightY = this.mLightY - (float)attachInfo.mWindowTop;
        float zRatio = (float)Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) / (450.0f * displayMetrics.density);
        float zWeightedAdjustment = (zRatio + 2.0f) / 3.0f;
        float lightZ = this.mLightZ * zWeightedAdjustment;
        this.setLightSourceGeometry(lightX, lightY, lightZ, this.mLightRadius);
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    private static int dumpArgsToFlags(String[] args) {
        if (args == null || args.length == 0) {
            return 1;
        }
        int flags = 0;
        block10: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "framestats": {
                    flags |= 1;
                    continue block10;
                }
                case "reset": {
                    flags |= 2;
                    continue block10;
                }
                case "-a": {
                    flags = 1;
                }
            }
        }
        return flags;
    }

    public static void handleDumpGfxInfo(FileDescriptor fd, String[] args) {
        ThreadedRenderer.dumpGlobalProfileInfo(fd, ThreadedRenderer.dumpArgsToFlags(args));
        WindowManagerGlobal.getInstance().dumpGfxInfo(fd, args);
    }

    void dumpGfxInfo(PrintWriter pw, FileDescriptor fd, String[] args) {
        pw.flush();
        this.dumpProfileInfo(fd, ThreadedRenderer.dumpArgsToFlags(args));
    }

    Picture captureRenderingCommands() {
        return null;
    }

    @Override
    public boolean loadSystemProperties() {
        boolean changed = super.loadSystemProperties();
        if (changed) {
            this.invalidateRoot();
        }
        return changed;
    }

    private void updateViewTreeDisplayList(View view) {
        view.mPrivateFlags |= 0x20;
        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        view.mPrivateFlags &= Integer.MAX_VALUE;
        view.updateDisplayListIfDirty();
        view.mRecreateDisplayList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootDisplayList(View view, DrawCallbacks callbacks) {
        Trace.traceBegin(8L, "Record View#draw()");
        this.updateViewTreeDisplayList(view);
        if (this.mNextRtFrameCallbacks != null) {
            final ArrayList<HardwareRenderer.FrameDrawingCallback> frameCallbacks = this.mNextRtFrameCallbacks;
            this.mNextRtFrameCallbacks = null;
            this.setFrameCallback(new HardwareRenderer.FrameDrawingCallback(){

                @Override
                public void onFrameDraw(long frame) {
                }

                @Override
                public HardwareRenderer.FrameCommitCallback onFrameDraw(int syncResult, long frame) {
                    ArrayList<HardwareRenderer.FrameCommitCallback> frameCommitCallbacks = new ArrayList<HardwareRenderer.FrameCommitCallback>();
                    for (int i = 0; i < frameCallbacks.size(); ++i) {
                        HardwareRenderer.FrameCommitCallback frameCommitCallback = ((HardwareRenderer.FrameDrawingCallback)frameCallbacks.get(i)).onFrameDraw(syncResult, frame);
                        if (frameCommitCallback == null) continue;
                        frameCommitCallbacks.add(frameCommitCallback);
                    }
                    if (frameCommitCallbacks.isEmpty()) {
                        return null;
                    }
                    return didProduceBuffer -> {
                        for (int i = 0; i < frameCommitCallbacks.size(); ++i) {
                            ((HardwareRenderer.FrameCommitCallback)frameCommitCallbacks.get(i)).onFrameCommit(didProduceBuffer);
                        }
                    };
                }
            });
        }
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.hasDisplayList()) {
            RecordingCanvas canvas = this.mRootNode.beginRecording(this.mSurfaceWidth, this.mSurfaceHeight);
            try {
                int saveCount = canvas.save();
                canvas.translate(this.mInsetLeft, this.mInsetTop);
                callbacks.onPreDraw(canvas);
                canvas.enableZ();
                canvas.drawRenderNode(view.updateDisplayListIfDirty());
                canvas.disableZ();
                callbacks.onPostDraw(canvas);
                canvas.restoreToCount(saveCount);
                this.mRootNodeNeedsUpdate = false;
            }
            finally {
                this.mRootNode.endRecording();
            }
        }
        Trace.traceEnd(8L);
    }

    void invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    void draw(View view, View.AttachInfo attachInfo, DrawCallbacks callbacks) {
        FrameInfo frameInfo;
        int syncResult;
        attachInfo.mViewRootImpl.mViewFrameInfo.markDrawStart();
        this.updateRootDisplayList(view, callbacks);
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int count = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if (((syncResult = this.syncAndDrawFrame(frameInfo = attachInfo.mViewRootImpl.getUpdatedFrameInfo())) & 2) != 0) {
            Log.w("OpenGLRenderer", "Surface lost, forcing relayout");
            attachInfo.mViewRootImpl.mForceNextWindowRelayout = true;
            attachInfo.mViewRootImpl.requestLayout();
        }
        if ((syncResult & 1) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    public RenderNode getRootNode() {
        return this.mRootNode;
    }

    static /* synthetic */ boolean access$000() {
        return ThreadedRenderer.isWebViewOverlaysEnabled();
    }

    private static class WebViewOverlayProvider
    implements HardwareRenderer.PrepareSurfaceControlForWebviewCallback,
    HardwareRenderer.ASurfaceTransactionCallback {
        private static final boolean sOverlaysAreEnabled = ThreadedRenderer.access$000();
        private final SurfaceControl.Transaction mTransaction = new SurfaceControl.Transaction();
        private boolean mHasWebViewOverlays = false;
        private BLASTBufferQueue mBLASTBufferQueue;
        private SurfaceControl mSurfaceControl;

        private WebViewOverlayProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setSurfaceControlOpaque(boolean opaque) {
            WebViewOverlayProvider webViewOverlayProvider = this;
            synchronized (webViewOverlayProvider) {
                if (this.mHasWebViewOverlays) {
                    return false;
                }
                this.mTransaction.setOpaque(this.mSurfaceControl, opaque).apply();
            }
            return opaque;
        }

        public boolean shouldEnableOverlaySupport() {
            return sOverlaysAreEnabled && this.mSurfaceControl != null && this.mBLASTBufferQueue != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSurfaceControl(SurfaceControl surfaceControl) {
            WebViewOverlayProvider webViewOverlayProvider = this;
            synchronized (webViewOverlayProvider) {
                this.mSurfaceControl = surfaceControl;
                if (this.mSurfaceControl != null && this.mHasWebViewOverlays) {
                    this.mTransaction.setOpaque(surfaceControl, false).apply();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBLASTBufferQueue(BLASTBufferQueue bufferQueue) {
            WebViewOverlayProvider webViewOverlayProvider = this;
            synchronized (webViewOverlayProvider) {
                this.mBLASTBufferQueue = bufferQueue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void prepare() {
            WebViewOverlayProvider webViewOverlayProvider = this;
            synchronized (webViewOverlayProvider) {
                this.mHasWebViewOverlays = true;
                if (this.mSurfaceControl != null) {
                    this.mTransaction.setOpaque(this.mSurfaceControl, false).apply();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onMergeTransaction(long nativeTransactionObj, long aSurfaceControlNativeObj, long frameNr) {
            WebViewOverlayProvider webViewOverlayProvider = this;
            synchronized (webViewOverlayProvider) {
                if (this.mBLASTBufferQueue == null) {
                    return false;
                }
                this.mBLASTBufferQueue.mergeWithNextTransaction(nativeTransactionObj, frameNr);
                return true;
            }
        }
    }

    static interface DrawCallbacks {
        public void onPreDraw(RecordingCanvas var1);

        public void onPostDraw(RecordingCanvas var1);
    }

    public static class SimpleRenderer
    extends HardwareRenderer {
        private final float mLightY;
        private final float mLightZ;
        private final float mLightRadius;

        public SimpleRenderer(Context context, String name, Surface surface) {
            this.setName(name);
            this.setOpaque(false);
            this.setSurface(surface);
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
            this.mLightY = a.getDimension(3, 0.0f);
            this.mLightZ = a.getDimension(4, 0.0f);
            this.mLightRadius = a.getDimension(2, 0.0f);
            float ambientShadowAlpha = a.getFloat(0, 0.0f);
            float spotShadowAlpha = a.getFloat(1, 0.0f);
            a.recycle();
            this.setLightSourceAlpha(ambientShadowAlpha, spotShadowAlpha);
        }

        public void setLightCenter(Display display, int windowLeft, int windowTop) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getRealMetrics(displayMetrics);
            float lightX = (float)displayMetrics.widthPixels / 2.0f - (float)windowLeft;
            float lightY = this.mLightY - (float)windowTop;
            float zRatio = (float)Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) / (450.0f * displayMetrics.density);
            float zWeightedAdjustment = (zRatio + 2.0f) / 3.0f;
            float lightZ = this.mLightZ * zWeightedAdjustment;
            this.setLightSourceGeometry(lightX, lightY, lightZ, this.mLightRadius);
        }

        public RenderNode getRootNode() {
            return this.mRootNode;
        }

        public void draw(HardwareRenderer.FrameDrawingCallback callback) {
            long vsync = AnimationUtils.currentAnimationTimeMillis() * 1000000L;
            if (callback != null) {
                this.setFrameCallback(callback);
            }
            this.createRenderRequest().setVsyncTime(vsync).syncAndDraw();
        }
    }
}

