/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.InsetsController;
import android.view.InsetsFlags;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.inputmethod.InputMethodManager;
import java.util.List;

public class ViewRootInsetsControllerHost
implements InsetsController.Host {
    private final String TAG = "VRInsetsControllerHost";
    private final ViewRootImpl mViewRoot;
    private SyncRtSurfaceTransactionApplier mApplier;

    public ViewRootInsetsControllerHost(ViewRootImpl viewRoot) {
        this.mViewRoot = viewRoot;
    }

    @Override
    public Handler getHandler() {
        return this.mViewRoot.mHandler;
    }

    @Override
    public void notifyInsetsChanged() {
        this.mViewRoot.notifyInsetsChanged();
    }

    @Override
    public void addOnPreDrawRunnable(final Runnable r) {
        if (this.mViewRoot.mView == null) {
            return;
        }
        this.mViewRoot.mView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                ViewRootInsetsControllerHost.this.mViewRoot.mView.getViewTreeObserver().removeOnPreDrawListener(this);
                r.run();
                return true;
            }
        });
        this.mViewRoot.mView.invalidate();
    }

    @Override
    public void dispatchWindowInsetsAnimationPrepare(WindowInsetsAnimation animation) {
        if (this.mViewRoot.mView == null) {
            return;
        }
        this.mViewRoot.mView.dispatchWindowInsetsAnimationPrepare(animation);
    }

    @Override
    public WindowInsetsAnimation.Bounds dispatchWindowInsetsAnimationStart(WindowInsetsAnimation animation, WindowInsetsAnimation.Bounds bounds) {
        if (this.mViewRoot.mView == null) {
            return null;
        }
        return this.mViewRoot.mView.dispatchWindowInsetsAnimationStart(animation, bounds);
    }

    @Override
    public WindowInsets dispatchWindowInsetsAnimationProgress(WindowInsets insets, List<WindowInsetsAnimation> runningAnimations) {
        if (this.mViewRoot.mView == null) {
            return null;
        }
        return this.mViewRoot.mView.dispatchWindowInsetsAnimationProgress(insets, runningAnimations);
    }

    @Override
    public void dispatchWindowInsetsAnimationEnd(WindowInsetsAnimation animation) {
        if (this.mViewRoot.mView == null) {
            return;
        }
        this.mViewRoot.mView.dispatchWindowInsetsAnimationEnd(animation);
    }

    @Override
    public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... params) {
        if (this.mViewRoot.mView == null) {
            throw new IllegalStateException("View of the ViewRootImpl is not initiated.");
        }
        if (this.mApplier == null) {
            this.mApplier = new SyncRtSurfaceTransactionApplier(this.mViewRoot.mView);
        }
        if (this.mViewRoot.mView.isHardwareAccelerated() && this.isVisibleToUser()) {
            this.mApplier.scheduleApply(params);
        } else {
            SurfaceControl.Transaction t = new SurfaceControl.Transaction();
            this.mApplier.applyParams(t, params);
            t.apply();
        }
    }

    @Override
    public void postInsetsAnimationCallback(Runnable r) {
        this.mViewRoot.mChoreographer.postCallback(2, r, null);
    }

    @Override
    public void updateCompatSysUiVisibility(int visibleTypes, int requestedVisibleTypes, int controllableTypes) {
        this.mViewRoot.updateCompatSysUiVisibility(visibleTypes, requestedVisibleTypes, controllableTypes);
    }

    @Override
    public void updateRequestedVisibleTypes(int types) {
        try {
            if (this.mViewRoot.mAdded) {
                this.mViewRoot.mWindowSession.updateRequestedVisibleTypes(this.mViewRoot.mWindow, types);
            }
        }
        catch (RemoteException e) {
            Log.e("VRInsetsControllerHost", "Failed to call insetsModified", e);
        }
    }

    @Override
    public boolean hasAnimationCallbacks() {
        if (this.mViewRoot.mView == null) {
            return false;
        }
        return this.mViewRoot.mView.hasWindowInsetsAnimationCallback();
    }

    @Override
    public void setSystemBarsAppearance(int appearance, int mask) {
        this.mViewRoot.mWindowAttributes.privateFlags |= 0x4000000;
        InsetsFlags insetsFlags = this.mViewRoot.mWindowAttributes.insetsFlags;
        int newAppearance = insetsFlags.appearance & ~mask | appearance & mask;
        if (insetsFlags.appearance != newAppearance) {
            insetsFlags.appearance = newAppearance;
            this.mViewRoot.mWindowAttributesChanged = true;
            this.mViewRoot.scheduleTraversals();
        }
    }

    @Override
    public int getSystemBarsAppearance() {
        return this.mViewRoot.mWindowAttributes.insetsFlags.appearance;
    }

    @Override
    public boolean isSystemBarsAppearanceControlled() {
        return (this.mViewRoot.mWindowAttributes.privateFlags & 0x4000000) != 0;
    }

    @Override
    public void setSystemBarsBehavior(int behavior) {
        this.mViewRoot.mWindowAttributes.privateFlags |= 0x8000000;
        if (this.mViewRoot.mWindowAttributes.insetsFlags.behavior != behavior) {
            this.mViewRoot.mWindowAttributes.insetsFlags.behavior = behavior;
            this.mViewRoot.mWindowAttributesChanged = true;
            this.mViewRoot.scheduleTraversals();
        }
    }

    @Override
    public int getSystemBarsBehavior() {
        return this.mViewRoot.mWindowAttributes.insetsFlags.behavior;
    }

    @Override
    public boolean isSystemBarsBehaviorControlled() {
        return (this.mViewRoot.mWindowAttributes.privateFlags & 0x8000000) != 0;
    }

    @Override
    public void releaseSurfaceControlFromRt(SurfaceControl surfaceControl) {
        if (this.mViewRoot.mView != null && this.mViewRoot.mView.isHardwareAccelerated()) {
            this.mViewRoot.registerRtFrameCallback(frame -> surfaceControl.release());
            this.mViewRoot.mView.invalidate();
        } else {
            surfaceControl.release();
        }
    }

    @Override
    public InputMethodManager getInputMethodManager() {
        return this.mViewRoot.mContext.getSystemService(InputMethodManager.class);
    }

    @Override
    public String getRootViewTitle() {
        if (this.mViewRoot == null) {
            return null;
        }
        return this.mViewRoot.getTitle().toString();
    }

    @Override
    public Context getRootViewContext() {
        return this.mViewRoot != null ? this.mViewRoot.mContext : null;
    }

    @Override
    public int dipToPx(int dips) {
        if (this.mViewRoot != null) {
            return this.mViewRoot.dipToPx(dips);
        }
        return 0;
    }

    @Override
    public IBinder getWindowToken() {
        if (this.mViewRoot == null) {
            return null;
        }
        View view = this.mViewRoot.getView();
        if (view == null) {
            return null;
        }
        return view.getWindowToken();
    }

    @Override
    public CompatibilityInfo.Translator getTranslator() {
        if (this.mViewRoot != null) {
            return this.mViewRoot.mTranslator;
        }
        return null;
    }

    private boolean isVisibleToUser() {
        return this.mViewRoot.getHostVisibility() == 0;
    }
}

