/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.Gravity;
import android.view.InsetsFlags;
import android.view.InsetsFrameProvider;
import android.view.KeyboardShortcutGroup;
import android.view.Surface;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewManager;
import android.view.WindowInsets;
import android.view.WindowMetrics;
import android.view.accessibility.AccessibilityNodeInfo;
import android.window.TaskFpsCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public interface WindowManager
extends ViewManager {
    public static final int DOCKED_INVALID = -1;
    public static final int DOCKED_LEFT = 1;
    public static final int DOCKED_TOP = 2;
    public static final int DOCKED_RIGHT = 3;
    public static final int DOCKED_BOTTOM = 4;
    public static final String INPUT_CONSUMER_PIP = "pip_input_consumer";
    public static final String INPUT_CONSUMER_NAVIGATION = "nav_input_consumer";
    public static final String INPUT_CONSUMER_WALLPAPER = "wallpaper_input_consumer";
    public static final String INPUT_CONSUMER_RECENTS_ANIMATION = "recents_animation_input_consumer";
    public static final int SHELL_ROOT_LAYER_DIVIDER = 0;
    public static final int SHELL_ROOT_LAYER_PIP = 1;
    public static final int TRANSIT_OLD_UNSET = -1;
    public static final int TRANSIT_OLD_NONE = 0;
    public static final int TRANSIT_OLD_ACTIVITY_OPEN = 6;
    public static final int TRANSIT_OLD_ACTIVITY_CLOSE = 7;
    public static final int TRANSIT_OLD_TASK_OPEN = 8;
    public static final int TRANSIT_OLD_TASK_CLOSE = 9;
    public static final int TRANSIT_OLD_TASK_TO_FRONT = 10;
    public static final int TRANSIT_OLD_TASK_TO_BACK = 11;
    public static final int TRANSIT_OLD_WALLPAPER_CLOSE = 12;
    public static final int TRANSIT_OLD_WALLPAPER_OPEN = 13;
    public static final int TRANSIT_OLD_WALLPAPER_INTRA_OPEN = 14;
    public static final int TRANSIT_OLD_WALLPAPER_INTRA_CLOSE = 15;
    public static final int TRANSIT_OLD_TASK_OPEN_BEHIND = 16;
    public static final int TRANSIT_OLD_ACTIVITY_RELAUNCH = 18;
    public static final int TRANSIT_OLD_KEYGUARD_GOING_AWAY = 20;
    public static final int TRANSIT_OLD_KEYGUARD_GOING_AWAY_ON_WALLPAPER = 21;
    public static final int TRANSIT_OLD_KEYGUARD_OCCLUDE = 22;
    public static final int TRANSIT_OLD_KEYGUARD_OCCLUDE_BY_DREAM = 33;
    public static final int TRANSIT_OLD_KEYGUARD_UNOCCLUDE = 23;
    public static final int TRANSIT_OLD_TRANSLUCENT_ACTIVITY_OPEN = 24;
    public static final int TRANSIT_OLD_TRANSLUCENT_ACTIVITY_CLOSE = 25;
    public static final int TRANSIT_OLD_CRASHING_ACTIVITY_CLOSE = 26;
    public static final int TRANSIT_OLD_TASK_CHANGE_WINDOWING_MODE = 27;
    public static final int TRANSIT_OLD_TASK_FRAGMENT_OPEN = 28;
    public static final int TRANSIT_OLD_TASK_FRAGMENT_CLOSE = 29;
    public static final int TRANSIT_OLD_TASK_FRAGMENT_CHANGE = 30;
    public static final int TRANSIT_OLD_DREAM_ACTIVITY_OPEN = 31;
    public static final int TRANSIT_OLD_DREAM_ACTIVITY_CLOSE = 32;
    public static final int TRANSIT_NONE = 0;
    public static final int TRANSIT_OPEN = 1;
    public static final int TRANSIT_CLOSE = 2;
    public static final int TRANSIT_TO_FRONT = 3;
    public static final int TRANSIT_TO_BACK = 4;
    public static final int TRANSIT_RELAUNCH = 5;
    public static final int TRANSIT_CHANGE = 6;
    @Deprecated
    public static final int TRANSIT_KEYGUARD_GOING_AWAY = 7;
    public static final int TRANSIT_KEYGUARD_OCCLUDE = 8;
    public static final int TRANSIT_KEYGUARD_UNOCCLUDE = 9;
    public static final int TRANSIT_PIP = 10;
    public static final int TRANSIT_WAKE = 11;
    public static final int TRANSIT_SLEEP = 12;
    public static final int TRANSIT_FIRST_CUSTOM = 1000;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_TO_SHADE = 1;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_NO_ANIMATION = 2;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_WITH_WALLPAPER = 4;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_SUBTLE_ANIMATION = 8;
    public static final int TRANSIT_FLAG_APP_CRASHED = 16;
    public static final int TRANSIT_FLAG_OPEN_BEHIND = 32;
    public static final int TRANSIT_FLAG_KEYGUARD_LOCKED = 64;
    public static final int TRANSIT_FLAG_IS_RECENTS = 128;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY = 256;
    public static final int TRANSIT_FLAG_KEYGUARD_GOING_AWAY_TO_LAUNCHER_CLEAR_SNAPSHOT = 512;
    public static final int TRANSIT_FLAG_INVISIBLE = 1024;
    public static final int TRANSIT_FLAG_KEYGUARD_APPEARING = 2048;
    public static final int TRANSIT_FLAG_KEYGUARD_OCCLUDING = 4096;
    public static final int TRANSIT_FLAG_KEYGUARD_UNOCCLUDING = 8192;
    public static final int KEYGUARD_VISIBILITY_TRANSIT_FLAGS = 14592;
    public static final int REMOVE_CONTENT_MODE_UNDEFINED = 0;
    public static final int REMOVE_CONTENT_MODE_MOVE_TO_PRIMARY = 1;
    public static final int REMOVE_CONTENT_MODE_DESTROY = 2;
    public static final int DISPLAY_IME_POLICY_LOCAL = 0;
    public static final int DISPLAY_IME_POLICY_FALLBACK_DISPLAY = 1;
    public static final int DISPLAY_IME_POLICY_HIDE = 2;
    public static final int TAKE_SCREENSHOT_FULLSCREEN = 1;
    public static final int TAKE_SCREENSHOT_PROVIDED_IMAGE = 3;
    public static final int LARGE_SCREEN_SMALLEST_SCREEN_WIDTH_DP = 600;
    public static final String PROPERTY_COMPAT_IGNORE_REQUESTED_ORIENTATION = "android.window.PROPERTY_COMPAT_IGNORE_REQUESTED_ORIENTATION";
    public static final String PROPERTY_COMPAT_ALLOW_IGNORING_ORIENTATION_REQUEST_WHEN_LOOP_DETECTED = "android.window.PROPERTY_COMPAT_ALLOW_IGNORING_ORIENTATION_REQUEST_WHEN_LOOP_DETECTED";
    public static final String PROPERTY_COMPAT_ALLOW_SANDBOXING_VIEW_BOUNDS_APIS = "android.window.PROPERTY_COMPAT_ALLOW_SANDBOXING_VIEW_BOUNDS_APIS";
    public static final String PROPERTY_COMPAT_ENABLE_FAKE_FOCUS = "android.window.PROPERTY_COMPAT_ENABLE_FAKE_FOCUS";
    public static final String PROPERTY_CAMERA_COMPAT_ALLOW_FORCE_ROTATION = "android.window.PROPERTY_CAMERA_COMPAT_ALLOW_FORCE_ROTATION";
    public static final String PROPERTY_CAMERA_COMPAT_ALLOW_REFRESH = "android.window.PROPERTY_CAMERA_COMPAT_ALLOW_REFRESH";
    public static final String PROPERTY_CAMERA_COMPAT_ENABLE_REFRESH_VIA_PAUSE = "android.window.PROPERTY_CAMERA_COMPAT_ENABLE_REFRESH_VIA_PAUSE";
    public static final String PROPERTY_COMPAT_ALLOW_ORIENTATION_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_ORIENTATION_OVERRIDE";
    public static final String PROPERTY_COMPAT_ALLOW_DISPLAY_ORIENTATION_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_DISPLAY_ORIENTATION_OVERRIDE";
    public static final String PROPERTY_COMPAT_ALLOW_MIN_ASPECT_RATIO_OVERRIDE = "android.window.PROPERTY_COMPAT_ALLOW_MIN_ASPECT_RATIO_OVERRIDE";
    public static final String PROPERTY_COMPAT_ALLOW_RESIZEABLE_ACTIVITY_OVERRIDES = "android.window.PROPERTY_COMPAT_ALLOW_RESIZEABLE_ACTIVITY_OVERRIDES";
    public static final String PARCEL_KEY_SHORTCUTS_ARRAY = "shortcuts_array";
    public static final boolean WINDOW_EXTENSIONS_ENABLED = SystemProperties.getBoolean("persist.wm.extensions.enabled", false);
    public static final String PROPERTY_ACTIVITY_EMBEDDING_ALLOW_SYSTEM_OVERRIDE = "android.window.PROPERTY_ACTIVITY_EMBEDDING_ALLOW_SYSTEM_OVERRIDE";
    public static final String PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED = "android.window.PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED";

    @Deprecated
    public Display getDefaultDisplay();

    public void removeViewImmediate(View var1);

    default public WindowMetrics getCurrentWindowMetrics() {
        throw new UnsupportedOperationException();
    }

    default public WindowMetrics getMaximumWindowMetrics() {
        throw new UnsupportedOperationException();
    }

    default public Set<WindowMetrics> getPossibleMaximumWindowMetrics(int displayId) {
        throw new UnsupportedOperationException();
    }

    public static boolean hasWindowExtensionsEnabled() {
        return WINDOW_EXTENSIONS_ENABLED;
    }

    public void requestAppKeyboardShortcuts(KeyboardShortcutsReceiver var1, int var2);

    @SystemApi
    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public Region getCurrentImeTouchRegion();

    default public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
    }

    default public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
    }

    default public boolean shouldShowSystemDecors(int displayId) {
        return false;
    }

    default public void setDisplayImePolicy(int displayId, @DisplayImePolicy int imePolicy) {
    }

    @DisplayImePolicy
    default public int getDisplayImePolicy(int displayId) {
        return 1;
    }

    default public boolean isGlobalKey(int keyCode) {
        return false;
    }

    default public boolean isCrossWindowBlurEnabled() {
        return false;
    }

    default public void addCrossWindowBlurEnabledListener(Consumer<Boolean> listener) {
    }

    default public void addCrossWindowBlurEnabledListener(Executor executor, Consumer<Boolean> listener) {
    }

    default public void removeCrossWindowBlurEnabledListener(Consumer<Boolean> listener) {
    }

    default public void addProposedRotationListener(Executor executor, IntConsumer listener) {
    }

    default public void removeProposedRotationListener(IntConsumer listener) {
    }

    public static String transitTypeToString(int type) {
        switch (type) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "OPEN";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "TO_FRONT";
            }
            case 4: {
                return "TO_BACK";
            }
            case 5: {
                return "RELAUNCH";
            }
            case 6: {
                return "CHANGE";
            }
            case 7: {
                return "KEYGUARD_GOING_AWAY";
            }
            case 8: {
                return "KEYGUARD_OCCLUDE";
            }
            case 9: {
                return "KEYGUARD_UNOCCLUDE";
            }
            case 10: {
                return "PIP";
            }
            case 11: {
                return "WAKE";
            }
            case 12: {
                return "SLEEP";
            }
            case 1000: {
                return "FIRST_CUSTOM";
            }
        }
        if (type > 1000) {
            return "FIRST_CUSTOM+" + (type - 1000);
        }
        return "UNKNOWN(" + type + ")";
    }

    public static float fixScale(float scale) {
        return Math.max(Math.min(scale, 20.0f), 0.0f);
    }

    default public void holdLock(IBinder token, int durationMs) {
        throw new UnsupportedOperationException();
    }

    default public boolean isTaskSnapshotSupported() {
        return false;
    }

    @SystemApi
    default public void registerTaskFpsCallback(int taskId, Executor executor, TaskFpsCallback callback) {
    }

    @SystemApi
    default public void unregisterTaskFpsCallback(TaskFpsCallback callback) {
    }

    default public Bitmap snapshotTaskForRecents(int taskId) {
        return null;
    }

    @SystemApi
    default public List<ComponentName> notifyScreenshotListeners(int displayId) {
        throw new UnsupportedOperationException();
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements Parcelable {
        @ViewDebug.ExportedProperty
        public int x;
        @ViewDebug.ExportedProperty
        public int y;
        @ViewDebug.ExportedProperty
        public float horizontalWeight;
        @ViewDebug.ExportedProperty
        public float verticalWeight;
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=1, to="BASE_APPLICATION"), @ViewDebug.IntToString(from=2, to="APPLICATION"), @ViewDebug.IntToString(from=3, to="APPLICATION_STARTING"), @ViewDebug.IntToString(from=4, to="DRAWN_APPLICATION"), @ViewDebug.IntToString(from=1000, to="APPLICATION_PANEL"), @ViewDebug.IntToString(from=1001, to="APPLICATION_MEDIA"), @ViewDebug.IntToString(from=1002, to="APPLICATION_SUB_PANEL"), @ViewDebug.IntToString(from=1005, to="APPLICATION_ABOVE_SUB_PANEL"), @ViewDebug.IntToString(from=1003, to="APPLICATION_ATTACHED_DIALOG"), @ViewDebug.IntToString(from=1004, to="APPLICATION_MEDIA_OVERLAY"), @ViewDebug.IntToString(from=2000, to="STATUS_BAR"), @ViewDebug.IntToString(from=2001, to="SEARCH_BAR"), @ViewDebug.IntToString(from=2002, to="PHONE"), @ViewDebug.IntToString(from=2003, to="SYSTEM_ALERT"), @ViewDebug.IntToString(from=2005, to="TOAST"), @ViewDebug.IntToString(from=2006, to="SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2007, to="PRIORITY_PHONE"), @ViewDebug.IntToString(from=2008, to="SYSTEM_DIALOG"), @ViewDebug.IntToString(from=2009, to="KEYGUARD_DIALOG"), @ViewDebug.IntToString(from=2010, to="SYSTEM_ERROR"), @ViewDebug.IntToString(from=2011, to="INPUT_METHOD"), @ViewDebug.IntToString(from=2012, to="INPUT_METHOD_DIALOG"), @ViewDebug.IntToString(from=2013, to="WALLPAPER"), @ViewDebug.IntToString(from=2014, to="STATUS_BAR_PANEL"), @ViewDebug.IntToString(from=2015, to="SECURE_SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2016, to="DRAG"), @ViewDebug.IntToString(from=2017, to="STATUS_BAR_SUB_PANEL"), @ViewDebug.IntToString(from=2018, to="POINTER"), @ViewDebug.IntToString(from=2019, to="NAVIGATION_BAR"), @ViewDebug.IntToString(from=2020, to="VOLUME_OVERLAY"), @ViewDebug.IntToString(from=2021, to="BOOT_PROGRESS"), @ViewDebug.IntToString(from=2022, to="INPUT_CONSUMER"), @ViewDebug.IntToString(from=2024, to="NAVIGATION_BAR_PANEL"), @ViewDebug.IntToString(from=2026, to="DISPLAY_OVERLAY"), @ViewDebug.IntToString(from=2027, to="MAGNIFICATION_OVERLAY"), @ViewDebug.IntToString(from=2037, to="PRESENTATION"), @ViewDebug.IntToString(from=2030, to="PRIVATE_PRESENTATION"), @ViewDebug.IntToString(from=2031, to="VOICE_INTERACTION"), @ViewDebug.IntToString(from=2033, to="VOICE_INTERACTION_STARTING"), @ViewDebug.IntToString(from=2034, to="DOCK_DIVIDER"), @ViewDebug.IntToString(from=2035, to="QS_DIALOG"), @ViewDebug.IntToString(from=2036, to="SCREENSHOT"), @ViewDebug.IntToString(from=2038, to="APPLICATION_OVERLAY")})
        public int type;
        public static final int FIRST_APPLICATION_WINDOW = 1;
        public static final int TYPE_BASE_APPLICATION = 1;
        public static final int TYPE_APPLICATION = 2;
        public static final int TYPE_APPLICATION_STARTING = 3;
        public static final int TYPE_DRAWN_APPLICATION = 4;
        public static final int LAST_APPLICATION_WINDOW = 99;
        public static final int FIRST_SUB_WINDOW = 1000;
        public static final int TYPE_APPLICATION_PANEL = 1000;
        public static final int TYPE_APPLICATION_MEDIA = 1001;
        public static final int TYPE_APPLICATION_SUB_PANEL = 1002;
        public static final int TYPE_APPLICATION_ATTACHED_DIALOG = 1003;
        @UnsupportedAppUsage
        public static final int TYPE_APPLICATION_MEDIA_OVERLAY = 1004;
        public static final int TYPE_APPLICATION_ABOVE_SUB_PANEL = 1005;
        public static final int LAST_SUB_WINDOW = 1999;
        public static final int FIRST_SYSTEM_WINDOW = 2000;
        public static final int TYPE_STATUS_BAR = 2000;
        public static final int TYPE_SEARCH_BAR = 2001;
        @Deprecated
        public static final int TYPE_PHONE = 2002;
        @Deprecated
        public static final int TYPE_SYSTEM_ALERT = 2003;
        public static final int TYPE_KEYGUARD = 2004;
        @Deprecated
        public static final int TYPE_TOAST = 2005;
        @Deprecated
        public static final int TYPE_SYSTEM_OVERLAY = 2006;
        @Deprecated
        public static final int TYPE_PRIORITY_PHONE = 2007;
        public static final int TYPE_SYSTEM_DIALOG = 2008;
        public static final int TYPE_KEYGUARD_DIALOG = 2009;
        @Deprecated
        public static final int TYPE_SYSTEM_ERROR = 2010;
        public static final int TYPE_INPUT_METHOD = 2011;
        public static final int TYPE_INPUT_METHOD_DIALOG = 2012;
        public static final int TYPE_WALLPAPER = 2013;
        public static final int TYPE_STATUS_BAR_PANEL = 2014;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int TYPE_SECURE_SYSTEM_OVERLAY = 2015;
        public static final int TYPE_DRAG = 2016;
        public static final int TYPE_STATUS_BAR_SUB_PANEL = 2017;
        public static final int TYPE_POINTER = 2018;
        public static final int TYPE_NAVIGATION_BAR = 2019;
        public static final int TYPE_VOLUME_OVERLAY = 2020;
        public static final int TYPE_BOOT_PROGRESS = 2021;
        public static final int TYPE_INPUT_CONSUMER = 2022;
        public static final int TYPE_NAVIGATION_BAR_PANEL = 2024;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int TYPE_DISPLAY_OVERLAY = 2026;
        public static final int TYPE_MAGNIFICATION_OVERLAY = 2027;
        public static final int TYPE_PRIVATE_PRESENTATION = 2030;
        public static final int TYPE_VOICE_INTERACTION = 2031;
        public static final int TYPE_ACCESSIBILITY_OVERLAY = 2032;
        public static final int TYPE_VOICE_INTERACTION_STARTING = 2033;
        public static final int TYPE_DOCK_DIVIDER = 2034;
        public static final int TYPE_QS_DIALOG = 2035;
        public static final int TYPE_SCREENSHOT = 2036;
        public static final int TYPE_PRESENTATION = 2037;
        public static final int TYPE_APPLICATION_OVERLAY = 2038;
        public static final int TYPE_ACCESSIBILITY_MAGNIFICATION_OVERLAY = 2039;
        public static final int TYPE_NOTIFICATION_SHADE = 2040;
        public static final int TYPE_STATUS_BAR_ADDITIONAL = 2041;
        public static final int LAST_SYSTEM_WINDOW = 2999;
        public static final int INVALID_WINDOW_TYPE = -1;
        @Deprecated
        public static final int MEMORY_TYPE_NORMAL = 0;
        @Deprecated
        public static final int MEMORY_TYPE_HARDWARE = 1;
        @Deprecated
        public static final int MEMORY_TYPE_GPU = 2;
        @Deprecated
        public static final int MEMORY_TYPE_PUSH_BUFFERS = 3;
        @Deprecated
        public int memoryType;
        public static final int FLAG_ALLOW_LOCK_WHILE_SCREEN_ON = 1;
        public static final int FLAG_DIM_BEHIND = 2;
        public static final int FLAG_BLUR_BEHIND = 4;
        public static final int FLAG_NOT_FOCUSABLE = 8;
        public static final int FLAG_NOT_TOUCHABLE = 16;
        public static final int FLAG_NOT_TOUCH_MODAL = 32;
        @Deprecated
        public static final int FLAG_TOUCHABLE_WHEN_WAKING = 64;
        public static final int FLAG_KEEP_SCREEN_ON = 128;
        public static final int FLAG_LAYOUT_IN_SCREEN = 256;
        public static final int FLAG_LAYOUT_NO_LIMITS = 512;
        @Deprecated
        public static final int FLAG_FULLSCREEN = 1024;
        @Deprecated
        public static final int FLAG_FORCE_NOT_FULLSCREEN = 2048;
        @Deprecated
        public static final int FLAG_DITHER = 4096;
        public static final int FLAG_SECURE = 8192;
        public static final int FLAG_SCALED = 16384;
        public static final int FLAG_IGNORE_CHEEK_PRESSES = 32768;
        @Deprecated
        public static final int FLAG_LAYOUT_INSET_DECOR = 65536;
        public static final int FLAG_ALT_FOCUSABLE_IM = 131072;
        public static final int FLAG_WATCH_OUTSIDE_TOUCH = 262144;
        @Deprecated
        public static final int FLAG_SHOW_WHEN_LOCKED = 524288;
        public static final int FLAG_SHOW_WALLPAPER = 0x100000;
        @Deprecated
        public static final int FLAG_TURN_SCREEN_ON = 0x200000;
        @Deprecated
        public static final int FLAG_DISMISS_KEYGUARD = 0x400000;
        public static final int FLAG_SPLIT_TOUCH = 0x800000;
        public static final int FLAG_HARDWARE_ACCELERATED = 0x1000000;
        @Deprecated
        public static final int FLAG_LAYOUT_IN_OVERSCAN = 0x2000000;
        @Deprecated
        public static final int FLAG_TRANSLUCENT_STATUS = 0x4000000;
        @Deprecated
        public static final int FLAG_TRANSLUCENT_NAVIGATION = 0x8000000;
        public static final int FLAG_LOCAL_FOCUS_MODE = 0x10000000;
        @UnsupportedAppUsage
        public static final int FLAG_SLIPPERY = 0x20000000;
        @Deprecated
        public static final int FLAG_LAYOUT_ATTACHED_IN_DECOR = 0x40000000;
        public static final int FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="ALLOW_LOCK_WHILE_SCREEN_ON"), @ViewDebug.FlagToString(mask=2, equals=2, name="DIM_BEHIND"), @ViewDebug.FlagToString(mask=4, equals=4, name="BLUR_BEHIND"), @ViewDebug.FlagToString(mask=8, equals=8, name="NOT_FOCUSABLE"), @ViewDebug.FlagToString(mask=16, equals=16, name="NOT_TOUCHABLE"), @ViewDebug.FlagToString(mask=32, equals=32, name="NOT_TOUCH_MODAL"), @ViewDebug.FlagToString(mask=64, equals=64, name="TOUCHABLE_WHEN_WAKING"), @ViewDebug.FlagToString(mask=128, equals=128, name="KEEP_SCREEN_ON"), @ViewDebug.FlagToString(mask=256, equals=256, name="LAYOUT_IN_SCREEN"), @ViewDebug.FlagToString(mask=512, equals=512, name="LAYOUT_NO_LIMITS"), @ViewDebug.FlagToString(mask=1024, equals=1024, name="FULLSCREEN"), @ViewDebug.FlagToString(mask=2048, equals=2048, name="FORCE_NOT_FULLSCREEN"), @ViewDebug.FlagToString(mask=4096, equals=4096, name="DITHER"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="SECURE"), @ViewDebug.FlagToString(mask=16384, equals=16384, name="SCALED"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="IGNORE_CHEEK_PRESSES"), @ViewDebug.FlagToString(mask=65536, equals=65536, name="LAYOUT_INSET_DECOR"), @ViewDebug.FlagToString(mask=131072, equals=131072, name="ALT_FOCUSABLE_IM"), @ViewDebug.FlagToString(mask=262144, equals=262144, name="WATCH_OUTSIDE_TOUCH"), @ViewDebug.FlagToString(mask=524288, equals=524288, name="SHOW_WHEN_LOCKED"), @ViewDebug.FlagToString(mask=0x100000, equals=0x100000, name="SHOW_WALLPAPER"), @ViewDebug.FlagToString(mask=0x200000, equals=0x200000, name="TURN_SCREEN_ON"), @ViewDebug.FlagToString(mask=0x400000, equals=0x400000, name="DISMISS_KEYGUARD"), @ViewDebug.FlagToString(mask=0x800000, equals=0x800000, name="SPLIT_TOUCH"), @ViewDebug.FlagToString(mask=0x1000000, equals=0x1000000, name="HARDWARE_ACCELERATED"), @ViewDebug.FlagToString(mask=0x2000000, equals=0x2000000, name="LOCAL_FOCUS_MODE"), @ViewDebug.FlagToString(mask=0x4000000, equals=0x4000000, name="TRANSLUCENT_STATUS"), @ViewDebug.FlagToString(mask=0x8000000, equals=0x8000000, name="TRANSLUCENT_NAVIGATION"), @ViewDebug.FlagToString(mask=0x10000000, equals=0x10000000, name="LOCAL_FOCUS_MODE"), @ViewDebug.FlagToString(mask=0x20000000, equals=0x20000000, name="FLAG_SLIPPERY"), @ViewDebug.FlagToString(mask=0x40000000, equals=0x40000000, name="FLAG_LAYOUT_ATTACHED_IN_DECOR"), @ViewDebug.FlagToString(mask=-2147483648, equals=-2147483648, name="DRAWS_SYSTEM_BAR_BACKGROUNDS")}, formatToHexString=true)
        public int flags;
        public static final int PRIVATE_FLAG_FORCE_HARDWARE_ACCELERATED = 2;
        public static final int PRIVATE_FLAG_WANTS_OFFSET_NOTIFICATIONS = 4;
        @RequiresPermission(value="android.permission.SYSTEM_APPLICATION_OVERLAY")
        public static final int PRIVATE_FLAG_SYSTEM_APPLICATION_OVERLAY = 8;
        @SystemApi
        @RequiresPermission(value="android.permission.INTERNAL_SYSTEM_WINDOW")
        public static final int SYSTEM_FLAG_SHOW_FOR_ALL_USERS = 16;
        public static final int PRIVATE_FLAG_UNRESTRICTED_GESTURE_EXCLUSION = 32;
        @UnsupportedAppUsage
        public static final int PRIVATE_FLAG_NO_MOVE_ANIMATION = 64;
        public static final int PRIVATE_FLAG_COMPATIBLE_WINDOW = 128;
        public static final int PRIVATE_FLAG_SYSTEM_ERROR = 256;
        public static final int PRIVATE_FLAG_OPTIMIZE_MEASURE = 512;
        public static final int PRIVATE_FLAG_DISABLE_WALLPAPER_TOUCH_EVENTS = 1024;
        public static final int PRIVATE_FLAG_FORCE_SHOW_STATUS_BAR = 2048;
        public static final int PRIVATE_FLAG_LAYOUT_SIZE_EXTENDED_BY_CUTOUT = 4096;
        public static final int PRIVATE_FLAG_FORCE_DECOR_VIEW_VISIBILITY = 8192;
        public static final int PRIVATE_FLAG_LAYOUT_CHILD_WINDOW_IN_PARENT_FRAME = 16384;
        public static final int PRIVATE_FLAG_FORCE_DRAW_BAR_BACKGROUNDS = 32768;
        public static final int PRIVATE_FLAG_SUSTAINED_PERFORMANCE_MODE = 65536;
        @SystemApi
        @RequiresPermission(value="android.permission.HIDE_NON_SYSTEM_OVERLAY_WINDOWS")
        public static final int SYSTEM_FLAG_HIDE_NON_SYSTEM_OVERLAY_WINDOWS = 524288;
        public static final int PRIVATE_FLAG_IS_ROUNDED_CORNERS_OVERLAY = 0x100000;
        public static final int PRIVATE_FLAG_EXCLUDE_FROM_SCREEN_MAGNIFICATION = 0x200000;
        public static final int PRIVATE_FLAG_NOT_MAGNIFIABLE = 0x400000;
        public static final int PRIVATE_FLAG_STATUS_FORCE_SHOW_NAVIGATION = 0x800000;
        public static final int PRIVATE_FLAG_COLOR_SPACE_AGNOSTIC = 0x1000000;
        public static final int PRIVATE_FLAG_USE_BLAST = 0x2000000;
        public static final int PRIVATE_FLAG_APPEARANCE_CONTROLLED = 0x4000000;
        public static final int PRIVATE_FLAG_BEHAVIOR_CONTROLLED = 0x8000000;
        public static final int PRIVATE_FLAG_FIT_INSETS_CONTROLLED = 0x10000000;
        public static final int PRIVATE_FLAG_TRUSTED_OVERLAY = 0x20000000;
        public static final int PRIVATE_FLAG_INSET_PARENT_FRAME_BY_IME = 0x40000000;
        @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
        public static final int PRIVATE_FLAG_INTERCEPT_GLOBAL_DRAG_AND_DROP = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=2, equals=2, name="FORCE_HARDWARE_ACCELERATED"), @ViewDebug.FlagToString(mask=4, equals=4, name="WANTS_OFFSET_NOTIFICATIONS"), @ViewDebug.FlagToString(mask=16, equals=16, name="SHOW_FOR_ALL_USERS"), @ViewDebug.FlagToString(mask=32, equals=32, name="UNRESTRICTED_GESTURE_EXCLUSION"), @ViewDebug.FlagToString(mask=64, equals=64, name="NO_MOVE_ANIMATION"), @ViewDebug.FlagToString(mask=128, equals=128, name="COMPATIBLE_WINDOW"), @ViewDebug.FlagToString(mask=256, equals=256, name="SYSTEM_ERROR"), @ViewDebug.FlagToString(mask=512, equals=512, name="OPTIMIZE_MEASURE"), @ViewDebug.FlagToString(mask=1024, equals=1024, name="DISABLE_WALLPAPER_TOUCH_EVENTS"), @ViewDebug.FlagToString(mask=2048, equals=2048, name="FORCE_STATUS_BAR_VISIBLE"), @ViewDebug.FlagToString(mask=4096, equals=4096, name="LAYOUT_SIZE_EXTENDED_BY_CUTOUT"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="FORCE_DECOR_VIEW_VISIBILITY"), @ViewDebug.FlagToString(mask=16384, equals=16384, name="LAYOUT_CHILD_WINDOW_IN_PARENT_FRAME"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="FORCE_DRAW_STATUS_BAR_BACKGROUND"), @ViewDebug.FlagToString(mask=65536, equals=65536, name="SUSTAINED_PERFORMANCE_MODE"), @ViewDebug.FlagToString(mask=524288, equals=524288, name="HIDE_NON_SYSTEM_OVERLAY_WINDOWS"), @ViewDebug.FlagToString(mask=0x100000, equals=0x100000, name="IS_ROUNDED_CORNERS_OVERLAY"), @ViewDebug.FlagToString(mask=0x200000, equals=0x200000, name="EXCLUDE_FROM_SCREEN_MAGNIFICATION"), @ViewDebug.FlagToString(mask=0x400000, equals=0x400000, name="NOT_MAGNIFIABLE"), @ViewDebug.FlagToString(mask=0x800000, equals=0x800000, name="STATUS_FORCE_SHOW_NAVIGATION"), @ViewDebug.FlagToString(mask=0x1000000, equals=0x1000000, name="COLOR_SPACE_AGNOSTIC"), @ViewDebug.FlagToString(mask=0x2000000, equals=0x2000000, name="USE_BLAST"), @ViewDebug.FlagToString(mask=0x4000000, equals=0x4000000, name="APPEARANCE_CONTROLLED"), @ViewDebug.FlagToString(mask=0x8000000, equals=0x8000000, name="BEHAVIOR_CONTROLLED"), @ViewDebug.FlagToString(mask=0x10000000, equals=0x10000000, name="FIT_INSETS_CONTROLLED"), @ViewDebug.FlagToString(mask=0x20000000, equals=0x20000000, name="TRUSTED_OVERLAY"), @ViewDebug.FlagToString(mask=0x40000000, equals=0x40000000, name="INSET_PARENT_FRAME_BY_IME"), @ViewDebug.FlagToString(mask=-2147483648, equals=-2147483648, name="INTERCEPT_GLOBAL_DRAG_AND_DROP"), @ViewDebug.FlagToString(mask=8, equals=8, name="PRIVATE_FLAG_SYSTEM_APPLICATION_OVERLAY")})
        @UnsupportedAppUsage
        @PrivateFlags
        public int privateFlags;
        public static final int SOFT_INPUT_MASK_STATE = 15;
        public static final int SOFT_INPUT_STATE_UNSPECIFIED = 0;
        public static final int SOFT_INPUT_STATE_UNCHANGED = 1;
        public static final int SOFT_INPUT_STATE_HIDDEN = 2;
        public static final int SOFT_INPUT_STATE_ALWAYS_HIDDEN = 3;
        public static final int SOFT_INPUT_STATE_VISIBLE = 4;
        public static final int SOFT_INPUT_STATE_ALWAYS_VISIBLE = 5;
        public static final int SOFT_INPUT_MASK_ADJUST = 240;
        public static final int SOFT_INPUT_ADJUST_UNSPECIFIED = 0;
        @Deprecated
        public static final int SOFT_INPUT_ADJUST_RESIZE = 16;
        public static final int SOFT_INPUT_ADJUST_PAN = 32;
        public static final int SOFT_INPUT_ADJUST_NOTHING = 48;
        public static final int SOFT_INPUT_IS_FORWARD_NAVIGATION = 256;
        public int softInputMode;
        public int gravity;
        public float horizontalMargin;
        public float verticalMargin;
        public final Rect surfaceInsets = new Rect();
        public boolean hasManualSurfaceInsets;
        public boolean receiveInsetsIgnoringZOrder;
        public boolean preservePreviousSurfaceInsets = true;
        public int format;
        public int windowAnimations;
        public float alpha = 1.0f;
        public float dimAmount = 1.0f;
        public static final float BRIGHTNESS_OVERRIDE_NONE = -1.0f;
        public static final float BRIGHTNESS_OVERRIDE_OFF = 0.0f;
        public static final float BRIGHTNESS_OVERRIDE_FULL = 1.0f;
        public float screenBrightness = -1.0f;
        public float buttonBrightness = -1.0f;
        public static final int ROTATION_ANIMATION_UNSPECIFIED = -1;
        public static final int ROTATION_ANIMATION_ROTATE = 0;
        public static final int ROTATION_ANIMATION_CROSSFADE = 1;
        public static final int ROTATION_ANIMATION_JUMPCUT = 2;
        public static final int ROTATION_ANIMATION_SEAMLESS = 3;
        public int rotationAnimation = 0;
        public IBinder token = null;
        public IBinder mWindowContextToken = null;
        public String packageName = null;
        public int screenOrientation = -1;
        public float preferredRefreshRate;
        public int preferredDisplayModeId;
        public float preferredMinDisplayRefreshRate;
        public float preferredMaxDisplayRefreshRate;
        public static final int DISPLAY_FLAG_DISABLE_HDR_CONVERSION = 1;
        @DisplayFlags
        private int mDisplayFlags;
        @Deprecated
        public int systemUiVisibility;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int subtreeSystemUiVisibility;
        @UnsupportedAppUsage
        public boolean hasSystemUiListeners;
        public int layoutInDisplayCutoutMode = 0;
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_DEFAULT = 0;
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES = 1;
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_NEVER = 2;
        public static final int LAYOUT_IN_DISPLAY_CUTOUT_MODE_ALWAYS = 3;
        public static final int INPUT_FEATURE_NO_INPUT_CHANNEL = 1;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int INPUT_FEATURE_DISABLE_USER_ACTIVITY = 2;
        @RequiresPermission(value="android.permission.MONITOR_INPUT")
        public static final int INPUT_FEATURE_SPY = 4;
        @UnsupportedAppUsage
        public int inputFeatures;
        @UnsupportedAppUsage
        public long userActivityTimeout = -1L;
        public long accessibilityIdOfAnchor = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
        public CharSequence accessibilityTitle;
        @UnsupportedAppUsage
        public long hideTimeoutMilliseconds = -1L;
        public boolean preferMinimalPostProcessing = false;
        private int mBlurBehindRadius = 0;
        private int mColorMode = 0;
        public final InsetsFlags insetsFlags = new InsetsFlags();
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="STATUS_BARS"), @ViewDebug.FlagToString(mask=2, equals=2, name="NAVIGATION_BARS"), @ViewDebug.FlagToString(mask=4, equals=4, name="CAPTION_BAR"), @ViewDebug.FlagToString(mask=8, equals=8, name="IME"), @ViewDebug.FlagToString(mask=16, equals=16, name="SYSTEM_GESTURES"), @ViewDebug.FlagToString(mask=32, equals=32, name="MANDATORY_SYSTEM_GESTURES"), @ViewDebug.FlagToString(mask=64, equals=64, name="TAPPABLE_ELEMENT"), @ViewDebug.FlagToString(mask=256, equals=256, name="WINDOW_DECOR")})
        private int mFitInsetsTypes = WindowInsets.Type.systemBars();
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="LEFT"), @ViewDebug.FlagToString(mask=2, equals=2, name="TOP"), @ViewDebug.FlagToString(mask=4, equals=4, name="RIGHT"), @ViewDebug.FlagToString(mask=8, equals=8, name="BOTTOM")})
        private int mFitInsetsSides = WindowInsets.Side.all();
        private boolean mFitInsetsIgnoringVisibility = false;
        public InsetsFrameProvider[] providedInsets;
        public boolean insetsRoundedCornerFrame = false;
        public LayoutParams[] paramsForRotation;
        private boolean mWallpaperTouchEventsEnabled = true;
        public static final Parcelable.Creator<LayoutParams> CREATOR = new Parcelable.Creator<LayoutParams>(){

            @Override
            public LayoutParams createFromParcel(Parcel in) {
                return new LayoutParams(in);
            }

            public LayoutParams[] newArray(int size) {
                return new LayoutParams[size];
            }
        };
        public static final int LAYOUT_CHANGED = 1;
        public static final int TYPE_CHANGED = 2;
        public static final int FLAGS_CHANGED = 4;
        public static final int FORMAT_CHANGED = 8;
        public static final int ANIMATION_CHANGED = 16;
        public static final int DIM_AMOUNT_CHANGED = 32;
        public static final int TITLE_CHANGED = 64;
        public static final int ALPHA_CHANGED = 128;
        public static final int MEMORY_TYPE_CHANGED = 256;
        public static final int SOFT_INPUT_MODE_CHANGED = 512;
        public static final int SCREEN_ORIENTATION_CHANGED = 1024;
        public static final int SCREEN_BRIGHTNESS_CHANGED = 2048;
        public static final int ROTATION_ANIMATION_CHANGED = 4096;
        public static final int BUTTON_BRIGHTNESS_CHANGED = 8192;
        public static final int SYSTEM_UI_VISIBILITY_CHANGED = 16384;
        public static final int SYSTEM_UI_LISTENER_CHANGED = 32768;
        public static final int INPUT_FEATURES_CHANGED = 65536;
        public static final int PRIVATE_FLAGS_CHANGED = 131072;
        public static final int USER_ACTIVITY_TIMEOUT_CHANGED = 262144;
        public static final int TRANSLUCENT_FLAGS_CHANGED = 524288;
        public static final int SURFACE_INSETS_CHANGED = 0x100000;
        public static final int PREFERRED_REFRESH_RATE_CHANGED = 0x200000;
        public static final int DISPLAY_FLAGS_CHANGED = 0x400000;
        public static final int PREFERRED_DISPLAY_MODE_ID = 0x800000;
        public static final int ACCESSIBILITY_ANCHOR_CHANGED = 0x1000000;
        public static final int ACCESSIBILITY_TITLE_CHANGED = 0x2000000;
        public static final int COLOR_MODE_CHANGED = 0x4000000;
        public static final int INSET_FLAGS_CHANGED = 0x8000000;
        public static final int MINIMAL_POST_PROCESSING_PREFERENCE_CHANGED = 0x10000000;
        public static final int BLUR_BEHIND_RADIUS_CHANGED = 0x20000000;
        public static final int PREFERRED_MIN_DISPLAY_REFRESH_RATE = 0x40000000;
        public static final int PREFERRED_MAX_DISPLAY_REFRESH_RATE = Integer.MIN_VALUE;
        private int[] mCompatibilityParamsBackup = null;
        private CharSequence mTitle = null;

        public static boolean isSystemAlertWindowType(int type) {
            switch (type) {
                case 2002: 
                case 2003: 
                case 2006: 
                case 2007: 
                case 2010: 
                case 2038: {
                    return true;
                }
            }
            return false;
        }

        public static boolean mayUseInputMethod(int flags) {
            return (flags & 8) != 8 && (flags & 0x20000) != 131072;
        }

        public void setFitInsetsTypes(int types) {
            this.mFitInsetsTypes = types;
            this.privateFlags |= 0x10000000;
        }

        public void setFitInsetsSides(int sides) {
            this.mFitInsetsSides = sides;
            this.privateFlags |= 0x10000000;
        }

        public void setFitInsetsIgnoringVisibility(boolean ignore) {
            this.mFitInsetsIgnoringVisibility = ignore;
            this.privateFlags |= 0x10000000;
        }

        public void setTrustedOverlay() {
            this.privateFlags |= 0x20000000;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.SYSTEM_APPLICATION_OVERLAY")
        public void setSystemApplicationOverlay(boolean isSystemApplicationOverlay) {
            this.privateFlags = isSystemApplicationOverlay ? (this.privateFlags |= 8) : (this.privateFlags &= 0xFFFFFFF7);
        }

        @SystemApi
        public boolean isSystemApplicationOverlay() {
            return (this.privateFlags & 8) == 8;
        }

        public void setWallpaperTouchEventsEnabled(boolean enable) {
            this.mWallpaperTouchEventsEnabled = enable;
        }

        public boolean areWallpaperTouchEventsEnabled() {
            return this.mWallpaperTouchEventsEnabled;
        }

        public void setCanPlayMoveAnimation(boolean enable) {
            this.privateFlags = enable ? (this.privateFlags &= 0xFFFFFFBF) : (this.privateFlags |= 0x40);
        }

        public boolean canPlayMoveAnimation() {
            return (this.privateFlags & 0x40) == 0;
        }

        public int getFitInsetsTypes() {
            return this.mFitInsetsTypes;
        }

        public int getFitInsetsSides() {
            return this.mFitInsetsSides;
        }

        public boolean isFitInsetsIgnoringVisibility() {
            return this.mFitInsetsIgnoringVisibility;
        }

        private void checkNonRecursiveParams() {
            if (this.paramsForRotation == null) {
                return;
            }
            for (int i = this.paramsForRotation.length - 1; i >= 0; --i) {
                if (this.paramsForRotation[i].paramsForRotation == null) continue;
                throw new IllegalArgumentException("Params cannot contain params recursively.");
            }
        }

        public LayoutParams forRotation(int rotation) {
            if (this.paramsForRotation == null || this.paramsForRotation.length <= rotation || this.paramsForRotation[rotation] == null) {
                return this;
            }
            return this.paramsForRotation[rotation];
        }

        public LayoutParams() {
            super(-1, -1);
            this.type = 2;
            this.format = -1;
        }

        public LayoutParams(int _type) {
            super(-1, -1);
            this.type = _type;
            this.format = -1;
        }

        public LayoutParams(int _type, int _flags) {
            super(-1, -1);
            this.type = _type;
            this.flags = _flags;
            this.format = -1;
        }

        public LayoutParams(int _type, int _flags, int _format) {
            super(-1, -1);
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        public LayoutParams(int w, int h, int _type, int _flags, int _format) {
            super(w, h);
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        public LayoutParams(int w, int h, int xpos, int ypos, int _type, int _flags, int _format) {
            super(w, h);
            this.x = xpos;
            this.y = ypos;
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        public void setTitle(CharSequence title) {
            if (null == title) {
                title = "";
            }
            this.mTitle = TextUtils.stringOrSpannedString(title);
        }

        public CharSequence getTitle() {
            return this.mTitle != null ? this.mTitle : "";
        }

        public void setSurfaceInsets(View view, boolean manual, boolean preservePrevious) {
            int surfaceInset = (int)Math.ceil(view.getZ() * 2.0f);
            if (surfaceInset == 0) {
                this.surfaceInsets.set(0, 0, 0, 0);
            } else {
                this.surfaceInsets.set(Math.max(surfaceInset, this.surfaceInsets.left), Math.max(surfaceInset, this.surfaceInsets.top), Math.max(surfaceInset, this.surfaceInsets.right), Math.max(surfaceInset, this.surfaceInsets.bottom));
            }
            this.hasManualSurfaceInsets = manual;
            this.preservePreviousSurfaceInsets = preservePrevious;
        }

        public boolean isHdrConversionEnabled() {
            return (this.mDisplayFlags & 1) == 0;
        }

        public void setHdrConversionEnabled(boolean enabled) {
            this.mDisplayFlags = !enabled ? (this.mDisplayFlags |= 1) : (this.mDisplayFlags &= 0xFFFFFFFE);
        }

        public void setColorMode(int colorMode) {
            this.mColorMode = colorMode;
        }

        public int getColorMode() {
            return this.mColorMode;
        }

        public void setBlurBehindRadius(int blurBehindRadius) {
            this.mBlurBehindRadius = blurBehindRadius;
        }

        public int getBlurBehindRadius() {
            return this.mBlurBehindRadius;
        }

        @SystemApi
        public void setUserActivityTimeout(long timeout) {
            this.userActivityTimeout = timeout;
        }

        @SystemApi
        public long getUserActivityTimeout() {
            return this.userActivityTimeout;
        }

        public void setWindowContextToken(IBinder token) {
            this.mWindowContextToken = token;
        }

        public IBinder getWindowContextToken() {
            return this.mWindowContextToken;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.width);
            out.writeInt(this.height);
            out.writeInt(this.x);
            out.writeInt(this.y);
            out.writeInt(this.type);
            out.writeInt(this.flags);
            out.writeInt(this.privateFlags);
            out.writeInt(this.softInputMode);
            out.writeInt(this.layoutInDisplayCutoutMode);
            out.writeInt(this.gravity);
            out.writeFloat(this.horizontalMargin);
            out.writeFloat(this.verticalMargin);
            out.writeInt(this.format);
            out.writeInt(this.windowAnimations);
            out.writeFloat(this.alpha);
            out.writeFloat(this.dimAmount);
            out.writeFloat(this.screenBrightness);
            out.writeFloat(this.buttonBrightness);
            out.writeInt(this.rotationAnimation);
            out.writeStrongBinder(this.token);
            out.writeStrongBinder(this.mWindowContextToken);
            out.writeString(this.packageName);
            TextUtils.writeToParcel(this.mTitle, out, parcelableFlags);
            out.writeInt(this.screenOrientation);
            out.writeFloat(this.preferredRefreshRate);
            out.writeInt(this.preferredDisplayModeId);
            out.writeFloat(this.preferredMinDisplayRefreshRate);
            out.writeFloat(this.preferredMaxDisplayRefreshRate);
            out.writeInt(this.systemUiVisibility);
            out.writeInt(this.subtreeSystemUiVisibility);
            out.writeBoolean(this.hasSystemUiListeners);
            out.writeInt(this.inputFeatures);
            out.writeLong(this.userActivityTimeout);
            out.writeInt(this.surfaceInsets.left);
            out.writeInt(this.surfaceInsets.top);
            out.writeInt(this.surfaceInsets.right);
            out.writeInt(this.surfaceInsets.bottom);
            out.writeBoolean(this.hasManualSurfaceInsets);
            out.writeBoolean(this.receiveInsetsIgnoringZOrder);
            out.writeBoolean(this.preservePreviousSurfaceInsets);
            out.writeLong(this.accessibilityIdOfAnchor);
            TextUtils.writeToParcel(this.accessibilityTitle, out, parcelableFlags);
            out.writeInt(this.mColorMode);
            out.writeLong(this.hideTimeoutMilliseconds);
            out.writeInt(this.insetsFlags.appearance);
            out.writeInt(this.insetsFlags.behavior);
            out.writeInt(this.mFitInsetsTypes);
            out.writeInt(this.mFitInsetsSides);
            out.writeBoolean(this.mFitInsetsIgnoringVisibility);
            out.writeBoolean(this.preferMinimalPostProcessing);
            out.writeInt(this.mBlurBehindRadius);
            out.writeBoolean(this.insetsRoundedCornerFrame);
            out.writeBoolean(this.mWallpaperTouchEventsEnabled);
            out.writeTypedArray(this.providedInsets, 0);
            this.checkNonRecursiveParams();
            out.writeTypedArray(this.paramsForRotation, 0);
            out.writeInt(this.mDisplayFlags);
        }

        public LayoutParams(Parcel in) {
            this.width = in.readInt();
            this.height = in.readInt();
            this.x = in.readInt();
            this.y = in.readInt();
            this.type = in.readInt();
            this.flags = in.readInt();
            this.privateFlags = in.readInt();
            this.softInputMode = in.readInt();
            this.layoutInDisplayCutoutMode = in.readInt();
            this.gravity = in.readInt();
            this.horizontalMargin = in.readFloat();
            this.verticalMargin = in.readFloat();
            this.format = in.readInt();
            this.windowAnimations = in.readInt();
            this.alpha = in.readFloat();
            this.dimAmount = in.readFloat();
            this.screenBrightness = in.readFloat();
            this.buttonBrightness = in.readFloat();
            this.rotationAnimation = in.readInt();
            this.token = in.readStrongBinder();
            this.mWindowContextToken = in.readStrongBinder();
            this.packageName = in.readString();
            this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.screenOrientation = in.readInt();
            this.preferredRefreshRate = in.readFloat();
            this.preferredDisplayModeId = in.readInt();
            this.preferredMinDisplayRefreshRate = in.readFloat();
            this.preferredMaxDisplayRefreshRate = in.readFloat();
            this.systemUiVisibility = in.readInt();
            this.subtreeSystemUiVisibility = in.readInt();
            this.hasSystemUiListeners = in.readBoolean();
            this.inputFeatures = in.readInt();
            this.userActivityTimeout = in.readLong();
            this.surfaceInsets.left = in.readInt();
            this.surfaceInsets.top = in.readInt();
            this.surfaceInsets.right = in.readInt();
            this.surfaceInsets.bottom = in.readInt();
            this.hasManualSurfaceInsets = in.readBoolean();
            this.receiveInsetsIgnoringZOrder = in.readBoolean();
            this.preservePreviousSurfaceInsets = in.readBoolean();
            this.accessibilityIdOfAnchor = in.readLong();
            this.accessibilityTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mColorMode = in.readInt();
            this.hideTimeoutMilliseconds = in.readLong();
            this.insetsFlags.appearance = in.readInt();
            this.insetsFlags.behavior = in.readInt();
            this.mFitInsetsTypes = in.readInt();
            this.mFitInsetsSides = in.readInt();
            this.mFitInsetsIgnoringVisibility = in.readBoolean();
            this.preferMinimalPostProcessing = in.readBoolean();
            this.mBlurBehindRadius = in.readInt();
            this.insetsRoundedCornerFrame = in.readBoolean();
            this.mWallpaperTouchEventsEnabled = in.readBoolean();
            this.providedInsets = in.createTypedArray(InsetsFrameProvider.CREATOR);
            this.paramsForRotation = in.createTypedArray(CREATOR);
            this.mDisplayFlags = in.readInt();
        }

        public int copyFrom(LayoutParams o) {
            int changes = 0;
            if (this.width != o.width) {
                this.width = o.width;
                changes |= 1;
            }
            if (this.height != o.height) {
                this.height = o.height;
                changes |= 1;
            }
            if (this.x != o.x) {
                this.x = o.x;
                changes |= 1;
            }
            if (this.y != o.y) {
                this.y = o.y;
                changes |= 1;
            }
            if (this.horizontalWeight != o.horizontalWeight) {
                this.horizontalWeight = o.horizontalWeight;
                changes |= 1;
            }
            if (this.verticalWeight != o.verticalWeight) {
                this.verticalWeight = o.verticalWeight;
                changes |= 1;
            }
            if (this.horizontalMargin != o.horizontalMargin) {
                this.horizontalMargin = o.horizontalMargin;
                changes |= 1;
            }
            if (this.verticalMargin != o.verticalMargin) {
                this.verticalMargin = o.verticalMargin;
                changes |= 1;
            }
            if (this.type != o.type) {
                this.type = o.type;
                changes |= 2;
            }
            if (this.flags != o.flags) {
                int diff = this.flags ^ o.flags;
                if ((diff & 0xC000000) != 0) {
                    changes |= 0x80000;
                }
                this.flags = o.flags;
                changes |= 4;
            }
            if (this.privateFlags != o.privateFlags) {
                this.privateFlags = o.privateFlags;
                changes |= 0x20000;
            }
            if (this.softInputMode != o.softInputMode) {
                this.softInputMode = o.softInputMode;
                changes |= 0x200;
            }
            if (this.layoutInDisplayCutoutMode != o.layoutInDisplayCutoutMode) {
                this.layoutInDisplayCutoutMode = o.layoutInDisplayCutoutMode;
                changes |= 1;
            }
            if (this.gravity != o.gravity) {
                this.gravity = o.gravity;
                changes |= 1;
            }
            if (this.format != o.format) {
                this.format = o.format;
                changes |= 8;
            }
            if (this.windowAnimations != o.windowAnimations) {
                this.windowAnimations = o.windowAnimations;
                changes |= 0x10;
            }
            if (this.token == null) {
                this.token = o.token;
            }
            if (this.mWindowContextToken == null) {
                this.mWindowContextToken = o.mWindowContextToken;
            }
            if (this.packageName == null) {
                this.packageName = o.packageName;
            }
            if (!Objects.equals(this.mTitle, o.mTitle) && o.mTitle != null) {
                this.mTitle = o.mTitle;
                changes |= 0x40;
            }
            if (this.alpha != o.alpha) {
                this.alpha = o.alpha;
                changes |= 0x80;
            }
            if (this.dimAmount != o.dimAmount) {
                this.dimAmount = o.dimAmount;
                changes |= 0x20;
            }
            if (this.screenBrightness != o.screenBrightness) {
                this.screenBrightness = o.screenBrightness;
                changes |= 0x800;
            }
            if (this.buttonBrightness != o.buttonBrightness) {
                this.buttonBrightness = o.buttonBrightness;
                changes |= 0x2000;
            }
            if (this.rotationAnimation != o.rotationAnimation) {
                this.rotationAnimation = o.rotationAnimation;
                changes |= 0x1000;
            }
            if (this.screenOrientation != o.screenOrientation) {
                this.screenOrientation = o.screenOrientation;
                changes |= 0x400;
            }
            if (this.preferredRefreshRate != o.preferredRefreshRate) {
                this.preferredRefreshRate = o.preferredRefreshRate;
                changes |= 0x200000;
            }
            if (this.preferredDisplayModeId != o.preferredDisplayModeId) {
                this.preferredDisplayModeId = o.preferredDisplayModeId;
                changes |= 0x800000;
            }
            if (this.preferredMinDisplayRefreshRate != o.preferredMinDisplayRefreshRate) {
                this.preferredMinDisplayRefreshRate = o.preferredMinDisplayRefreshRate;
                changes |= 0x40000000;
            }
            if (this.preferredMaxDisplayRefreshRate != o.preferredMaxDisplayRefreshRate) {
                this.preferredMaxDisplayRefreshRate = o.preferredMaxDisplayRefreshRate;
                changes |= Integer.MIN_VALUE;
            }
            if (this.mDisplayFlags != o.mDisplayFlags) {
                this.mDisplayFlags = o.mDisplayFlags;
                changes |= 0x400000;
            }
            if (this.systemUiVisibility != o.systemUiVisibility || this.subtreeSystemUiVisibility != o.subtreeSystemUiVisibility) {
                this.systemUiVisibility = o.systemUiVisibility;
                this.subtreeSystemUiVisibility = o.subtreeSystemUiVisibility;
                changes |= 0x4000;
            }
            if (this.hasSystemUiListeners != o.hasSystemUiListeners) {
                this.hasSystemUiListeners = o.hasSystemUiListeners;
                changes |= 0x8000;
            }
            if (this.inputFeatures != o.inputFeatures) {
                this.inputFeatures = o.inputFeatures;
                changes |= 0x10000;
            }
            if (this.userActivityTimeout != o.userActivityTimeout) {
                this.userActivityTimeout = o.userActivityTimeout;
                changes |= 0x40000;
            }
            if (!this.surfaceInsets.equals(o.surfaceInsets)) {
                this.surfaceInsets.set(o.surfaceInsets);
                changes |= 0x100000;
            }
            if (this.hasManualSurfaceInsets != o.hasManualSurfaceInsets) {
                this.hasManualSurfaceInsets = o.hasManualSurfaceInsets;
                changes |= 0x100000;
            }
            if (this.receiveInsetsIgnoringZOrder != o.receiveInsetsIgnoringZOrder) {
                this.receiveInsetsIgnoringZOrder = o.receiveInsetsIgnoringZOrder;
                changes |= 0x100000;
            }
            if (this.preservePreviousSurfaceInsets != o.preservePreviousSurfaceInsets) {
                this.preservePreviousSurfaceInsets = o.preservePreviousSurfaceInsets;
                changes |= 0x100000;
            }
            if (this.accessibilityIdOfAnchor != o.accessibilityIdOfAnchor) {
                this.accessibilityIdOfAnchor = o.accessibilityIdOfAnchor;
                changes |= 0x1000000;
            }
            if (!Objects.equals(this.accessibilityTitle, o.accessibilityTitle) && o.accessibilityTitle != null) {
                this.accessibilityTitle = o.accessibilityTitle;
                changes |= 0x2000000;
            }
            if (this.mColorMode != o.mColorMode) {
                this.mColorMode = o.mColorMode;
                changes |= 0x4000000;
            }
            if (this.preferMinimalPostProcessing != o.preferMinimalPostProcessing) {
                this.preferMinimalPostProcessing = o.preferMinimalPostProcessing;
                changes |= 0x10000000;
            }
            if (this.mBlurBehindRadius != o.mBlurBehindRadius) {
                this.mBlurBehindRadius = o.mBlurBehindRadius;
                changes |= 0x20000000;
            }
            this.hideTimeoutMilliseconds = o.hideTimeoutMilliseconds;
            if (this.insetsFlags.appearance != o.insetsFlags.appearance) {
                this.insetsFlags.appearance = o.insetsFlags.appearance;
                changes |= 0x8000000;
            }
            if (this.insetsFlags.behavior != o.insetsFlags.behavior) {
                this.insetsFlags.behavior = o.insetsFlags.behavior;
                changes |= 0x8000000;
            }
            if (this.mFitInsetsTypes != o.mFitInsetsTypes) {
                this.mFitInsetsTypes = o.mFitInsetsTypes;
                changes |= 1;
            }
            if (this.mFitInsetsSides != o.mFitInsetsSides) {
                this.mFitInsetsSides = o.mFitInsetsSides;
                changes |= 1;
            }
            if (this.mFitInsetsIgnoringVisibility != o.mFitInsetsIgnoringVisibility) {
                this.mFitInsetsIgnoringVisibility = o.mFitInsetsIgnoringVisibility;
                changes |= 1;
            }
            if (!Arrays.equals(this.providedInsets, o.providedInsets)) {
                this.providedInsets = o.providedInsets;
                changes |= 1;
            }
            if (this.insetsRoundedCornerFrame != o.insetsRoundedCornerFrame) {
                this.insetsRoundedCornerFrame = o.insetsRoundedCornerFrame;
                changes |= 1;
            }
            if (this.paramsForRotation != o.paramsForRotation) {
                if ((changes & 1) == 0) {
                    if (this.paramsForRotation != null && o.paramsForRotation != null && this.paramsForRotation.length == o.paramsForRotation.length) {
                        for (int i = this.paramsForRotation.length - 1; i >= 0; --i) {
                            if (!LayoutParams.hasLayoutDiff(this.paramsForRotation[i], o.paramsForRotation[i])) continue;
                            changes |= 1;
                            break;
                        }
                    } else {
                        changes |= 1;
                    }
                }
                this.paramsForRotation = o.paramsForRotation;
                this.checkNonRecursiveParams();
            }
            if (this.mWallpaperTouchEventsEnabled != o.mWallpaperTouchEventsEnabled) {
                this.mWallpaperTouchEventsEnabled = o.mWallpaperTouchEventsEnabled;
                changes |= 1;
            }
            return changes;
        }

        private static boolean hasLayoutDiff(LayoutParams a, LayoutParams b) {
            return a.width != b.width || a.height != b.height || a.x != b.x || a.y != b.y || a.horizontalMargin != b.horizontalMargin || a.verticalMargin != b.verticalMargin || a.layoutInDisplayCutoutMode != b.layoutInDisplayCutoutMode || a.gravity != b.gravity || !Arrays.equals(a.providedInsets, b.providedInsets) || a.mFitInsetsTypes != b.mFitInsetsTypes || a.mFitInsetsSides != b.mFitInsetsSides || a.mFitInsetsIgnoringVisibility != b.mFitInsetsIgnoringVisibility;
        }

        @Override
        public String debug(String output) {
            output = output + "Contents of " + this + ":";
            Log.d("Debug", output);
            output = super.debug("");
            Log.d("Debug", output);
            Log.d("Debug", "");
            Log.d("Debug", "WindowManager.LayoutParams={title=" + this.mTitle + "}");
            return "";
        }

        public String toString() {
            return this.toString("");
        }

        public void dumpDimensions(StringBuilder sb) {
            sb.append('(');
            sb.append(this.x);
            sb.append(',');
            sb.append(this.y);
            sb.append(")(");
            sb.append(this.width == -1 ? "fill" : (this.width == -2 ? "wrap" : String.valueOf(this.width)));
            sb.append('x');
            sb.append(this.height == -1 ? "fill" : (this.height == -2 ? "wrap" : String.valueOf(this.height)));
            sb.append(")");
        }

        public String toString(String prefix) {
            int i;
            StringBuilder sb = new StringBuilder(256);
            sb.append('{');
            this.dumpDimensions(sb);
            if (this.horizontalMargin != 0.0f) {
                sb.append(" hm=");
                sb.append(this.horizontalMargin);
            }
            if (this.verticalMargin != 0.0f) {
                sb.append(" vm=");
                sb.append(this.verticalMargin);
            }
            if (this.gravity != 0) {
                sb.append(" gr=");
                sb.append(Gravity.toString(this.gravity));
            }
            if (this.softInputMode != 0) {
                sb.append(" sim={");
                sb.append(LayoutParams.softInputModeToString(this.softInputMode));
                sb.append('}');
            }
            if (this.layoutInDisplayCutoutMode != 0) {
                sb.append(" layoutInDisplayCutoutMode=");
                sb.append(LayoutParams.layoutInDisplayCutoutModeToString(this.layoutInDisplayCutoutMode));
            }
            sb.append(" ty=");
            sb.append(ViewDebug.intToString(LayoutParams.class, "type", this.type));
            if (this.format != -1) {
                sb.append(" fmt=");
                sb.append(PixelFormat.formatToString(this.format));
            }
            if (this.windowAnimations != 0) {
                sb.append(" wanim=0x");
                sb.append(Integer.toHexString(this.windowAnimations));
            }
            if (this.screenOrientation != -1) {
                sb.append(" or=");
                sb.append(ActivityInfo.screenOrientationToString(this.screenOrientation));
            }
            if (this.alpha != 1.0f) {
                sb.append(" alpha=");
                sb.append(this.alpha);
            }
            if (this.screenBrightness != -1.0f) {
                sb.append(" sbrt=");
                sb.append(this.screenBrightness);
            }
            if (this.buttonBrightness != -1.0f) {
                sb.append(" bbrt=");
                sb.append(this.buttonBrightness);
            }
            if (this.rotationAnimation != 0) {
                sb.append(" rotAnim=");
                sb.append(LayoutParams.rotationAnimationToString(this.rotationAnimation));
            }
            if (this.preferredRefreshRate != 0.0f) {
                sb.append(" preferredRefreshRate=");
                sb.append(this.preferredRefreshRate);
            }
            if (this.preferredDisplayModeId != 0) {
                sb.append(" preferredDisplayMode=");
                sb.append(this.preferredDisplayModeId);
            }
            if (this.preferredMinDisplayRefreshRate != 0.0f) {
                sb.append(" preferredMinDisplayRefreshRate=");
                sb.append(this.preferredMinDisplayRefreshRate);
            }
            if (this.preferredMaxDisplayRefreshRate != 0.0f) {
                sb.append(" preferredMaxDisplayRefreshRate=");
                sb.append(this.preferredMaxDisplayRefreshRate);
            }
            if (this.mDisplayFlags != 0) {
                sb.append(" displayFlags=0x");
                sb.append(Integer.toHexString(this.mDisplayFlags));
            }
            if (this.hasSystemUiListeners) {
                sb.append(" sysuil=");
                sb.append(this.hasSystemUiListeners);
            }
            if (this.inputFeatures != 0) {
                sb.append(" if=").append(LayoutParams.inputFeaturesToString(this.inputFeatures));
            }
            if (this.userActivityTimeout >= 0L) {
                sb.append(" userActivityTimeout=").append(this.userActivityTimeout);
            }
            if (this.surfaceInsets.left != 0 || this.surfaceInsets.top != 0 || this.surfaceInsets.right != 0 || this.surfaceInsets.bottom != 0 || this.hasManualSurfaceInsets || !this.preservePreviousSurfaceInsets) {
                sb.append(" surfaceInsets=").append(this.surfaceInsets);
                if (this.hasManualSurfaceInsets) {
                    sb.append(" (manual)");
                }
                if (!this.preservePreviousSurfaceInsets) {
                    sb.append(" (!preservePreviousSurfaceInsets)");
                }
            }
            if (this.receiveInsetsIgnoringZOrder) {
                sb.append(" receive insets ignoring z-order");
            }
            if (this.mColorMode != 0) {
                sb.append(" colorMode=").append(ActivityInfo.colorModeToString(this.mColorMode));
            }
            if (this.preferMinimalPostProcessing) {
                sb.append(" preferMinimalPostProcessing=");
                sb.append(this.preferMinimalPostProcessing);
            }
            if (this.mBlurBehindRadius != 0) {
                sb.append(" blurBehindRadius=");
                sb.append(this.mBlurBehindRadius);
            }
            sb.append(System.lineSeparator());
            sb.append(prefix).append("  fl=").append(ViewDebug.flagsToString(LayoutParams.class, "flags", this.flags));
            if (this.privateFlags != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  pfl=").append(ViewDebug.flagsToString(LayoutParams.class, "privateFlags", this.privateFlags));
            }
            if (this.systemUiVisibility != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  sysui=").append(ViewDebug.flagsToString(View.class, "mSystemUiVisibility", this.systemUiVisibility));
            }
            if (this.subtreeSystemUiVisibility != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  vsysui=").append(ViewDebug.flagsToString(View.class, "mSystemUiVisibility", this.subtreeSystemUiVisibility));
            }
            if (this.insetsFlags.appearance != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  apr=").append(ViewDebug.flagsToString(InsetsFlags.class, "appearance", this.insetsFlags.appearance));
            }
            if (this.insetsFlags.behavior != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  bhv=").append(ViewDebug.flagsToString(InsetsFlags.class, "behavior", this.insetsFlags.behavior));
            }
            if (this.mFitInsetsTypes != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  fitTypes=").append(ViewDebug.flagsToString(LayoutParams.class, "mFitInsetsTypes", this.mFitInsetsTypes));
            }
            if (this.mFitInsetsSides != WindowInsets.Side.all()) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  fitSides=").append(ViewDebug.flagsToString(LayoutParams.class, "mFitInsetsSides", this.mFitInsetsSides));
            }
            if (this.mFitInsetsIgnoringVisibility) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  fitIgnoreVis");
            }
            if (this.providedInsets != null) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  providedInsets:");
                for (i = 0; i < this.providedInsets.length; ++i) {
                    sb.append(System.lineSeparator());
                    sb.append(prefix).append("    ").append(this.providedInsets[i]);
                }
            }
            if (this.insetsRoundedCornerFrame) {
                sb.append(" insetsRoundedCornerFrame=");
                sb.append(this.insetsRoundedCornerFrame);
            }
            if (this.paramsForRotation != null && this.paramsForRotation.length != 0) {
                sb.append(System.lineSeparator());
                sb.append(prefix).append("  paramsForRotation:");
                for (i = 0; i < this.paramsForRotation.length; ++i) {
                    sb.append(System.lineSeparator()).append(prefix).append("    ");
                    sb.append(Surface.rotationToString(i)).append("=");
                    sb.append(this.paramsForRotation[i].toString(prefix + "    "));
                }
            }
            sb.append('}');
            return sb.toString();
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.type);
            proto.write(1120986464258L, this.x);
            proto.write(1120986464259L, this.y);
            proto.write(1120986464260L, this.width);
            proto.write(0x10500000005L, this.height);
            proto.write(1108101562374L, this.horizontalMargin);
            proto.write(1108101562375L, this.verticalMargin);
            proto.write(1120986464264L, this.gravity);
            proto.write(1120986464265L, this.softInputMode);
            proto.write(1159641169930L, this.format);
            proto.write(1120986464267L, this.windowAnimations);
            proto.write(1108101562380L, this.alpha);
            proto.write(1108101562381L, this.screenBrightness);
            proto.write(1108101562382L, this.buttonBrightness);
            proto.write(1159641169935L, this.rotationAnimation);
            proto.write(0x10200000010L, this.preferredRefreshRate);
            proto.write(0x10500000011L, this.preferredDisplayModeId);
            proto.write(1133871366162L, this.hasSystemUiListeners);
            proto.write(1155346202643L, this.inputFeatures);
            proto.write(1112396529684L, this.userActivityTimeout);
            proto.write(1159641169943L, this.mColorMode);
            proto.write(1155346202648L, this.flags);
            proto.write(1155346202650L, this.privateFlags);
            proto.write(1155346202651L, this.systemUiVisibility);
            proto.write(1155346202652L, this.subtreeSystemUiVisibility);
            proto.write(0x10D0000001DL, this.insetsFlags.appearance);
            proto.write(1155346202654L, this.insetsFlags.behavior);
            proto.write(1155346202655L, this.mFitInsetsTypes);
            proto.write(1155346202656L, this.mFitInsetsSides);
            proto.write(1133871366177L, this.mFitInsetsIgnoringVisibility);
            proto.end(token);
        }

        public void scale(float scale) {
            this.x = (int)((float)this.x * scale + 0.5f);
            this.y = (int)((float)this.y * scale + 0.5f);
            if (this.width > 0) {
                this.width = (int)((float)this.width * scale + 0.5f);
            }
            if (this.height > 0) {
                this.height = (int)((float)this.height * scale + 0.5f);
            }
        }

        @UnsupportedAppUsage
        void backup() {
            int[] backup = this.mCompatibilityParamsBackup;
            if (backup == null) {
                backup = this.mCompatibilityParamsBackup = new int[4];
            }
            backup[0] = this.x;
            backup[1] = this.y;
            backup[2] = this.width;
            backup[3] = this.height;
        }

        @UnsupportedAppUsage
        void restore() {
            int[] backup = this.mCompatibilityParamsBackup;
            if (backup != null) {
                this.x = backup[0];
                this.y = backup[1];
                this.width = backup[2];
                this.height = backup[3];
            }
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("x", this.x);
            encoder.addProperty("y", this.y);
            encoder.addProperty("horizontalWeight", this.horizontalWeight);
            encoder.addProperty("verticalWeight", this.verticalWeight);
            encoder.addProperty("type", this.type);
            encoder.addProperty("flags", this.flags);
        }

        public boolean isFullscreen() {
            return this.x == 0 && this.y == 0 && this.width == -1 && this.height == -1;
        }

        private static String layoutInDisplayCutoutModeToString(int mode) {
            switch (mode) {
                case 0: {
                    return "default";
                }
                case 3: {
                    return "always";
                }
                case 2: {
                    return "never";
                }
                case 1: {
                    return "shortEdges";
                }
            }
            return "unknown(" + mode + ")";
        }

        private static String softInputModeToString(int softInputMode) {
            int adjust;
            StringBuilder result = new StringBuilder();
            int state = softInputMode & 0xF;
            if (state != 0) {
                result.append("state=");
                switch (state) {
                    case 1: {
                        result.append("unchanged");
                        break;
                    }
                    case 2: {
                        result.append("hidden");
                        break;
                    }
                    case 3: {
                        result.append("always_hidden");
                        break;
                    }
                    case 4: {
                        result.append("visible");
                        break;
                    }
                    case 5: {
                        result.append("always_visible");
                        break;
                    }
                    default: {
                        result.append(state);
                    }
                }
                result.append(' ');
            }
            if ((adjust = softInputMode & 0xF0) != 0) {
                result.append("adjust=");
                switch (adjust) {
                    case 16: {
                        result.append("resize");
                        break;
                    }
                    case 32: {
                        result.append("pan");
                        break;
                    }
                    case 48: {
                        result.append("nothing");
                        break;
                    }
                    default: {
                        result.append(adjust);
                    }
                }
                result.append(' ');
            }
            if ((softInputMode & 0x100) != 0) {
                result.append("forwardNavigation").append(' ');
            }
            result.deleteCharAt(result.length() - 1);
            return result.toString();
        }

        private static String rotationAnimationToString(int rotationAnimation) {
            switch (rotationAnimation) {
                case -1: {
                    return "UNSPECIFIED";
                }
                case 0: {
                    return "ROTATE";
                }
                case 1: {
                    return "CROSSFADE";
                }
                case 2: {
                    return "JUMPCUT";
                }
                case 3: {
                    return "SEAMLESS";
                }
            }
            return Integer.toString(rotationAnimation);
        }

        private static String inputFeaturesToString(int inputFeatures) {
            ArrayList<String> features = new ArrayList<String>();
            if ((inputFeatures & 1) != 0) {
                inputFeatures &= 0xFFFFFFFE;
                features.add("INPUT_FEATURE_NO_INPUT_CHANNEL");
            }
            if ((inputFeatures & 2) != 0) {
                inputFeatures &= 0xFFFFFFFD;
                features.add("INPUT_FEATURE_DISABLE_USER_ACTIVITY");
            }
            if ((inputFeatures & 4) != 0) {
                inputFeatures &= 0xFFFFFFFB;
                features.add("INPUT_FEATURE_SPY");
            }
            if (inputFeatures != 0) {
                features.add(Integer.toHexString(inputFeatures));
            }
            return String.join((CharSequence)" | ", features);
        }

        public boolean isModal() {
            return (this.flags & 0x28) == 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InputFeatureFlags {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface LayoutInDisplayCutoutMode {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SystemUiVisibilityFlags {
        }

        public static @interface DisplayFlags {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SoftInputModeFlags {
        }

        public static @interface PrivateFlags {
        }

        @SystemApi
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SystemFlags {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface WindowType {
        }
    }

    public static @interface ScreenshotSource {
        public static final int SCREENSHOT_GLOBAL_ACTIONS = 0;
        public static final int SCREENSHOT_KEY_CHORD = 1;
        public static final int SCREENSHOT_KEY_OTHER = 2;
        public static final int SCREENSHOT_OVERVIEW = 3;
        public static final int SCREENSHOT_ACCESSIBILITY_ACTIONS = 4;
        public static final int SCREENSHOT_OTHER = 5;
        public static final int SCREENSHOT_VENDOR_GESTURE = 6;
    }

    public static @interface ScreenshotType {
    }

    public static interface KeyboardShortcutsReceiver {
        public void onKeyboardShortcutsReceived(List<KeyboardShortcutGroup> var1);
    }

    public static class InvalidDisplayException
    extends RuntimeException {
        public InvalidDisplayException() {
        }

        public InvalidDisplayException(String name) {
            super(name);
        }
    }

    public static class BadTokenException
    extends RuntimeException {
        public BadTokenException() {
        }

        public BadTokenException(String name) {
            super(name);
        }
    }

    public static @interface DisplayImePolicy {
    }

    public static @interface RemoveContentMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransitionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransitionType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransitionOldType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShellRootLayer {
    }
}

