/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.WindowManager;
import java.util.Objects;

public class AccessibilityWindowAttributes
implements Parcelable {
    private final CharSequence mWindowTitle;
    private final LocaleList mLocales;
    public static final Parcelable.Creator<AccessibilityWindowAttributes> CREATOR = new Parcelable.Creator<AccessibilityWindowAttributes>(){

        @Override
        public AccessibilityWindowAttributes createFromParcel(Parcel in) {
            return new AccessibilityWindowAttributes(in);
        }

        public AccessibilityWindowAttributes[] newArray(int size) {
            return new AccessibilityWindowAttributes[size];
        }
    };

    public AccessibilityWindowAttributes(WindowManager.LayoutParams layoutParams, LocaleList locales) {
        this.mWindowTitle = this.populateWindowTitle(layoutParams);
        this.mLocales = locales;
    }

    private AccessibilityWindowAttributes(Parcel in) {
        this.mWindowTitle = in.readCharSequence();
        LocaleList inLocales = in.readParcelable(null, LocaleList.class);
        this.mLocales = inLocales != null ? inLocales : LocaleList.getEmptyLocaleList();
    }

    public CharSequence getWindowTitle() {
        return this.mWindowTitle;
    }

    private CharSequence populateWindowTitle(WindowManager.LayoutParams layoutParams) {
        boolean isAccessibilityOverlay;
        CharSequence windowTitle = layoutParams.accessibilityTitle;
        boolean isPanelWindow = layoutParams.type >= 1000 && layoutParams.type <= 1999;
        boolean bl = isAccessibilityOverlay = layoutParams.type == 2032;
        if (TextUtils.isEmpty(windowTitle) && (isPanelWindow || isAccessibilityOverlay)) {
            windowTitle = TextUtils.isEmpty(layoutParams.getTitle()) ? null : layoutParams.getTitle();
        }
        return windowTitle;
    }

    public LocaleList getLocales() {
        return this.mLocales;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessibilityWindowAttributes)) {
            return false;
        }
        AccessibilityWindowAttributes that = (AccessibilityWindowAttributes)o;
        return TextUtils.equals(this.mWindowTitle, that.mWindowTitle) && Objects.equals(this.mLocales, that.mLocales);
    }

    public int hashCode() {
        return Objects.hash(this.mWindowTitle, this.mLocales);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeCharSequence(this.mWindowTitle);
        parcel.writeParcelable(this.mLocales, flags);
    }

    public String toString() {
        return "AccessibilityWindowAttributes{mAccessibilityWindowTitle=" + this.mWindowTitle + "mLocales=" + this.mLocales + '}';
    }
}

