/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.app.assist.AssistStructure;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutofillWindowPresenter;
import java.util.ArrayList;
import java.util.List;

public interface IAugmentedAutofillManagerClient
extends IInterface {
    public static final String DESCRIPTOR = "android.view.autofill.IAugmentedAutofillManagerClient";

    public Rect getViewCoordinates(AutofillId var1) throws RemoteException;

    public AssistStructure.ViewNodeParcelable getViewNodeParcelable(AutofillId var1) throws RemoteException;

    public void autofill(int var1, List<AutofillId> var2, List<AutofillValue> var3, boolean var4) throws RemoteException;

    public void requestShowFillUi(int var1, AutofillId var2, int var3, int var4, Rect var5, IAutofillWindowPresenter var6) throws RemoteException;

    public void requestHideFillUi(int var1, AutofillId var2) throws RemoteException;

    public boolean requestAutofill(int var1, AutofillId var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAugmentedAutofillManagerClient {
        static final int TRANSACTION_getViewCoordinates = 1;
        static final int TRANSACTION_getViewNodeParcelable = 2;
        static final int TRANSACTION_autofill = 3;
        static final int TRANSACTION_requestShowFillUi = 4;
        static final int TRANSACTION_requestHideFillUi = 5;
        static final int TRANSACTION_requestAutofill = 6;

        public Stub() {
            this.attachInterface(this, IAugmentedAutofillManagerClient.DESCRIPTOR);
        }

        public static IAugmentedAutofillManagerClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAugmentedAutofillManagerClient.DESCRIPTOR);
            if (iin != null && iin instanceof IAugmentedAutofillManagerClient) {
                return (IAugmentedAutofillManagerClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getViewCoordinates";
                }
                case 2: {
                    return "getViewNodeParcelable";
                }
                case 3: {
                    return "autofill";
                }
                case 4: {
                    return "requestShowFillUi";
                }
                case 5: {
                    return "requestHideFillUi";
                }
                case 6: {
                    return "requestAutofill";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAugmentedAutofillManagerClient.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AutofillId _arg0 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    Rect _result = this.getViewCoordinates(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    AutofillId _arg0 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    AssistStructure.ViewNodeParcelable _result = this.getViewNodeParcelable(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    ArrayList<AutofillId> _arg1 = data.createTypedArrayList(AutofillId.CREATOR);
                    ArrayList<AutofillValue> _arg2 = data.createTypedArrayList(AutofillValue.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.autofill(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Rect _arg4 = data.readTypedObject(Rect.CREATOR);
                    IAutofillWindowPresenter _arg5 = IAutofillWindowPresenter.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestShowFillUi(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestHideFillUi(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.requestAutofill(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IAugmentedAutofillManagerClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAugmentedAutofillManagerClient.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Rect getViewCoordinates(AutofillId id2) throws RemoteException {
                Rect _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAugmentedAutofillManagerClient.DESCRIPTOR);
                    _data.writeTypedObject(id2, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Rect.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AssistStructure.ViewNodeParcelable getViewNodeParcelable(AutofillId id2) throws RemoteException {
                AssistStructure.ViewNodeParcelable _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAugmentedAutofillManagerClient.DESCRIPTOR);
                    _data.writeTypedObject(id2, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AssistStructure.ViewNodeParcelable.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values, boolean hideHighlight) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAugmentedAutofillManagerClient.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedList(ids, 0);
                    _data.writeTypedList(values, 0);
                    _data.writeBoolean(hideHighlight);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAugmentedAutofillManagerClient.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeTypedObject(anchorBounds, 0);
                    _data.writeStrongInterface(presenter);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestHideFillUi(int sessionId, AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAugmentedAutofillManagerClient.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestAutofill(int sessionId, AutofillId id2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAugmentedAutofillManagerClient.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAugmentedAutofillManagerClient {
        @Override
        public Rect getViewCoordinates(AutofillId id2) throws RemoteException {
            return null;
        }

        @Override
        public AssistStructure.ViewNodeParcelable getViewNodeParcelable(AutofillId id2) throws RemoteException {
            return null;
        }

        @Override
        public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values, boolean hideHighlight) throws RemoteException {
        }

        @Override
        public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) throws RemoteException {
        }

        @Override
        public void requestHideFillUi(int sessionId, AutofillId id2) throws RemoteException {
        }

        @Override
        public boolean requestAutofill(int sessionId, AutofillId id2) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

