/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MetaKeyKeyListener;
import android.util.Log;
import android.view.ContentInfo;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ComposingText;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import android.view.inputmethod.TextSnapshot;
import com.android.internal.util.Preconditions;

public class BaseInputConnection
implements InputConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "BaseInputConnection";
    static final Object COMPOSING = new ComposingText();
    protected final InputMethodManager mIMM;
    final View mTargetView;
    final boolean mFallbackMode;
    private Object[] mDefaultComposingSpans;
    Editable mEditable;
    KeyCharacterMap mKeyCharacterMap;
    private static int INVALID_INDEX = -1;

    BaseInputConnection(InputMethodManager mgr, boolean fullEditor) {
        this.mIMM = mgr;
        this.mTargetView = null;
        this.mFallbackMode = !fullEditor;
    }

    public BaseInputConnection(View targetView, boolean fullEditor) {
        this.mIMM = (InputMethodManager)targetView.getContext().getSystemService("input_method");
        this.mTargetView = targetView;
        this.mFallbackMode = !fullEditor;
    }

    public static void removeComposingSpans(Spannable text) {
        text.removeSpan(COMPOSING);
        Object[] sps = text.getSpans(0, text.length(), Object.class);
        if (sps != null) {
            for (int i = sps.length - 1; i >= 0; --i) {
                Object o = sps[i];
                if ((text.getSpanFlags(o) & 0x100) == 0) continue;
                text.removeSpan(o);
            }
        }
    }

    public static void setComposingSpans(Spannable text) {
        BaseInputConnection.setComposingSpans(text, 0, text.length());
    }

    public static void setComposingSpans(Spannable text, int start, int end) {
        Object[] sps = text.getSpans(start, end, Object.class);
        if (sps != null) {
            for (int i = sps.length - 1; i >= 0; --i) {
                Object o = sps[i];
                if (o == COMPOSING) {
                    text.removeSpan(o);
                    continue;
                }
                int fl = text.getSpanFlags(o);
                if ((fl & 0x133) == 289) continue;
                text.setSpan(o, text.getSpanStart(o), text.getSpanEnd(o), fl & 0xFFFFFFCC | 0x100 | 0x21);
            }
        }
        text.setSpan(COMPOSING, start, end, 289);
    }

    public static int getComposingSpanStart(Spannable text) {
        return text.getSpanStart(COMPOSING);
    }

    public static int getComposingSpanEnd(Spannable text) {
        return text.getSpanEnd(COMPOSING);
    }

    public Editable getEditable() {
        if (this.mEditable == null) {
            this.mEditable = Editable.Factory.getInstance().newEditable("");
            Selection.setSelection(this.mEditable, 0);
        }
        return this.mEditable;
    }

    @Override
    public boolean beginBatchEdit() {
        return false;
    }

    @Override
    public boolean endBatchEdit() {
        return false;
    }

    public void endComposingRegionEditInternal() {
    }

    @Override
    public void closeConnection() {
        this.finishComposingText();
        this.setImeConsumesInput(false);
    }

    @Override
    public boolean clearMetaKeyStates(int states) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        MetaKeyKeyListener.clearMetaKeyState(content, states);
        return true;
    }

    @Override
    public boolean commitCompletion(CompletionInfo text) {
        return false;
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        return false;
    }

    @Override
    public boolean commitText(CharSequence text, int newCursorPosition) {
        this.replaceText(text, newCursorPosition, false);
        this.sendCurrentText();
        return true;
    }

    @Override
    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        this.beginBatchEdit();
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        if (a > b) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (a == -1 || b == -1) {
            this.endBatchEdit();
            return false;
        }
        int ca = BaseInputConnection.getComposingSpanStart(content);
        int cb = BaseInputConnection.getComposingSpanEnd(content);
        if (cb < ca) {
            int tmp = ca;
            ca = cb;
            cb = tmp;
        }
        if (ca != -1 && cb != -1) {
            if (ca < a) {
                a = ca;
            }
            if (cb > b) {
                b = cb;
            }
        }
        int deleted = 0;
        if (beforeLength > 0) {
            int start = a - beforeLength;
            if (start < 0) {
                start = 0;
            }
            int numDeleteBefore = a - start;
            if (a >= 0 && numDeleteBefore > 0) {
                content.delete(start, a);
                deleted = numDeleteBefore;
            }
        }
        if (afterLength > 0) {
            int end = (b -= deleted) + afterLength;
            if (end > content.length()) {
                end = content.length();
            }
            int numDeleteAfter = end - b;
            if (b >= 0 && numDeleteAfter > 0) {
                content.delete(b, end);
            }
        }
        this.endBatchEdit();
        return true;
    }

    private static int findIndexBackward(CharSequence cs, int from, int numCodePoints) {
        int currentIndex = from;
        boolean waitingHighSurrogate = false;
        int N = cs.length();
        if (currentIndex < 0 || N < currentIndex) {
            return INVALID_INDEX;
        }
        if (numCodePoints < 0) {
            return INVALID_INDEX;
        }
        int remainingCodePoints = numCodePoints;
        while (remainingCodePoints != 0) {
            if (--currentIndex < 0) {
                if (waitingHighSurrogate) {
                    return INVALID_INDEX;
                }
                return 0;
            }
            char c = cs.charAt(currentIndex);
            if (waitingHighSurrogate) {
                if (!Character.isHighSurrogate(c)) {
                    return INVALID_INDEX;
                }
                waitingHighSurrogate = false;
                --remainingCodePoints;
                continue;
            }
            if (!Character.isSurrogate(c)) {
                --remainingCodePoints;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                return INVALID_INDEX;
            }
            waitingHighSurrogate = true;
        }
        return currentIndex;
    }

    private static int findIndexForward(CharSequence cs, int from, int numCodePoints) {
        int currentIndex = from;
        boolean waitingLowSurrogate = false;
        int N = cs.length();
        if (currentIndex < 0 || N < currentIndex) {
            return INVALID_INDEX;
        }
        if (numCodePoints < 0) {
            return INVALID_INDEX;
        }
        int remainingCodePoints = numCodePoints;
        while (remainingCodePoints != 0) {
            if (currentIndex >= N) {
                if (waitingLowSurrogate) {
                    return INVALID_INDEX;
                }
                return N;
            }
            char c = cs.charAt(currentIndex);
            if (waitingLowSurrogate) {
                if (!Character.isLowSurrogate(c)) {
                    return INVALID_INDEX;
                }
                --remainingCodePoints;
                waitingLowSurrogate = false;
                ++currentIndex;
                continue;
            }
            if (!Character.isSurrogate(c)) {
                --remainingCodePoints;
                ++currentIndex;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                return INVALID_INDEX;
            }
            waitingLowSurrogate = true;
            ++currentIndex;
        }
        return currentIndex;
    }

    @Override
    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        int end;
        int start;
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        this.beginBatchEdit();
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        if (a > b) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        int ca = BaseInputConnection.getComposingSpanStart(content);
        int cb = BaseInputConnection.getComposingSpanEnd(content);
        if (cb < ca) {
            int tmp = ca;
            ca = cb;
            cb = tmp;
        }
        if (ca != -1 && cb != -1) {
            if (ca < a) {
                a = ca;
            }
            if (cb > b) {
                b = cb;
            }
        }
        if (a >= 0 && b >= 0 && (start = BaseInputConnection.findIndexBackward(content, a, Math.max(beforeLength, 0))) != INVALID_INDEX && (end = BaseInputConnection.findIndexForward(content, b, Math.max(afterLength, 0))) != INVALID_INDEX) {
            int numDeleteAfter;
            int numDeleteBefore = a - start;
            if (numDeleteBefore > 0) {
                content.delete(start, a);
            }
            if ((numDeleteAfter = end - b) > 0) {
                content.delete(b - numDeleteBefore, end - numDeleteBefore);
            }
        }
        this.endBatchEdit();
        return true;
    }

    @Override
    public boolean finishComposingText() {
        Editable content = this.getEditable();
        if (content != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(content);
            this.sendCurrentText();
            this.endBatchEdit();
            this.endComposingRegionEditInternal();
        }
        return true;
    }

    @Override
    public int getCursorCapsMode(int reqModes) {
        int b;
        if (this.mFallbackMode) {
            return 0;
        }
        Editable content = this.getEditable();
        if (content == null) {
            return 0;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        return TextUtils.getCapsMode(content, a, reqModes);
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        return null;
    }

    @Override
    public CharSequence getTextBeforeCursor(int length, int flags) {
        int b;
        Preconditions.checkArgumentNonnegative(length);
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (a <= 0) {
            return "";
        }
        if (length > a) {
            length = a;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(a - length, a);
        }
        return TextUtils.substring(content, a - length, a);
    }

    @Override
    public CharSequence getSelectedText(int flags) {
        int b;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (a == b || a < 0) {
            return null;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(a, b);
        }
        return TextUtils.substring(content, a, b);
    }

    @Override
    public CharSequence getTextAfterCursor(int length, int flags) {
        int b;
        Preconditions.checkArgumentNonnegative(length);
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (b < 0) {
            b = 0;
        }
        int end = (int)Math.min((long)b + (long)length, (long)content.length());
        if ((flags & 1) != 0) {
            return content.subSequence(b, end);
        }
        return TextUtils.substring(content, b, end);
    }

    @Override
    public SurroundingText getSurroundingText(int beforeLength, int afterLength, int flags) {
        Preconditions.checkArgumentNonnegative(beforeLength);
        Preconditions.checkArgumentNonnegative(afterLength);
        Editable content = this.getEditable();
        if (content == null || this.mEditable == content) {
            return InputConnection.super.getSurroundingText(beforeLength, afterLength, flags);
        }
        int selStart = Selection.getSelectionStart(content);
        int selEnd = Selection.getSelectionEnd(content);
        if (selStart < 0 || selEnd < 0) {
            return null;
        }
        if (selStart > selEnd) {
            int tmp = selStart;
            selStart = selEnd;
            selEnd = tmp;
        }
        int startPos = Math.max(0, selStart - beforeLength);
        int endPos = (int)Math.min((long)selEnd + (long)afterLength, (long)content.length());
        CharSequence surroundingText = (flags & 1) != 0 ? content.subSequence(startPos, endPos) : TextUtils.substring(content, startPos, endPos);
        return new SurroundingText(surroundingText, selStart - startPos, selEnd - startPos, startPos);
    }

    @Override
    public boolean performEditorAction(int actionCode) {
        long eventTime = SystemClock.uptimeMillis();
        this.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, -1, 0, 22));
        this.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, -1, 0, 22));
        return true;
    }

    @Override
    public boolean performContextMenuAction(int id2) {
        return false;
    }

    @Override
    public boolean performPrivateCommand(String action, Bundle data) {
        return false;
    }

    @Override
    public boolean requestCursorUpdates(int cursorUpdateMode) {
        return false;
    }

    @Override
    public Handler getHandler() {
        return null;
    }

    @Override
    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        this.replaceText(text, newCursorPosition, true);
        return true;
    }

    @Override
    public boolean setComposingRegion(int start, int end) {
        Editable content = this.getEditable();
        if (content != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(content);
            int a = start;
            int b = end;
            if (a > b) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            int length = content.length();
            if (a < 0) {
                a = 0;
            }
            if (b < 0) {
                b = 0;
            }
            if (a > length) {
                a = length;
            }
            if (b > length) {
                b = length;
            }
            this.ensureDefaultComposingSpans();
            if (this.mDefaultComposingSpans != null) {
                for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                    content.setSpan(this.mDefaultComposingSpans[i], a, b, 289);
                }
            }
            content.setSpan(COMPOSING, a, b, 289);
            this.sendCurrentText();
            this.endBatchEdit();
            this.endComposingRegionEditInternal();
        }
        return true;
    }

    @Override
    public boolean setSelection(int start, int end) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        int len = content.length();
        if (start > len || end > len || start < 0 || end < 0) {
            return true;
        }
        if (start == end && MetaKeyKeyListener.getMetaState((CharSequence)content, 2048) != 0) {
            Selection.extendSelection(content, start);
        } else {
            Selection.setSelection(content, start, end);
        }
        return true;
    }

    @Override
    public boolean sendKeyEvent(KeyEvent event) {
        this.mIMM.dispatchKeyEventFromInputMethod(this.mTargetView, event);
        return false;
    }

    @Override
    public boolean reportFullscreenMode(boolean enabled) {
        return true;
    }

    private void sendCurrentText() {
        if (!this.mFallbackMode) {
            return;
        }
        Editable content = this.getEditable();
        if (content != null) {
            int N = content.length();
            if (N == 0) {
                return;
            }
            if (N == 1) {
                if (this.mKeyCharacterMap == null) {
                    this.mKeyCharacterMap = KeyCharacterMap.load(-1);
                }
                char[] chars = new char[1];
                content.getChars(0, 1, chars, 0);
                KeyEvent[] events = this.mKeyCharacterMap.getEvents(chars);
                if (events != null) {
                    for (int i = 0; i < events.length; ++i) {
                        this.sendKeyEvent(events[i]);
                    }
                    content.clear();
                    return;
                }
            }
            KeyEvent event = new KeyEvent(SystemClock.uptimeMillis(), content.toString(), -1, 0);
            this.sendKeyEvent(event);
            content.clear();
        }
    }

    private void ensureDefaultComposingSpans() {
        Context context;
        if (this.mDefaultComposingSpans == null && (context = this.mTargetView != null ? this.mTargetView.getContext() : this.mIMM.getFallbackContextFromServedView()) != null) {
            TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{16843312});
            CharSequence style2 = ta.getText(0);
            ta.recycle();
            if (style2 != null && style2 instanceof Spanned) {
                this.mDefaultComposingSpans = ((Spanned)style2).getSpans(0, style2.length(), Object.class);
            }
        }
    }

    @Override
    public boolean replaceText(int start, int end, CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        Preconditions.checkArgumentNonnegative(start);
        Preconditions.checkArgumentNonnegative(end);
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        this.beginBatchEdit();
        BaseInputConnection.removeComposingSpans(content);
        int len = content.length();
        start = Math.min(start, len);
        end = Math.min(end, len);
        if (end < start) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        this.replaceTextInternal(start, end, text, newCursorPosition, false);
        this.endBatchEdit();
        return true;
    }

    private void replaceText(CharSequence text, int newCursorPosition, boolean composing) {
        int tmp;
        Editable content = this.getEditable();
        if (content == null) {
            return;
        }
        this.beginBatchEdit();
        int a = BaseInputConnection.getComposingSpanStart(content);
        int b = BaseInputConnection.getComposingSpanEnd(content);
        if (b < a) {
            tmp = a;
            a = b;
            b = tmp;
        }
        if (a != -1 && b != -1) {
            BaseInputConnection.removeComposingSpans(content);
        } else {
            a = Selection.getSelectionStart(content);
            b = Selection.getSelectionEnd(content);
            if (a < 0) {
                a = 0;
            }
            if (b < 0) {
                b = 0;
            }
            if (b < a) {
                tmp = a;
                a = b;
                b = tmp;
            }
        }
        this.replaceTextInternal(a, b, text, newCursorPosition, composing);
        this.endBatchEdit();
    }

    private void replaceTextInternal(int a, int b, CharSequence text, int newCursorPosition, boolean composing) {
        Editable content = this.getEditable();
        if (content == null) {
            return;
        }
        if (composing) {
            Spannable sp = null;
            if (!(text instanceof Spannable)) {
                sp = new SpannableStringBuilder(text);
                text = sp;
                this.ensureDefaultComposingSpans();
                if (this.mDefaultComposingSpans != null) {
                    for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                        sp.setSpan(this.mDefaultComposingSpans[i], 0, sp.length(), 289);
                    }
                }
            } else {
                sp = (Spannable)text;
            }
            BaseInputConnection.setComposingSpans(sp);
        }
        int requestedNewCursorPosition = newCursorPosition;
        newCursorPosition = newCursorPosition > 0 ? (newCursorPosition += b - 1) : (newCursorPosition += a);
        if (newCursorPosition < 0) {
            newCursorPosition = 0;
        }
        if (newCursorPosition > content.length()) {
            newCursorPosition = content.length();
        }
        Selection.setSelection(content, newCursorPosition);
        content.replace(a, b, text);
        if (requestedNewCursorPosition == 0 && a == b) {
            Selection.setSelection(content, newCursorPosition);
        }
    }

    @Override
    public boolean commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
        ClipData clip;
        ContentInfo payload;
        if (this.mTargetView == null) {
            return false;
        }
        ClipDescription description = inputContentInfo.getDescription();
        if (this.mTargetView.getReceiveContentMimeTypes() == null) {
            return false;
        }
        if ((flags & 1) != 0) {
            try {
                inputContentInfo.requestPermission();
            }
            catch (Exception e) {
                Log.w(TAG, "Can't insert content from IME; requestPermission() failed", e);
                return false;
            }
        }
        return this.mTargetView.performReceiveContent(payload = new ContentInfo.Builder(clip = new ClipData(inputContentInfo.getDescription(), new ClipData.Item(inputContentInfo.getContentUri())), 2).setLinkUri(inputContentInfo.getLinkUri()).setExtras(opts).setInputContentInfo(inputContentInfo).build()) == null;
    }

    @Override
    public TextSnapshot takeSnapshot() {
        SurroundingText surroundingText;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int composingStart = BaseInputConnection.getComposingSpanStart(content);
        int composingEnd = BaseInputConnection.getComposingSpanEnd(content);
        if (composingEnd < composingStart) {
            int tmp = composingStart;
            composingStart = composingEnd;
            composingEnd = tmp;
        }
        if ((surroundingText = this.getSurroundingText(1024, 1024, 1)) == null) {
            return null;
        }
        int cursorCapsMode = this.getCursorCapsMode(28672);
        return new TextSnapshot(surroundingText, composingStart, composingEnd, cursorCapsMode);
    }
}

