/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.SuppressLint;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.PreviewableHandwritingGesture;
import java.util.Objects;

public class DeleteGesture
extends PreviewableHandwritingGesture
implements Parcelable {
    @HandwritingGesture.Granularity
    private int mGranularity;
    private RectF mArea;
    public static final Parcelable.Creator<DeleteGesture> CREATOR = new Parcelable.Creator<DeleteGesture>(){

        @Override
        public DeleteGesture createFromParcel(Parcel source) {
            return new DeleteGesture(source);
        }

        public DeleteGesture[] newArray(int size) {
            return new DeleteGesture[size];
        }
    };

    private DeleteGesture(@HandwritingGesture.Granularity int granularity, RectF area, String fallbackText) {
        this.mType = 4;
        this.mArea = area;
        this.mGranularity = granularity;
        this.mFallbackText = fallbackText;
    }

    private DeleteGesture(Parcel source) {
        this.mType = 4;
        this.mFallbackText = source.readString8();
        this.mGranularity = source.readInt();
        this.mArea = source.readTypedObject(RectF.CREATOR);
    }

    @HandwritingGesture.Granularity
    public int getGranularity() {
        return this.mGranularity;
    }

    public RectF getDeletionArea() {
        return this.mArea;
    }

    public int hashCode() {
        return Objects.hash(this.mArea, this.mGranularity, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteGesture)) {
            return false;
        }
        DeleteGesture that = (DeleteGesture)o;
        if (this.mGranularity != that.mGranularity) {
            return false;
        }
        if (!Objects.equals(this.mFallbackText, that.mFallbackText)) {
            return false;
        }
        return Objects.equals(this.mArea, that.mArea);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mFallbackText);
        dest.writeInt(this.mGranularity);
        dest.writeTypedObject(this.mArea, flags);
    }

    public static class Builder {
        private int mGranularity;
        private RectF mArea;
        private String mFallbackText;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setGranularity(@HandwritingGesture.Granularity int granularity) {
            this.mGranularity = granularity;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setDeletionArea(RectF area) {
            this.mArea = area;
            return this;
        }

        public Builder setFallbackText(String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        public DeleteGesture build() {
            if (this.mArea == null || this.mArea.isEmpty()) {
                throw new IllegalArgumentException("Deletion area must be set.");
            }
            if (this.mGranularity <= 0) {
                throw new IllegalArgumentException("Deletion granularity must be set.");
            }
            return new DeleteGesture(this.mGranularity, this.mArea, this.mFallbackText);
        }
    }
}

