/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.util.Log;
import android.view.inputmethod.EditorInfo;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IAccessibilityInputMethodSession;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;

class IAccessibilityInputMethodSessionInvoker {
    private static final String TAG = "IAccessibilityInputMethodSessionInvoker";
    private final IAccessibilityInputMethodSession mSession;
    private final Handler mCustomHandler;
    private static final Object sAsyncBinderEmulationHandlerLock = new Object();
    @GuardedBy(value={"sAsyncBinderEmulationHandlerLock"})
    private static Handler sAsyncBinderEmulationHandler;

    private IAccessibilityInputMethodSessionInvoker(IAccessibilityInputMethodSession session, Handler customHandler) {
        this.mSession = session;
        this.mCustomHandler = customHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAccessibilityInputMethodSessionInvoker createOrNull(IAccessibilityInputMethodSession session) {
        Handler customHandler;
        if (session != null && !Binder.isProxy(session)) {
            Object object = sAsyncBinderEmulationHandlerLock;
            synchronized (object) {
                if (sAsyncBinderEmulationHandler == null) {
                    HandlerThread thread = new HandlerThread("IMM.IAIMS");
                    thread.start();
                    sAsyncBinderEmulationHandler = Handler.createAsync(thread.getLooper());
                }
                customHandler = sAsyncBinderEmulationHandler;
            }
        } else {
            customHandler = null;
        }
        return session == null ? null : new IAccessibilityInputMethodSessionInvoker(session, customHandler);
    }

    void finishInput() {
        if (this.mCustomHandler == null) {
            this.finishInputInternal();
        } else {
            this.mCustomHandler.post(this::finishInputInternal);
        }
    }

    private void finishInputInternal() {
        try {
            this.mSession.finishInput();
        }
        catch (RemoteException e) {
            Log.w(TAG, "A11yIME died", e);
        }
    }

    void updateSelection(int oldSelStart, int oldSelEnd, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        if (this.mCustomHandler == null) {
            this.updateSelectionInternal(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
        } else {
            this.mCustomHandler.post(() -> this.updateSelectionInternal(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd));
        }
    }

    private void updateSelectionInternal(int oldSelStart, int oldSelEnd, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        try {
            this.mSession.updateSelection(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
        }
        catch (RemoteException e) {
            Log.w(TAG, "A11yIME died", e);
        }
    }

    void invalidateInput(EditorInfo editorInfo, IRemoteAccessibilityInputConnection connection, int sessionId) {
        if (this.mCustomHandler == null) {
            this.invalidateInputInternal(editorInfo, connection, sessionId);
        } else {
            this.mCustomHandler.post(() -> this.invalidateInputInternal(editorInfo, connection, sessionId));
        }
    }

    private void invalidateInputInternal(EditorInfo editorInfo, IRemoteAccessibilityInputConnection connection, int sessionId) {
        try {
            this.mSession.invalidateInput(editorInfo, connection, sessionId);
        }
        catch (RemoteException e) {
            Log.w(TAG, "A11yIME died", e);
        }
    }
}

