/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.inputmethod.IImeTracker;
import com.android.internal.inputmethod.IInputMethodClient;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.InputBindResult;
import com.android.internal.view.IInputMethodManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class IInputMethodManagerGlobalInvoker {
    private static volatile IInputMethodManager sServiceCache = null;
    private static volatile IImeTracker sTrackerServiceCache = null;

    IInputMethodManagerGlobalInvoker() {
    }

    static boolean isAvailable() {
        return IInputMethodManagerGlobalInvoker.getService() != null;
    }

    static IInputMethodManager getService() {
        IInputMethodManager service = sServiceCache;
        if (service == null) {
            if (InputMethodManager.isInEditModeInternal()) {
                return null;
            }
            service = IInputMethodManager.Stub.asInterface(ServiceManager.getService("input_method"));
            if (service == null) {
                return null;
            }
            sServiceCache = service;
        }
        return service;
    }

    private static void handleRemoteExceptionOrRethrow(RemoteException e, Consumer<RemoteException> exceptionHandler) {
        if (exceptionHandler == null) {
            throw e.rethrowFromSystemServer();
        }
        exceptionHandler.accept(e);
    }

    @RequiresNoPermission
    static void startProtoDump(byte[] protoDump, int source, String where, Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.startProtoDump(protoDump, source, where);
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    static void startImeTrace(Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.startImeTrace();
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    static void stopImeTrace(Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.stopImeTrace();
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    @RequiresNoPermission
    static boolean isImeTraceEnabled() {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.isImeTraceEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERNAL_SYSTEM_WINDOW")
    static void removeImeSurface(Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.removeImeSurface();
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    static void addClient(IInputMethodClient client, IRemoteInputConnection fallbackInputConnection, int untrustedDisplayId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.addClient(client, fallbackInputConnection, untrustedDisplayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputMethodInfo getCurrentInputMethodInfoAsUser(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return null;
        }
        try {
            return service.getCurrentInputMethodInfoAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static List<InputMethodInfo> getInputMethodList(int userId, int directBootAwareness) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return new ArrayList<InputMethodInfo>();
        }
        try {
            return service.getInputMethodList(userId, directBootAwareness);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static List<InputMethodInfo> getEnabledInputMethodList(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return new ArrayList<InputMethodInfo>();
        }
        try {
            return service.getEnabledInputMethodList(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlyEnabledSubtypes, int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return new ArrayList<InputMethodSubtype>();
        }
        try {
            return service.getEnabledInputMethodSubtypeList(imiId, allowsImplicitlyEnabledSubtypes, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputMethodSubtype getLastInputMethodSubtype(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return null;
        }
        try {
            return service.getLastInputMethodSubtype(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean showSoftInput(IInputMethodClient client, IBinder windowToken, ImeTracker.Token statsToken, int flags, int lastClickToolType, ResultReceiver resultReceiver, int reason) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.showSoftInput(client, windowToken, statsToken, flags, lastClickToolType, resultReceiver, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean hideSoftInput(IInputMethodClient client, IBinder windowToken, ImeTracker.Token statsToken, int flags, ResultReceiver resultReceiver, int reason) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.hideSoftInput(client, windowToken, statsToken, flags, resultReceiver, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo editorInfo, IRemoteInputConnection remoteInputConnection, IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, int userId, ImeOnBackInvokedDispatcher imeDispatcher) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return InputBindResult.NULL;
        }
        try {
            return service.startInputOrWindowGainedFocus(startInputReason, client, windowToken, startInputFlags, softInputMode, windowFlags, editorInfo, remoteInputConnection, remoteAccessibilityInputConnection, unverifiedTargetSdkVersion, userId, imeDispatcher);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.showInputMethodPickerFromClient(client, auxiliarySubtypeMode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    static void showInputMethodPickerFromSystem(int auxiliarySubtypeMode, int displayId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.showInputMethodPickerFromSystem(auxiliarySubtypeMode, displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static boolean isInputMethodPickerShownForTest() {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.isInputMethodPickerShownForTest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputMethodSubtype getCurrentInputMethodSubtype(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return null;
        }
        try {
            return service.getCurrentInputMethodSubtype(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static void setAdditionalInputMethodSubtypes(String imeId, InputMethodSubtype[] subtypes, int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.setAdditionalInputMethodSubtypes(imeId, subtypes, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static void setExplicitlyEnabledInputMethodSubtypes(String imeId, int[] subtypeHashCodes, int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.setExplicitlyEnabledInputMethodSubtypes(imeId, subtypeHashCodes, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static int getInputMethodWindowVisibleHeight(IInputMethodClient client) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return 0;
        }
        try {
            return service.getInputMethodWindowVisibleHeight(client);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void reportVirtualDisplayGeometryAsync(IInputMethodClient client, int childDisplayId, float[] matrixValues) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.reportVirtualDisplayGeometryAsync(client, childDisplayId, matrixValues);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void reportPerceptibleAsync(IBinder windowToken, boolean perceptible) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.reportPerceptibleAsync(windowToken, perceptible);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void removeImeSurfaceFromWindowAsync(IBinder windowToken) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.removeImeSurfaceFromWindowAsync(windowToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void startStylusHandwriting(IInputMethodClient client) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.startStylusHandwriting(client);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void prepareStylusHandwritingDelegation(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.prepareStylusHandwritingDelegation(client, userId, delegatePackageName, delegatorPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean acceptStylusHandwritingDelegation(IInputMethodClient client, int userId, String delegatePackageName, String delegatorPackageName) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.acceptStylusHandwritingDelegation(client, userId, delegatePackageName, delegatorPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static boolean isStylusHandwritingAvailableAsUser(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.isStylusHandwritingAvailableAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static void addVirtualStylusIdForTestSession(IInputMethodClient client) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.addVirtualStylusIdForTestSession(client);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static void setStylusWindowIdleTimeoutForTest(IInputMethodClient client, long timeout) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.setStylusWindowIdleTimeoutForTest(client, timeout);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static ImeTracker.Token onRequestShow(String tag, int uid, int origin, int reason) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return new ImeTracker.Token(new Binder(), tag);
        }
        try {
            return service.onRequestShow(tag, uid, origin, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static ImeTracker.Token onRequestHide(String tag, int uid, int origin, int reason) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return new ImeTracker.Token(new Binder(), tag);
        }
        try {
            return service.onRequestHide(tag, uid, origin, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onProgress(IBinder binder, int phase) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onProgress(binder, phase);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onFailed(ImeTracker.Token statsToken, int phase) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onFailed(statsToken, phase);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onCancelled(ImeTracker.Token statsToken, int phase) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onCancelled(statsToken, phase);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onShown(ImeTracker.Token statsToken) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onShown(statsToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onHidden(ImeTracker.Token statsToken) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onHidden(statsToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static boolean hasPendingImeVisibilityRequests() {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return true;
        }
        try {
            return service.hasPendingImeVisibilityRequests();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static IImeTracker getImeTrackerService() {
        IImeTracker trackerService = sTrackerServiceCache;
        if (trackerService == null) {
            IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
            if (service == null) {
                return null;
            }
            try {
                trackerService = service.getImeTrackerService();
                if (trackerService == null) {
                    return null;
                }
                sTrackerServiceCache = trackerService;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return trackerService;
    }
}

