/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.util.Slog;
import android.view.inputmethod.InputMethodSubtype;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class InputMethodSubtypeArray {
    private static final String TAG = "InputMethodSubtypeArray";
    private final Object mLockObject = new Object();
    private final int mCount;
    private volatile InputMethodSubtype[] mInstance;
    private volatile byte[] mCompressedData;
    private volatile int mDecompressedSize;

    @UnsupportedAppUsage
    public InputMethodSubtypeArray(List<InputMethodSubtype> subtypes) {
        if (subtypes == null) {
            this.mCount = 0;
            return;
        }
        this.mCount = subtypes.size();
        this.mInstance = subtypes.toArray(new InputMethodSubtype[this.mCount]);
    }

    public InputMethodSubtypeArray(Parcel source) {
        this.mCount = source.readInt();
        if (this.mCount < 0) {
            throw new BadParcelableException("mCount must be non-negative.");
        }
        if (this.mCount > 0) {
            this.mDecompressedSize = source.readInt();
            this.mCompressedData = source.createByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel dest) {
        if (this.mCount == 0) {
            dest.writeInt(this.mCount);
            return;
        }
        byte[] compressedData = this.mCompressedData;
        int decompressedSize = this.mDecompressedSize;
        if (compressedData == null && decompressedSize == 0) {
            Object object = this.mLockObject;
            synchronized (object) {
                compressedData = this.mCompressedData;
                decompressedSize = this.mDecompressedSize;
                if (compressedData == null && decompressedSize == 0) {
                    byte[] decompressedData = InputMethodSubtypeArray.marshall(this.mInstance);
                    compressedData = InputMethodSubtypeArray.compress(decompressedData);
                    if (compressedData == null) {
                        decompressedSize = -1;
                        Slog.i(TAG, "Failed to compress data.");
                    } else {
                        decompressedSize = decompressedData.length;
                    }
                    this.mDecompressedSize = decompressedSize;
                    this.mCompressedData = compressedData;
                }
            }
        }
        if (compressedData != null && decompressedSize > 0) {
            dest.writeInt(this.mCount);
            dest.writeInt(decompressedSize);
            dest.writeByteArray(compressedData);
        } else {
            Slog.i(TAG, "Unexpected state. Behaving as an empty array.");
            dest.writeInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputMethodSubtype get(int index) {
        if (index < 0 || this.mCount <= index) {
            throw new ArrayIndexOutOfBoundsException();
        }
        InputMethodSubtype[] instance = this.mInstance;
        if (instance == null) {
            Object object = this.mLockObject;
            synchronized (object) {
                instance = this.mInstance;
                if (instance == null) {
                    byte[] decompressedData = InputMethodSubtypeArray.decompress(this.mCompressedData, this.mDecompressedSize);
                    this.mCompressedData = null;
                    this.mDecompressedSize = 0;
                    if (decompressedData != null) {
                        instance = InputMethodSubtypeArray.unmarshall(decompressedData);
                    } else {
                        Slog.e(TAG, "Failed to decompress data. Returns null as fallback.");
                        instance = new InputMethodSubtype[this.mCount];
                    }
                    this.mInstance = instance;
                }
            }
        }
        return instance[index];
    }

    public int getCount() {
        return this.mCount;
    }

    private static byte[] marshall(InputMethodSubtype[] array2) {
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.writeTypedArray(array2, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
                parcel = null;
            }
        }
    }

    private static InputMethodSubtype[] unmarshall(byte[] data) {
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            InputMethodSubtype[] inputMethodSubtypeArray = parcel.createTypedArray(InputMethodSubtype.CREATOR);
            return inputMethodSubtypeArray;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
                parcel = null;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] compress(byte[] data) {
        try (ByteArrayOutputStream resultStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream zipper = new GZIPOutputStream(resultStream);){
                zipper.write(data);
                zipper.finish();
                byArray = resultStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            Slog.e(TAG, "Failed to compress the data.", e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] decompress(byte[] data, int expectedSize) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            byte[] result;
            GZIPInputStream unzipper;
            block15: {
                byte[] byArray;
                unzipper = new GZIPInputStream(inputStream);
                try {
                    int restBytes;
                    int totalReadBytes;
                    int readBytes;
                    result = new byte[expectedSize];
                    for (totalReadBytes = 0; totalReadBytes < result.length && (readBytes = unzipper.read(result, totalReadBytes, restBytes = result.length - totalReadBytes)) >= 0; totalReadBytes += readBytes) {
                    }
                    if (expectedSize == totalReadBytes) break block15;
                    byArray = null;
                }
                catch (Throwable throwable) {
                    try {
                        unzipper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                unzipper.close();
                return byArray;
            }
            byte[] byArray = result;
            unzipper.close();
            return byArray;
        }
        catch (Exception e) {
            Slog.e(TAG, "Failed to decompress the data.", e);
            return null;
        }
    }
}

