/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.os.CancellationSignal;
import android.os.CancellationSignalBeamer;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.CancellableHandwritingGesture;
import androidx.annotation.Nullable;
import java.util.Objects;

public class InsertModeGesture
extends CancellableHandwritingGesture
implements Parcelable {
    private PointF mPoint;
    public static final Parcelable.Creator<InsertModeGesture> CREATOR = new Parcelable.Creator<InsertModeGesture>(){

        @Override
        public InsertModeGesture createFromParcel(Parcel source) {
            return new InsertModeGesture(source);
        }

        public InsertModeGesture[] newArray(int size) {
            return new InsertModeGesture[size];
        }
    };

    private InsertModeGesture(PointF point, String fallbackText, CancellationSignal cancellationSignal) {
        this.mType = 128;
        this.mPoint = point;
        this.mFallbackText = fallbackText;
        this.mCancellationSignal = cancellationSignal;
    }

    private InsertModeGesture(Parcel source) {
        this.mType = 128;
        this.mFallbackText = source.readString8();
        this.mPoint = source.readTypedObject(PointF.CREATOR);
        this.mCancellationSignalToken = source.readStrongBinder();
    }

    @Override
    public CancellationSignal getCancellationSignal() {
        return this.mCancellationSignal;
    }

    public PointF getInsertionPoint() {
        return this.mPoint;
    }

    public int hashCode() {
        return Objects.hash(this.mPoint, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsertModeGesture)) {
            return false;
        }
        InsertModeGesture that = (InsertModeGesture)o;
        if (!Objects.equals(this.mFallbackText, that.mFallbackText)) {
            return false;
        }
        return Objects.equals(this.mPoint, that.mPoint);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mFallbackText);
        dest.writeTypedObject(this.mPoint, flags);
        dest.writeStrongBinder(CancellationSignalBeamer.Sender.beamFromScope(this.mCancellationSignal));
    }

    public static class Builder {
        private PointF mPoint;
        private String mFallbackText;
        private CancellationSignal mCancellationSignal;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setInsertionPoint(PointF point) {
            this.mPoint = point;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setCancellationSignal(CancellationSignal cancellationSignal) {
            this.mCancellationSignal = cancellationSignal;
            return this;
        }

        public Builder setFallbackText(@Nullable String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        public InsertModeGesture build() {
            if (this.mPoint == null) {
                throw new IllegalArgumentException("Insertion point must be set.");
            }
            if (this.mCancellationSignal == null) {
                throw new IllegalArgumentException("CancellationSignal must be set.");
            }
            return new InsertModeGesture(this.mPoint, this.mFallbackText, this.mCancellationSignal);
        }
    }
}

