/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.DeleteGesture;
import android.view.inputmethod.DeleteRangeGesture;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.InsertGesture;
import android.view.inputmethod.InsertModeGesture;
import android.view.inputmethod.JoinOrSplitGesture;
import android.view.inputmethod.RemoveSpaceGesture;
import android.view.inputmethod.SelectGesture;
import android.view.inputmethod.SelectRangeGesture;
import java.util.Objects;

public class ParcelableHandwritingGesture
implements Parcelable {
    private final HandwritingGesture mGesture;
    private final Parcelable mGestureAsParcelable;
    public static final Parcelable.Creator<ParcelableHandwritingGesture> CREATOR = new Parcelable.Creator<ParcelableHandwritingGesture>(){

        @Override
        public ParcelableHandwritingGesture createFromParcel(Parcel in) {
            int gestureType = in.readInt();
            return new ParcelableHandwritingGesture(ParcelableHandwritingGesture.createFromParcelInternal(gestureType, in));
        }

        public ParcelableHandwritingGesture[] newArray(int size) {
            return new ParcelableHandwritingGesture[size];
        }
    };

    private ParcelableHandwritingGesture(HandwritingGesture gesture) {
        this.mGesture = gesture;
        this.mGestureAsParcelable = (Parcelable)((Object)gesture);
    }

    public static ParcelableHandwritingGesture of(HandwritingGesture gesture) {
        return new ParcelableHandwritingGesture(Objects.requireNonNull(gesture));
    }

    public HandwritingGesture get() {
        return this.mGesture;
    }

    private static HandwritingGesture createFromParcelInternal(int gestureType, Parcel parcel) {
        switch (gestureType) {
            case 0: {
                throw new UnsupportedOperationException("GESTURE_TYPE_NONE is not supported");
            }
            case 1: {
                return SelectGesture.CREATOR.createFromParcel(parcel);
            }
            case 32: {
                return SelectRangeGesture.CREATOR.createFromParcel(parcel);
            }
            case 2: {
                return InsertGesture.CREATOR.createFromParcel(parcel);
            }
            case 128: {
                return InsertModeGesture.CREATOR.createFromParcel(parcel);
            }
            case 4: {
                return DeleteGesture.CREATOR.createFromParcel(parcel);
            }
            case 64: {
                return DeleteRangeGesture.CREATOR.createFromParcel(parcel);
            }
            case 16: {
                return JoinOrSplitGesture.CREATOR.createFromParcel(parcel);
            }
            case 8: {
                return RemoveSpaceGesture.CREATOR.createFromParcel(parcel);
            }
        }
        throw new UnsupportedOperationException("Unknown type=" + gestureType);
    }

    @Override
    public int describeContents() {
        return this.mGestureAsParcelable.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mGesture.getGestureType());
        this.mGestureAsParcelable.writeToParcel(dest, flags);
    }
}

