/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.RectF;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.CancellationSignalBeamer;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ResultReceiver;
import android.os.Trace;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.inputmethod.CancellableHandwritingGesture;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.DumpableInputConnection;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.ParcelableHandwritingGesture;
import android.view.inputmethod.PreviewableHandwritingGesture;
import android.view.inputmethod.TextAttribute;
import android.view.inputmethod.TextBoundsInfo;
import android.view.inputmethod.TextBoundsInfoResult;
import android.view.inputmethod.TextSnapshot;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.ImeTracing;
import com.android.internal.inputmethod.InputConnectionCommandHeader;
import com.android.internal.inputmethod.InputConnectionProtoDumper;
import com.android.tools.layoutlib.java.Reference_Delegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

class RemoteInputConnectionImpl
extends IRemoteInputConnection.Stub {
    private static final String TAG = "RemoteInputConnectionImpl";
    private static final boolean DEBUG = false;
    private static final int MAX_END_BATCH_EDIT_RETRY = 16;
    @GuardedBy(value={"mLock"})
    private InputConnection mInputConnection;
    private final Looper mLooper;
    private final Handler mH;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mFinished = false;
    private final InputMethodManager mParentInputMethodManager;
    private final WeakReference<View> mServedView;
    private final AtomicInteger mCurrentSessionId = new AtomicInteger(0);
    private final AtomicBoolean mHasPendingInvalidation = new AtomicBoolean();
    private final AtomicBoolean mIsCursorAnchorInfoMonitoring = new AtomicBoolean(false);
    private final AtomicBoolean mHasPendingImmediateCursorAnchorInfoUpdate = new AtomicBoolean(false);
    private CancellationSignalBeamer.Receiver mBeamer;
    private final IRemoteAccessibilityInputConnection mAccessibilityInputConnection = new IRemoteAccessibilityInputConnection.Stub(){

        @Override
        public void commitText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("commitTextFromA11yIme", () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "commitText on inactive InputConnection");
                    return;
                }
                ic.beginBatchEdit();
                ic.finishComposingText();
                ic.commitText(text, newCursorPosition, textAttribute);
                ic.endBatchEdit();
            });
        }

        @Override
        public void setSelection(InputConnectionCommandHeader header, int start, int end) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("setSelectionFromA11yIme", () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "setSelection on inactive InputConnection");
                    return;
                }
                ic.setSelection(start, end);
            });
        }

        @Override
        public void getSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength, int flags, AndroidFuture future) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("getSurroundingTextFromA11yIme", future, () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return null;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "getSurroundingText on inactive InputConnection");
                    return null;
                }
                if (beforeLength < 0) {
                    Log.i(RemoteInputConnectionImpl.TAG, "Returning null to getSurroundingText due to an invalid beforeLength=" + beforeLength);
                    return null;
                }
                if (afterLength < 0) {
                    Log.i(RemoteInputConnectionImpl.TAG, "Returning null to getSurroundingText due to an invalid afterLength=" + afterLength);
                    return null;
                }
                return ic.getSurroundingText(beforeLength, afterLength, flags);
            }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetSurroundingTextProto(beforeLength, afterLength, flags, result) : null);
        }

        @Override
        public void deleteSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("deleteSurroundingTextFromA11yIme", () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "deleteSurroundingText on inactive InputConnection");
                    return;
                }
                ic.deleteSurroundingText(beforeLength, afterLength);
            });
        }

        @Override
        public void sendKeyEvent(InputConnectionCommandHeader header, KeyEvent event) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("sendKeyEventFromA11yIme", () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "sendKeyEvent on inactive InputConnection");
                    return;
                }
                ic.sendKeyEvent(event);
            });
        }

        @Override
        public void performEditorAction(InputConnectionCommandHeader header, int id2) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("performEditorActionFromA11yIme", () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "performEditorAction on inactive InputConnection");
                    return;
                }
                ic.performEditorAction(id2);
            });
        }

        @Override
        public void performContextMenuAction(InputConnectionCommandHeader header, int id2) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("performContextMenuActionFromA11yIme", () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "performContextMenuAction on inactive InputConnection");
                    return;
                }
                ic.performContextMenuAction(id2);
            });
        }

        @Override
        public void getCursorCapsMode(InputConnectionCommandHeader header, int reqModes, AndroidFuture future) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("getCursorCapsModeFromA11yIme", future, () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return 0;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "getCursorCapsMode on inactive InputConnection");
                    return 0;
                }
                return ic.getCursorCapsMode(reqModes);
            }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetCursorCapsModeProto(reqModes, result) : null);
        }

        @Override
        public void clearMetaKeyStates(InputConnectionCommandHeader header, int states) {
            RemoteInputConnectionImpl.this.dispatchWithTracing("clearMetaKeyStatesFromA11yIme", () -> {
                if (header.mSessionId != RemoteInputConnectionImpl.this.mCurrentSessionId.get()) {
                    return;
                }
                InputConnection ic = RemoteInputConnectionImpl.this.getInputConnection();
                if (ic == null || !RemoteInputConnectionImpl.this.isActive()) {
                    Log.w(RemoteInputConnectionImpl.TAG, "clearMetaKeyStates on inactive InputConnection");
                    return;
                }
                ic.clearMetaKeyStates(states);
            });
        }
    };

    RemoteInputConnectionImpl(Looper looper, InputConnection inputConnection, InputMethodManager inputMethodManager, View servedView) {
        this.mInputConnection = inputConnection;
        this.mLooper = looper;
        this.mH = new Handler(this.mLooper);
        this.mParentInputMethodManager = inputMethodManager;
        this.mServedView = new WeakReference<View>(servedView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputConnection getInputConnection() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputConnection;
        }
    }

    public boolean hasPendingInvalidation() {
        return this.mHasPendingInvalidation.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFinished() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFinished;
        }
    }

    private boolean isActive() {
        return this.mParentInputMethodManager.isActive() && !this.isFinished();
    }

    private View getServedView() {
        return (View)this.mServedView.get();
    }

    public boolean isAssociatedWith(View view) {
        if (view == null) {
            return false;
        }
        return Reference_Delegate.refersTo(this.mServedView, view);
    }

    public boolean resetHasPendingImmediateCursorAnchorInfoUpdate() {
        return this.mHasPendingImmediateCursorAnchorInfoUpdate.getAndSet(false);
    }

    public boolean isCursorAnchorInfoMonitoring() {
        return this.mIsCursorAnchorInfoMonitoring.get();
    }

    public void scheduleInvalidateInput() {
        if (this.mHasPendingInvalidation.compareAndSet(false, true)) {
            int nextSessionId = this.mCurrentSessionId.incrementAndGet();
            this.mH.post(() -> {
                try {
                    TextSnapshot textSnapshot;
                    if (this.isFinished()) {
                        return;
                    }
                    InputConnection ic = this.getInputConnection();
                    if (ic == null) {
                        return;
                    }
                    View view = this.getServedView();
                    if (view == null) {
                        return;
                    }
                    Class<?> icClass = ic.getClass();
                    boolean alwaysTrueEndBatchEditDetected = KnownAlwaysTrueEndBatchEditCache.contains(icClass);
                    if (!alwaysTrueEndBatchEditDetected) {
                        boolean supportsBatchEdit = ic.beginBatchEdit();
                        ic.finishComposingText();
                        if (supportsBatchEdit) {
                            int retryCount = 0;
                            while (ic.endBatchEdit()) {
                                if (++retryCount <= 16) continue;
                                Log.e(TAG, icClass.getTypeName() + "#endBatchEdit() still returns true even after retrying " + 16 + " times.  Falling back to InputMethodManager#restartInput(View)");
                                alwaysTrueEndBatchEditDetected = true;
                                KnownAlwaysTrueEndBatchEditCache.add(icClass);
                                break;
                            }
                        }
                    }
                    if (!alwaysTrueEndBatchEditDetected && (textSnapshot = ic.takeSnapshot()) != null && this.mParentInputMethodManager.doInvalidateInput(this, textSnapshot, nextSessionId)) {
                        return;
                    }
                    this.mParentInputMethodManager.restartInput(view);
                }
                finally {
                    this.mHasPendingInvalidation.set(false);
                }
            });
        }
    }

    public void deactivate() {
        if (this.isFinished()) {
            return;
        }
        this.dispatch(() -> {
            if (this.isFinished()) {
                return;
            }
            Trace.traceBegin(4L, "InputConnection#closeConnection");
            try {
                InputConnection ic = this.getInputConnection();
                if (ic == null) {
                    return;
                }
                try {
                    ic.closeConnection();
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            finally {
                Object object = this.mLock;
                synchronized (object) {
                    this.mInputConnection = null;
                    this.mFinished = true;
                }
                Trace.traceEnd(4L);
            }
            View servedView = (View)this.mServedView.get();
            if (servedView != null) {
                ViewRootImpl viewRoot;
                Handler handler = servedView.getHandler();
                if (handler != null) {
                    if (handler.getLooper().isCurrentThread()) {
                        servedView.onInputConnectionClosedInternal();
                    } else {
                        handler.post(servedView::onInputConnectionClosedInternal);
                    }
                }
                if ((viewRoot = servedView.getViewRootImpl()) != null) {
                    viewRoot.getHandwritingInitiator().onInputConnectionClosed(servedView);
                }
            }
        });
    }

    @Override
    public void cancelCancellationSignal(IBinder token) {
        if (this.mBeamer == null) {
            return;
        }
        this.dispatch(() -> this.mBeamer.cancel(token));
    }

    @Override
    public void forgetCancellationSignal(IBinder token) {
        if (this.mBeamer == null) {
            return;
        }
        this.mBeamer.forget(token);
    }

    public String toString() {
        return "RemoteInputConnectionImpl{connection=" + this.getInputConnection() + " finished=" + this.isFinished() + " mParentInputMethodManager.isActive()=" + this.mParentInputMethodManager.isActive() + " mServedView=" + this.mServedView.get() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInputConnection instanceof DumpableInputConnection && this.mLooper.isCurrentThread()) {
                ((DumpableInputConnection)((Object)this.mInputConnection)).dumpDebug(proto, fieldId);
            }
        }
    }

    public void dispatchReportFullscreenMode(boolean enabled) {
        this.dispatch(() -> {
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                return;
            }
            ic.reportFullscreenMode(enabled);
        });
    }

    @Override
    public void getTextAfterCursor(InputConnectionCommandHeader header, int length, int flags, AndroidFuture future) {
        this.dispatchWithTracing("getTextAfterCursor", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return null;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "getTextAfterCursor on inactive InputConnection");
                return null;
            }
            if (length < 0) {
                Log.i(TAG, "Returning null to getTextAfterCursor due to an invalid length=" + length);
                return null;
            }
            return ic.getTextAfterCursor(length, flags);
        }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetTextAfterCursorProto(length, flags, result) : null);
    }

    @Override
    public void getTextBeforeCursor(InputConnectionCommandHeader header, int length, int flags, AndroidFuture future) {
        this.dispatchWithTracing("getTextBeforeCursor", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return null;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "getTextBeforeCursor on inactive InputConnection");
                return null;
            }
            if (length < 0) {
                Log.i(TAG, "Returning null to getTextBeforeCursor due to an invalid length=" + length);
                return null;
            }
            return ic.getTextBeforeCursor(length, flags);
        }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetTextBeforeCursorProto(length, flags, result) : null);
    }

    @Override
    public void getSelectedText(InputConnectionCommandHeader header, int flags, AndroidFuture future) {
        this.dispatchWithTracing("getSelectedText", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return null;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "getSelectedText on inactive InputConnection");
                return null;
            }
            try {
                return ic.getSelectedText(flags);
            }
            catch (AbstractMethodError ignored) {
                return null;
            }
        }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetSelectedTextProto(flags, result) : null);
    }

    @Override
    public void getSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength, int flags, AndroidFuture future) {
        this.dispatchWithTracing("getSurroundingText", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return null;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "getSurroundingText on inactive InputConnection");
                return null;
            }
            if (beforeLength < 0) {
                Log.i(TAG, "Returning null to getSurroundingText due to an invalid beforeLength=" + beforeLength);
                return null;
            }
            if (afterLength < 0) {
                Log.i(TAG, "Returning null to getSurroundingText due to an invalid afterLength=" + afterLength);
                return null;
            }
            return ic.getSurroundingText(beforeLength, afterLength, flags);
        }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetSurroundingTextProto(beforeLength, afterLength, flags, result) : null);
    }

    @Override
    public void getCursorCapsMode(InputConnectionCommandHeader header, int reqModes, AndroidFuture future) {
        this.dispatchWithTracing("getCursorCapsMode", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return 0;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "getCursorCapsMode on inactive InputConnection");
                return 0;
            }
            return ic.getCursorCapsMode(reqModes);
        }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetCursorCapsModeProto(reqModes, result) : null);
    }

    @Override
    public void getExtractedText(InputConnectionCommandHeader header, ExtractedTextRequest request, int flags, AndroidFuture future) {
        this.dispatchWithTracing("getExtractedText", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return null;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "getExtractedText on inactive InputConnection");
                return null;
            }
            return ic.getExtractedText(request, flags);
        }, RemoteInputConnectionImpl.useImeTracing() ? result -> InputConnectionProtoDumper.buildGetExtractedTextProto(request, flags, result) : null);
    }

    @Override
    public void commitText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition) {
        this.dispatchWithTracing("commitText", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "commitText on inactive InputConnection");
                return;
            }
            ic.commitText(text, newCursorPosition);
        });
    }

    @Override
    public void commitTextWithTextAttribute(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        this.dispatchWithTracing("commitTextWithTextAttribute", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "commitText on inactive InputConnection");
                return;
            }
            ic.commitText(text, newCursorPosition, textAttribute);
        });
    }

    @Override
    public void commitCompletion(InputConnectionCommandHeader header, CompletionInfo text) {
        this.dispatchWithTracing("commitCompletion", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "commitCompletion on inactive InputConnection");
                return;
            }
            ic.commitCompletion(text);
        });
    }

    @Override
    public void commitCorrection(InputConnectionCommandHeader header, CorrectionInfo info) {
        this.dispatchWithTracing("commitCorrection", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "commitCorrection on inactive InputConnection");
                return;
            }
            try {
                ic.commitCorrection(info);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        });
    }

    @Override
    public void setSelection(InputConnectionCommandHeader header, int start, int end) {
        this.dispatchWithTracing("setSelection", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "setSelection on inactive InputConnection");
                return;
            }
            ic.setSelection(start, end);
        });
    }

    @Override
    public void performEditorAction(InputConnectionCommandHeader header, int id2) {
        this.dispatchWithTracing("performEditorAction", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "performEditorAction on inactive InputConnection");
                return;
            }
            ic.performEditorAction(id2);
        });
    }

    @Override
    public void performContextMenuAction(InputConnectionCommandHeader header, int id2) {
        this.dispatchWithTracing("performContextMenuAction", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "performContextMenuAction on inactive InputConnection");
                return;
            }
            ic.performContextMenuAction(id2);
        });
    }

    @Override
    public void setComposingRegion(InputConnectionCommandHeader header, int start, int end) {
        this.dispatchWithTracing("setComposingRegion", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "setComposingRegion on inactive InputConnection");
                return;
            }
            try {
                ic.setComposingRegion(start, end);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        });
    }

    @Override
    public void setComposingRegionWithTextAttribute(InputConnectionCommandHeader header, int start, int end, TextAttribute textAttribute) {
        this.dispatchWithTracing("setComposingRegionWithTextAttribute", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "setComposingRegion on inactive InputConnection");
                return;
            }
            ic.setComposingRegion(start, end, textAttribute);
        });
    }

    @Override
    public void setComposingText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition) {
        this.dispatchWithTracing("setComposingText", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "setComposingText on inactive InputConnection");
                return;
            }
            ic.setComposingText(text, newCursorPosition);
        });
    }

    @Override
    public void setComposingTextWithTextAttribute(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        this.dispatchWithTracing("setComposingTextWithTextAttribute", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "setComposingText on inactive InputConnection");
                return;
            }
            ic.setComposingText(text, newCursorPosition, textAttribute);
        });
    }

    public void finishComposingTextFromImm() {
        int currentSessionId = this.mCurrentSessionId.get();
        this.dispatchWithTracing("finishComposingTextFromImm", () -> {
            if (this.isFinished()) {
                return;
            }
            if (currentSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null) {
                Log.w(TAG, "finishComposingTextFromImm on inactive InputConnection");
                return;
            }
            ic.finishComposingText();
        });
    }

    @Override
    public void finishComposingText(InputConnectionCommandHeader header) {
        this.dispatchWithTracing("finishComposingText", () -> {
            if (this.isFinished()) {
                return;
            }
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null) {
                Log.w(TAG, "finishComposingText on inactive InputConnection");
                return;
            }
            ic.finishComposingText();
        });
    }

    @Override
    public void sendKeyEvent(InputConnectionCommandHeader header, KeyEvent event) {
        this.dispatchWithTracing("sendKeyEvent", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "sendKeyEvent on inactive InputConnection");
                return;
            }
            ic.sendKeyEvent(event);
        });
    }

    @Override
    public void clearMetaKeyStates(InputConnectionCommandHeader header, int states) {
        this.dispatchWithTracing("clearMetaKeyStates", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "clearMetaKeyStates on inactive InputConnection");
                return;
            }
            ic.clearMetaKeyStates(states);
        });
    }

    @Override
    public void deleteSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength) {
        this.dispatchWithTracing("deleteSurroundingText", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "deleteSurroundingText on inactive InputConnection");
                return;
            }
            ic.deleteSurroundingText(beforeLength, afterLength);
        });
    }

    @Override
    public void deleteSurroundingTextInCodePoints(InputConnectionCommandHeader header, int beforeLength, int afterLength) {
        this.dispatchWithTracing("deleteSurroundingTextInCodePoints", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "deleteSurroundingTextInCodePoints on inactive InputConnection");
                return;
            }
            try {
                ic.deleteSurroundingTextInCodePoints(beforeLength, afterLength);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        });
    }

    @Override
    public void beginBatchEdit(InputConnectionCommandHeader header) {
        this.dispatchWithTracing("beginBatchEdit", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "beginBatchEdit on inactive InputConnection");
                return;
            }
            ic.beginBatchEdit();
        });
    }

    @Override
    public void endBatchEdit(InputConnectionCommandHeader header) {
        this.dispatchWithTracing("endBatchEdit", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "endBatchEdit on inactive InputConnection");
                return;
            }
            ic.endBatchEdit();
        });
    }

    @Override
    public void performSpellCheck(InputConnectionCommandHeader header) {
        this.dispatchWithTracing("performSpellCheck", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "performSpellCheck on inactive InputConnection");
                return;
            }
            ic.performSpellCheck();
        });
    }

    @Override
    public void performPrivateCommand(InputConnectionCommandHeader header, String action, Bundle data) {
        this.dispatchWithTracing("performPrivateCommand", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "performPrivateCommand on inactive InputConnection");
                return;
            }
            ic.performPrivateCommand(action, data);
        });
    }

    @Override
    public void performHandwritingGesture(InputConnectionCommandHeader header, ParcelableHandwritingGesture gestureContainer, ResultReceiver resultReceiver) {
        HandwritingGesture gesture = gestureContainer.get();
        if (gesture instanceof CancellableHandwritingGesture) {
            CancellableHandwritingGesture cancellableGesture = (CancellableHandwritingGesture)gesture;
            cancellableGesture.unbeamCancellationSignal(this.getCancellationSignalBeamer());
            if (cancellableGesture.getCancellationSignal() != null && cancellableGesture.getCancellationSignal().isCanceled()) {
                if (resultReceiver != null) {
                    resultReceiver.send(4, null);
                }
                return;
            }
        }
        this.dispatchWithTracing("performHandwritingGesture", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                if (resultReceiver != null) {
                    resultReceiver.send(4, null);
                }
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "performHandwritingGesture on inactive InputConnection");
                if (resultReceiver != null) {
                    resultReceiver.send(4, null);
                }
                return;
            }
            ic.performHandwritingGesture(gesture, resultReceiver != null ? Runnable::run : null, resultReceiver != null ? resultCode -> resultReceiver.send(resultCode, null) : null);
        });
    }

    @Override
    public void previewHandwritingGesture(InputConnectionCommandHeader header, ParcelableHandwritingGesture gestureContainer, IBinder cancellationSignalToken) {
        CancellationSignal cancellationSignal = cancellationSignalToken != null ? this.getCancellationSignalBeamer().unbeam(cancellationSignalToken) : null;
        PreviewableHandwritingGesture gesture = (PreviewableHandwritingGesture)gestureContainer.get();
        this.dispatchWithTracing("previewHandwritingGesture", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get() || cancellationSignal != null && cancellationSignal.isCanceled()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "previewHandwritingGesture on inactive InputConnection");
                return;
            }
            ic.previewHandwritingGesture(gesture, cancellationSignal);
        });
    }

    private CancellationSignalBeamer.Receiver getCancellationSignalBeamer() {
        if (this.mBeamer != null) {
            return this.mBeamer;
        }
        this.mBeamer = new CancellationSignalBeamer.Receiver(true);
        return this.mBeamer;
    }

    @Override
    public void requestCursorUpdates(InputConnectionCommandHeader header, int cursorUpdateMode, int imeDisplayId, AndroidFuture future) {
        this.dispatchWithTracing("requestCursorUpdates", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return false;
            }
            return this.requestCursorUpdatesInternal(cursorUpdateMode, 0, imeDisplayId);
        });
    }

    @Override
    public void requestCursorUpdatesWithFilter(InputConnectionCommandHeader header, int cursorUpdateMode, int cursorUpdateFilter, int imeDisplayId, AndroidFuture future) {
        this.dispatchWithTracing("requestCursorUpdates", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return false;
            }
            return this.requestCursorUpdatesInternal(cursorUpdateMode, cursorUpdateFilter, imeDisplayId);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestCursorUpdatesInternal(int cursorUpdateMode, int cursorUpdateFilter, int imeDisplayId) {
        InputConnection ic = this.getInputConnection();
        if (ic == null || !this.isActive()) {
            Log.w(TAG, "requestCursorAnchorInfo on inactive InputConnection");
            return false;
        }
        if (this.mParentInputMethodManager.mRequestCursorUpdateDisplayIdCheck.get() && this.mParentInputMethodManager.getDisplayId() != imeDisplayId && !this.mParentInputMethodManager.hasVirtualDisplayToScreenMatrix()) {
            return false;
        }
        boolean hasImmediate = (cursorUpdateMode & 1) != 0;
        boolean hasMonitoring = (cursorUpdateMode & 2) != 0;
        boolean result = false;
        try {
            boolean bl = result = ic.requestCursorUpdates(cursorUpdateMode, cursorUpdateFilter);
            this.mHasPendingImmediateCursorAnchorInfoUpdate.set(result && hasImmediate);
            this.mIsCursorAnchorInfoMonitoring.set(result && hasMonitoring);
            return bl;
        }
        catch (AbstractMethodError ignored) {
            try {
                boolean bl = false;
                this.mHasPendingImmediateCursorAnchorInfoUpdate.set(result && hasImmediate);
                this.mIsCursorAnchorInfoMonitoring.set(result && hasMonitoring);
                return bl;
            }
            catch (Throwable throwable) {
                this.mHasPendingImmediateCursorAnchorInfoUpdate.set(result && hasImmediate);
                this.mIsCursorAnchorInfoMonitoring.set(result && hasMonitoring);
                throw throwable;
            }
        }
    }

    @Override
    public void requestTextBoundsInfo(InputConnectionCommandHeader header, RectF bounds, ResultReceiver resultReceiver) {
        this.dispatchWithTracing("requestTextBoundsInfo", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                resultReceiver.send(3, null);
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "requestTextBoundsInfo on inactive InputConnection");
                resultReceiver.send(3, null);
                return;
            }
            ic.requestTextBoundsInfo(bounds, Runnable::run, (TextBoundsInfoResult textBoundsInfoResult) -> {
                int resultCode = textBoundsInfoResult.getResultCode();
                TextBoundsInfo textBoundsInfo = textBoundsInfoResult.getTextBoundsInfo();
                resultReceiver.send(resultCode, textBoundsInfo == null ? null : textBoundsInfo.toBundle());
            });
        });
    }

    @Override
    public void commitContent(InputConnectionCommandHeader header, InputContentInfo inputContentInfo, int flags, Bundle opts, AndroidFuture future) {
        this.dispatchWithTracing("commitContent", future, () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return false;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "commitContent on inactive InputConnection");
                return false;
            }
            if (inputContentInfo == null || !inputContentInfo.validate()) {
                Log.w(TAG, "commitContent with invalid inputContentInfo=" + inputContentInfo);
                return false;
            }
            try {
                return ic.commitContent(inputContentInfo, flags, opts);
            }
            catch (AbstractMethodError ignored) {
                return false;
            }
        });
    }

    @Override
    public void setImeConsumesInput(InputConnectionCommandHeader header, boolean imeConsumesInput) {
        this.dispatchWithTracing("setImeConsumesInput", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "setImeConsumesInput on inactive InputConnection");
                return;
            }
            ic.setImeConsumesInput(imeConsumesInput);
        });
    }

    @Override
    public void replaceText(InputConnectionCommandHeader header, int start, int end, CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        this.dispatchWithTracing("replaceText", () -> {
            if (header.mSessionId != this.mCurrentSessionId.get()) {
                return;
            }
            InputConnection ic = this.getInputConnection();
            if (ic == null || !this.isActive()) {
                Log.w(TAG, "replaceText on inactive InputConnection");
                return;
            }
            ic.replaceText(start, end, text, newCursorPosition, textAttribute);
        });
    }

    public IRemoteAccessibilityInputConnection asIRemoteAccessibilityInputConnection() {
        return this.mAccessibilityInputConnection;
    }

    private void dispatch(Runnable runnable) {
        if (this.mLooper.isCurrentThread()) {
            runnable.run();
            return;
        }
        this.mH.post(runnable);
    }

    private void dispatchWithTracing(String methodName, Runnable runnable) {
        Runnable actualRunnable = Trace.isTagEnabled(4L) ? () -> {
            Trace.traceBegin(4L, "InputConnection#" + methodName);
            try {
                runnable.run();
            }
            finally {
                Trace.traceEnd(4L);
            }
        } : runnable;
        this.dispatch(actualRunnable);
    }

    private <T> void dispatchWithTracing(String methodName, AndroidFuture untypedFuture, Supplier<T> supplier) {
        this.dispatchWithTracing(methodName, untypedFuture, supplier, null);
    }

    private <T> void dispatchWithTracing(String methodName, AndroidFuture untypedFuture, Supplier<T> supplier, Function<T, byte[]> dumpProtoProvider) {
        AndroidFuture future = untypedFuture;
        this.dispatchWithTracing(methodName, () -> {
            Object result;
            try {
                result = supplier.get();
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
                throw throwable;
            }
            future.complete(result);
            if (dumpProtoProvider != null) {
                byte[] icProto = (byte[])dumpProtoProvider.apply(result);
                ImeTracing.getInstance().triggerClientDump("RemoteInputConnectionImpl#" + methodName, this.mParentInputMethodManager, icProto);
            }
        });
    }

    private static boolean useImeTracing() {
        return ImeTracing.getInstance().isEnabled();
    }

    private static class KnownAlwaysTrueEndBatchEditCache {
        private static volatile Class<?> sElement;
        private static volatile Class<?>[] sArray;

        private KnownAlwaysTrueEndBatchEditCache() {
        }

        static boolean contains(Class<? extends InputConnection> klass) {
            if (klass == sElement) {
                return true;
            }
            Class<?>[] array2 = sArray;
            if (array2 == null) {
                return false;
            }
            for (Class<?> item : array2) {
                if (item != klass) continue;
                return true;
            }
            return false;
        }

        static void add(Class<? extends InputConnection> klass) {
            if (sElement == null) {
                sElement = klass;
                return;
            }
            Class<?>[] array2 = sArray;
            int arraySize = array2 != null ? array2.length : 0;
            Class[] newArray = new Class[arraySize + 1];
            for (int i = 0; i < arraySize; ++i) {
                newArray[i] = array2[i];
            }
            newArray[arraySize] = klass;
            sArray = newArray;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Dispatching {
        public boolean cancellable();
    }
}

