/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.SuppressLint;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.PreviewableHandwritingGesture;
import java.util.Objects;

public class SelectGesture
extends PreviewableHandwritingGesture
implements Parcelable {
    @HandwritingGesture.Granularity
    private int mGranularity;
    private RectF mArea;
    public static final Parcelable.Creator<SelectGesture> CREATOR = new Parcelable.Creator<SelectGesture>(){

        @Override
        public SelectGesture createFromParcel(Parcel source) {
            return new SelectGesture(source);
        }

        public SelectGesture[] newArray(int size) {
            return new SelectGesture[size];
        }
    };

    private SelectGesture(int granularity, RectF area, String fallbackText) {
        this.mType = 1;
        this.mArea = area;
        this.mGranularity = granularity;
        this.mFallbackText = fallbackText;
    }

    private SelectGesture(Parcel source) {
        this.mType = 1;
        this.mFallbackText = source.readString8();
        this.mGranularity = source.readInt();
        this.mArea = source.readTypedObject(RectF.CREATOR);
    }

    @HandwritingGesture.Granularity
    public int getGranularity() {
        return this.mGranularity;
    }

    public RectF getSelectionArea() {
        return this.mArea;
    }

    public int hashCode() {
        return Objects.hash(this.mGranularity, this.mArea, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SelectGesture)) {
            return false;
        }
        SelectGesture that = (SelectGesture)o;
        if (this.mGranularity != that.mGranularity) {
            return false;
        }
        if (!Objects.equals(this.mFallbackText, that.mFallbackText)) {
            return false;
        }
        return Objects.equals(this.mArea, that.mArea);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mFallbackText);
        dest.writeInt(this.mGranularity);
        dest.writeTypedObject(this.mArea, flags);
    }

    public static class Builder {
        private int mGranularity;
        private RectF mArea;
        private String mFallbackText;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setGranularity(@HandwritingGesture.Granularity int granularity) {
            this.mGranularity = granularity;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSelectionArea(RectF area) {
            this.mArea = area;
            return this;
        }

        public Builder setFallbackText(String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        public SelectGesture build() {
            if (this.mArea == null || this.mArea.isEmpty()) {
                throw new IllegalArgumentException("Selection area must be set.");
            }
            if (this.mGranularity <= 0) {
                throw new IllegalArgumentException("Selection granularity must be set.");
            }
            return new SelectGesture(this.mGranularity, this.mArea, this.mFallbackText);
        }
    }
}

