/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.SuppressLint;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.PreviewableHandwritingGesture;
import java.util.Objects;

public class SelectRangeGesture
extends PreviewableHandwritingGesture
implements Parcelable {
    @HandwritingGesture.Granularity
    private int mGranularity;
    private RectF mStartArea;
    private RectF mEndArea;
    public static final Parcelable.Creator<SelectRangeGesture> CREATOR = new Parcelable.Creator<SelectRangeGesture>(){

        @Override
        public SelectRangeGesture createFromParcel(Parcel source) {
            return new SelectRangeGesture(source);
        }

        public SelectRangeGesture[] newArray(int size) {
            return new SelectRangeGesture[size];
        }
    };

    private SelectRangeGesture(int granularity, RectF startArea, RectF endArea, String fallbackText) {
        this.mType = 32;
        this.mStartArea = startArea;
        this.mEndArea = endArea;
        this.mGranularity = granularity;
        this.mFallbackText = fallbackText;
    }

    private SelectRangeGesture(Parcel source) {
        this.mType = 32;
        this.mFallbackText = source.readString8();
        this.mGranularity = source.readInt();
        this.mStartArea = source.readTypedObject(RectF.CREATOR);
        this.mEndArea = source.readTypedObject(RectF.CREATOR);
    }

    @HandwritingGesture.Granularity
    public int getGranularity() {
        return this.mGranularity;
    }

    public RectF getSelectionStartArea() {
        return this.mStartArea;
    }

    public RectF getSelectionEndArea() {
        return this.mEndArea;
    }

    public int hashCode() {
        return Objects.hash(this.mGranularity, this.mStartArea, this.mEndArea, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SelectRangeGesture)) {
            return false;
        }
        SelectRangeGesture that = (SelectRangeGesture)o;
        if (this.mGranularity != that.mGranularity) {
            return false;
        }
        if (!Objects.equals(this.mFallbackText, that.mFallbackText)) {
            return false;
        }
        if (!Objects.equals(this.mStartArea, that.mStartArea)) {
            return false;
        }
        return Objects.equals(this.mEndArea, that.mEndArea);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mFallbackText);
        dest.writeInt(this.mGranularity);
        dest.writeTypedObject(this.mStartArea, flags);
        dest.writeTypedObject(this.mEndArea, flags);
    }

    public static class Builder {
        private int mGranularity;
        private RectF mStartArea;
        private RectF mEndArea;
        private String mFallbackText;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setGranularity(@HandwritingGesture.Granularity int granularity) {
            this.mGranularity = granularity;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSelectionStartArea(RectF startArea) {
            this.mStartArea = startArea;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSelectionEndArea(RectF endArea) {
            this.mEndArea = endArea;
            return this;
        }

        public Builder setFallbackText(String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        public SelectRangeGesture build() {
            if (this.mStartArea == null || this.mStartArea.isEmpty() || this.mEndArea == null || this.mEndArea.isEmpty()) {
                throw new IllegalArgumentException("Selection area must be set.");
            }
            if (this.mGranularity <= 0) {
                throw new IllegalArgumentException("Selection granularity must be set.");
            }
            return new SelectRangeGesture(this.mGranularity, this.mStartArea, this.mEndArea, this.mFallbackText);
        }
    }
}

