/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Layout;
import android.text.SegmentFinder;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class TextBoundsInfo
implements Parcelable {
    public static final int FLAG_CHARACTER_WHITESPACE = 1;
    public static final int FLAG_CHARACTER_LINEFEED = 2;
    public static final int FLAG_CHARACTER_PUNCTUATION = 4;
    public static final int FLAG_LINE_IS_RTL = 8;
    private static final int KNOWN_CHARACTER_FLAGS = 15;
    private static final int BIDI_LEVEL_SHIFT = 19;
    private static final int BIDI_LEVEL_MASK = 66584576;
    private static final int FLAG_LINE_SEGMENT_START = Integer.MIN_VALUE;
    private static final int FLAG_LINE_SEGMENT_END = 0x40000000;
    private static final int FLAG_WORD_SEGMENT_START = 0x20000000;
    private static final int FLAG_WORD_SEGMENT_END = 0x10000000;
    private static final int FLAG_GRAPHEME_SEGMENT_START = 0x8000000;
    private static final int FLAG_GRAPHEME_SEGMENT_END = 0x4000000;
    private final int mStart;
    private final int mEnd;
    private final float[] mMatrixValues;
    private final float[] mCharacterBounds;
    private final int[] mInternalCharacterFlags;
    private final SegmentFinder mLineSegmentFinder;
    private final SegmentFinder mWordSegmentFinder;
    private final SegmentFinder mGraphemeSegmentFinder;
    public static final Parcelable.Creator<TextBoundsInfo> CREATOR = new Parcelable.Creator<TextBoundsInfo>(){

        @Override
        public TextBoundsInfo createFromParcel(Parcel source) {
            return new TextBoundsInfo(source);
        }

        public TextBoundsInfo[] newArray(int size) {
            return new TextBoundsInfo[size];
        }
    };
    private static final String TEXT_BOUNDS_INFO_KEY = "android.view.inputmethod.TextBoundsInfo";

    public void getMatrix(Matrix matrix) {
        Objects.requireNonNull(matrix);
        matrix.setValues(this.mMatrixValues);
    }

    public int getStartIndex() {
        return this.mStart;
    }

    public int getEndIndex() {
        return this.mEnd;
    }

    public void getCharacterBounds(int index, RectF bounds) {
        if (index < this.mStart || index >= this.mEnd) {
            throw new IndexOutOfBoundsException("Index is out of the bounds of [" + this.mStart + ", " + this.mEnd + ").");
        }
        int offset = 4 * (index - this.mStart);
        bounds.set(this.mCharacterBounds[offset], this.mCharacterBounds[offset + 1], this.mCharacterBounds[offset + 2], this.mCharacterBounds[offset + 3]);
    }

    public int getCharacterFlags(int index) {
        if (index < this.mStart || index >= this.mEnd) {
            throw new IndexOutOfBoundsException("Index is out of the bounds of [" + this.mStart + ", " + this.mEnd + ").");
        }
        int offset = index - this.mStart;
        return this.mInternalCharacterFlags[offset] & 0xF;
    }

    public int getCharacterBidiLevel(int index) {
        if (index < this.mStart || index >= this.mEnd) {
            throw new IndexOutOfBoundsException("Index is out of the bounds of [" + this.mStart + ", " + this.mEnd + ").");
        }
        int offset = index - this.mStart;
        return (this.mInternalCharacterFlags[offset] & 0x3F80000) >> 19;
    }

    public SegmentFinder getWordSegmentFinder() {
        return this.mWordSegmentFinder;
    }

    public SegmentFinder getGraphemeSegmentFinder() {
        return this.mGraphemeSegmentFinder;
    }

    public SegmentFinder getLineSegmentFinder() {
        return this.mLineSegmentFinder;
    }

    public int getOffsetForPosition(float x, float y) {
        int[] lineRange = new int[2];
        RectF lineBounds = new RectF();
        this.getLineInfo(y, lineRange, lineBounds);
        if (lineRange[0] == -1 || lineRange[1] == -1) {
            return -1;
        }
        int lineStart = lineRange[0];
        int lineEnd = lineRange[1];
        boolean lineEndsWithLinefeed = (this.getCharacterFlags(lineEnd - 1) & 2) != 0;
        int lineLimit = lineEndsWithLinefeed ? lineEnd : lineEnd + 1;
        int graphemeStart = this.mGraphemeSegmentFinder.nextEndBoundary(lineStart);
        if (graphemeStart == -1) {
            return -1;
        }
        graphemeStart = this.mGraphemeSegmentFinder.previousStartBoundary(graphemeStart);
        int target = -1;
        float minDistance = Float.MAX_VALUE;
        while (graphemeStart != -1 && graphemeStart < lineLimit) {
            float cursorPosition;
            float distance;
            if (graphemeStart >= lineStart && (distance = Math.abs((cursorPosition = this.getCursorHorizontalPosition(graphemeStart, lineStart, lineEnd, lineBounds.left, lineBounds.right)) - x)) < minDistance) {
                minDistance = distance;
                target = graphemeStart;
            }
            graphemeStart = this.mGraphemeSegmentFinder.nextStartBoundary(graphemeStart);
        }
        return target;
    }

    private boolean primaryIsTrailingPrevious(int offset, int lineStart, int lineEnd) {
        int bidiLevelBefore;
        int bidiLevel;
        if (offset < lineEnd) {
            bidiLevel = this.getCharacterBidiLevel(offset);
        } else {
            boolean lineIsRtl = (this.getCharacterFlags(offset - 1) & 8) == 8;
            int n = bidiLevel = lineIsRtl ? 1 : 0;
        }
        if (offset > lineStart) {
            bidiLevelBefore = this.getCharacterBidiLevel(offset - 1);
        } else {
            boolean lineIsRtl = (this.getCharacterFlags(offset) & 8) == 8;
            bidiLevelBefore = lineIsRtl ? 1 : 0;
        }
        return bidiLevelBefore < bidiLevel;
    }

    private float getCursorHorizontalPosition(int index, int lineStart, int lineEnd, float lineLeft, float lineRight) {
        boolean isStart;
        int targetIndex;
        Preconditions.checkArgumentInRange(index, lineStart, lineEnd, "index");
        boolean lineIsRtl = (this.getCharacterFlags(lineStart) & 8) != 0;
        boolean isPrimaryIsTrailingPrevious = this.primaryIsTrailingPrevious(index, lineStart, lineEnd);
        if (isPrimaryIsTrailingPrevious) {
            if (index <= lineStart) {
                return lineIsRtl ? lineRight : lineLeft;
            }
            targetIndex = index - 1;
            isStart = false;
        } else {
            if (index >= lineEnd) {
                return lineIsRtl ? lineLeft : lineRight;
            }
            targetIndex = index;
            isStart = true;
        }
        boolean isRtl = (this.getCharacterBidiLevel(targetIndex) & 1) != 0;
        int offset = targetIndex - this.mStart;
        return isRtl != isStart ? this.mCharacterBounds[4 * offset] : this.mCharacterBounds[4 * offset + 2];
    }

    private void getBoundsForRange(int start, int end, RectF rectF) {
        Preconditions.checkArgumentInRange(start, this.mStart, this.mEnd - 1, "start");
        Preconditions.checkArgumentInRange(end, start, this.mEnd, "end");
        if (end <= start) {
            rectF.setEmpty();
            return;
        }
        rectF.left = Float.MAX_VALUE;
        rectF.top = Float.MAX_VALUE;
        rectF.right = Float.MIN_VALUE;
        rectF.bottom = Float.MIN_VALUE;
        for (int index = start; index < end; ++index) {
            int offset = index - this.mStart;
            rectF.left = Math.min(rectF.left, this.mCharacterBounds[4 * offset]);
            rectF.top = Math.min(rectF.top, this.mCharacterBounds[4 * offset + 1]);
            rectF.right = Math.max(rectF.right, this.mCharacterBounds[4 * offset + 2]);
            rectF.bottom = Math.max(rectF.bottom, this.mCharacterBounds[4 * offset + 3]);
        }
    }

    private void getLineInfo(float y, int[] characterRange, RectF bounds) {
        characterRange[0] = -1;
        characterRange[1] = -1;
        int currentLineEnd = this.mLineSegmentFinder.nextEndBoundary(this.mStart);
        if (currentLineEnd == -1) {
            return;
        }
        int currentLineStart = this.mLineSegmentFinder.previousStartBoundary(currentLineEnd);
        float top = Float.MAX_VALUE;
        float bottom = Float.MIN_VALUE;
        float minDistance = Float.MAX_VALUE;
        RectF currentLineBounds = new RectF();
        while (currentLineStart != -1 && currentLineStart < this.mEnd) {
            int lineStartInRange = Math.max(this.mStart, currentLineStart);
            int lineEndInRange = Math.min(this.mEnd, currentLineEnd);
            this.getBoundsForRange(lineStartInRange, lineEndInRange, currentLineBounds);
            top = Math.min(currentLineBounds.top, top);
            bottom = Math.max(currentLineBounds.bottom, bottom);
            float distance = TextBoundsInfo.verticalDistance(currentLineBounds, y);
            if (distance == 0.0f) {
                characterRange[0] = currentLineStart;
                characterRange[1] = currentLineEnd;
                if (bounds != null) {
                    bounds.set(currentLineBounds);
                }
                return;
            }
            if (distance < minDistance) {
                minDistance = distance;
                characterRange[0] = currentLineStart;
                characterRange[1] = currentLineEnd;
                if (bounds != null) {
                    bounds.set(currentLineBounds);
                }
            }
            if (y < bounds.top) break;
            currentLineStart = this.mLineSegmentFinder.nextStartBoundary(currentLineStart);
            currentLineEnd = this.mLineSegmentFinder.nextEndBoundary(currentLineEnd);
        }
        if (y < top || y > bottom) {
            characterRange[0] = -1;
            characterRange[1] = -1;
            if (bounds != null) {
                bounds.setEmpty();
            }
        }
    }

    public int[] getRangeForRect(RectF area, SegmentFinder segmentFinder, Layout.TextInclusionStrategy inclusionStrategy) {
        int lineEnd = this.mLineSegmentFinder.nextEndBoundary(this.mStart);
        if (lineEnd == -1) {
            return null;
        }
        int lineStart = this.mLineSegmentFinder.previousStartBoundary(lineEnd);
        int start = -1;
        while (lineStart != -1 && start == -1) {
            start = this.getStartForRectWithinLine(lineStart, lineEnd, area, segmentFinder, inclusionStrategy);
            lineStart = this.mLineSegmentFinder.nextStartBoundary(lineStart);
            lineEnd = this.mLineSegmentFinder.nextEndBoundary(lineEnd);
        }
        if (start == -1) {
            return null;
        }
        lineStart = this.mLineSegmentFinder.previousStartBoundary(this.mEnd);
        if (lineStart == -1) {
            return null;
        }
        lineEnd = this.mLineSegmentFinder.nextEndBoundary(lineStart);
        int end = -1;
        while (lineEnd > start && end == -1) {
            end = this.getEndForRectWithinLine(lineStart, lineEnd, area, segmentFinder, inclusionStrategy);
            lineStart = this.mLineSegmentFinder.previousStartBoundary(lineStart);
            lineEnd = this.mLineSegmentFinder.previousEndBoundary(lineEnd);
        }
        start = segmentFinder.previousStartBoundary(start + 1);
        end = segmentFinder.nextEndBoundary(end - 1);
        return new int[]{start, end};
    }

    private int getStartForRectWithinLine(int lineStart, int lineEnd, RectF area, SegmentFinder segmentFinder, Layout.TextInclusionStrategy inclusionStrategy) {
        if (lineStart >= lineEnd) {
            return -1;
        }
        int runStart = lineStart;
        int runLevel = -1;
        for (int index = lineStart; index < lineEnd; ++index) {
            int level = this.getCharacterBidiLevel(index);
            if (level == runLevel) continue;
            int start = this.getStartForRectWithinRun(runStart, index, area, segmentFinder, inclusionStrategy);
            if (start != -1) {
                return start;
            }
            runStart = index;
            runLevel = level;
        }
        return this.getStartForRectWithinRun(runStart, lineEnd, area, segmentFinder, inclusionStrategy);
    }

    private int getStartForRectWithinRun(int runStart, int runEnd, RectF area, SegmentFinder segmentFinder, Layout.TextInclusionStrategy inclusionStrategy) {
        if (runStart >= runEnd) {
            return -1;
        }
        int segmentEndOffset = segmentFinder.nextEndBoundary(runStart);
        if (segmentEndOffset == -1) {
            return -1;
        }
        int segmentStartOffset = segmentFinder.previousStartBoundary(segmentEndOffset);
        RectF segmentBounds = new RectF();
        while (segmentStartOffset != -1 && segmentStartOffset < runEnd) {
            int start = Math.max(runStart, segmentStartOffset);
            int end = Math.min(runEnd, segmentEndOffset);
            this.getBoundsForRange(start, end, segmentBounds);
            if (inclusionStrategy.isSegmentInside(segmentBounds, area)) {
                return start;
            }
            segmentStartOffset = segmentFinder.nextStartBoundary(segmentStartOffset);
            segmentEndOffset = segmentFinder.nextEndBoundary(segmentEndOffset);
        }
        return -1;
    }

    private int getEndForRectWithinLine(int lineStart, int lineEnd, RectF area, SegmentFinder segmentFinder, Layout.TextInclusionStrategy inclusionStrategy) {
        if (lineStart >= lineEnd) {
            return -1;
        }
        lineStart = Math.max(lineStart, this.mStart);
        int runEnd = lineEnd = Math.min(lineEnd, this.mEnd);
        int runLevel = -1;
        for (int index = lineEnd - 1; index >= lineStart; --index) {
            int level = this.getCharacterBidiLevel(index);
            if (level == runLevel) continue;
            int end = this.getEndForRectWithinRun(index + 1, runEnd, area, segmentFinder, inclusionStrategy);
            if (end != -1) {
                return end;
            }
            runEnd = index + 1;
            runLevel = level;
        }
        return this.getEndForRectWithinRun(lineStart, runEnd, area, segmentFinder, inclusionStrategy);
    }

    private int getEndForRectWithinRun(int runStart, int runEnd, RectF area, SegmentFinder segmentFinder, Layout.TextInclusionStrategy inclusionStrategy) {
        if (runStart >= runEnd) {
            return -1;
        }
        int segmentStart = segmentFinder.previousStartBoundary(runEnd);
        if (segmentStart == -1) {
            return -1;
        }
        int segmentEnd = segmentFinder.nextEndBoundary(segmentStart);
        RectF segmentBounds = new RectF();
        while (segmentEnd != -1 && segmentEnd > runStart) {
            int start = Math.max(runStart, segmentStart);
            int end = Math.min(runEnd, segmentEnd);
            this.getBoundsForRange(start, end, segmentBounds);
            if (inclusionStrategy.isSegmentInside(segmentBounds, area)) {
                return end;
            }
            segmentStart = segmentFinder.previousStartBoundary(segmentStart);
            segmentEnd = segmentFinder.previousEndBoundary(segmentEnd);
        }
        return -1;
    }

    private static float verticalDistance(RectF rectF, float y) {
        if (rectF.top <= y && y < rectF.bottom) {
            return 0.0f;
        }
        if (y < rectF.top) {
            return rectF.top - y;
        }
        return y - rectF.bottom;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStart);
        dest.writeInt(this.mEnd);
        dest.writeFloatArray(this.mMatrixValues);
        dest.writeFloatArray(this.mCharacterBounds);
        int[] encodedFlags = Arrays.copyOf(this.mInternalCharacterFlags, this.mEnd - this.mStart + 1);
        TextBoundsInfo.encodeSegmentFinder(encodedFlags, 0x8000000, 0x4000000, this.mStart, this.mEnd, this.mGraphemeSegmentFinder);
        TextBoundsInfo.encodeSegmentFinder(encodedFlags, 0x20000000, 0x10000000, this.mStart, this.mEnd, this.mWordSegmentFinder);
        TextBoundsInfo.encodeSegmentFinder(encodedFlags, Integer.MIN_VALUE, 0x40000000, this.mStart, this.mEnd, this.mLineSegmentFinder);
        dest.writeIntArray(encodedFlags);
    }

    private TextBoundsInfo(Parcel source) {
        this.mStart = source.readInt();
        this.mEnd = source.readInt();
        this.mMatrixValues = Objects.requireNonNull(source.createFloatArray());
        this.mCharacterBounds = Objects.requireNonNull(source.createFloatArray());
        int[] encodedFlags = Objects.requireNonNull(source.createIntArray());
        this.mGraphemeSegmentFinder = TextBoundsInfo.decodeSegmentFinder(encodedFlags, 0x8000000, 0x4000000, this.mStart, this.mEnd);
        this.mWordSegmentFinder = TextBoundsInfo.decodeSegmentFinder(encodedFlags, 0x20000000, 0x10000000, this.mStart, this.mEnd);
        this.mLineSegmentFinder = TextBoundsInfo.decodeSegmentFinder(encodedFlags, Integer.MIN_VALUE, 0x40000000, this.mStart, this.mEnd);
        int length = this.mEnd - this.mStart;
        int flagsMask = 66584591;
        this.mInternalCharacterFlags = new int[length];
        for (int i = 0; i < length; ++i) {
            this.mInternalCharacterFlags[i] = encodedFlags[i] & 0x3F8000F;
        }
    }

    private TextBoundsInfo(Builder builder) {
        this.mStart = builder.mStart;
        this.mEnd = builder.mEnd;
        this.mMatrixValues = Arrays.copyOf(builder.mMatrixValues, 9);
        int length = this.mEnd - this.mStart;
        this.mCharacterBounds = Arrays.copyOf(builder.mCharacterBounds, 4 * length);
        this.mInternalCharacterFlags = new int[length];
        for (int index = 0; index < length; ++index) {
            this.mInternalCharacterFlags[index] = builder.mCharacterFlags[index] | builder.mCharacterBidiLevels[index] << 19;
        }
        this.mGraphemeSegmentFinder = builder.mGraphemeSegmentFinder;
        this.mWordSegmentFinder = builder.mWordSegmentFinder;
        this.mLineSegmentFinder = builder.mLineSegmentFinder;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TEXT_BOUNDS_INFO_KEY, this);
        return bundle;
    }

    public static TextBoundsInfo createFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return bundle.getParcelable(TEXT_BOUNDS_INFO_KEY, TextBoundsInfo.class);
    }

    private static void encodeSegmentFinder(int[] flags, int segmentStartFlag, int segmentEndFlag, int start, int end, SegmentFinder segmentFinder) {
        if (end - start + 1 != flags.length) {
            throw new IllegalStateException("The given flags array must have the same length as the given range. flags length: " + flags.length + " range: [" + start + ", " + end + "]");
        }
        int segmentEnd = segmentFinder.nextEndBoundary(start);
        if (segmentEnd == -1) {
            return;
        }
        int segmentStart = segmentFinder.previousStartBoundary(segmentEnd);
        while (segmentEnd != -1 && segmentEnd <= end) {
            if (segmentStart >= start) {
                int n = segmentStart - start;
                flags[n] = flags[n] | segmentStartFlag;
                int n2 = segmentEnd - start;
                flags[n2] = flags[n2] | segmentEndFlag;
            }
            segmentStart = segmentFinder.nextStartBoundary(segmentStart);
            segmentEnd = segmentFinder.nextEndBoundary(segmentEnd);
        }
    }

    private static SegmentFinder decodeSegmentFinder(int[] flags, int segmentStartFlag, int segmentEndFlag, int start, int end) {
        if (end - start + 1 != flags.length) {
            throw new IllegalStateException("The given flags array must have the same length as the given range. flags length: " + flags.length + " range: [" + start + ", " + end + "]");
        }
        int[] breaks = ArrayUtils.newUnpaddedIntArray(10);
        int count = 0;
        for (int offset = 0; offset < flags.length; ++offset) {
            if ((flags[offset] & segmentStartFlag) == segmentStartFlag) {
                breaks = GrowingArrayUtils.append(breaks, count++, start + offset);
            }
            if ((flags[offset] & segmentEndFlag) != segmentEndFlag) continue;
            breaks = GrowingArrayUtils.append(breaks, count++, start + offset);
        }
        return new SegmentFinder.PrescribedSegmentFinder(Arrays.copyOf(breaks, count));
    }

    private static boolean isLineDirectionFlagConsistent(int[] characterFlags, SegmentFinder lineSegmentFinder, int start, int end) {
        int segmentEnd = lineSegmentFinder.nextEndBoundary(start);
        if (segmentEnd == -1) {
            return true;
        }
        int segmentStart = lineSegmentFinder.previousStartBoundary(segmentEnd);
        while (segmentStart != -1 && segmentStart < end) {
            int lineStart = Math.max(segmentStart, start);
            int lineEnd = Math.min(segmentEnd, end);
            boolean lineIsRtl = (characterFlags[lineStart - start] & 8) != 0;
            for (int index = lineStart + 1; index < lineEnd; ++index) {
                boolean characterLineIsRtl;
                int flags = characterFlags[index - start];
                boolean bl = characterLineIsRtl = (flags & 8) != 0;
                if (characterLineIsRtl == lineIsRtl) continue;
                return false;
            }
            segmentStart = lineSegmentFinder.nextStartBoundary(segmentStart);
            segmentEnd = lineSegmentFinder.nextEndBoundary(segmentEnd);
        }
        return true;
    }

    public static class Builder {
        private final float[] mMatrixValues = new float[9];
        private boolean mMatrixInitialized;
        private int mStart = -1;
        private int mEnd = -1;
        private float[] mCharacterBounds;
        private int[] mCharacterFlags;
        private int[] mCharacterBidiLevels;
        private SegmentFinder mLineSegmentFinder;
        private SegmentFinder mWordSegmentFinder;
        private SegmentFinder mGraphemeSegmentFinder;

        public Builder(int start, int end) {
            this.setStartAndEnd(start, end);
        }

        public Builder clear() {
            this.mMatrixInitialized = false;
            this.mStart = -1;
            this.mEnd = -1;
            this.mCharacterBounds = null;
            this.mCharacterFlags = null;
            this.mCharacterBidiLevels = null;
            this.mLineSegmentFinder = null;
            this.mWordSegmentFinder = null;
            this.mGraphemeSegmentFinder = null;
            return this;
        }

        public Builder setMatrix(Matrix matrix) {
            Objects.requireNonNull(matrix).getValues(this.mMatrixValues);
            this.mMatrixInitialized = true;
            return this;
        }

        public Builder setStartAndEnd(int start, int end) {
            Preconditions.checkArgument(start >= 0);
            Preconditions.checkArgumentInRange(start, 0, end, "start");
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        public Builder setCharacterBounds(float[] characterBounds) {
            this.mCharacterBounds = Objects.requireNonNull(characterBounds);
            return this;
        }

        public Builder setCharacterFlags(int[] characterFlags) {
            Objects.requireNonNull(characterFlags);
            for (int characterFlag : characterFlags) {
                if ((characterFlag & 0xFFFFFFF0) == 0) continue;
                throw new IllegalArgumentException("characterFlags contains invalid flags.");
            }
            this.mCharacterFlags = characterFlags;
            return this;
        }

        public Builder setCharacterBidiLevel(int[] characterBidiLevels) {
            Objects.requireNonNull(characterBidiLevels);
            for (int index = 0; index < characterBidiLevels.length; ++index) {
                Preconditions.checkArgumentInRange(characterBidiLevels[index], 0, 125, "bidiLevels[" + index + "]");
            }
            this.mCharacterBidiLevels = characterBidiLevels;
            return this;
        }

        public Builder setGraphemeSegmentFinder(SegmentFinder graphemeSegmentFinder) {
            this.mGraphemeSegmentFinder = Objects.requireNonNull(graphemeSegmentFinder);
            return this;
        }

        public Builder setWordSegmentFinder(SegmentFinder wordSegmentFinder) {
            this.mWordSegmentFinder = Objects.requireNonNull(wordSegmentFinder);
            return this;
        }

        public Builder setLineSegmentFinder(SegmentFinder lineSegmentFinder) {
            this.mLineSegmentFinder = Objects.requireNonNull(lineSegmentFinder);
            return this;
        }

        public TextBoundsInfo build() {
            if (this.mStart < 0 || this.mEnd < 0) {
                throw new IllegalStateException("Start and end must be set.");
            }
            if (!this.mMatrixInitialized) {
                throw new IllegalStateException("Matrix must be set.");
            }
            if (this.mCharacterBounds == null) {
                throw new IllegalStateException("CharacterBounds must be set.");
            }
            if (this.mCharacterFlags == null) {
                throw new IllegalStateException("CharacterFlags must be set.");
            }
            if (this.mCharacterBidiLevels == null) {
                throw new IllegalStateException("CharacterBidiLevel must be set.");
            }
            if (this.mCharacterBounds.length != 4 * (this.mEnd - this.mStart)) {
                throw new IllegalStateException("The length of characterBounds doesn't match the length of the given start and end. Expected length: " + 4 * (this.mEnd - this.mStart) + " characterBounds length: " + this.mCharacterBounds.length);
            }
            if (this.mCharacterFlags.length != this.mEnd - this.mStart) {
                throw new IllegalStateException("The length of characterFlags doesn't match the length of the given start and end. Expected length: " + (this.mEnd - this.mStart) + " characterFlags length: " + this.mCharacterFlags.length);
            }
            if (this.mCharacterBidiLevels.length != this.mEnd - this.mStart) {
                throw new IllegalStateException("The length of characterBidiLevels doesn't match the length of the given start and end. Expected length: " + (this.mEnd - this.mStart) + " characterFlags length: " + this.mCharacterBidiLevels.length);
            }
            if (this.mGraphemeSegmentFinder == null) {
                throw new IllegalStateException("GraphemeSegmentFinder must be set.");
            }
            if (this.mWordSegmentFinder == null) {
                throw new IllegalStateException("WordSegmentFinder must be set.");
            }
            if (this.mLineSegmentFinder == null) {
                throw new IllegalStateException("LineSegmentFinder must be set.");
            }
            if (!TextBoundsInfo.isLineDirectionFlagConsistent(this.mCharacterFlags, this.mLineSegmentFinder, this.mStart, this.mEnd)) {
                throw new IllegalStateException("characters in the same line must have the same FLAG_LINE_IS_RTL flag value.");
            }
            return new TextBoundsInfo(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CharacterFlags {
    }
}

