/*
 * Decompiled with CFR 0.152.
 */
package android.view.selectiontoolbar;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.selectiontoolbar.ToolbarMenuItem;
import android.view.selectiontoolbar.WidgetInfo;

public interface ISelectionToolbarCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.view.selectiontoolbar.ISelectionToolbarCallback";

    public void onShown(WidgetInfo var1) throws RemoteException;

    public void onWidgetUpdated(WidgetInfo var1) throws RemoteException;

    public void onToolbarShowTimeout() throws RemoteException;

    public void onMenuItemClicked(ToolbarMenuItem var1) throws RemoteException;

    public void onError(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISelectionToolbarCallback {
        static final int TRANSACTION_onShown = 1;
        static final int TRANSACTION_onWidgetUpdated = 2;
        static final int TRANSACTION_onToolbarShowTimeout = 3;
        static final int TRANSACTION_onMenuItemClicked = 4;
        static final int TRANSACTION_onError = 5;

        public Stub() {
            this.attachInterface(this, ISelectionToolbarCallback.DESCRIPTOR);
        }

        public static ISelectionToolbarCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISelectionToolbarCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISelectionToolbarCallback) {
                return (ISelectionToolbarCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onShown";
                }
                case 2: {
                    return "onWidgetUpdated";
                }
                case 3: {
                    return "onToolbarShowTimeout";
                }
                case 4: {
                    return "onMenuItemClicked";
                }
                case 5: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISelectionToolbarCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    WidgetInfo _arg0 = data.readTypedObject(WidgetInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onShown(_arg0);
                    break;
                }
                case 2: {
                    WidgetInfo _arg0 = data.readTypedObject(WidgetInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onWidgetUpdated(_arg0);
                    break;
                }
                case 3: {
                    this.onToolbarShowTimeout();
                    break;
                }
                case 4: {
                    ToolbarMenuItem _arg0 = data.readTypedObject(ToolbarMenuItem.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMenuItemClicked(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ISelectionToolbarCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISelectionToolbarCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onShown(WidgetInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarCallback.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWidgetUpdated(WidgetInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarCallback.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onToolbarShowTimeout() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMenuItemClicked(ToolbarMenuItem item) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarCallback.DESCRIPTOR);
                    _data.writeTypedObject(item, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISelectionToolbarCallback {
        @Override
        public void onShown(WidgetInfo info) throws RemoteException {
        }

        @Override
        public void onWidgetUpdated(WidgetInfo info) throws RemoteException {
        }

        @Override
        public void onToolbarShowTimeout() throws RemoteException {
        }

        @Override
        public void onMenuItemClicked(ToolbarMenuItem item) throws RemoteException {
        }

        @Override
        public void onError(int errorCode) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

