/*
 * Decompiled with CFR 0.152.
 */
package android.view.selectiontoolbar;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.selectiontoolbar.ISelectionToolbarCallback;
import android.view.selectiontoolbar.ShowInfo;

public interface ISelectionToolbarManager
extends IInterface {
    public static final String DESCRIPTOR = "android.view.selectiontoolbar.ISelectionToolbarManager";

    public void showToolbar(ShowInfo var1, ISelectionToolbarCallback var2, int var3) throws RemoteException;

    public void hideToolbar(long var1, int var3) throws RemoteException;

    public void dismissToolbar(long var1, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISelectionToolbarManager {
        static final int TRANSACTION_showToolbar = 1;
        static final int TRANSACTION_hideToolbar = 2;
        static final int TRANSACTION_dismissToolbar = 3;

        public Stub() {
            this.attachInterface(this, ISelectionToolbarManager.DESCRIPTOR);
        }

        public static ISelectionToolbarManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISelectionToolbarManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISelectionToolbarManager) {
                return (ISelectionToolbarManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "showToolbar";
                }
                case 2: {
                    return "hideToolbar";
                }
                case 3: {
                    return "dismissToolbar";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISelectionToolbarManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ShowInfo _arg0 = data.readTypedObject(ShowInfo.CREATOR);
                    ISelectionToolbarCallback _arg1 = ISelectionToolbarCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showToolbar(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.hideToolbar(_arg0, _arg1);
                    break;
                }
                case 3: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dismissToolbar(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ISelectionToolbarManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISelectionToolbarManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showToolbar(ShowInfo showInfo, ISelectionToolbarCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarManager.DESCRIPTOR);
                    _data.writeTypedObject(showInfo, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideToolbar(long widgetToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarManager.DESCRIPTOR);
                    _data.writeLong(widgetToken);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissToolbar(long widgetToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISelectionToolbarManager.DESCRIPTOR);
                    _data.writeLong(widgetToken);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISelectionToolbarManager {
        @Override
        public void showToolbar(ShowInfo showInfo, ISelectionToolbarCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void hideToolbar(long widgetToken, int userId) throws RemoteException {
        }

        @Override
        public void dismissToolbar(long widgetToken, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

