/*
 * Decompiled with CFR 0.152.
 */
package android.view.selectiontoolbar;

import android.content.Context;
import android.os.RemoteException;
import android.provider.DeviceConfig;
import android.view.selectiontoolbar.ISelectionToolbarCallback;
import android.view.selectiontoolbar.ISelectionToolbarManager;
import android.view.selectiontoolbar.ShowInfo;
import java.util.Objects;

public class SelectionToolbarManager {
    private static final String TAG = "SelectionToolbar";
    public static final String LOG_TAG = "SelectionToolbar";
    private static final String REMOTE_SELECTION_TOOLBAR_ENABLED = "remote_selection_toolbar_enabled";
    public static final long NO_TOOLBAR_ID = 0L;
    public static final int ERROR_DO_NOT_ALLOW_MULTIPLE_TOOL_BAR = 1;
    private final Context mContext;
    private final ISelectionToolbarManager mService;

    public SelectionToolbarManager(Context context, ISelectionToolbarManager service) {
        this.mContext = Objects.requireNonNull(context);
        this.mService = service;
    }

    public void showToolbar(ShowInfo showInfo, ISelectionToolbarCallback callback) {
        try {
            Objects.requireNonNull(showInfo);
            Objects.requireNonNull(callback);
            this.mService.showToolbar(showInfo, callback, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void hideToolbar(long widgetToken) {
        try {
            this.mService.hideToolbar(widgetToken, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void dismissToolbar(long widgetToken) {
        try {
            this.mService.dismissToolbar(widgetToken, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean isRemoteSelectionToolbarEnabled() {
        return DeviceConfig.getBoolean("selection_toolbar", REMOTE_SELECTION_TOOLBAR_ENABLED, false);
    }

    public static boolean isRemoteSelectionToolbarEnabled(Context context) {
        SelectionToolbarManager manager = context.getSystemService(SelectionToolbarManager.class);
        if (manager != null) {
            return manager.isRemoteSelectionToolbarEnabled();
        }
        return false;
    }
}

