/*
 * Decompiled with CFR 0.152.
 */
package android.view.selectiontoolbar;

import android.annotation.NonNull;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.selectiontoolbar.ToolbarMenuItem;
import com.android.internal.util.AnnotationValidations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ShowInfo
implements Parcelable {
    private final long mWidgetToken;
    private final boolean mLayoutRequired;
    private final List<ToolbarMenuItem> mMenuItems;
    private final Rect mContentRect;
    private final int mSuggestedWidth;
    private final Rect mViewPortOnScreen;
    private final IBinder mHostInputToken;
    private final boolean mIsLightTheme;
    public static final Parcelable.Creator<ShowInfo> CREATOR = new Parcelable.Creator<ShowInfo>(){

        public ShowInfo[] newArray(int size) {
            return new ShowInfo[size];
        }

        @Override
        public ShowInfo createFromParcel(Parcel in) {
            return new ShowInfo(in);
        }
    };

    public ShowInfo(long widgetToken, boolean layoutRequired, List<ToolbarMenuItem> menuItems, Rect contentRect, int suggestedWidth, Rect viewPortOnScreen, IBinder hostInputToken, boolean isLightTheme) {
        this.mWidgetToken = widgetToken;
        this.mLayoutRequired = layoutRequired;
        this.mMenuItems = menuItems;
        AnnotationValidations.validate(NonNull.class, null, this.mMenuItems);
        this.mContentRect = contentRect;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mContentRect);
        this.mSuggestedWidth = suggestedWidth;
        this.mViewPortOnScreen = viewPortOnScreen;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mViewPortOnScreen);
        this.mHostInputToken = hostInputToken;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHostInputToken);
        this.mIsLightTheme = isLightTheme;
    }

    public long getWidgetToken() {
        return this.mWidgetToken;
    }

    public boolean isLayoutRequired() {
        return this.mLayoutRequired;
    }

    public List<ToolbarMenuItem> getMenuItems() {
        return this.mMenuItems;
    }

    public Rect getContentRect() {
        return this.mContentRect;
    }

    public int getSuggestedWidth() {
        return this.mSuggestedWidth;
    }

    public Rect getViewPortOnScreen() {
        return this.mViewPortOnScreen;
    }

    public IBinder getHostInputToken() {
        return this.mHostInputToken;
    }

    public boolean isIsLightTheme() {
        return this.mIsLightTheme;
    }

    public String toString() {
        return "ShowInfo { widgetToken = " + this.mWidgetToken + ", layoutRequired = " + this.mLayoutRequired + ", menuItems = " + this.mMenuItems + ", contentRect = " + this.mContentRect + ", suggestedWidth = " + this.mSuggestedWidth + ", viewPortOnScreen = " + this.mViewPortOnScreen + ", hostInputToken = " + this.mHostInputToken + ", isLightTheme = " + this.mIsLightTheme + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowInfo that = (ShowInfo)o;
        return this.mWidgetToken == that.mWidgetToken && this.mLayoutRequired == that.mLayoutRequired && Objects.equals(this.mMenuItems, that.mMenuItems) && Objects.equals(this.mContentRect, that.mContentRect) && this.mSuggestedWidth == that.mSuggestedWidth && Objects.equals(this.mViewPortOnScreen, that.mViewPortOnScreen) && Objects.equals(this.mHostInputToken, that.mHostInputToken) && this.mIsLightTheme == that.mIsLightTheme;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Long.hashCode(this.mWidgetToken);
        _hash = 31 * _hash + Boolean.hashCode(this.mLayoutRequired);
        _hash = 31 * _hash + Objects.hashCode(this.mMenuItems);
        _hash = 31 * _hash + Objects.hashCode(this.mContentRect);
        _hash = 31 * _hash + this.mSuggestedWidth;
        _hash = 31 * _hash + Objects.hashCode(this.mViewPortOnScreen);
        _hash = 31 * _hash + Objects.hashCode(this.mHostInputToken);
        _hash = 31 * _hash + Boolean.hashCode(this.mIsLightTheme);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int flg = 0;
        if (this.mLayoutRequired) {
            flg |= 2;
        }
        if (this.mIsLightTheme) {
            flg |= 0x80;
        }
        dest.writeInt(flg);
        dest.writeLong(this.mWidgetToken);
        dest.writeParcelableList(this.mMenuItems, flags);
        dest.writeTypedObject(this.mContentRect, flags);
        dest.writeInt(this.mSuggestedWidth);
        dest.writeTypedObject(this.mViewPortOnScreen, flags);
        dest.writeStrongBinder(this.mHostInputToken);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ShowInfo(Parcel in) {
        int flg = in.readInt();
        boolean layoutRequired = (flg & 2) != 0;
        boolean isLightTheme = (flg & 0x80) != 0;
        long widgetToken = in.readLong();
        ArrayList<ToolbarMenuItem> menuItems = new ArrayList<ToolbarMenuItem>();
        in.readParcelableList(menuItems, ToolbarMenuItem.class.getClassLoader(), ToolbarMenuItem.class);
        Rect contentRect = in.readTypedObject(Rect.CREATOR);
        int suggestedWidth = in.readInt();
        Rect viewPortOnScreen = in.readTypedObject(Rect.CREATOR);
        IBinder hostInputToken = in.readStrongBinder();
        this.mWidgetToken = widgetToken;
        this.mLayoutRequired = layoutRequired;
        this.mMenuItems = menuItems;
        AnnotationValidations.validate(NonNull.class, null, this.mMenuItems);
        this.mContentRect = contentRect;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mContentRect);
        this.mSuggestedWidth = suggestedWidth;
        this.mViewPortOnScreen = viewPortOnScreen;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mViewPortOnScreen);
        this.mHostInputToken = hostInputToken;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHostInputToken);
        this.mIsLightTheme = isLightTheme;
    }

    @Deprecated
    private void __metadata() {
    }
}

