/*
 * Decompiled with CFR 0.152.
 */
package android.view.selectiontoolbar;

import android.annotation.NonNull;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.MenuItem;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ToolbarMenuItem
implements Parcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_PRIMARY = 1;
    public static final int PRIORITY_OVERFLOW = 2;
    private final int mItemId;
    private final CharSequence mTitle;
    private final CharSequence mContentDescription;
    private final int mGroupId;
    private final Icon mIcon;
    private final CharSequence mTooltipText;
    private final int mPriority;
    public static final Parcelable.Creator<ToolbarMenuItem> CREATOR = new Parcelable.Creator<ToolbarMenuItem>(){

        public ToolbarMenuItem[] newArray(int size) {
            return new ToolbarMenuItem[size];
        }

        @Override
        public ToolbarMenuItem createFromParcel(Parcel in) {
            return new ToolbarMenuItem(in);
        }
    };

    public static int getPriorityFromMenuItem(MenuItem menuItem) {
        if (menuItem.requiresActionButton()) {
            return 1;
        }
        if (menuItem.requiresOverflow()) {
            return 2;
        }
        return 0;
    }

    public static String priorityToString(int value) {
        switch (value) {
            case 0: {
                return "PRIORITY_UNKNOWN";
            }
            case 1: {
                return "PRIORITY_PRIMARY";
            }
            case 2: {
                return "PRIORITY_OVERFLOW";
            }
        }
        return Integer.toHexString(value);
    }

    ToolbarMenuItem(int itemId, CharSequence title, CharSequence contentDescription, int groupId, Icon icon, CharSequence tooltipText, int priority) {
        this.mItemId = itemId;
        this.mTitle = title;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTitle);
        this.mContentDescription = contentDescription;
        this.mGroupId = groupId;
        this.mIcon = icon;
        this.mTooltipText = tooltipText;
        this.mPriority = priority;
    }

    public int getItemId() {
        return this.mItemId;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public int getGroupId() {
        return this.mGroupId;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public CharSequence getTooltipText() {
        return this.mTooltipText;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public String toString() {
        return "ToolbarMenuItem { itemId = " + this.mItemId + ", title = " + this.mTitle + ", contentDescription = " + this.mContentDescription + ", groupId = " + this.mGroupId + ", icon = " + this.mIcon + ", tooltipText = " + this.mTooltipText + ", priority = " + this.mPriority + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolbarMenuItem that = (ToolbarMenuItem)o;
        return this.mItemId == that.mItemId && Objects.equals(this.mTitle, that.mTitle) && Objects.equals(this.mContentDescription, that.mContentDescription) && this.mGroupId == that.mGroupId && Objects.equals(this.mIcon, that.mIcon) && Objects.equals(this.mTooltipText, that.mTooltipText) && this.mPriority == that.mPriority;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mItemId;
        _hash = 31 * _hash + Objects.hashCode(this.mTitle);
        _hash = 31 * _hash + Objects.hashCode(this.mContentDescription);
        _hash = 31 * _hash + this.mGroupId;
        _hash = 31 * _hash + Objects.hashCode(this.mIcon);
        _hash = 31 * _hash + Objects.hashCode(this.mTooltipText);
        _hash = 31 * _hash + this.mPriority;
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mContentDescription != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mIcon != null) {
            flg = (byte)(flg | 0x10);
        }
        if (this.mTooltipText != null) {
            flg = (byte)(flg | 0x20);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mItemId);
        dest.writeCharSequence(this.mTitle);
        if (this.mContentDescription != null) {
            dest.writeCharSequence(this.mContentDescription);
        }
        dest.writeInt(this.mGroupId);
        if (this.mIcon != null) {
            dest.writeTypedObject(this.mIcon, flags);
        }
        if (this.mTooltipText != null) {
            dest.writeCharSequence(this.mTooltipText);
        }
        dest.writeInt(this.mPriority);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ToolbarMenuItem(Parcel in) {
        byte flg = in.readByte();
        int itemId = in.readInt();
        CharSequence title = in.readCharSequence();
        CharSequence contentDescription = (flg & 4) == 0 ? null : in.readCharSequence();
        int groupId = in.readInt();
        Icon icon = (flg & 0x10) == 0 ? null : in.readTypedObject(Icon.CREATOR);
        CharSequence tooltipText = (flg & 0x20) == 0 ? null : in.readCharSequence();
        int priority = in.readInt();
        this.mItemId = itemId;
        this.mTitle = title;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTitle);
        this.mContentDescription = contentDescription;
        this.mGroupId = groupId;
        this.mIcon = icon;
        this.mTooltipText = tooltipText;
        this.mPriority = priority;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private int mItemId;
        private CharSequence mTitle;
        private CharSequence mContentDescription;
        private int mGroupId;
        private Icon mIcon;
        private CharSequence mTooltipText;
        private int mPriority;
        private long mBuilderFieldsSet = 0L;

        public Builder(int itemId, CharSequence title, CharSequence contentDescription, int groupId, Icon icon, CharSequence tooltipText, int priority) {
            this.mItemId = itemId;
            this.mTitle = title;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTitle);
            this.mContentDescription = contentDescription;
            this.mGroupId = groupId;
            this.mIcon = icon;
            this.mTooltipText = tooltipText;
            this.mPriority = priority;
        }

        public Builder setItemId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mItemId = value;
            return this;
        }

        public Builder setTitle(CharSequence value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mTitle = value;
            return this;
        }

        public Builder setContentDescription(CharSequence value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mContentDescription = value;
            return this;
        }

        public Builder setGroupId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mGroupId = value;
            return this;
        }

        public Builder setIcon(Icon value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mIcon = value;
            return this;
        }

        public Builder setTooltipText(CharSequence value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mTooltipText = value;
            return this;
        }

        public Builder setPriority(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mPriority = value;
            return this;
        }

        public ToolbarMenuItem build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            ToolbarMenuItem o = new ToolbarMenuItem(this.mItemId, this.mTitle, this.mContentDescription, this.mGroupId, this.mIcon, this.mTooltipText, this.mPriority);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x80L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }
}

