/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.textclassifier.ITextClassifierCallback;
import android.service.textclassifier.ITextClassifierService;
import android.service.textclassifier.TextClassifierService;
import android.view.textclassifier.ConversationActions;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.SystemTextClassifierMetadata;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierEvent;
import android.view.textclassifier.TextLanguage;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class SystemTextClassifier
implements TextClassifier {
    private static final String LOG_TAG = "androidtc";
    private final ITextClassifierService mManagerService = ITextClassifierService.Stub.asInterface(ServiceManager.getServiceOrThrow("textclassification"));
    private final TextClassificationConstants mSettings;
    private final TextClassifier mFallback;
    private TextClassificationSessionId mSessionId;
    private final SystemTextClassifierMetadata mSystemTcMetadata;

    public SystemTextClassifier(Context context, TextClassificationConstants settings, boolean useDefault) throws ServiceManager.ServiceNotFoundException {
        this.mSettings = Objects.requireNonNull(settings);
        this.mFallback = TextClassifier.NO_OP;
        this.mSystemTcMetadata = new SystemTextClassifierMetadata(Objects.requireNonNull(context.getOpPackageName()), context.getUserId(), useDefault);
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        Objects.requireNonNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            request.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            BlockingCallback callback = new BlockingCallback("textselection", this.mSettings);
            this.mManagerService.onSuggestSelection(this.mSessionId, request, callback);
            TextSelection selection = (TextSelection)callback.get();
            if (selection != null) {
                return selection;
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error suggesting selection for text. Using fallback.", e);
        }
        return this.mFallback.suggestSelection(request);
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        Objects.requireNonNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            request.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            BlockingCallback callback = new BlockingCallback("textclassification", this.mSettings);
            this.mManagerService.onClassifyText(this.mSessionId, request, callback);
            TextClassification classification = (TextClassification)callback.get();
            if (classification != null) {
                return classification;
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error classifying text. Using fallback.", e);
        }
        return this.mFallback.classifyText(request);
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        Objects.requireNonNull(request);
        TextClassifier.Utils.checkMainThread();
        if (!TextClassifier.Utils.checkTextLength(request.getText(), this.getMaxGenerateLinksTextLength())) {
            return this.mFallback.generateLinks(request);
        }
        if (!this.mSettings.isSmartLinkifyEnabled() && request.isLegacyFallback()) {
            return TextClassifier.Utils.generateLegacyLinks(request);
        }
        try {
            request.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            BlockingCallback callback = new BlockingCallback("textlinks", this.mSettings);
            this.mManagerService.onGenerateLinks(this.mSessionId, request, callback);
            TextLinks links = (TextLinks)callback.get();
            if (links != null) {
                return links;
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error generating links. Using fallback.", e);
        }
        return this.mFallback.generateLinks(request);
    }

    @Override
    public void onSelectionEvent(SelectionEvent event) {
        Objects.requireNonNull(event);
        TextClassifier.Utils.checkMainThread();
        try {
            event.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            this.mManagerService.onSelectionEvent(this.mSessionId, event);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error reporting selection event.", e);
        }
    }

    @Override
    public void onTextClassifierEvent(TextClassifierEvent event) {
        Objects.requireNonNull(event);
        TextClassifier.Utils.checkMainThread();
        try {
            TextClassificationContext tcContext = event.getEventContext() == null ? new TextClassificationContext.Builder(this.mSystemTcMetadata.getCallingPackageName(), "unknown").build() : event.getEventContext();
            tcContext.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            event.setEventContext(tcContext);
            this.mManagerService.onTextClassifierEvent(this.mSessionId, event);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error reporting textclassifier event.", e);
        }
    }

    @Override
    public TextLanguage detectLanguage(TextLanguage.Request request) {
        Objects.requireNonNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            request.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            BlockingCallback callback = new BlockingCallback("textlanguage", this.mSettings);
            this.mManagerService.onDetectLanguage(this.mSessionId, request, callback);
            TextLanguage textLanguage = (TextLanguage)callback.get();
            if (textLanguage != null) {
                return textLanguage;
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error detecting language.", e);
        }
        return this.mFallback.detectLanguage(request);
    }

    @Override
    public ConversationActions suggestConversationActions(ConversationActions.Request request) {
        Objects.requireNonNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            request.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            BlockingCallback callback = new BlockingCallback("conversation-actions", this.mSettings);
            this.mManagerService.onSuggestConversationActions(this.mSessionId, request, callback);
            ConversationActions conversationActions = (ConversationActions)callback.get();
            if (conversationActions != null) {
                return conversationActions;
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error reporting selection event.", e);
        }
        return this.mFallback.suggestConversationActions(request);
    }

    @Override
    public int getMaxGenerateLinksTextLength() {
        return this.mSettings.getGenerateLinksMaxTextLength();
    }

    @Override
    public void destroy() {
        try {
            if (this.mSessionId != null) {
                this.mManagerService.onDestroyTextClassificationSession(this.mSessionId);
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error destroying classification session.", e);
        }
    }

    @Override
    public void dump(IndentingPrintWriter printWriter) {
        printWriter.println("SystemTextClassifier:");
        printWriter.increaseIndent();
        printWriter.printPair("mFallback", this.mFallback);
        printWriter.printPair("mSessionId", this.mSessionId);
        printWriter.printPair("mSystemTcMetadata", this.mSystemTcMetadata);
        printWriter.decreaseIndent();
        printWriter.println();
    }

    void initializeRemoteSession(TextClassificationContext classificationContext, TextClassificationSessionId sessionId) {
        this.mSessionId = Objects.requireNonNull(sessionId);
        try {
            classificationContext.setSystemTextClassifierMetadata(this.mSystemTcMetadata);
            this.mManagerService.onCreateTextClassificationSession(classificationContext, this.mSessionId);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Error starting a new classification session.", e);
        }
    }

    private static class BlockingCallback<T extends Parcelable>
    extends ITextClassifierCallback.Stub {
        private final ResponseReceiver<T> mReceiver;

        BlockingCallback(String name, TextClassificationConstants settings) {
            this.mReceiver = new ResponseReceiver(name, settings);
        }

        @Override
        public void onSuccess(Bundle result) {
            this.mReceiver.onSuccess(TextClassifierService.getResponse(result));
        }

        @Override
        public void onFailure() {
            this.mReceiver.onFailure();
        }

        public T get() {
            return (T)((Parcelable)this.mReceiver.get());
        }
    }

    private static class ResponseReceiver<T> {
        private final CountDownLatch mLatch = new CountDownLatch(1);
        private final String mName;
        private final TextClassificationConstants mSettings;
        private T mResponse;

        private ResponseReceiver(String name, TextClassificationConstants settings) {
            this.mName = name;
            this.mSettings = settings;
        }

        public void onSuccess(T response) {
            this.mResponse = response;
            this.mLatch.countDown();
        }

        public void onFailure() {
            Log.e(SystemTextClassifier.LOG_TAG, "Request failed at " + this.mName, null);
            this.mLatch.countDown();
        }

        public T get() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                try {
                    boolean success = this.mLatch.await(this.mSettings.getSystemTextClassifierApiTimeoutInSecond(), TimeUnit.SECONDS);
                    if (!success) {
                        Log.w(SystemTextClassifier.LOG_TAG, "Timeout in ResponseReceiver.get(): " + this.mName);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Log.e(SystemTextClassifier.LOG_TAG, "Interrupted during ResponseReceiver.get(): " + this.mName, e);
                }
            }
            return this.mResponse;
        }
    }
}

