/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.PackageInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.webkit.WebViewProviderInfo;
import android.webkit.WebViewProviderResponse;

public interface IWebViewUpdateService
extends IInterface {
    public void notifyRelroCreationCompleted() throws RemoteException;

    public WebViewProviderResponse waitForAndGetProvider() throws RemoteException;

    public String changeProviderAndSetting(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/webkit/IWebViewUpdateService.aidl:54:1:54:69")
    public WebViewProviderInfo[] getValidWebViewPackages() throws RemoteException;

    public WebViewProviderInfo[] getAllWebViewPackages() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/webkit/IWebViewUpdateService.aidl:65:1:65:69")
    public String getCurrentWebViewPackageName() throws RemoteException;

    public PackageInfo getCurrentWebViewPackage() throws RemoteException;

    public boolean isMultiProcessEnabled() throws RemoteException;

    public void enableMultiProcess(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWebViewUpdateService {
        public static final String DESCRIPTOR = "android.webkit.IWebViewUpdateService";
        static final int TRANSACTION_notifyRelroCreationCompleted = 1;
        static final int TRANSACTION_waitForAndGetProvider = 2;
        static final int TRANSACTION_changeProviderAndSetting = 3;
        static final int TRANSACTION_getValidWebViewPackages = 4;
        static final int TRANSACTION_getAllWebViewPackages = 5;
        static final int TRANSACTION_getCurrentWebViewPackageName = 6;
        static final int TRANSACTION_getCurrentWebViewPackage = 7;
        static final int TRANSACTION_isMultiProcessEnabled = 8;
        static final int TRANSACTION_enableMultiProcess = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWebViewUpdateService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWebViewUpdateService) {
                return (IWebViewUpdateService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifyRelroCreationCompleted";
                }
                case 2: {
                    return "waitForAndGetProvider";
                }
                case 3: {
                    return "changeProviderAndSetting";
                }
                case 4: {
                    return "getValidWebViewPackages";
                }
                case 5: {
                    return "getAllWebViewPackages";
                }
                case 6: {
                    return "getCurrentWebViewPackageName";
                }
                case 7: {
                    return "getCurrentWebViewPackage";
                }
                case 8: {
                    return "isMultiProcessEnabled";
                }
                case 9: {
                    return "enableMultiProcess";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.notifyRelroCreationCompleted();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    WebViewProviderResponse _result = this.waitForAndGetProvider();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.changeProviderAndSetting(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 4: {
                    Parcelable[] _result = this.getValidWebViewPackages();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 5: {
                    Parcelable[] _result = this.getAllWebViewPackages();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 6: {
                    String _result = this.getCurrentWebViewPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 7: {
                    PackageInfo _result = this.getCurrentWebViewPackage();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    boolean _result = this.isMultiProcessEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.enableMultiProcess(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IWebViewUpdateService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRelroCreationCompleted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WebViewProviderResponse waitForAndGetProvider() throws RemoteException {
                WebViewProviderResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WebViewProviderResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String changeProviderAndSetting(String newProvider) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(newProvider);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WebViewProviderInfo[] getValidWebViewPackages() throws RemoteException {
                WebViewProviderInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(WebViewProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WebViewProviderInfo[] getAllWebViewPackages() throws RemoteException {
                WebViewProviderInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(WebViewProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentWebViewPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PackageInfo getCurrentWebViewPackage() throws RemoteException {
                PackageInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PackageInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultiProcessEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableMultiProcess(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWebViewUpdateService {
        @Override
        public void notifyRelroCreationCompleted() throws RemoteException {
        }

        @Override
        public WebViewProviderResponse waitForAndGetProvider() throws RemoteException {
            return null;
        }

        @Override
        public String changeProviderAndSetting(String newProvider) throws RemoteException {
            return null;
        }

        @Override
        public WebViewProviderInfo[] getValidWebViewPackages() throws RemoteException {
            return null;
        }

        @Override
        public WebViewProviderInfo[] getAllWebViewPackages() throws RemoteException {
            return null;
        }

        @Override
        public String getCurrentWebViewPackageName() throws RemoteException {
            return null;
        }

        @Override
        public PackageInfo getCurrentWebViewPackage() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMultiProcessEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void enableMultiProcess(boolean enable) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

