/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.util.ArraySet;
import android.util.Log;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewDelegate;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewLibraryLoader;
import android.webkit.WebViewProviderResponse;
import android.webkit.WebViewZygote;
import java.io.File;
import java.lang.reflect.Method;

@SystemApi
public class WebViewFactory {
    private static final String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProviderForT";
    private static final String CHROMIUM_WEBVIEW_FACTORY_METHOD = "create";
    private static final String LOGTAG = "WebViewFactory";
    private static final boolean DEBUG = false;
    @UnsupportedAppUsage
    private static WebViewFactoryProvider sProviderInstance;
    private static final Object sProviderLock;
    @UnsupportedAppUsage
    private static PackageInfo sPackageInfo;
    private static Boolean sWebViewSupported;
    private static boolean sWebViewDisabled;
    private static String sDataDirectorySuffix;
    public static final int LIBLOAD_SUCCESS = 0;
    public static final int LIBLOAD_WRONG_PACKAGE_NAME = 1;
    public static final int LIBLOAD_ADDRESS_SPACE_NOT_RESERVED = 2;
    public static final int LIBLOAD_FAILED_WAITING_FOR_RELRO = 3;
    public static final int LIBLOAD_FAILED_LISTING_WEBVIEW_PACKAGES = 4;
    public static final int LIBLOAD_FAILED_TO_OPEN_RELRO_FILE = 5;
    public static final int LIBLOAD_FAILED_TO_LOAD_LIBRARY = 6;
    public static final int LIBLOAD_FAILED_JNI_CALL = 7;
    public static final int LIBLOAD_FAILED_WAITING_FOR_WEBVIEW_REASON_UNKNOWN = 8;
    public static final int LIBLOAD_FAILED_TO_FIND_NAMESPACE = 10;
    static final StartupTimestamps sTimestamps;
    private static String WEBVIEW_UPDATE_SERVICE_NAME;

    static StartupTimestamps getStartupTimestamps() {
        return sTimestamps;
    }

    private static String getWebViewPreparationErrorReason(int error) {
        switch (error) {
            case 3: {
                return "Time out waiting for Relro files being created";
            }
            case 4: {
                return "No WebView installed";
            }
            case 8: {
                return "Crashed for unknown reason";
            }
        }
        return "Unknown";
    }

    private static boolean isWebViewSupported() {
        if (sWebViewSupported == null) {
            sWebViewSupported = AppGlobals.getInitialApplication().getPackageManager().hasSystemFeature("android.software.webview");
        }
        return sWebViewSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableWebView() {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                throw new IllegalStateException("Can't disable WebView: WebView already initialized");
            }
            sWebViewDisabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDataDirectorySuffix(String suffix) {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                throw new IllegalStateException("Can't set data directory suffix: WebView already initialized");
            }
            if (suffix.indexOf(File.separatorChar) >= 0) {
                throw new IllegalArgumentException("Suffix " + suffix + " contains a path separator");
            }
            sDataDirectorySuffix = suffix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDataDirectorySuffix() {
        Object object = sProviderLock;
        synchronized (object) {
            return sDataDirectorySuffix;
        }
    }

    public static String getWebViewLibrary(ApplicationInfo ai) {
        if (ai.metaData != null) {
            return ai.metaData.getString("com.android.webview.WebViewLibrary");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageInfo getLoadedPackageInfo() {
        Object object = sProviderLock;
        synchronized (object) {
            return sPackageInfo;
        }
    }

    public static Class<WebViewFactoryProvider> getWebViewProviderClass(ClassLoader clazzLoader) throws ClassNotFoundException {
        return Class.forName(CHROMIUM_WEBVIEW_FACTORY, true, clazzLoader);
    }

    public static int loadWebViewNativeLibraryFromPackage(String packageName, ClassLoader clazzLoader) {
        String libraryFileName;
        if (!WebViewFactory.isWebViewSupported()) {
            return 1;
        }
        WebViewProviderResponse response = null;
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        catch (RemoteException e) {
            Log.e(LOGTAG, "error waiting for relro creation", e);
            return 8;
        }
        if (response.status != 0 && response.status != 3) {
            return response.status;
        }
        if (!response.packageInfo.packageName.equals(packageName)) {
            return 1;
        }
        PackageManager packageManager = AppGlobals.getInitialApplication().getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0x10000080);
            libraryFileName = WebViewFactory.getWebViewLibrary(packageInfo.applicationInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOGTAG, "Couldn't find package " + packageName);
            return 1;
        }
        int loadNativeRet = WebViewLibraryLoader.loadNativeLibrary(clazzLoader, libraryFileName);
        if (loadNativeRet == 0) {
            return response.status;
        }
        return loadNativeRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @UnsupportedAppUsage
    static WebViewFactoryProvider getProvider() {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                return sProviderInstance;
            }
            WebViewFactory.sTimestamps.mWebViewLoadStart = SystemClock.uptimeMillis();
            int uid = Process.myUid();
            if (uid == 0 || uid == 1000 || uid == 1001 || uid == 1027 || uid == 1002) {
                throw new UnsupportedOperationException("For security reasons, WebView is not allowed in privileged processes");
            }
            if (!WebViewFactory.isWebViewSupported()) {
                throw new UnsupportedOperationException();
            }
            if (sWebViewDisabled) {
                throw new IllegalStateException("WebView.disableWebView() was called: WebView is disabled");
            }
            Trace.traceBegin(16L, "WebViewFactory.getProvider()");
            try {
                WebViewFactoryProvider webViewFactoryProvider;
                Class<WebViewFactoryProvider> providerClass = WebViewFactory.getProviderClass();
                Method staticFactory = providerClass.getMethod(CHROMIUM_WEBVIEW_FACTORY_METHOD, WebViewDelegate.class);
                Trace.traceBegin(16L, "WebViewFactoryProvider invocation");
                try {
                    webViewFactoryProvider = sProviderInstance = (WebViewFactoryProvider)staticFactory.invoke(null, new WebViewDelegate());
                }
                catch (Throwable throwable) {
                    try {
                        Trace.traceEnd(16L);
                        throw throwable;
                    }
                    catch (Exception e) {
                        Log.e(LOGTAG, "error instantiating provider", e);
                        throw new AndroidRuntimeException(e);
                    }
                }
                Trace.traceEnd(16L);
                return webViewFactoryProvider;
            }
            finally {
                Trace.traceEnd(16L);
            }
        }
    }

    private static boolean signaturesEquals(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        ArraySet<Signature> set1 = new ArraySet<Signature>();
        for (Signature signature : s1) {
            set1.add(signature);
        }
        ArraySet<Signature> set2 = new ArraySet<Signature>();
        for (Signature signature : s2) {
            set2.add(signature);
        }
        return set1.equals(set2);
    }

    private static void verifyPackageInfo(PackageInfo chosen, PackageInfo toUse) throws MissingWebViewPackageException {
        if (!chosen.packageName.equals(toUse.packageName)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, packageName mismatch, expected: " + chosen.packageName + " actual: " + toUse.packageName);
        }
        if (chosen.getLongVersionCode() > toUse.getLongVersionCode()) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, version code is lower than expected: " + chosen.getLongVersionCode() + " actual: " + toUse.getLongVersionCode());
        }
        if (WebViewFactory.getWebViewLibrary(toUse.applicationInfo) == null) {
            throw new MissingWebViewPackageException("Tried to load an invalid WebView provider: " + toUse.packageName);
        }
        if (!WebViewFactory.signaturesEquals(chosen.signatures, toUse.signatures)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, signature mismatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static Context getWebViewContextAndSetProvider() throws MissingWebViewPackageException {
        Context context;
        Application initialApplication = AppGlobals.getInitialApplication();
        WebViewProviderResponse response = null;
        Trace.traceBegin(16L, "WebViewUpdateService.waitForAndGetProvider()");
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        finally {
            Trace.traceEnd(16L);
        }
        if (response.status != 0 && response.status != 3) {
            throw new MissingWebViewPackageException("Failed to load WebView provider: " + WebViewFactory.getWebViewPreparationErrorReason(response.status));
        }
        Trace.traceBegin(16L, "ActivityManager.addPackageDependency()");
        try {
            ActivityManager.getService().addPackageDependency(response.packageInfo.packageName);
        }
        finally {
            Trace.traceEnd(16L);
        }
        PackageInfo newPackageInfo = null;
        PackageManager pm = initialApplication.getPackageManager();
        Trace.traceBegin(16L, "PackageManager.getPackageInfo()");
        try {
            newPackageInfo = pm.getPackageInfo(response.packageInfo.packageName, 268444864);
        }
        finally {
            Trace.traceEnd(16L);
        }
        WebViewFactory.verifyPackageInfo(response.packageInfo, newPackageInfo);
        ApplicationInfo ai = newPackageInfo.applicationInfo;
        Trace.traceBegin(16L, "initialApplication.createApplicationContext");
        WebViewFactory.sTimestamps.mCreateContextStart = SystemClock.uptimeMillis();
        try {
            Context webViewContext = initialApplication.createApplicationContext(ai, 3);
            sPackageInfo = newPackageInfo;
            context = webViewContext;
        }
        catch (Throwable throwable) {
            try {
                WebViewFactory.sTimestamps.mCreateContextEnd = SystemClock.uptimeMillis();
                Trace.traceEnd(16L);
                throw throwable;
            }
            catch (PackageManager.NameNotFoundException | RemoteException e) {
                throw new MissingWebViewPackageException("Failed to load WebView provider: " + e);
            }
        }
        WebViewFactory.sTimestamps.mCreateContextEnd = SystemClock.uptimeMillis();
        Trace.traceEnd(16L);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static Class<WebViewFactoryProvider> getProviderClass() {
        Context webViewContext = null;
        Application initialApplication = AppGlobals.getInitialApplication();
        try {
            Trace.traceBegin(16L, "WebViewFactory.getWebViewContextAndSetProvider()");
            try {
                webViewContext = WebViewFactory.getWebViewContextAndSetProvider();
            }
            finally {
                Trace.traceEnd(16L);
            }
            Log.i(LOGTAG, "Loading " + WebViewFactory.sPackageInfo.packageName + " version " + WebViewFactory.sPackageInfo.versionName + " (code " + sPackageInfo.getLongVersionCode() + ")");
            Trace.traceBegin(16L, "WebViewFactory.getChromiumProviderClass()");
            try {
                Class<WebViewFactoryProvider> clazz;
                WebViewFactory.sTimestamps.mAddAssetsStart = SystemClock.uptimeMillis();
                for (String newAssetPath : webViewContext.getApplicationInfo().getAllApkPaths()) {
                    initialApplication.getAssets().addAssetPathAsSharedLibrary(newAssetPath);
                }
                WebViewFactory.sTimestamps.mAddAssetsEnd = WebViewFactory.sTimestamps.mGetClassLoaderStart = SystemClock.uptimeMillis();
                ClassLoader clazzLoader = webViewContext.getClassLoader();
                Trace.traceBegin(16L, "WebViewFactory.loadNativeLibrary()");
                WebViewFactory.sTimestamps.mGetClassLoaderEnd = WebViewFactory.sTimestamps.mNativeLoadStart = SystemClock.uptimeMillis();
                WebViewLibraryLoader.loadNativeLibrary(clazzLoader, WebViewFactory.getWebViewLibrary(WebViewFactory.sPackageInfo.applicationInfo));
                Trace.traceEnd(16L);
                Trace.traceBegin(16L, "Class.forName()");
                WebViewFactory.sTimestamps.mNativeLoadEnd = WebViewFactory.sTimestamps.mProviderClassForNameStart = SystemClock.uptimeMillis();
                try {
                    clazz = WebViewFactory.getWebViewProviderClass(clazzLoader);
                }
                catch (Throwable throwable) {
                    try {
                        WebViewFactory.sTimestamps.mProviderClassForNameEnd = SystemClock.uptimeMillis();
                        Trace.traceEnd(16L);
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        Log.e(LOGTAG, "error loading provider", e);
                        throw new AndroidRuntimeException(e);
                    }
                }
                WebViewFactory.sTimestamps.mProviderClassForNameEnd = SystemClock.uptimeMillis();
                Trace.traceEnd(16L);
                return clazz;
            }
            finally {
                Trace.traceEnd(16L);
            }
        }
        catch (MissingWebViewPackageException e) {
            Log.e(LOGTAG, "Chromium WebView package does not exist", e);
            throw new AndroidRuntimeException(e);
        }
    }

    public static void prepareWebViewInZygote() {
        try {
            WebViewLibraryLoader.reserveAddressSpaceInZygote();
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error preparing native loader", t);
        }
    }

    public static int onWebViewProviderChanged(PackageInfo packageInfo) {
        int startedRelroProcesses = 0;
        try {
            startedRelroProcesses = WebViewLibraryLoader.prepareNativeLibraries(packageInfo);
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error preparing webview native library", t);
        }
        WebViewZygote.onWebViewProviderChanged(packageInfo);
        return startedRelroProcesses;
    }

    @UnsupportedAppUsage
    public static IWebViewUpdateService getUpdateService() {
        if (WebViewFactory.isWebViewSupported()) {
            return WebViewFactory.getUpdateServiceUnchecked();
        }
        return null;
    }

    static IWebViewUpdateService getUpdateServiceUnchecked() {
        return IWebViewUpdateService.Stub.asInterface(ServiceManager.getService(WEBVIEW_UPDATE_SERVICE_NAME));
    }

    static {
        sProviderLock = new Object();
        sTimestamps = new StartupTimestamps();
        WEBVIEW_UPDATE_SERVICE_NAME = "webviewupdate";
    }

    public static class StartupTimestamps {
        long mWebViewLoadStart;
        long mCreateContextStart;
        long mCreateContextEnd;
        long mAddAssetsStart;
        long mAddAssetsEnd;
        long mGetClassLoaderStart;
        long mGetClassLoaderEnd;
        long mNativeLoadStart;
        long mNativeLoadEnd;
        long mProviderClassForNameStart;
        long mProviderClassForNameEnd;

        StartupTimestamps() {
        }

        public long getWebViewLoadStart() {
            return this.mWebViewLoadStart;
        }

        public long getCreateContextStart() {
            return this.mCreateContextStart;
        }

        public long getCreateContextEnd() {
            return this.mCreateContextEnd;
        }

        public long getAddAssetsStart() {
            return this.mAddAssetsStart;
        }

        public long getAddAssetsEnd() {
            return this.mAddAssetsEnd;
        }

        public long getGetClassLoaderStart() {
            return this.mGetClassLoaderStart;
        }

        public long getGetClassLoaderEnd() {
            return this.mGetClassLoaderEnd;
        }

        public long getNativeLoadStart() {
            return this.mNativeLoadStart;
        }

        public long getNativeLoadEnd() {
            return this.mNativeLoadEnd;
        }

        public long getProviderClassForNameStart() {
            return this.mProviderClassForNameStart;
        }

        public long getProviderClassForNameEnd() {
            return this.mProviderClassForNameEnd;
        }
    }

    static class MissingWebViewPackageException
    extends Exception {
        public MissingWebViewPackageException(String message) {
            super(message);
        }

        public MissingWebViewPackageException(Exception e) {
            super(e);
        }
    }
}

