/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.SpanUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.TextView;
import com.android.internal.R;

public class EditText
extends TextView {
    private boolean mStyleShortcutsEnabled = false;
    private static final int ID_BOLD = 16908379;
    private static final int ID_ITALIC = 16908380;
    private static final int ID_UNDERLINE = 16908381;

    public EditText(Context context) {
        this(context, null);
    }

    public EditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public EditText(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public EditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.EditText, defStyleAttr, defStyleRes);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    this.mStyleShortcutsEnabled = a.getBoolean(attr2, false);
                }
            }
        }
    }

    @Override
    public boolean getFreezesText() {
        return true;
    }

    @Override
    protected boolean getDefaultEditable() {
        return true;
    }

    @Override
    protected MovementMethod getDefaultMovementMethod() {
        return ArrowKeyMovementMethod.getInstance();
    }

    @Override
    public Editable getText() {
        CharSequence text = super.getText();
        if (text == null) {
            return null;
        }
        if (text instanceof Editable) {
            return (Editable)text;
        }
        super.setText(text, TextView.BufferType.EDITABLE);
        return (Editable)super.getText();
    }

    @Override
    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, TextView.BufferType.EDITABLE);
    }

    public void setSelection(int start, int stop) {
        Selection.setSelection(this.getText(), start, stop);
    }

    public void setSelection(int index) {
        Selection.setSelection(this.getText(), index);
    }

    public void selectAll() {
        Selection.selectAll(this.getText());
    }

    public void extendSelection(int index) {
        Selection.extendSelection(this.getText(), index);
    }

    @Override
    public void setEllipsize(TextUtils.TruncateAt ellipsis) {
        if (ellipsis == TextUtils.TruncateAt.MARQUEE) {
            throw new IllegalArgumentException("EditText cannot use the ellipsize mode TextUtils.TruncateAt.MARQUEE");
        }
        super.setEllipsize(ellipsis);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return EditText.class.getName();
    }

    @Override
    protected boolean supportsAutoSizeText() {
        return false;
    }

    @Override
    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        if (event.hasModifiers(4096)) {
            switch (keyCode) {
                case 30: {
                    if (!this.mStyleShortcutsEnabled || !this.hasSelection()) break;
                    return this.onTextContextMenuItem(16908379);
                }
                case 37: {
                    if (!this.mStyleShortcutsEnabled || !this.hasSelection()) break;
                    return this.onTextContextMenuItem(16908380);
                }
                case 49: {
                    if (!this.mStyleShortcutsEnabled || !this.hasSelection()) break;
                    return this.onTextContextMenuItem(16908381);
                }
            }
        }
        return super.onKeyShortcut(keyCode, event);
    }

    @Override
    public boolean onTextContextMenuItem(int id2) {
        if (id2 == 16908379 || id2 == 16908380 || id2 == 16908381) {
            return this.performStylingAction(id2);
        }
        return super.onTextContextMenuItem(id2);
    }

    private boolean performStylingAction(int actionId) {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (selectionStart < 0 || selectionEnd < 0) {
            return false;
        }
        int min = Math.min(selectionStart, selectionEnd);
        int max = Math.max(selectionStart, selectionEnd);
        Editable spannable = this.getText();
        if (actionId == 16908379) {
            return SpanUtils.toggleBold(spannable, min, max);
        }
        if (actionId == 16908380) {
            return SpanUtils.toggleItalic(spannable, min, max);
        }
        if (actionId == 16908381) {
            return SpanUtils.toggleUnderline(spannable, min, max);
        }
        return false;
    }

    public void setStyleShortcutsEnabled(boolean enabled) {
        this.mStyleShortcutsEnabled = enabled;
    }

    public boolean isStyleShortcutEnabled() {
        return this.mStyleShortcutsEnabled;
    }
}

