/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BLASTBufferQueue;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.HardwareRenderer;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.SurfaceView;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewRootImpl;
import android.widget.Magnifier_Delegate;
import com.android.internal.R;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class Magnifier {
    private static final String TAG = "Magnifier";
    private static final int NONEXISTENT_PREVIOUS_CONFIG_VALUE = -1;
    private static final HandlerThread sPixelCopyHandlerThread = new HandlerThread("magnifier pixel copy result handler");
    private static final float FISHEYE_RAMP_WIDTH = 12.0f;
    private final View mView;
    private final int[] mViewCoordinatesInSurface;
    private InternalPopupWindow mWindow;
    private final int mWindowWidth;
    private int mWindowHeight;
    private float mZoom;
    private int mSourceWidth;
    private int mSourceHeight;
    private boolean mDirtyState;
    private final float mWindowElevation;
    private final float mWindowCornerRadius;
    private final Drawable mOverlay;
    private final int mDefaultHorizontalSourceToMagnifierOffset;
    private final int mDefaultVerticalSourceToMagnifierOffset;
    private final boolean mClippingEnabled;
    private int mLeftContentBound;
    private int mTopContentBound;
    private int mRightContentBound;
    private int mBottomContentBound;
    private SurfaceInfo mParentSurface;
    private SurfaceInfo mContentCopySurface;
    private final Point mWindowCoords = new Point();
    private final Point mClampedCenterZoomCoords = new Point();
    private final Point mPrevStartCoordsInSurface = new Point(-1, -1);
    private final PointF mPrevShowSourceCoords = new PointF(-1.0f, -1.0f);
    private final PointF mPrevShowWindowCoords = new PointF(-1.0f, -1.0f);
    private final Rect mPixelCopyRequestRect = new Rect();
    private final Object mLock = new Object();
    private boolean mIsFishEyeStyle;
    private int mLeftCutWidth = 0;
    private int mRightCutWidth = 0;
    private final int mRamp;
    private Drawable mCursorDrawable;
    private boolean mDrawCursorEnabled;
    public static final int SOURCE_BOUND_MAX_IN_SURFACE = 0;
    public static final int SOURCE_BOUND_MAX_VISIBLE = 1;
    private Callback mCallback;

    @Deprecated
    public Magnifier(View view) {
        this(Magnifier.createBuilderWithOldMagnifierDefaults(view));
    }

    static Builder createBuilderWithOldMagnifierDefaults(View view) {
        Builder params = new Builder(view);
        Context context = view.getContext();
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Magnifier, 17957000, 0);
        params.mWidth = a.getDimensionPixelSize(5, 0);
        params.mHeight = a.getDimensionPixelSize(2, 0);
        params.mElevation = a.getDimension(1, 0.0f);
        params.mCornerRadius = Magnifier.getDeviceDefaultDialogCornerRadius(context);
        params.mZoom = a.getFloat(6, 0.0f);
        params.mHorizontalDefaultSourceToMagnifierOffset = a.getDimensionPixelSize(3, 0);
        params.mVerticalDefaultSourceToMagnifierOffset = a.getDimensionPixelSize(4, 0);
        params.mOverlay = new ColorDrawable(a.getColor(0, 0));
        a.recycle();
        params.mClippingEnabled = true;
        params.mLeftContentBound = 1;
        params.mTopContentBound = 0;
        params.mRightContentBound = 1;
        params.mBottomContentBound = 0;
        return params;
    }

    private static float getDeviceDefaultDialogCornerRadius(Context context) {
        ContextThemeWrapper deviceDefaultContext = new ContextThemeWrapper(context, 16974120);
        TypedArray ta = deviceDefaultContext.obtainStyledAttributes(new int[]{16844145});
        float dialogCornerRadius = ta.getDimension(0, 0.0f);
        ta.recycle();
        return dialogCornerRadius;
    }

    private Magnifier(Builder params) {
        this.mView = params.mView;
        this.mWindowWidth = params.mWidth;
        this.mWindowHeight = params.mHeight;
        this.mZoom = params.mZoom;
        this.mIsFishEyeStyle = params.mIsFishEyeStyle;
        if (params.mSourceWidth > 0 && params.mSourceHeight > 0) {
            this.mSourceWidth = params.mSourceWidth;
            this.mSourceHeight = params.mSourceHeight;
        } else {
            this.mSourceWidth = Math.round((float)this.mWindowWidth / this.mZoom);
            this.mSourceHeight = Math.round((float)this.mWindowHeight / this.mZoom);
        }
        this.mWindowElevation = params.mElevation;
        this.mWindowCornerRadius = params.mCornerRadius;
        this.mOverlay = params.mOverlay;
        this.mDefaultHorizontalSourceToMagnifierOffset = params.mHorizontalDefaultSourceToMagnifierOffset;
        this.mDefaultVerticalSourceToMagnifierOffset = params.mVerticalDefaultSourceToMagnifierOffset;
        this.mClippingEnabled = params.mClippingEnabled;
        this.mLeftContentBound = params.mLeftContentBound;
        this.mTopContentBound = params.mTopContentBound;
        this.mRightContentBound = params.mRightContentBound;
        this.mBottomContentBound = params.mBottomContentBound;
        this.mViewCoordinatesInSurface = new int[2];
        this.mRamp = (int)TypedValue.applyDimension(1, 12.0f, this.mView.getContext().getResources().getDisplayMetrics());
    }

    public void show_Original(float sourceCenterX, float sourceCenterY) {
        this.show(sourceCenterX, sourceCenterY, sourceCenterX + (float)this.mDefaultHorizontalSourceToMagnifierOffset, sourceCenterY + (float)this.mDefaultVerticalSourceToMagnifierOffset);
    }

    @LayoutlibDelegate
    public void show(float f, float f2) {
        Magnifier_Delegate.show(this, f, f2);
    }

    void setDrawCursor(boolean enabled, Drawable cursorDrawable) {
        this.mDrawCursorEnabled = enabled;
        this.mCursorDrawable = cursorDrawable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show_Original(float sourceCenterX, float sourceCenterY, float magnifierCenterX, float magnifierCenterY) {
        this.obtainSurfaces();
        this.obtainContentCoordinates(sourceCenterX, sourceCenterY);
        int startX = this.mClampedCenterZoomCoords.x - this.mSourceWidth / 2;
        int startY = this.mClampedCenterZoomCoords.y - this.mSourceHeight / 2;
        if (this.mIsFishEyeStyle) {
            magnifierCenterX = this.mClampedCenterZoomCoords.x - this.mViewCoordinatesInSurface[0];
            magnifierCenterY = this.mClampedCenterZoomCoords.y - this.mViewCoordinatesInSurface[1];
            float rampPre = ((float)this.mSourceWidth - (float)(this.mSourceWidth - 2 * this.mRamp) / this.mZoom) / 2.0f;
            float leftEdge = 0.0f;
            float x0 = sourceCenterX - (float)this.mSourceWidth / 2.0f;
            float rampX0 = x0 + (float)this.mRamp;
            if (leftEdge > rampX0) {
                leftEdge = sourceCenterX - (sourceCenterX - leftEdge) / this.mZoom;
            } else if (leftEdge > x0) {
                leftEdge = x0 + rampPre - (rampX0 - leftEdge) * rampPre / (float)this.mRamp;
            }
            int leftBound = Math.min((int)leftEdge, this.mView.getWidth());
            float x1 = sourceCenterX + (float)this.mSourceWidth / 2.0f;
            float rampX1 = x1 - (float)this.mRamp;
            float rightEdge = this.mView.getWidth();
            if (rightEdge < rampX1) {
                rightEdge = sourceCenterX + (rightEdge - sourceCenterX) / this.mZoom;
            } else if (rightEdge < x1) {
                rightEdge = x1 - rampPre + (rightEdge - rampX1) * rampPre / (float)this.mRamp;
            }
            int rightBound = Math.max(leftBound, (int)rightEdge);
            leftBound = Math.max(leftBound + this.mViewCoordinatesInSurface[0], 0);
            rightBound = Math.min(rightBound + this.mViewCoordinatesInSurface[0], this.mContentCopySurface.mWidth);
            this.mLeftCutWidth = Math.max(0, leftBound - startX);
            this.mRightCutWidth = Math.max(0, startX + this.mSourceWidth - rightBound);
            startX = Math.max(startX, leftBound);
        }
        this.obtainWindowCoordinates(magnifierCenterX, magnifierCenterY);
        if (sourceCenterX != this.mPrevShowSourceCoords.x || sourceCenterY != this.mPrevShowSourceCoords.y || this.mDirtyState) {
            if (this.mWindow == null) {
                Object rampPre = this.mLock;
                synchronized (rampPre) {
                    this.mWindow = new InternalPopupWindow(this.mView.getContext(), this.mView.getDisplay(), this.mParentSurface.mSurfaceControl, this.mWindowWidth, this.mWindowHeight, this.mZoom, this.mRamp, this.mWindowElevation, this.mWindowCornerRadius, this.mOverlay != null ? this.mOverlay : new ColorDrawable(0), Handler.getMain(), this.mLock, this.mCallback, this.mIsFishEyeStyle);
                }
            }
            this.performPixelCopy(startX, startY, true);
        } else if (magnifierCenterX != this.mPrevShowWindowCoords.x || magnifierCenterY != this.mPrevShowWindowCoords.y) {
            Point windowCoords = this.getCurrentClampedWindowCoordinates();
            InternalPopupWindow currentWindowInstance = this.mWindow;
            sPixelCopyHandlerThread.getThreadHandler().post(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mWindow != currentWindowInstance) {
                        return;
                    }
                    this.mWindow.setContentPositionForNextDraw(windowCoords.x, windowCoords.y);
                }
            });
        }
        this.mPrevShowSourceCoords.x = sourceCenterX;
        this.mPrevShowSourceCoords.y = sourceCenterY;
        this.mPrevShowWindowCoords.x = magnifierCenterX;
        this.mPrevShowWindowCoords.y = magnifierCenterY;
    }

    @LayoutlibDelegate
    public void show(float f, float f2, float f3, float f4) {
        Magnifier_Delegate.show(this, f, f2, f3, f4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss() {
        if (this.mWindow != null) {
            Object object = this.mLock;
            synchronized (object) {
                this.mWindow.destroy();
                this.mWindow = null;
            }
            this.mPrevShowSourceCoords.x = -1.0f;
            this.mPrevShowSourceCoords.y = -1.0f;
            this.mPrevShowWindowCoords.x = -1.0f;
            this.mPrevShowWindowCoords.y = -1.0f;
            this.mPrevStartCoordsInSurface.x = -1;
            this.mPrevStartCoordsInSurface.y = -1;
        }
    }

    public void update() {
        if (this.mWindow != null) {
            this.obtainSurfaces();
            if (!this.mDirtyState) {
                this.performPixelCopy(this.mPrevStartCoordsInSurface.x, this.mPrevStartCoordsInSurface.y, false);
            } else {
                this.show(this.mPrevShowSourceCoords.x, this.mPrevShowSourceCoords.y, this.mPrevShowWindowCoords.x, this.mPrevShowWindowCoords.y);
            }
        }
    }

    public int getWidth() {
        return this.mWindowWidth;
    }

    public int getHeight() {
        return this.mWindowHeight;
    }

    public int getSourceWidth() {
        return this.mSourceWidth;
    }

    public int getSourceHeight() {
        return this.mSourceHeight;
    }

    public void setZoom(float zoom) {
        Preconditions.checkArgumentPositive(zoom, "Zoom should be positive");
        this.mZoom = zoom;
        this.mSourceWidth = this.mIsFishEyeStyle ? this.mWindowWidth : Math.round((float)this.mWindowWidth / this.mZoom);
        this.mSourceHeight = Math.round((float)this.mWindowHeight / this.mZoom);
        this.mDirtyState = true;
    }

    void updateSourceFactors(int sourceHeight, float zoom) {
        this.mZoom = zoom;
        this.mSourceHeight = sourceHeight;
        this.mWindowHeight = (int)((float)sourceHeight * zoom);
        if (this.mWindow != null) {
            this.mWindow.updateContentFactors(this.mWindowHeight, zoom);
        }
    }

    public float getZoom() {
        return this.mZoom;
    }

    public float getElevation() {
        return this.mWindowElevation;
    }

    public float getCornerRadius() {
        return this.mWindowCornerRadius;
    }

    public int getDefaultHorizontalSourceToMagnifierOffset() {
        return this.mDefaultHorizontalSourceToMagnifierOffset;
    }

    public int getDefaultVerticalSourceToMagnifierOffset() {
        return this.mDefaultVerticalSourceToMagnifierOffset;
    }

    public Drawable getOverlay() {
        return this.mOverlay;
    }

    public boolean isClippingEnabled() {
        return this.mClippingEnabled;
    }

    public Point getPosition() {
        if (this.mWindow == null) {
            return null;
        }
        Point position = this.getCurrentClampedWindowCoordinates();
        position.offset(-this.mParentSurface.mInsets.left, -this.mParentSurface.mInsets.top);
        return new Point(position);
    }

    public Point getSourcePosition() {
        if (this.mWindow == null) {
            return null;
        }
        Point position = new Point(this.mPixelCopyRequestRect.left, this.mPixelCopyRequestRect.top);
        position.offset(-this.mContentCopySurface.mInsets.left, -this.mContentCopySurface.mInsets.top);
        return new Point(position);
    }

    private void obtainSurfaces() {
        SurfaceInfo validMainWindowSurface = SurfaceInfo.NULL;
        if (this.mView.getViewRootImpl() != null) {
            ViewRootImpl viewRootImpl = this.mView.getViewRootImpl();
            Surface mainWindowSurface = viewRootImpl.mSurface;
            if (mainWindowSurface != null && mainWindowSurface.isValid()) {
                Rect surfaceInsets = viewRootImpl.mWindowAttributes.surfaceInsets;
                int surfaceWidth = viewRootImpl.getWidth() + surfaceInsets.left + surfaceInsets.right;
                int surfaceHeight = viewRootImpl.getHeight() + surfaceInsets.top + surfaceInsets.bottom;
                validMainWindowSurface = new SurfaceInfo(viewRootImpl.getSurfaceControl(), mainWindowSurface, surfaceWidth, surfaceHeight, surfaceInsets, true);
            }
        }
        SurfaceInfo validSurfaceViewSurface = SurfaceInfo.NULL;
        if (this.mView instanceof SurfaceView) {
            SurfaceControl sc = ((SurfaceView)this.mView).getSurfaceControl();
            SurfaceHolder surfaceHolder = ((SurfaceView)this.mView).getHolder();
            Surface surfaceViewSurface = surfaceHolder.getSurface();
            if (sc != null && sc.isValid()) {
                Rect surfaceFrame = surfaceHolder.getSurfaceFrame();
                validSurfaceViewSurface = new SurfaceInfo(sc, surfaceViewSurface, surfaceFrame.right, surfaceFrame.bottom, new Rect(), false);
            }
        }
        this.mParentSurface = validMainWindowSurface != SurfaceInfo.NULL ? validMainWindowSurface : validSurfaceViewSurface;
        this.mContentCopySurface = this.mView instanceof SurfaceView ? validSurfaceViewSurface : validMainWindowSurface;
    }

    private void obtainContentCoordinates(float xPosInView, float yPosInView) {
        Rect surfaceBounds;
        int zoomCenterY;
        int zoomCenterX;
        int prevViewXInSurface = this.mViewCoordinatesInSurface[0];
        int prevViewYInSurface = this.mViewCoordinatesInSurface[1];
        this.mView.getLocationInSurface(this.mViewCoordinatesInSurface);
        if (this.mViewCoordinatesInSurface[0] != prevViewXInSurface || this.mViewCoordinatesInSurface[1] != prevViewYInSurface) {
            this.mDirtyState = true;
        }
        if (this.mView instanceof SurfaceView) {
            zoomCenterX = Math.round(xPosInView);
            zoomCenterY = Math.round(yPosInView);
        } else {
            zoomCenterX = Math.round(xPosInView + (float)this.mViewCoordinatesInSurface[0]);
            zoomCenterY = Math.round(yPosInView + (float)this.mViewCoordinatesInSurface[1]);
        }
        Rect[] bounds = new Rect[2];
        bounds[0] = surfaceBounds = new Rect(0, 0, this.mContentCopySurface.mWidth, this.mContentCopySurface.mHeight);
        Rect viewVisibleRegion = new Rect();
        this.mView.getGlobalVisibleRect(viewVisibleRegion);
        if (this.mView.getViewRootImpl() != null) {
            Rect surfaceInsets = this.mView.getViewRootImpl().mWindowAttributes.surfaceInsets;
            viewVisibleRegion.offset(surfaceInsets.left, surfaceInsets.top);
        }
        if (this.mView instanceof SurfaceView) {
            viewVisibleRegion.offset(-this.mViewCoordinatesInSurface[0], -this.mViewCoordinatesInSurface[1]);
        }
        bounds[1] = viewVisibleRegion;
        int resolvedLeft = Integer.MIN_VALUE;
        for (int i = this.mLeftContentBound; i >= 0; --i) {
            resolvedLeft = Math.max(resolvedLeft, bounds[i].left);
        }
        int resolvedTop = Integer.MIN_VALUE;
        for (int i = this.mTopContentBound; i >= 0; --i) {
            resolvedTop = Math.max(resolvedTop, bounds[i].top);
        }
        int resolvedRight = Integer.MAX_VALUE;
        for (int i = this.mRightContentBound; i >= 0; --i) {
            resolvedRight = Math.min(resolvedRight, bounds[i].right);
        }
        int resolvedBottom = Integer.MAX_VALUE;
        for (int i = this.mBottomContentBound; i >= 0; --i) {
            resolvedBottom = Math.min(resolvedBottom, bounds[i].bottom);
        }
        resolvedLeft = Math.min(resolvedLeft, this.mContentCopySurface.mWidth - this.mSourceWidth);
        resolvedTop = Math.min(resolvedTop, this.mContentCopySurface.mHeight - this.mSourceHeight);
        if (resolvedLeft < 0 || resolvedTop < 0) {
            Log.e(TAG, "Magnifier's content is copied from a surface smaller thanthe content requested size. The magnifier will be dismissed.");
        }
        resolvedRight = Math.max(resolvedRight, resolvedLeft + this.mSourceWidth);
        resolvedBottom = Math.max(resolvedBottom, resolvedTop + this.mSourceHeight);
        this.mClampedCenterZoomCoords.x = this.mIsFishEyeStyle ? Math.max(resolvedLeft, Math.min(zoomCenterX, resolvedRight)) : Math.max(resolvedLeft + this.mSourceWidth / 2, Math.min(zoomCenterX, resolvedRight - this.mSourceWidth / 2));
        this.mClampedCenterZoomCoords.y = Math.max(resolvedTop + this.mSourceHeight / 2, Math.min(zoomCenterY, resolvedBottom - this.mSourceHeight / 2));
    }

    private void obtainWindowCoordinates(float xWindowPos, float yWindowPos) {
        int windowCenterY;
        int windowCenterX;
        if (this.mView instanceof SurfaceView) {
            windowCenterX = Math.round(xWindowPos);
            windowCenterY = Math.round(yWindowPos);
        } else {
            windowCenterX = Math.round(xWindowPos + (float)this.mViewCoordinatesInSurface[0]);
            windowCenterY = Math.round(yWindowPos + (float)this.mViewCoordinatesInSurface[1]);
        }
        this.mWindowCoords.x = windowCenterX - this.mWindowWidth / 2;
        this.mWindowCoords.y = windowCenterY - this.mWindowHeight / 2;
        if (this.mParentSurface != this.mContentCopySurface) {
            this.mWindowCoords.x += this.mViewCoordinatesInSurface[0];
            this.mWindowCoords.y += this.mViewCoordinatesInSurface[1];
        }
    }

    private void maybeDrawCursor(Canvas canvas) {
        if (this.mDrawCursorEnabled) {
            if (this.mCursorDrawable != null) {
                this.mCursorDrawable.setBounds(this.mSourceWidth / 2, 0, this.mSourceWidth / 2 + this.mCursorDrawable.getIntrinsicWidth(), this.mSourceHeight);
                this.mCursorDrawable.draw(canvas);
            } else {
                Paint paint = new Paint();
                paint.setColor(-16777216);
                canvas.drawRect(new Rect(this.mSourceWidth / 2 - 1, 0, this.mSourceWidth / 2 + 1, this.mSourceHeight), paint);
            }
        }
    }

    private void performPixelCopy(int startXInSurface, int startYInSurface, boolean updateWindowPosition) {
        if (this.mContentCopySurface.mSurface == null || !this.mContentCopySurface.mSurface.isValid()) {
            this.onPixelCopyFailed();
            return;
        }
        Point windowCoords = this.getCurrentClampedWindowCoordinates();
        this.mPixelCopyRequestRect.set(startXInSurface, startYInSurface, startXInSurface + this.mSourceWidth - this.mLeftCutWidth - this.mRightCutWidth, startYInSurface + this.mSourceHeight);
        this.mPrevStartCoordsInSurface.x = startXInSurface;
        this.mPrevStartCoordsInSurface.y = startYInSurface;
        this.mDirtyState = false;
        InternalPopupWindow currentWindowInstance = this.mWindow;
        if (this.mPixelCopyRequestRect.width() == 0) {
            this.mWindow.updateContent(Bitmap.createBitmap(this.mSourceWidth, this.mSourceHeight, Bitmap.Config.ALPHA_8));
            return;
        }
        Bitmap bitmap = Bitmap.createBitmap(this.mSourceWidth - this.mLeftCutWidth - this.mRightCutWidth, this.mSourceHeight, Bitmap.Config.ARGB_8888);
        PixelCopy.request(this.mContentCopySurface.mSurface, this.mPixelCopyRequestRect, bitmap, result -> {
            if (result != 0) {
                this.onPixelCopyFailed();
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.mWindow != currentWindowInstance) {
                    return;
                }
                if (updateWindowPosition) {
                    this.mWindow.setContentPositionForNextDraw(windowCoords.x, windowCoords.y);
                }
                if (bitmap.getWidth() < this.mSourceWidth) {
                    Bitmap newBitmap = Bitmap.createBitmap(this.mSourceWidth, bitmap.getHeight(), bitmap.getConfig());
                    Canvas can = new Canvas(newBitmap);
                    Rect dstRect = new Rect(this.mLeftCutWidth, 0, this.mSourceWidth - this.mRightCutWidth, bitmap.getHeight());
                    can.drawBitmap(bitmap, null, dstRect, null);
                    this.maybeDrawCursor(can);
                    this.mWindow.updateContent(newBitmap);
                } else {
                    this.maybeDrawCursor(new Canvas(bitmap));
                    this.mWindow.updateContent(bitmap);
                }
            }
        }, sPixelCopyHandlerThread.getThreadHandler());
    }

    private void onPixelCopyFailed() {
        Log.e(TAG, "Magnifier failed to copy content from the view Surface. It will be dismissed.");
        Handler.getMain().postAtFrontOfQueue(() -> {
            this.dismiss();
            if (this.mCallback != null) {
                this.mCallback.onOperationComplete();
            }
        });
    }

    private Point getCurrentClampedWindowCoordinates() {
        Rect windowBounds;
        if (!this.mClippingEnabled) {
            return new Point(this.mWindowCoords);
        }
        if (this.mParentSurface.mIsMainWindowSurface) {
            Insets systemInsets = this.mView.getRootWindowInsets().getSystemWindowInsets();
            windowBounds = new Rect(systemInsets.left + this.mParentSurface.mInsets.left, systemInsets.top + this.mParentSurface.mInsets.top, this.mParentSurface.mWidth - systemInsets.right - this.mParentSurface.mInsets.right, this.mParentSurface.mHeight - systemInsets.bottom - this.mParentSurface.mInsets.bottom);
        } else {
            windowBounds = new Rect(0, 0, this.mParentSurface.mWidth, this.mParentSurface.mHeight);
        }
        int windowCoordsX = Math.max(windowBounds.left, Math.min(windowBounds.right - this.mWindowWidth, this.mWindowCoords.x));
        int windowCoordsY = Math.max(windowBounds.top, Math.min(windowBounds.bottom - this.mWindowHeight, this.mWindowCoords.y));
        return new Point(windowCoordsX, windowCoordsY);
    }

    public void setOnOperationCompleteCallback(Callback callback) {
        this.mCallback = callback;
        if (this.mWindow != null) {
            this.mWindow.mCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getContent() {
        if (this.mWindow == null) {
            return null;
        }
        Object object = this.mWindow.mLock;
        synchronized (object) {
            return this.mWindow.mCurrentContent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getOriginalContent() {
        if (this.mWindow == null) {
            return null;
        }
        Object object = this.mWindow.mLock;
        synchronized (object) {
            return Bitmap.createBitmap(this.mWindow.mBitmap);
        }
    }

    public static PointF getMagnifierDefaultSize() {
        Resources resources = Resources.getSystem();
        float density = resources.getDisplayMetrics().density;
        PointF size = new PointF();
        size.x = resources.getDimension(17105190) / density;
        size.y = resources.getDimension(17105187) / density;
        return size;
    }

    static {
        sPixelCopyHandlerThread.start();
    }

    public static class Builder {
        private View mView;
        private int mWidth;
        private int mHeight;
        private float mZoom;
        private float mElevation;
        private float mCornerRadius;
        private Drawable mOverlay;
        private int mHorizontalDefaultSourceToMagnifierOffset;
        private int mVerticalDefaultSourceToMagnifierOffset;
        private boolean mClippingEnabled;
        private int mLeftContentBound;
        private int mTopContentBound;
        private int mRightContentBound;
        private int mBottomContentBound;
        private boolean mIsFishEyeStyle;
        private int mSourceWidth;
        private int mSourceHeight;

        public Builder(View view) {
            this.mView = Objects.requireNonNull(view);
            this.applyDefaults();
        }

        private void applyDefaults() {
            Resources resources = this.mView.getContext().getResources();
            this.mWidth = resources.getDimensionPixelSize(17105190);
            this.mHeight = resources.getDimensionPixelSize(17105187);
            this.mElevation = resources.getDimension(17105186);
            this.mCornerRadius = resources.getDimension(17105185);
            this.mZoom = resources.getFloat(17105191);
            this.mHorizontalDefaultSourceToMagnifierOffset = resources.getDimensionPixelSize(17105188);
            this.mVerticalDefaultSourceToMagnifierOffset = resources.getDimensionPixelSize(17105189);
            this.mOverlay = new ColorDrawable(resources.getColor(17170944, null));
            this.mClippingEnabled = true;
            this.mLeftContentBound = 1;
            this.mTopContentBound = 1;
            this.mRightContentBound = 1;
            this.mBottomContentBound = 1;
            this.mIsFishEyeStyle = false;
        }

        public Builder setSize(int width, int height) {
            Preconditions.checkArgumentPositive(width, "Width should be positive");
            Preconditions.checkArgumentPositive(height, "Height should be positive");
            this.mWidth = width;
            this.mHeight = height;
            return this;
        }

        public Builder setInitialZoom(float zoom) {
            Preconditions.checkArgumentPositive(zoom, "Zoom should be positive");
            this.mZoom = zoom;
            return this;
        }

        public Builder setElevation(float elevation) {
            Preconditions.checkArgumentNonNegative(elevation, "Elevation should be non-negative");
            this.mElevation = elevation;
            return this;
        }

        public Builder setCornerRadius(float cornerRadius) {
            Preconditions.checkArgumentNonNegative(cornerRadius, "Corner radius should be non-negative");
            this.mCornerRadius = cornerRadius;
            return this;
        }

        public Builder setOverlay(Drawable overlay) {
            this.mOverlay = overlay;
            return this;
        }

        public Builder setDefaultSourceToMagnifierOffset(int horizontalOffset, int verticalOffset) {
            this.mHorizontalDefaultSourceToMagnifierOffset = horizontalOffset;
            this.mVerticalDefaultSourceToMagnifierOffset = verticalOffset;
            return this;
        }

        public Builder setClippingEnabled(boolean clip) {
            this.mClippingEnabled = clip;
            return this;
        }

        public Builder setSourceBounds(int left, int top, int right, int bottom) {
            this.mLeftContentBound = left;
            this.mTopContentBound = top;
            this.mRightContentBound = right;
            this.mBottomContentBound = bottom;
            return this;
        }

        Builder setSourceSize(int width, int height) {
            this.mSourceWidth = width;
            this.mSourceHeight = height;
            return this;
        }

        Builder setFishEyeStyle() {
            this.mIsFishEyeStyle = true;
            return this;
        }

        public Magnifier build() {
            return new Magnifier(this);
        }
    }

    private static class SurfaceInfo {
        public static final SurfaceInfo NULL = new SurfaceInfo(null, null, 0, 0, null, false);
        private Surface mSurface;
        private SurfaceControl mSurfaceControl;
        private int mWidth;
        private int mHeight;
        private Rect mInsets;
        private boolean mIsMainWindowSurface;

        SurfaceInfo(SurfaceControl surfaceControl, Surface surface, int width, int height, Rect insets, boolean isMainWindowSurface) {
            this.mSurfaceControl = surfaceControl;
            this.mSurface = surface;
            this.mWidth = width;
            this.mHeight = height;
            this.mInsets = insets;
            this.mIsMainWindowSurface = isMainWindowSurface;
        }
    }

    private static class InternalPopupWindow {
        private static final int SURFACE_Z = 5;
        private final Display mDisplay;
        private final int mContentWidth;
        private int mContentHeight;
        private final int mOffsetX;
        private final int mOffsetY;
        private final Drawable mOverlay;
        private final SurfaceSession mSurfaceSession;
        private final SurfaceControl mSurfaceControl;
        private final SurfaceControl mBbqSurfaceControl;
        private final BLASTBufferQueue mBBQ;
        private final SurfaceControl.Transaction mTransaction = new SurfaceControl.Transaction();
        private final Surface mSurface;
        private final ThreadedRenderer.SimpleRenderer mRenderer;
        private final RenderNode mBitmapRenderNode;
        private final RenderNode mOverlayRenderNode;
        private final Runnable mMagnifierUpdater;
        private final Handler mHandler;
        private Callback mCallback;
        private final Object mLock;
        private boolean mFrameDrawScheduled;
        private Bitmap mBitmap;
        private boolean mFirstDraw = true;
        private int mWindowPositionX;
        private int mWindowPositionY;
        private boolean mPendingWindowPositionUpdate;
        private Bitmap mCurrentContent;
        private float mZoom;
        private final int mRamp;
        private boolean mIsFishEyeStyle;
        private float[] mMeshLeft;
        private float[] mMeshRight;
        private int mMeshWidth;
        private int mMeshHeight;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InternalPopupWindow(Context context, Display display, SurfaceControl parentSurfaceControl, int width, int height, float zoom, int ramp, float elevation, float cornerRadius, Drawable overlay, Handler handler, Object lock, Callback callback, boolean isFishEyeStyle) {
            this.mDisplay = display;
            this.mOverlay = overlay;
            this.mLock = lock;
            this.mCallback = callback;
            this.mContentWidth = width;
            this.mContentHeight = height;
            this.mZoom = zoom;
            this.mRamp = ramp;
            this.mOffsetX = (int)(1.05f * elevation);
            this.mOffsetY = (int)(1.05f * elevation);
            int surfaceWidth = this.mContentWidth + 2 * this.mOffsetX;
            int surfaceHeight = this.mContentHeight + 2 * this.mOffsetY;
            this.mSurfaceSession = new SurfaceSession();
            this.mSurfaceControl = new SurfaceControl.Builder(this.mSurfaceSession).setName("magnifier surface").setFlags(4).setContainerLayer().setParent(parentSurfaceControl).setCallsite("InternalPopupWindow").build();
            this.mBbqSurfaceControl = new SurfaceControl.Builder(this.mSurfaceSession).setName("magnifier surface bbq wrapper").setHidden(false).setBLASTLayer().setParent(this.mSurfaceControl).setCallsite("InternalPopupWindow").build();
            this.mBBQ = new BLASTBufferQueue("magnifier surface", this.mBbqSurfaceControl, surfaceWidth, surfaceHeight, -3);
            this.mSurface = this.mBBQ.createSurface();
            this.mRenderer = new ThreadedRenderer.SimpleRenderer(context, "magnifier renderer", this.mSurface);
            this.mBitmapRenderNode = this.createRenderNodeForBitmap("magnifier content", elevation, cornerRadius);
            this.mOverlayRenderNode = this.createRenderNodeForOverlay("magnifier overlay", cornerRadius);
            this.setupOverlay();
            RecordingCanvas canvas = this.mRenderer.getRootNode().beginRecording(width, height);
            try {
                canvas.enableZ();
                canvas.drawRenderNode(this.mBitmapRenderNode);
                canvas.disableZ();
                canvas.drawRenderNode(this.mOverlayRenderNode);
                canvas.disableZ();
            }
            finally {
                this.mRenderer.getRootNode().endRecording();
            }
            if (this.mCallback != null) {
                this.mCurrentContent = Bitmap.createBitmap(this.mContentWidth, this.mContentHeight, Bitmap.Config.ARGB_8888);
                this.updateCurrentContentForTesting();
            }
            this.mHandler = handler;
            this.mMagnifierUpdater = this::doDraw;
            this.mFrameDrawScheduled = false;
            this.mIsFishEyeStyle = isFishEyeStyle;
            if (this.mIsFishEyeStyle) {
                this.createMeshMatrixForFishEyeEffect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateContentFactors(int contentHeight, float zoom) {
            if (this.mContentHeight == contentHeight && this.mZoom == zoom) {
                return;
            }
            if (this.mContentHeight < contentHeight) {
                this.mBBQ.update(this.mBbqSurfaceControl, this.mContentWidth, contentHeight, -3);
                this.mRenderer.setSurface(this.mSurface);
                Outline outline = new Outline();
                outline.setRoundRect(0, 0, this.mContentWidth, contentHeight, 0.0f);
                outline.setAlpha(1.0f);
                this.mBitmapRenderNode.setLeftTopRightBottom(this.mOffsetX, this.mOffsetY, this.mOffsetX + this.mContentWidth, this.mOffsetY + contentHeight);
                this.mBitmapRenderNode.setOutline(outline);
                this.mOverlayRenderNode.setLeftTopRightBottom(this.mOffsetX, this.mOffsetY, this.mOffsetX + this.mContentWidth, this.mOffsetY + contentHeight);
                this.mOverlayRenderNode.setOutline(outline);
                RecordingCanvas canvas = this.mRenderer.getRootNode().beginRecording(this.mContentWidth, contentHeight);
                try {
                    canvas.enableZ();
                    canvas.drawRenderNode(this.mBitmapRenderNode);
                    canvas.disableZ();
                    canvas.drawRenderNode(this.mOverlayRenderNode);
                    canvas.disableZ();
                }
                finally {
                    this.mRenderer.getRootNode().endRecording();
                }
            }
            this.mContentHeight = contentHeight;
            this.mZoom = zoom;
            this.fillMeshMatrix();
        }

        private void createMeshMatrixForFishEyeEffect() {
            this.mMeshWidth = 1;
            this.mMeshHeight = 6;
            this.mMeshLeft = new float[2 * (this.mMeshWidth + 1) * (this.mMeshHeight + 1)];
            this.mMeshRight = new float[2 * (this.mMeshWidth + 1) * (this.mMeshHeight + 1)];
            this.fillMeshMatrix();
        }

        private void fillMeshMatrix() {
            this.mMeshWidth = 1;
            this.mMeshHeight = 6;
            float w = this.mContentWidth;
            float h = this.mContentHeight;
            float h0 = h / this.mZoom;
            float dh = h - h0;
            for (int i = 0; i < 2 * (this.mMeshWidth + 1) * (this.mMeshHeight + 1); i += 2) {
                int colIndex = i % (2 * (this.mMeshWidth + 1)) / 2;
                this.mMeshLeft[i] = (float)colIndex * (float)this.mRamp / (float)this.mMeshWidth;
                this.mMeshRight[i] = w - (float)this.mRamp + (float)(colIndex * this.mRamp / this.mMeshWidth);
                int rowIndex = i / 2 / (this.mMeshWidth + 1);
                float hl = h0 + dh * (float)colIndex / (float)this.mMeshWidth;
                float yl = (h - hl) / 2.0f;
                this.mMeshLeft[i + 1] = yl + hl * (float)rowIndex / (float)this.mMeshHeight;
                float hr = h - dh * (float)colIndex / (float)this.mMeshWidth;
                float yr = (h - hr) / 2.0f;
                this.mMeshRight[i + 1] = yr + hr * (float)rowIndex / (float)this.mMeshHeight;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RenderNode createRenderNodeForBitmap(String name, float elevation, float cornerRadius) {
            RenderNode bitmapRenderNode = RenderNode.create(name, null);
            bitmapRenderNode.setLeftTopRightBottom(this.mOffsetX, this.mOffsetY, this.mOffsetX + this.mContentWidth, this.mOffsetY + this.mContentHeight);
            bitmapRenderNode.setElevation(elevation);
            Outline outline = new Outline();
            outline.setRoundRect(0, 0, this.mContentWidth, this.mContentHeight, cornerRadius);
            outline.setAlpha(1.0f);
            bitmapRenderNode.setOutline(outline);
            bitmapRenderNode.setClipToOutline(true);
            RecordingCanvas canvas = bitmapRenderNode.beginRecording(this.mContentWidth, this.mContentHeight);
            try {
                canvas.drawColor(-16711936);
            }
            finally {
                bitmapRenderNode.endRecording();
            }
            return bitmapRenderNode;
        }

        private RenderNode createRenderNodeForOverlay(String name, float cornerRadius) {
            RenderNode overlayRenderNode = RenderNode.create(name, null);
            overlayRenderNode.setLeftTopRightBottom(this.mOffsetX, this.mOffsetY, this.mOffsetX + this.mContentWidth, this.mOffsetY + this.mContentHeight);
            Outline outline = new Outline();
            outline.setRoundRect(0, 0, this.mContentWidth, this.mContentHeight, cornerRadius);
            outline.setAlpha(1.0f);
            overlayRenderNode.setOutline(outline);
            overlayRenderNode.setClipToOutline(true);
            return overlayRenderNode;
        }

        private void setupOverlay() {
            this.drawOverlay();
            this.mOverlay.setCallback(new Drawable.Callback(){

                @Override
                public void invalidateDrawable(Drawable who) {
                    this.drawOverlay();
                    if (mCallback != null) {
                        this.updateCurrentContentForTesting();
                    }
                }

                @Override
                public void scheduleDrawable(Drawable who, Runnable what, long when) {
                    Handler.getMain().postAtTime(what, who, when);
                }

                @Override
                public void unscheduleDrawable(Drawable who, Runnable what) {
                    Handler.getMain().removeCallbacks(what, who);
                }
            });
        }

        private void drawOverlay() {
            RecordingCanvas canvas = this.mOverlayRenderNode.beginRecording(this.mContentWidth, this.mContentHeight);
            try {
                this.mOverlay.setBounds(0, 0, this.mContentWidth, this.mContentHeight);
                this.mOverlay.draw(canvas);
            }
            finally {
                this.mOverlayRenderNode.endRecording();
            }
        }

        public void setContentPositionForNextDraw(int contentX, int contentY) {
            this.mWindowPositionX = contentX - this.mOffsetX;
            this.mWindowPositionY = contentY - this.mOffsetY;
            this.mPendingWindowPositionUpdate = true;
            this.requestUpdate();
        }

        public void updateContent(Bitmap bitmap) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
            }
            this.mBitmap = bitmap;
            this.requestUpdate();
        }

        private void requestUpdate() {
            if (this.mFrameDrawScheduled) {
                return;
            }
            Message request = Message.obtain(this.mHandler, this.mMagnifierUpdater);
            request.setAsynchronous(true);
            request.sendToTarget();
            this.mFrameDrawScheduled = true;
        }

        public void destroy() {
            this.mRenderer.destroy();
            this.mSurface.destroy();
            this.mBBQ.destroy();
            new SurfaceControl.Transaction().remove(this.mSurfaceControl).remove(this.mBbqSurfaceControl).apply();
            this.mSurfaceSession.kill();
            this.mHandler.removeCallbacks(this.mMagnifierUpdater);
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
            }
            this.mOverlay.setCallback(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDraw() {
            HardwareRenderer.FrameDrawingCallback callback;
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mSurface.isValid()) {
                    return;
                }
                RecordingCanvas canvas = this.mBitmapRenderNode.beginRecording(this.mContentWidth, this.mContentHeight);
                try {
                    int w = this.mBitmap.getWidth();
                    int h = this.mBitmap.getHeight();
                    Paint paint = new Paint();
                    paint.setFilterBitmap(true);
                    if (this.mIsFishEyeStyle) {
                        int margin = (int)(((float)this.mContentWidth - (float)(this.mContentWidth - 2 * this.mRamp) / this.mZoom) / 2.0f);
                        Rect srcRect = new Rect(margin, 0, w - margin, h);
                        Rect dstRect = new Rect(this.mRamp, 0, this.mContentWidth - this.mRamp, this.mContentHeight);
                        canvas.drawBitmap(this.mBitmap, srcRect, dstRect, paint);
                        canvas.drawBitmapMesh(Bitmap.createBitmap(this.mBitmap, 0, 0, margin, h), this.mMeshWidth, this.mMeshHeight, this.mMeshLeft, 0, null, 0, paint);
                        canvas.drawBitmapMesh(Bitmap.createBitmap(this.mBitmap, w - margin, 0, margin, h), this.mMeshWidth, this.mMeshHeight, this.mMeshRight, 0, null, 0, paint);
                    } else {
                        Rect srcRect = new Rect(0, 0, w, h);
                        Rect dstRect = new Rect(0, 0, this.mContentWidth, this.mContentHeight);
                        canvas.drawBitmap(this.mBitmap, srcRect, dstRect, paint);
                    }
                }
                finally {
                    this.mBitmapRenderNode.endRecording();
                }
                if (this.mPendingWindowPositionUpdate || this.mFirstDraw) {
                    boolean firstDraw = this.mFirstDraw;
                    this.mFirstDraw = false;
                    boolean updateWindowPosition = this.mPendingWindowPositionUpdate;
                    this.mPendingWindowPositionUpdate = false;
                    int pendingX = this.mWindowPositionX;
                    int pendingY = this.mWindowPositionY;
                    callback = frame -> {
                        if (!this.mSurface.isValid()) {
                            return;
                        }
                        if (updateWindowPosition) {
                            this.mTransaction.setPosition(this.mSurfaceControl, pendingX, pendingY);
                        }
                        if (firstDraw) {
                            this.mTransaction.setLayer(this.mSurfaceControl, 5).show(this.mSurfaceControl);
                        }
                        this.mBBQ.mergeWithNextTransaction(this.mTransaction, frame);
                    };
                    if (!this.mIsFishEyeStyle) {
                        this.mRenderer.setLightCenter(this.mDisplay, pendingX, pendingY);
                    }
                } else {
                    callback = null;
                }
                this.mFrameDrawScheduled = false;
            }
            this.mRenderer.draw(callback);
            if (this.mCallback != null) {
                this.updateCurrentContentForTesting();
                this.mCallback.onOperationComplete();
            }
        }

        private void updateCurrentContentForTesting() {
            Canvas canvas = new Canvas(this.mCurrentContent);
            Rect bounds = new Rect(0, 0, this.mContentWidth, this.mContentHeight);
            if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
                Rect originalBounds = new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                canvas.drawBitmap(this.mBitmap, originalBounds, bounds, null);
            }
            this.mOverlay.setBounds(bounds);
            this.mOverlay.draw(canvas);
        }
    }

    public static interface Callback {
        public void onOperationComplete();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceBound {
    }
}

