/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.UndoManager;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.FontScaleConverterFactory;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.BaseCanvas;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.text.LineBreakConfig;
import android.icu.text.DecimalFormatSymbols;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ParcelableParcel;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.BoringLayout;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphemeClusterSegmentFinder;
import android.text.GraphicsOperations;
import android.text.Highlights;
import android.text.InputFilter;
import android.text.Layout;
import android.text.NoCopySpan;
import android.text.ParcelableSpan;
import android.text.PrecomputedText;
import android.text.SegmentFinder;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.WordSegmentFinder;
import android.text.method.AllCapsTransformationMethod;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.BaseKeyListener;
import android.text.method.DateKeyListener;
import android.text.method.DateTimeKeyListener;
import android.text.method.DialerKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.LinkMovementMethod;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.OffsetMapping;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TextKeyListener;
import android.text.method.TimeKeyListener;
import android.text.method.TransformationMethod;
import android.text.method.TransformationMethod2;
import android.text.method.WordIterator;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ParagraphStyle;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.text.style.URLSpan;
import android.text.style.UpdateAppearance;
import android.text.util.Linkify;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.FeatureFlagUtils;
import android.util.IntArray;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.AccessibilityIterators;
import android.view.ActionMode;
import android.view.Choreographer;
import android.view.ContentInfo;
import android.view.ContextMenu;
import android.view.DragEvent;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.view.contentcapture.ContentCaptureManager;
import android.view.contentcapture.ContentCaptureSession;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.DeleteGesture;
import android.view.inputmethod.DeleteRangeGesture;
import android.view.inputmethod.EditorBoundsInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InsertGesture;
import android.view.inputmethod.InsertModeGesture;
import android.view.inputmethod.JoinOrSplitGesture;
import android.view.inputmethod.PreviewableHandwritingGesture;
import android.view.inputmethod.RemoveSpaceGesture;
import android.view.inputmethod.SelectGesture;
import android.view.inputmethod.SelectRangeGesture;
import android.view.inputmethod.TextAppearanceInfo;
import android.view.inputmethod.TextBoundsInfo;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textservice.SpellCheckerSubtype;
import android.view.textservice.TextServicesManager;
import android.view.translation.TranslationRequestValue;
import android.view.translation.UiTranslationController;
import android.view.translation.ViewTranslationCallback;
import android.view.translation.ViewTranslationRequest;
import android.widget.AccessibilityIterators;
import android.widget.Editor;
import android.widget.RemoteViews;
import android.widget.Scroller;
import android.widget.SpellChecker;
import android.widget.TextViewTranslationCallback;
import android.widget.Toast;
import com.android.internal.R;
import com.android.internal.accessibility.util.AccessibilityUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.inputmethod.EditableInputConnection;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastMath;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParserException;

@RemoteViews.RemoteView
public class TextView
extends View
implements ViewTreeObserver.OnPreDrawListener {
    static final String LOG_TAG = "TextView";
    static final boolean DEBUG_EXTRACT = false;
    static final boolean DEBUG_CURSOR = false;
    private static final float[] TEMP_POSITION = new float[2];
    private static final int DEFAULT_TYPEFACE = -1;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private static final int ELLIPSIZE_NOT_SET = -1;
    private static final int ELLIPSIZE_NONE = 0;
    private static final int ELLIPSIZE_START = 1;
    private static final int ELLIPSIZE_MIDDLE = 2;
    private static final int ELLIPSIZE_END = 3;
    private static final int ELLIPSIZE_MARQUEE = 4;
    private static final int SIGNED = 2;
    private static final int DECIMAL = 4;
    private static final int MARQUEE_FADE_NORMAL = 0;
    private static final int MARQUEE_FADE_SWITCH_SHOW_ELLIPSIS = 1;
    private static final int MARQUEE_FADE_SWITCH_SHOW_FADE = 2;
    @UnsupportedAppUsage
    private static final int LINES = 1;
    private static final int EMS = 1;
    private static final int PIXELS = 2;
    private static final int MAX_LENGTH_FOR_SINGLE_LINE_EDIT_TEXT = 5000;
    private InputFilter.LengthFilter mSingleLineLengthFilter = null;
    private static final RectF TEMP_RECTF = new RectF();
    static final int VERY_WIDE = 0x100000;
    private static final int ANIMATED_SCROLL_GAP = 250;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private static final Spanned EMPTY_SPANNED = new SpannedString("");
    private static final int CHANGE_WATCHER_PRIORITY = 100;
    private static final int OFFSET_MAPPING_SPAN_PRIORITY = 200;
    private static final int[] MULTILINE_STATE_SET = new int[]{16843597};
    private static final int ACCESSIBILITY_ACTION_SHARE = 0x10000000;
    static final int ACCESSIBILITY_ACTION_PROCESS_TEXT_START_ID = 0x10000100;
    static final int ACCESSIBILITY_ACTION_SMART_START_ID = 0x10001000;
    public static final int PROCESS_TEXT_REQUEST_CODE = 100;
    private static final int KEY_EVENT_NOT_HANDLED = 0;
    private static final int KEY_EVENT_HANDLED = -1;
    private static final int KEY_DOWN_HANDLED_BY_KEY_LISTENER = 1;
    private static final int KEY_DOWN_HANDLED_BY_MOVEMENT_METHOD = 2;
    private static final int FLOATING_TOOLBAR_SELECT_ALL_REFRESH_DELAY = 500;
    private static final int DEFAULT_LINE_BREAK_STYLE = 0;
    private static final int DEFAULT_LINE_BREAK_WORD_STYLE = 0;
    public static final long BORINGLAYOUT_FALLBACK_LINESPACING = 210923482L;
    public static final long STATICLAYOUT_FALLBACK_LINESPACING = 37756858L;
    static long sLastCutCopyOrTextChangedTime;
    private ColorStateList mTextColor;
    private ColorStateList mHintTextColor;
    private ColorStateList mLinkTextColor;
    @ViewDebug.ExportedProperty(category="text")
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mCurTextColor;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mCurHintTextColor;
    private boolean mFreezesText;
    @UnsupportedAppUsage
    private Editable.Factory mEditableFactory = Editable.Factory.getInstance();
    @UnsupportedAppUsage
    private Spannable.Factory mSpannableFactory = Spannable.Factory.getInstance();
    @UnsupportedAppUsage
    private float mShadowRadius;
    @UnsupportedAppUsage
    private float mShadowDx;
    @UnsupportedAppUsage
    private float mShadowDy;
    private int mShadowColor;
    private boolean mPreDrawRegistered;
    private boolean mPreDrawListenerDetached;
    private TextClassifier mTextClassifier;
    private TextClassifier mTextClassificationSession;
    private TextClassificationContext mTextClassificationContext;
    private boolean mPreventDefaultMovement;
    private TextUtils.TruncateAt mEllipsize;
    private boolean mImeIsConsumingInput;
    private boolean mCursorVisibleFromAttr = true;
    @UnsupportedAppUsage
    Drawables mDrawables;
    @UnsupportedAppUsage
    private CharWrapper mCharWrapper;
    @UnsupportedAppUsage(trackingBug=124050217L)
    private Marquee mMarquee;
    @UnsupportedAppUsage
    private boolean mRestartMarquee;
    private int mMarqueeRepeatLimit = 3;
    private int mLastLayoutDirection = -1;
    @UnsupportedAppUsage
    private int mMarqueeFadeMode = 0;
    @UnsupportedAppUsage
    private Layout mSavedMarqueeModeLayout;
    @ViewDebug.ExportedProperty(category="text")
    @UnsupportedAppUsage
    private CharSequence mText;
    private Spannable mSpannable;
    private PrecomputedText mPrecomputed;
    @UnsupportedAppUsage
    private CharSequence mTransformed;
    @UnsupportedAppUsage
    private BufferType mBufferType = BufferType.NORMAL;
    private CharSequence mHint;
    @UnsupportedAppUsage
    private Layout mHintLayout;
    private boolean mHideHint;
    private MovementMethod mMovement;
    private TransformationMethod mTransformation;
    @UnsupportedAppUsage
    private boolean mAllowTransformationLengthChange;
    @UnsupportedAppUsage
    private ChangeWatcher mChangeWatcher;
    @UnsupportedAppUsage(trackingBug=123769451L)
    private ArrayList<TextWatcher> mListeners;
    @UnsupportedAppUsage
    private final TextPaint mTextPaint;
    @UnsupportedAppUsage
    private boolean mUserSetTextScaleX;
    @UnsupportedAppUsage
    private Layout mLayout;
    private boolean mLocalesChanged = false;
    private int mTextSizeUnit = -1;
    private int mLineBreakStyle = 0;
    private int mLineBreakWordStyle = 0;
    private boolean mUserSpeficiedLineBreakwordStyle = false;
    private int mFontWeightAdjustment;
    private Typeface mOriginalTypeface;
    private boolean mListenerChanged = false;
    private final boolean mUseInternationalizedInput;
    private static final int FALLBACK_LINE_SPACING_NONE = 0;
    private static final int FALLBACK_LINE_SPACING_STATIC_LAYOUT_ONLY = 1;
    private static final int FALLBACK_LINE_SPACING_ALL = 2;
    private int mUseFallbackLineSpacing;
    private final boolean mUseTextPaddingForUiTranslation;
    @ViewDebug.ExportedProperty(category="text")
    @UnsupportedAppUsage
    private int mGravity = 0x800033;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private boolean mHorizontallyScrolling;
    private int mAutoLinkMask;
    private boolean mLinksClickable = true;
    @UnsupportedAppUsage
    private float mSpacingMult = 1.0f;
    @UnsupportedAppUsage
    private float mSpacingAdd = 0.0f;
    private int mLineHeightComplexDimen;
    private int mBreakStrategy;
    private int mHyphenationFrequency;
    private int mJustificationMode;
    @UnsupportedAppUsage
    private int mMaximum = Integer.MAX_VALUE;
    @UnsupportedAppUsage
    private int mMaxMode = 1;
    @UnsupportedAppUsage
    private int mMinimum = 0;
    @UnsupportedAppUsage
    private int mMinMode = 1;
    @UnsupportedAppUsage
    private int mOldMaximum = this.mMaximum;
    @UnsupportedAppUsage
    private int mOldMaxMode = this.mMaxMode;
    @UnsupportedAppUsage
    private int mMaxWidth = Integer.MAX_VALUE;
    @UnsupportedAppUsage
    private int mMaxWidthMode = 2;
    @UnsupportedAppUsage
    private int mMinWidth = 0;
    @UnsupportedAppUsage
    private int mMinWidthMode = 2;
    @UnsupportedAppUsage
    private boolean mSingleLine;
    @UnsupportedAppUsage
    private int mDesiredHeightAtMeasure = -1;
    @UnsupportedAppUsage
    private boolean mIncludePad = true;
    private int mDeferScroll = -1;
    private Rect mTempRect;
    private long mLastScroll;
    private Scroller mScroller;
    private TextPaint mTempTextPaint;
    private Object mTempCursor;
    @UnsupportedAppUsage
    private BoringLayout.Metrics mBoring;
    @UnsupportedAppUsage
    private BoringLayout.Metrics mHintBoring;
    @UnsupportedAppUsage
    private BoringLayout mSavedLayout;
    @UnsupportedAppUsage
    private BoringLayout mSavedHintLayout;
    @UnsupportedAppUsage
    private TextDirectionHeuristic mTextDir;
    private InputFilter[] mFilters = NO_FILTERS;
    private UserHandle mTextOperationUser;
    private volatile Locale mCurrentSpellCheckerLocaleCache;
    @UnsupportedAppUsage
    int mHighlightColor = 1714664933;
    private Path mHighlightPath;
    @UnsupportedAppUsage
    private final Paint mHighlightPaint;
    @UnsupportedAppUsage
    private boolean mHighlightPathBogus = true;
    private List<Path> mHighlightPaths;
    private List<Paint> mHighlightPaints;
    private Highlights mHighlights;
    private int[] mSearchResultHighlights = null;
    private Paint mSearchResultHighlightPaint = null;
    private Paint mFocusedSearchResultHighlightPaint = null;
    private int mFocusedSearchResultHighlightColor = -27086;
    private int mSearchResultHighlightColor = -256;
    private int mFocusedSearchResultIndex = -1;
    private int mGesturePreviewHighlightStart = -1;
    private int mGesturePreviewHighlightEnd = -1;
    private Paint mGesturePreviewHighlightPaint;
    private final List<Path> mPathRecyclePool = new ArrayList<Path>();
    private boolean mHighlightPathsBogus = true;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int mCursorDrawableRes;
    private Drawable mCursorDrawable;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int mTextSelectHandleLeftRes;
    private Drawable mTextSelectHandleLeft;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int mTextSelectHandleRightRes;
    private Drawable mTextSelectHandleRight;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int mTextSelectHandleRes;
    private Drawable mTextSelectHandle;
    int mTextEditSuggestionItemLayout;
    int mTextEditSuggestionContainerLayout;
    int mTextEditSuggestionHighlightStyle;
    private static final int NO_POINTER_ID = -1;
    private int mPrimePointerId = -1;
    private boolean mIsPrimePointerFromHandleView;
    @UnsupportedAppUsage
    private Editor mEditor;
    private static final int DEVICE_PROVISIONED_UNKNOWN = 0;
    private static final int DEVICE_PROVISIONED_NO = 1;
    private static final int DEVICE_PROVISIONED_YES = 2;
    private int mDeviceProvisionedState = 0;
    private int mLastInputSource = 4098;
    public static final int AUTO_SIZE_TEXT_TYPE_NONE = 0;
    public static final int AUTO_SIZE_TEXT_TYPE_UNIFORM = 1;
    private static final int DEFAULT_AUTO_SIZE_MIN_TEXT_SIZE_IN_SP = 12;
    private static final int DEFAULT_AUTO_SIZE_MAX_TEXT_SIZE_IN_SP = 112;
    private static final int DEFAULT_AUTO_SIZE_GRANULARITY_IN_PX = 1;
    private static final float UNSET_AUTO_SIZE_UNIFORM_CONFIGURATION_VALUE = -1.0f;
    private int mAutoSizeTextType = 0;
    private boolean mNeedsAutoSizeText = false;
    private float mAutoSizeStepGranularityInPx = -1.0f;
    private float mAutoSizeMinTextSizeInPx = -1.0f;
    private float mAutoSizeMaxTextSizeInPx = -1.0f;
    private int[] mAutoSizeTextSizesInPx = EmptyArray.INT;
    private boolean mHasPresetAutoSizeValues = false;
    private boolean mTextSetFromXmlOrResourceId = false;
    private int mTextId = 0;
    private int mHintId = 0;
    private Pattern mWhitespacePattern;
    private static final SparseIntArray sAppearanceValues;
    public static final int FOCUSED_SEARCH_RESULT_INDEX_NONE = -1;
    @VisibleForTesting
    public static final BoringLayout.Metrics UNKNOWN_BORING;
    static final int ID_SELECT_ALL = 16908319;
    static final int ID_UNDO = 16908338;
    static final int ID_REDO = 16908339;
    static final int ID_CUT = 0x1020020;
    static final int ID_COPY = 0x1020021;
    static final int ID_PASTE = 0x1020022;
    static final int ID_SHARE = 16908341;
    static final int ID_PASTE_AS_PLAIN_TEXT = 16908337;
    static final int ID_REPLACE = 16908340;
    static final int ID_ASSIST = 16908353;
    static final int ID_AUTOFILL = 16908355;

    public static void preloadFontCache() {
    }

    public TextView(Context context) {
        this(context, null);
    }

    public TextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public TextView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public TextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        boolean isMonospaceEnforced;
        if (this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(1);
        }
        if (this.getImportantForContentCapture() == 0) {
            this.setImportantForContentCapture(1);
        }
        this.setTextInternal("");
        Resources res = this.getResources();
        CompatibilityInfo compat = res.getCompatibilityInfo();
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(compat.applicationScale);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setCompatibilityScaling(compat.applicationScale);
        this.mMovement = this.getDefaultMovementMethod();
        this.mTransformation = null;
        TextAppearanceAttributes attributes = new TextAppearanceAttributes();
        attributes.mTextColor = ColorStateList.valueOf(-16777216);
        attributes.mTextSize = 15;
        this.mBreakStrategy = 0;
        this.mHyphenationFrequency = 0;
        this.mJustificationMode = 0;
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.TextViewAppearance, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.TextViewAppearance, attrs, a, defStyleAttr, defStyleRes);
        TypedArray appearance = null;
        int ap = a.getResourceId(0, -1);
        a.recycle();
        if (ap != -1) {
            appearance = theme.obtainStyledAttributes(ap, R.styleable.TextAppearance);
            this.saveAttributeDataForStyleable(context, R.styleable.TextAppearance, null, appearance, 0, ap);
        }
        if (appearance != null) {
            this.readTextAppearance(context, appearance, attributes, false);
            attributes.mFontFamilyExplicit = false;
            appearance.recycle();
        }
        boolean editable = this.getDefaultEditable();
        CharSequence inputMethod = null;
        int numeric = 0;
        CharSequence digits = null;
        boolean phone = false;
        boolean autotext = false;
        int autocap = -1;
        int buffertype = 0;
        boolean selectallonfocus = false;
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        Drawable drawableStart = null;
        Drawable drawableEnd = null;
        ColorStateList drawableTint = null;
        BlendMode drawableTintMode = null;
        int drawablePadding = 0;
        int ellipsize = -1;
        boolean singleLine = false;
        int maxlength = -1;
        CharSequence text = "";
        CharSequence hint = null;
        boolean password = false;
        float autoSizeMinTextSizeInPx = -1.0f;
        float autoSizeMaxTextSizeInPx = -1.0f;
        float autoSizeStepGranularityInPx = -1.0f;
        int inputType = 0;
        a = theme.obtainStyledAttributes(attrs, R.styleable.TextView, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.TextView, attrs, a, defStyleAttr, defStyleRes);
        int firstBaselineToTopHeight = -1;
        int lastBaselineToBottomHeight = -1;
        float lineHeight = -1.0f;
        int lineHeightUnit = -1;
        this.readTextAppearance(context, a, attributes, true);
        int n = a.getIndexCount();
        boolean textIsSetFromXml = false;
        block109: for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 46: {
                    editable = a.getBoolean(attr2, editable);
                    continue block109;
                }
                case 43: {
                    inputMethod = a.getText(attr2);
                    continue block109;
                }
                case 40: {
                    numeric = a.getInt(attr2, numeric);
                    continue block109;
                }
                case 41: {
                    digits = a.getText(attr2);
                    continue block109;
                }
                case 42: {
                    phone = a.getBoolean(attr2, phone);
                    continue block109;
                }
                case 45: {
                    autotext = a.getBoolean(attr2, autotext);
                    continue block109;
                }
                case 44: {
                    autocap = a.getInt(attr2, autocap);
                    continue block109;
                }
                case 17: {
                    buffertype = a.getInt(attr2, buffertype);
                    continue block109;
                }
                case 33: {
                    selectallonfocus = a.getBoolean(attr2, selectallonfocus);
                    continue block109;
                }
                case 11: {
                    this.mAutoLinkMask = a.getInt(attr2, 0);
                    continue block109;
                }
                case 12: {
                    this.mLinksClickable = a.getBoolean(attr2, true);
                    continue block109;
                }
                case 50: {
                    drawableLeft = a.getDrawable(attr2);
                    continue block109;
                }
                case 48: {
                    drawableTop = a.getDrawable(attr2);
                    continue block109;
                }
                case 51: {
                    drawableRight = a.getDrawable(attr2);
                    continue block109;
                }
                case 49: {
                    drawableBottom = a.getDrawable(attr2);
                    continue block109;
                }
                case 73: {
                    drawableStart = a.getDrawable(attr2);
                    continue block109;
                }
                case 74: {
                    drawableEnd = a.getDrawable(attr2);
                    continue block109;
                }
                case 79: {
                    drawableTint = a.getColorStateList(attr2);
                    continue block109;
                }
                case 80: {
                    drawableTintMode = Drawable.parseBlendMode(a.getInt(attr2, -1), drawableTintMode);
                    continue block109;
                }
                case 52: {
                    drawablePadding = a.getDimensionPixelSize(attr2, drawablePadding);
                    continue block109;
                }
                case 22: {
                    this.setMaxLines(a.getInt(attr2, -1));
                    continue block109;
                }
                case 14: {
                    this.setMaxHeight(a.getDimensionPixelSize(attr2, -1));
                    continue block109;
                }
                case 23: {
                    this.setLines(a.getInt(attr2, -1));
                    continue block109;
                }
                case 24: {
                    this.setHeight(a.getDimensionPixelSize(attr2, -1));
                    continue block109;
                }
                case 25: {
                    this.setMinLines(a.getInt(attr2, -1));
                    continue block109;
                }
                case 16: {
                    this.setMinHeight(a.getDimensionPixelSize(attr2, -1));
                    continue block109;
                }
                case 26: {
                    this.setMaxEms(a.getInt(attr2, -1));
                    continue block109;
                }
                case 13: {
                    this.setMaxWidth(a.getDimensionPixelSize(attr2, -1));
                    continue block109;
                }
                case 27: {
                    this.setEms(a.getInt(attr2, -1));
                    continue block109;
                }
                case 28: {
                    this.setWidth(a.getDimensionPixelSize(attr2, -1));
                    continue block109;
                }
                case 29: {
                    this.setMinEms(a.getInt(attr2, -1));
                    continue block109;
                }
                case 15: {
                    this.setMinWidth(a.getDimensionPixelSize(attr2, -1));
                    continue block109;
                }
                case 10: {
                    this.setGravity(a.getInt(attr2, -1));
                    continue block109;
                }
                case 19: {
                    this.mHintId = a.getResourceId(attr2, 0);
                    hint = a.getText(attr2);
                    continue block109;
                }
                case 18: {
                    textIsSetFromXml = true;
                    this.mTextId = a.getResourceId(attr2, 0);
                    text = a.getText(attr2);
                    continue block109;
                }
                case 30: {
                    if (!a.getBoolean(attr2, false)) continue block109;
                    this.setHorizontallyScrolling(true);
                    continue block109;
                }
                case 32: {
                    singleLine = a.getBoolean(attr2, singleLine);
                    continue block109;
                }
                case 9: {
                    ellipsize = a.getInt(attr2, ellipsize);
                    continue block109;
                }
                case 55: {
                    this.setMarqueeRepeatLimit(a.getInt(attr2, this.mMarqueeRepeatLimit));
                    continue block109;
                }
                case 34: {
                    if (a.getBoolean(attr2, true)) continue block109;
                    this.setIncludeFontPadding(false);
                    continue block109;
                }
                case 21: {
                    if (a.getBoolean(attr2, true)) continue block109;
                    this.setCursorVisible(false);
                    continue block109;
                }
                case 35: {
                    maxlength = a.getInt(attr2, -1);
                    continue block109;
                }
                case 20: {
                    this.setTextScaleX(a.getFloat(attr2, 1.0f));
                    continue block109;
                }
                case 47: {
                    this.mFreezesText = a.getBoolean(attr2, false);
                    continue block109;
                }
                case 0: {
                    this.setEnabled(a.getBoolean(attr2, this.isEnabled()));
                    continue block109;
                }
                case 31: {
                    password = a.getBoolean(attr2, password);
                    continue block109;
                }
                case 53: {
                    this.mSpacingAdd = a.getDimensionPixelSize(attr2, (int)this.mSpacingAdd);
                    continue block109;
                }
                case 54: {
                    this.mSpacingMult = a.getFloat(attr2, this.mSpacingMult);
                    continue block109;
                }
                case 56: {
                    inputType = a.getInt(attr2, 0);
                    continue block109;
                }
                case 83: {
                    this.createEditorIfNeeded();
                    this.mEditor.mAllowUndo = a.getBoolean(attr2, true);
                    continue block109;
                }
                case 59: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeOptions = a.getInt(attr2, this.mEditor.mInputContentType.imeOptions);
                    continue block109;
                }
                case 60: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeActionLabel = a.getText(attr2);
                    continue block109;
                }
                case 61: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeActionId = a.getInt(attr2, this.mEditor.mInputContentType.imeActionId);
                    continue block109;
                }
                case 57: {
                    this.setPrivateImeOptions(a.getString(attr2));
                    continue block109;
                }
                case 58: {
                    try {
                        this.setInputExtras(a.getResourceId(attr2, 0));
                    }
                    catch (XmlPullParserException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    catch (IOException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    continue block109;
                }
                case 70: {
                    this.mCursorDrawableRes = a.getResourceId(attr2, 0);
                    continue block109;
                }
                case 62: {
                    this.mTextSelectHandleLeftRes = a.getResourceId(attr2, 0);
                    continue block109;
                }
                case 63: {
                    this.mTextSelectHandleRightRes = a.getResourceId(attr2, 0);
                    continue block109;
                }
                case 64: {
                    this.mTextSelectHandleRes = a.getResourceId(attr2, 0);
                    continue block109;
                }
                case 71: {
                    this.mTextEditSuggestionItemLayout = a.getResourceId(attr2, 0);
                    continue block109;
                }
                case 101: {
                    this.mTextEditSuggestionContainerLayout = a.getResourceId(attr2, 0);
                    continue block109;
                }
                case 102: {
                    this.mTextEditSuggestionHighlightStyle = a.getResourceId(attr2, 0);
                    continue block109;
                }
                case 67: {
                    this.setTextIsSelectable(a.getBoolean(attr2, false));
                    continue block109;
                }
                case 81: {
                    this.mBreakStrategy = a.getInt(attr2, 0);
                    continue block109;
                }
                case 82: {
                    this.mHyphenationFrequency = a.getInt(attr2, 0);
                    continue block109;
                }
                case 97: {
                    this.mLineBreakStyle = a.getInt(attr2, 0);
                    continue block109;
                }
                case 98: {
                    if (a.hasValue(attr2)) {
                        this.mUserSpeficiedLineBreakwordStyle = true;
                    }
                    this.mLineBreakWordStyle = a.getInt(attr2, 0);
                    continue block109;
                }
                case 84: {
                    this.mAutoSizeTextType = a.getInt(attr2, 0);
                    continue block109;
                }
                case 85: {
                    autoSizeStepGranularityInPx = a.getDimension(attr2, -1.0f);
                    continue block109;
                }
                case 87: {
                    autoSizeMinTextSizeInPx = a.getDimension(attr2, -1.0f);
                    continue block109;
                }
                case 88: {
                    autoSizeMaxTextSizeInPx = a.getDimension(attr2, -1.0f);
                    continue block109;
                }
                case 86: {
                    int autoSizeStepSizeArrayResId = a.getResourceId(attr2, 0);
                    if (autoSizeStepSizeArrayResId <= 0) continue block109;
                    TypedArray autoSizePresetTextSizes = a.getResources().obtainTypedArray(autoSizeStepSizeArrayResId);
                    this.setupAutoSizeUniformPresetSizes(autoSizePresetTextSizes);
                    autoSizePresetTextSizes.recycle();
                    continue block109;
                }
                case 89: {
                    this.mJustificationMode = a.getInt(attr2, 0);
                    continue block109;
                }
                case 92: {
                    firstBaselineToTopHeight = a.getDimensionPixelSize(attr2, -1);
                    continue block109;
                }
                case 93: {
                    lastBaselineToBottomHeight = a.getDimensionPixelSize(attr2, -1);
                    continue block109;
                }
                case 94: {
                    TypedValue peekValue = a.peekValue(attr2);
                    if (peekValue != null && peekValue.type == 5) {
                        lineHeightUnit = peekValue.getComplexUnit();
                        lineHeight = TypedValue.complexToFloat(peekValue.data);
                        continue block109;
                    }
                    lineHeight = a.getDimensionPixelSize(attr2, -1);
                }
            }
        }
        a.recycle();
        BufferType bufferType = BufferType.EDITABLE;
        int variation = inputType & 0xFFF;
        boolean passwordInputType = variation == 129;
        boolean webPasswordInputType = variation == 225;
        boolean numberPasswordInputType = variation == 18;
        int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        boolean bl = this.mUseInternationalizedInput = targetSdkVersion >= 26;
        this.mUseFallbackLineSpacing = CompatChanges.isChangeEnabled(210923482L) ? 2 : (CompatChanges.isChangeEnabled(37756858L) ? 1 : 0);
        boolean bl2 = this.mUseTextPaddingForUiTranslation = targetSdkVersion <= 30;
        if (inputMethod != null) {
            Class<?> c;
            try {
                c = Class.forName(inputMethod.toString());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.createEditorIfNeeded();
                this.mEditor.mKeyListener = (KeyListener)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.mEditor.mInputType = inputType != 0 ? inputType : this.mEditor.mKeyListener.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mEditor.mInputType = 1;
            }
        } else if (digits != null) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DigitsKeyListener.getInstance(digits.toString());
            this.mEditor.mInputType = inputType != 0 ? inputType : 1;
        } else if (inputType != 0) {
            this.setInputType(inputType, true);
            singleLine = !TextView.isMultilineInputType(inputType);
        } else if (phone) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DialerKeyListener.getInstance();
            inputType = 3;
            this.mEditor.mInputType = 3;
        } else if (numeric != 0) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DigitsKeyListener.getInstance(null, (numeric & 2) != 0, (numeric & 4) != 0);
            this.mEditor.mInputType = inputType = this.mEditor.mKeyListener.getInputType();
        } else if (autotext || autocap != -1) {
            TextKeyListener.Capitalize cap;
            inputType = 1;
            switch (autocap) {
                case 1: {
                    cap = TextKeyListener.Capitalize.SENTENCES;
                    inputType |= 0x4000;
                    break;
                }
                case 2: {
                    cap = TextKeyListener.Capitalize.WORDS;
                    inputType |= 0x2000;
                    break;
                }
                case 3: {
                    cap = TextKeyListener.Capitalize.CHARACTERS;
                    inputType |= 0x1000;
                    break;
                }
                default: {
                    cap = TextKeyListener.Capitalize.NONE;
                }
            }
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = TextKeyListener.getInstance(autotext, cap);
            this.mEditor.mInputType = inputType;
        } else if (editable) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = TextKeyListener.getInstance();
            this.mEditor.mInputType = 1;
        } else if (this.isTextSelectable()) {
            if (this.mEditor != null) {
                this.mEditor.mKeyListener = null;
                this.mEditor.mInputType = 0;
            }
            bufferType = BufferType.SPANNABLE;
            this.setMovementMethod(ArrowKeyMovementMethod.getInstance());
        } else {
            if (this.mEditor != null) {
                this.mEditor.mKeyListener = null;
            }
            switch (buffertype) {
                case 0: {
                    bufferType = BufferType.NORMAL;
                    break;
                }
                case 1: {
                    bufferType = BufferType.SPANNABLE;
                    break;
                }
                case 2: {
                    bufferType = BufferType.EDITABLE;
                }
            }
        }
        if (this.mEditor != null) {
            this.mEditor.adjustInputType(password, passwordInputType, webPasswordInputType, numberPasswordInputType);
        }
        if (selectallonfocus) {
            this.createEditorIfNeeded();
            this.mEditor.mSelectAllOnFocus = true;
            if (bufferType == BufferType.NORMAL) {
                bufferType = BufferType.SPANNABLE;
            }
        }
        if (drawableTint != null || drawableTintMode != null) {
            if (this.mDrawables == null) {
                this.mDrawables = new Drawables(context);
            }
            if (drawableTint != null) {
                this.mDrawables.mTintList = drawableTint;
                this.mDrawables.mHasTint = true;
            }
            if (drawableTintMode != null) {
                this.mDrawables.mBlendMode = drawableTintMode;
                this.mDrawables.mHasTintMode = true;
            }
        }
        this.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        this.setRelativeDrawablesIfNeeded(drawableStart, drawableEnd);
        this.setCompoundDrawablePadding(drawablePadding);
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, singleLine, singleLine, false);
        if (singleLine && this.getKeyListener() == null && ellipsize == -1) {
            ellipsize = 3;
        }
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                if (ViewConfiguration.get(context).isFadingMarqueeEnabled()) {
                    this.setHorizontalFadingEdgeEnabled(true);
                    this.mMarqueeFadeMode = 0;
                } else {
                    this.setHorizontalFadingEdgeEnabled(false);
                    this.mMarqueeFadeMode = 1;
                }
                this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
        boolean isPassword = password || passwordInputType || webPasswordInputType || numberPasswordInputType;
        boolean bl3 = isMonospaceEnforced = isPassword || this.mEditor != null && (this.mEditor.mInputType & 0xFFF) == 129;
        if (isMonospaceEnforced) {
            attributes.mTypefaceIndex = 3;
        }
        this.mFontWeightAdjustment = this.getContext().getResources().getConfiguration().fontWeightAdjustment;
        this.applyTextAppearance(attributes);
        if (isPassword) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
        }
        if (bufferType == BufferType.EDITABLE && singleLine && maxlength == -1) {
            this.mSingleLineLengthFilter = new InputFilter.LengthFilter(5000);
        }
        if (this.mSingleLineLengthFilter != null) {
            this.setFilters(new InputFilter[]{this.mSingleLineLengthFilter});
        } else if (maxlength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxlength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
        this.setText(text, bufferType);
        if (this.mText == null) {
            this.mText = "";
        }
        if (this.mTransformed == null) {
            this.mTransformed = "";
        }
        if (textIsSetFromXml) {
            this.mTextSetFromXmlOrResourceId = true;
        }
        if (hint != null) {
            this.setHint(hint);
        }
        a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyleAttr, defStyleRes);
        boolean canInputOrMove = this.mMovement != null || this.getKeyListener() != null;
        boolean clickable = canInputOrMove || this.isClickable();
        boolean longClickable = canInputOrMove || this.isLongClickable();
        int focusable = this.getFocusable();
        n = a.getIndexCount();
        block110: for (int i = 0; i < n; ++i) {
            int attr3 = a.getIndex(i);
            switch (attr3) {
                case 19: {
                    TypedValue val = new TypedValue();
                    if (!a.getValue(attr3, val)) continue block110;
                    focusable = val.type == 18 ? (val.data == 0 ? 0 : 1) : val.data;
                    continue block110;
                }
                case 30: {
                    clickable = a.getBoolean(attr3, clickable);
                    continue block110;
                }
                case 31: {
                    longClickable = a.getBoolean(attr3, longClickable);
                }
            }
        }
        a.recycle();
        if (focusable != this.getFocusable()) {
            this.setFocusable(focusable);
        }
        this.setClickable(clickable);
        this.setLongClickable(longClickable);
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        if (this.supportsAutoSizeText()) {
            if (this.mAutoSizeTextType == 1) {
                if (!this.mHasPresetAutoSizeValues) {
                    DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
                    if (autoSizeMinTextSizeInPx == -1.0f) {
                        autoSizeMinTextSizeInPx = TypedValue.applyDimension(2, 12.0f, displayMetrics);
                    }
                    if (autoSizeMaxTextSizeInPx == -1.0f) {
                        autoSizeMaxTextSizeInPx = TypedValue.applyDimension(2, 112.0f, displayMetrics);
                    }
                    if (autoSizeStepGranularityInPx == -1.0f) {
                        autoSizeStepGranularityInPx = 1.0f;
                    }
                    this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, autoSizeStepGranularityInPx);
                }
                this.setupAutoSizeText();
            }
        } else {
            this.mAutoSizeTextType = 0;
        }
        if (firstBaselineToTopHeight >= 0) {
            this.setFirstBaselineToTopHeight(firstBaselineToTopHeight);
        }
        if (lastBaselineToBottomHeight >= 0) {
            this.setLastBaselineToBottomHeight(lastBaselineToBottomHeight);
        }
        if (lineHeight >= 0.0f) {
            if (lineHeightUnit == -1) {
                this.setLineHeightPx(lineHeight);
            } else {
                this.setLineHeight(lineHeightUnit, lineHeight);
            }
        }
    }

    private void setTextInternal(CharSequence text) {
        this.mText = text;
        this.mSpannable = text instanceof Spannable ? (Spannable)text : null;
        this.mPrecomputed = text instanceof PrecomputedText ? (PrecomputedText)text : null;
    }

    public void setAutoSizeTextTypeWithDefaults(int autoSizeTextType) {
        if (this.supportsAutoSizeText()) {
            switch (autoSizeTextType) {
                case 0: {
                    this.clearAutoSizeConfiguration();
                    break;
                }
                case 1: {
                    DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
                    float autoSizeMinTextSizeInPx = TypedValue.applyDimension(2, 12.0f, displayMetrics);
                    float autoSizeMaxTextSizeInPx = TypedValue.applyDimension(2, 112.0f, displayMetrics);
                    this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, 1.0f);
                    if (!this.setupAutoSizeText()) break;
                    this.autoSizeText();
                    this.invalidate();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown auto-size text type: " + autoSizeTextType);
                }
            }
        }
    }

    public void setAutoSizeTextTypeUniformWithConfiguration(int autoSizeMinTextSize, int autoSizeMaxTextSize, int autoSizeStepGranularity, int unit) {
        if (this.supportsAutoSizeText()) {
            DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
            float autoSizeMinTextSizeInPx = TypedValue.applyDimension(unit, autoSizeMinTextSize, displayMetrics);
            float autoSizeMaxTextSizeInPx = TypedValue.applyDimension(unit, autoSizeMaxTextSize, displayMetrics);
            float autoSizeStepGranularityInPx = TypedValue.applyDimension(unit, autoSizeStepGranularity, displayMetrics);
            this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, autoSizeStepGranularityInPx);
            if (this.setupAutoSizeText()) {
                this.autoSizeText();
                this.invalidate();
            }
        }
    }

    public void setAutoSizeTextTypeUniformWithPresetSizes(int[] presetSizes, int unit) {
        if (this.supportsAutoSizeText()) {
            int presetSizesLength = presetSizes.length;
            if (presetSizesLength > 0) {
                int[] presetSizesInPx = new int[presetSizesLength];
                if (unit == 0) {
                    presetSizesInPx = Arrays.copyOf(presetSizes, presetSizesLength);
                } else {
                    DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
                    for (int i = 0; i < presetSizesLength; ++i) {
                        presetSizesInPx[i] = Math.round(TypedValue.applyDimension(unit, presetSizes[i], displayMetrics));
                    }
                }
                this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(presetSizesInPx);
                if (!this.setupAutoSizeUniformPresetSizesConfiguration()) {
                    throw new IllegalArgumentException("None of the preset sizes is valid: " + Arrays.toString(presetSizes));
                }
            } else {
                this.mHasPresetAutoSizeValues = false;
            }
            if (this.setupAutoSizeText()) {
                this.autoSizeText();
                this.invalidate();
            }
        }
    }

    public int getAutoSizeTextType() {
        return this.mAutoSizeTextType;
    }

    public int getAutoSizeStepGranularity() {
        return Math.round(this.mAutoSizeStepGranularityInPx);
    }

    public int getAutoSizeMinTextSize() {
        return Math.round(this.mAutoSizeMinTextSizeInPx);
    }

    public int getAutoSizeMaxTextSize() {
        return Math.round(this.mAutoSizeMaxTextSizeInPx);
    }

    public int[] getAutoSizeTextAvailableSizes() {
        return this.mAutoSizeTextSizesInPx;
    }

    private void setupAutoSizeUniformPresetSizes(TypedArray textSizes) {
        int textSizesLength = textSizes.length();
        int[] parsedSizes = new int[textSizesLength];
        if (textSizesLength > 0) {
            for (int i = 0; i < textSizesLength; ++i) {
                parsedSizes[i] = textSizes.getDimensionPixelSize(i, -1);
            }
            this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(parsedSizes);
            this.setupAutoSizeUniformPresetSizesConfiguration();
        }
    }

    private boolean setupAutoSizeUniformPresetSizesConfiguration() {
        int sizesLength = this.mAutoSizeTextSizesInPx.length;
        boolean bl = this.mHasPresetAutoSizeValues = sizesLength > 0;
        if (this.mHasPresetAutoSizeValues) {
            this.mAutoSizeTextType = 1;
            this.mAutoSizeMinTextSizeInPx = this.mAutoSizeTextSizesInPx[0];
            this.mAutoSizeMaxTextSizeInPx = this.mAutoSizeTextSizesInPx[sizesLength - 1];
            this.mAutoSizeStepGranularityInPx = -1.0f;
        }
        return this.mHasPresetAutoSizeValues;
    }

    private void validateAndSetAutoSizeTextTypeUniformConfiguration(float autoSizeMinTextSizeInPx, float autoSizeMaxTextSizeInPx, float autoSizeStepGranularityInPx) {
        if (autoSizeMinTextSizeInPx <= 0.0f) {
            throw new IllegalArgumentException("Minimum auto-size text size (" + autoSizeMinTextSizeInPx + "px) is less or equal to (0px)");
        }
        if (autoSizeMaxTextSizeInPx <= autoSizeMinTextSizeInPx) {
            throw new IllegalArgumentException("Maximum auto-size text size (" + autoSizeMaxTextSizeInPx + "px) is less or equal to minimum auto-size text size (" + autoSizeMinTextSizeInPx + "px)");
        }
        if (autoSizeStepGranularityInPx <= 0.0f) {
            throw new IllegalArgumentException("The auto-size step granularity (" + autoSizeStepGranularityInPx + "px) is less or equal to (0px)");
        }
        this.mAutoSizeTextType = 1;
        this.mAutoSizeMinTextSizeInPx = autoSizeMinTextSizeInPx;
        this.mAutoSizeMaxTextSizeInPx = autoSizeMaxTextSizeInPx;
        this.mAutoSizeStepGranularityInPx = autoSizeStepGranularityInPx;
        this.mHasPresetAutoSizeValues = false;
    }

    private void clearAutoSizeConfiguration() {
        this.mAutoSizeTextType = 0;
        this.mAutoSizeMinTextSizeInPx = -1.0f;
        this.mAutoSizeMaxTextSizeInPx = -1.0f;
        this.mAutoSizeStepGranularityInPx = -1.0f;
        this.mAutoSizeTextSizesInPx = EmptyArray.INT;
        this.mNeedsAutoSizeText = false;
    }

    private int[] cleanupAutoSizePresetSizes(int[] presetValues) {
        int presetValuesLength = presetValues.length;
        if (presetValuesLength == 0) {
            return presetValues;
        }
        Arrays.sort(presetValues);
        IntArray uniqueValidSizes = new IntArray();
        for (int i = 0; i < presetValuesLength; ++i) {
            int currentPresetValue = presetValues[i];
            if (currentPresetValue <= 0 || uniqueValidSizes.binarySearch(currentPresetValue) >= 0) continue;
            uniqueValidSizes.add(currentPresetValue);
        }
        return presetValuesLength == uniqueValidSizes.size() ? presetValues : uniqueValidSizes.toArray();
    }

    private boolean setupAutoSizeText() {
        if (this.supportsAutoSizeText() && this.mAutoSizeTextType == 1) {
            if (!this.mHasPresetAutoSizeValues || this.mAutoSizeTextSizesInPx.length == 0) {
                int autoSizeValuesLength = (int)Math.floor((this.mAutoSizeMaxTextSizeInPx - this.mAutoSizeMinTextSizeInPx) / this.mAutoSizeStepGranularityInPx) + 1;
                int[] autoSizeTextSizesInPx = new int[autoSizeValuesLength];
                for (int i = 0; i < autoSizeValuesLength; ++i) {
                    autoSizeTextSizesInPx[i] = Math.round(this.mAutoSizeMinTextSizeInPx + (float)i * this.mAutoSizeStepGranularityInPx);
                }
                this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(autoSizeTextSizesInPx);
            }
            this.mNeedsAutoSizeText = true;
        } else {
            this.mNeedsAutoSizeText = false;
        }
        return this.mNeedsAutoSizeText;
    }

    private int[] parseDimensionArray(TypedArray dimens) {
        if (dimens == null) {
            return null;
        }
        int[] result = new int[dimens.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = dimens.getDimensionPixelSize(i, 0);
        }
        return result;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 100) {
            if (resultCode == -1 && data != null) {
                CharSequence result = data.getCharSequenceExtra("android.intent.extra.PROCESS_TEXT");
                if (result != null) {
                    if (this.isTextEditable()) {
                        ClipData clip = ClipData.newPlainText("", result);
                        ContentInfo payload = new ContentInfo.Builder(clip, 5).build();
                        this.performReceiveContent(payload);
                        if (this.mEditor != null) {
                            this.mEditor.refreshTextActionMode();
                        }
                    } else if (result.length() > 0) {
                        Toast.makeText(this.getContext(), String.valueOf(result), 1).show();
                    }
                }
            } else if (this.mSpannable != null) {
                Selection.setSelection(this.mSpannable, this.getSelectionEnd());
            }
        }
    }

    private void setTypefaceFromAttrs(Typeface typeface, String familyName, int typefaceIndex, int style2, int weight) {
        if (typeface == null && familyName != null) {
            Typeface normalTypeface = Typeface.create(familyName, 0);
            this.resolveStyleAndSetTypeface(normalTypeface, style2, weight);
        } else if (typeface != null) {
            this.resolveStyleAndSetTypeface(typeface, style2, weight);
        } else {
            switch (typefaceIndex) {
                case 1: {
                    this.resolveStyleAndSetTypeface(Typeface.SANS_SERIF, style2, weight);
                    break;
                }
                case 2: {
                    this.resolveStyleAndSetTypeface(Typeface.SERIF, style2, weight);
                    break;
                }
                case 3: {
                    this.resolveStyleAndSetTypeface(Typeface.MONOSPACE, style2, weight);
                    break;
                }
                default: {
                    this.resolveStyleAndSetTypeface(null, style2, weight);
                }
            }
        }
    }

    private void resolveStyleAndSetTypeface(Typeface typeface, int style2, int weight) {
        if (weight >= 0) {
            weight = Math.min(1000, weight);
            boolean italic = (style2 & 2) != 0;
            this.setTypeface(Typeface.create(typeface, weight, italic));
        } else {
            this.setTypeface(typeface, style2);
        }
    }

    private void setRelativeDrawablesIfNeeded(Drawable start, Drawable end) {
        boolean hasRelativeDrawables;
        boolean bl = hasRelativeDrawables = start != null || end != null;
        if (hasRelativeDrawables) {
            Drawables dr = this.mDrawables;
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = true;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableStart = start;
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableEnd = end;
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
            this.resetResolvedDrawables();
            this.resolveDrawables();
            this.applyCompoundDrawableTint();
        }
    }

    @Override
    @RemotableViewMethod
    public void setEnabled(boolean enabled) {
        InputMethodManager imm;
        if (enabled == this.isEnabled()) {
            return;
        }
        if (!enabled && (imm = this.getInputMethodManager()) != null && imm.isActive(this)) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        super.setEnabled(enabled);
        if (enabled && (imm = this.getInputMethodManager()) != null) {
            imm.restartInput(this);
        }
        if (this.mEditor != null) {
            this.mEditor.invalidateTextDisplayList();
            this.mEditor.prepareCursorControllers();
            this.mEditor.makeBlink();
        }
    }

    public void setTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    protected boolean getDefaultEditable() {
        return false;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getText() {
        TextViewTranslationCallback defaultCallback;
        ViewTranslationCallback callback;
        if (this.mUseTextPaddingForUiTranslation && (callback = this.getViewTranslationCallback()) != null && callback instanceof TextViewTranslationCallback && (defaultCallback = (TextViewTranslationCallback)callback).isTextPaddingEnabled() && defaultCallback.isShowingTranslation()) {
            return defaultCallback.getPaddedText(this.mText, this.mTransformed);
        }
        return this.mText;
    }

    public int length() {
        return this.mText.length();
    }

    public Editable getEditableText() {
        return this.mText instanceof Editable ? (Editable)this.mText : null;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public CharSequence getTransformed() {
        return this.mTransformed;
    }

    public int getLineHeight() {
        return FastMath.round((float)this.mTextPaint.getFontMetricsInt(null) * this.mSpacingMult + this.mSpacingAdd);
    }

    public Layout getLayout() {
        return this.mLayout;
    }

    @UnsupportedAppUsage
    Layout getHintLayout() {
        return this.mHintLayout;
    }

    public UndoManager getUndoManager() {
        throw new UnsupportedOperationException("not implemented");
    }

    @VisibleForTesting
    public Editor getEditorForTesting() {
        return this.mEditor;
    }

    public void setUndoManager(UndoManager undoManager, String tag) {
        throw new UnsupportedOperationException("not implemented");
    }

    public KeyListener getKeyListener() {
        return this.mEditor == null ? null : this.mEditor.mKeyListener;
    }

    public void setKeyListener(KeyListener input) {
        this.mListenerChanged = true;
        this.setKeyListenerOnly(input);
        this.fixFocusableAndClickableSettings();
        if (input != null) {
            this.createEditorIfNeeded();
            this.setInputTypeFromEditor();
        } else if (this.mEditor != null) {
            this.mEditor.mInputType = 0;
        }
        InputMethodManager imm = this.getInputMethodManager();
        if (imm != null) {
            imm.restartInput(this);
        }
    }

    private void setInputTypeFromEditor() {
        try {
            this.mEditor.mInputType = this.mEditor.mKeyListener.getInputType();
        }
        catch (IncompatibleClassChangeError e) {
            this.mEditor.mInputType = 1;
        }
        this.setInputTypeSingleLine(this.mSingleLine);
    }

    private void setKeyListenerOnly(KeyListener input) {
        if (this.mEditor == null && input == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mKeyListener != input) {
            this.mEditor.mKeyListener = input;
            if (input != null && !(this.mText instanceof Editable)) {
                this.setText(this.mText);
            }
            this.setFilters((Editable)this.mText, this.mFilters);
        }
    }

    public MovementMethod getMovementMethod() {
        return this.mMovement;
    }

    public void setMovementMethod(MovementMethod movement) {
        if (this.mMovement != movement) {
            this.mMovement = movement;
            if (movement != null && this.mSpannable == null) {
                this.setText(this.mText);
            }
            this.fixFocusableAndClickableSettings();
            if (this.mEditor != null) {
                this.mEditor.prepareCursorControllers();
            }
        }
    }

    private void fixFocusableAndClickableSettings() {
        if (this.mMovement != null || this.mEditor != null && this.mEditor.mKeyListener != null) {
            this.setFocusable(1);
            this.setClickable(true);
            this.setLongClickable(true);
        } else {
            this.setFocusable(16);
            this.setClickable(false);
            this.setLongClickable(false);
        }
    }

    public TransformationMethod getTransformationMethod() {
        return this.mTransformation;
    }

    public void setTransformationMethod(TransformationMethod method) {
        if (this.mEditor != null) {
            this.mEditor.setTransformationMethod(method);
        } else {
            this.setTransformationMethodInternal(method);
        }
    }

    void setTransformationMethodInternal(TransformationMethod method) {
        if (method == this.mTransformation) {
            return;
        }
        if (this.mTransformation != null && this.mSpannable != null) {
            this.mSpannable.removeSpan(this.mTransformation);
        }
        this.mTransformation = method;
        if (method instanceof TransformationMethod2) {
            TransformationMethod2 method2 = (TransformationMethod2)method;
            this.mAllowTransformationLengthChange = !this.isTextSelectable() && !(this.mText instanceof Editable);
            method2.setLengthChangesAllowed(this.mAllowTransformationLengthChange);
        } else {
            this.mAllowTransformationLengthChange = false;
        }
        this.setText(this.mText);
        if (this.hasPasswordTransformationMethod()) {
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
        }
        this.mTextDir = this.getTextDirectionHeuristic();
    }

    public int getCompoundPaddingTop() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[1] == null) {
            return this.mPaddingTop;
        }
        return this.mPaddingTop + dr.mDrawablePadding + dr.mDrawableSizeTop;
    }

    public int getCompoundPaddingBottom() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[3] == null) {
            return this.mPaddingBottom;
        }
        return this.mPaddingBottom + dr.mDrawablePadding + dr.mDrawableSizeBottom;
    }

    public int getCompoundPaddingLeft() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[0] == null) {
            return this.mPaddingLeft;
        }
        return this.mPaddingLeft + dr.mDrawablePadding + dr.mDrawableSizeLeft;
    }

    public int getCompoundPaddingRight() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[2] == null) {
            return this.mPaddingRight;
        }
        return this.mPaddingRight + dr.mDrawablePadding + dr.mDrawableSizeRight;
    }

    public int getCompoundPaddingStart() {
        this.resolveDrawables();
        switch (this.getLayoutDirection()) {
            default: {
                return this.getCompoundPaddingLeft();
            }
            case 1: 
        }
        return this.getCompoundPaddingRight();
    }

    public int getCompoundPaddingEnd() {
        this.resolveDrawables();
        switch (this.getLayoutDirection()) {
            default: {
                return this.getCompoundPaddingRight();
            }
            case 1: 
        }
        return this.getCompoundPaddingLeft();
    }

    public int getExtendedPaddingTop() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingTop();
        }
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingTop();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return top;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return top;
        }
        if (gravity == 80) {
            return top + viewht - layoutht;
        }
        return top + (viewht - layoutht) / 2;
    }

    public int getExtendedPaddingBottom() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingBottom();
        }
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingBottom();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return bottom;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return bottom + viewht - layoutht;
        }
        if (gravity == 80) {
            return bottom;
        }
        return bottom + (viewht - layoutht) / 2;
    }

    public int getTotalPaddingLeft() {
        return this.getCompoundPaddingLeft();
    }

    public int getTotalPaddingRight() {
        return this.getCompoundPaddingRight();
    }

    public int getTotalPaddingStart() {
        return this.getCompoundPaddingStart();
    }

    public int getTotalPaddingEnd() {
        return this.getCompoundPaddingEnd();
    }

    public int getTotalPaddingTop() {
        return this.getExtendedPaddingTop() + this.getVerticalOffset(true);
    }

    public int getTotalPaddingBottom() {
        return this.getExtendedPaddingBottom() + this.getBottomVerticalOffset(true);
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            if (dr.mDrawableStart != null) {
                dr.mDrawableStart.setCallback(null);
            }
            dr.mDrawableStart = null;
            if (dr.mDrawableEnd != null) {
                dr.mDrawableEnd.setCallback(null);
            }
            dr.mDrawableEnd = null;
            dr.mDrawableHeightStart = 0;
            dr.mDrawableSizeStart = 0;
            dr.mDrawableHeightEnd = 0;
            dr.mDrawableSizeEnd = 0;
        }
        boolean bl = drawables = left != null || top != null || right != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (!dr.hasMetadata()) {
                    this.mDrawables = null;
                } else {
                    for (int i = dr.mShowing.length - 1; i >= 0; --i) {
                        if (dr.mShowing[i] != null) {
                            dr.mShowing[i].setCallback(null);
                        }
                        dr.mShowing[i] = null;
                    }
                    dr.mDrawableHeightLeft = 0;
                    dr.mDrawableSizeLeft = 0;
                    dr.mDrawableHeightRight = 0;
                    dr.mDrawableSizeRight = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = false;
            if (dr.mShowing[0] != left && dr.mShowing[0] != null) {
                dr.mShowing[0].setCallback(null);
            }
            dr.mShowing[0] = left;
            if (dr.mShowing[1] != top && dr.mShowing[1] != null) {
                dr.mShowing[1].setCallback(null);
            }
            dr.mShowing[1] = top;
            if (dr.mShowing[2] != right && dr.mShowing[2] != null) {
                dr.mShowing[2].setCallback(null);
            }
            dr.mShowing[2] = right;
            if (dr.mShowing[3] != bottom && dr.mShowing[3] != null) {
                dr.mShowing[3].setCallback(null);
            }
            dr.mShowing[3] = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (left != null) {
                left.setState(state);
                left.copyBounds(compoundRect);
                left.setCallback(this);
                dr.mDrawableSizeLeft = compoundRect.width();
                dr.mDrawableHeightLeft = compoundRect.height();
            } else {
                dr.mDrawableHeightLeft = 0;
                dr.mDrawableSizeLeft = 0;
            }
            if (right != null) {
                right.setState(state);
                right.copyBounds(compoundRect);
                right.setCallback(this);
                dr.mDrawableSizeRight = compoundRect.width();
                dr.mDrawableHeightRight = compoundRect.height();
            } else {
                dr.mDrawableHeightRight = 0;
                dr.mDrawableSizeRight = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        if (dr != null) {
            dr.mDrawableLeftInitial = left;
            dr.mDrawableRightInitial = right;
        }
        this.resetResolvedDrawables();
        this.resolveDrawables();
        this.applyCompoundDrawableTint();
        this.invalidate();
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        Context context = this.getContext();
        this.setCompoundDrawablesWithIntrinsicBounds(left != 0 ? context.getDrawable(left) : null, top != 0 ? context.getDrawable(top) : null, right != 0 ? context.getDrawable(right) : null, bottom != 0 ? context.getDrawable(bottom) : null);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (left != null) {
            left.setBounds(0, 0, left.getIntrinsicWidth(), left.getIntrinsicHeight());
        }
        if (right != null) {
            right.setBounds(0, 0, right.getIntrinsicWidth(), right.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawables(left, top, right, bottom);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesRelative(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            if (dr.mShowing[0] != null) {
                dr.mShowing[0].setCallback(null);
            }
            dr.mDrawableLeftInitial = null;
            dr.mShowing[0] = null;
            if (dr.mShowing[2] != null) {
                dr.mShowing[2].setCallback(null);
            }
            dr.mDrawableRightInitial = null;
            dr.mShowing[2] = null;
            dr.mDrawableHeightLeft = 0;
            dr.mDrawableSizeLeft = 0;
            dr.mDrawableHeightRight = 0;
            dr.mDrawableSizeRight = 0;
        }
        boolean bl = drawables = start != null || top != null || end != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (!dr.hasMetadata()) {
                    this.mDrawables = null;
                } else {
                    if (dr.mDrawableStart != null) {
                        dr.mDrawableStart.setCallback(null);
                    }
                    dr.mDrawableStart = null;
                    if (dr.mShowing[1] != null) {
                        dr.mShowing[1].setCallback(null);
                    }
                    dr.mShowing[1] = null;
                    if (dr.mDrawableEnd != null) {
                        dr.mDrawableEnd.setCallback(null);
                    }
                    dr.mDrawableEnd = null;
                    if (dr.mShowing[3] != null) {
                        dr.mShowing[3].setCallback(null);
                    }
                    dr.mShowing[3] = null;
                    dr.mDrawableHeightStart = 0;
                    dr.mDrawableSizeStart = 0;
                    dr.mDrawableHeightEnd = 0;
                    dr.mDrawableSizeEnd = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = true;
            if (dr.mDrawableStart != start && dr.mDrawableStart != null) {
                dr.mDrawableStart.setCallback(null);
            }
            dr.mDrawableStart = start;
            if (dr.mShowing[1] != top && dr.mShowing[1] != null) {
                dr.mShowing[1].setCallback(null);
            }
            dr.mShowing[1] = top;
            if (dr.mDrawableEnd != end && dr.mDrawableEnd != null) {
                dr.mDrawableEnd.setCallback(null);
            }
            dr.mDrawableEnd = end;
            if (dr.mShowing[3] != bottom && dr.mShowing[3] != null) {
                dr.mShowing[3].setCallback(null);
            }
            dr.mShowing[3] = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        this.resetResolvedDrawables();
        this.resolveDrawables();
        this.invalidate();
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        Context context = this.getContext();
        this.setCompoundDrawablesRelativeWithIntrinsicBounds(start != 0 ? context.getDrawable(start) : null, top != 0 ? context.getDrawable(top) : null, end != 0 ? context.getDrawable(end) : null, bottom != 0 ? context.getDrawable(bottom) : null);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (start != null) {
            start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
        }
        if (end != null) {
            end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawablesRelative(start, top, end, bottom);
    }

    public Drawable[] getCompoundDrawables() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return (Drawable[])dr.mShowing.clone();
        }
        return new Drawable[]{null, null, null, null};
    }

    public Drawable[] getCompoundDrawablesRelative() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return new Drawable[]{dr.mDrawableStart, dr.mShowing[1], dr.mDrawableEnd, dr.mShowing[3]};
        }
        return new Drawable[]{null, null, null, null};
    }

    @RemotableViewMethod
    public void setCompoundDrawablePadding(int pad) {
        Drawables dr = this.mDrawables;
        if (pad == 0) {
            if (dr != null) {
                dr.mDrawablePadding = pad;
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            dr.mDrawablePadding = pad;
        }
        this.invalidate();
        this.requestLayout();
    }

    public int getCompoundDrawablePadding() {
        Drawables dr = this.mDrawables;
        return dr != null ? dr.mDrawablePadding : 0;
    }

    public void setCompoundDrawableTintList(ColorStateList tint) {
        if (this.mDrawables == null) {
            this.mDrawables = new Drawables(this.getContext());
        }
        this.mDrawables.mTintList = tint;
        this.mDrawables.mHasTint = true;
        this.applyCompoundDrawableTint();
    }

    public ColorStateList getCompoundDrawableTintList() {
        return this.mDrawables != null ? this.mDrawables.mTintList : null;
    }

    public void setCompoundDrawableTintMode(PorterDuff.Mode tintMode) {
        this.setCompoundDrawableTintBlendMode(tintMode != null ? BlendMode.fromValue(tintMode.nativeInt) : null);
    }

    public void setCompoundDrawableTintBlendMode(BlendMode blendMode) {
        if (this.mDrawables == null) {
            this.mDrawables = new Drawables(this.getContext());
        }
        this.mDrawables.mBlendMode = blendMode;
        this.mDrawables.mHasTintMode = true;
        this.applyCompoundDrawableTint();
    }

    public PorterDuff.Mode getCompoundDrawableTintMode() {
        BlendMode mode = this.getCompoundDrawableTintBlendMode();
        return mode != null ? BlendMode.blendModeToPorterDuffMode(mode) : null;
    }

    public BlendMode getCompoundDrawableTintBlendMode() {
        return this.mDrawables != null ? this.mDrawables.mBlendMode : null;
    }

    private void applyCompoundDrawableTint() {
        if (this.mDrawables == null) {
            return;
        }
        if (this.mDrawables.mHasTint || this.mDrawables.mHasTintMode) {
            ColorStateList tintList = this.mDrawables.mTintList;
            BlendMode blendMode = this.mDrawables.mBlendMode;
            boolean hasTint = this.mDrawables.mHasTint;
            boolean hasTintMode = this.mDrawables.mHasTintMode;
            int[] state = this.getDrawableState();
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null || dr == this.mDrawables.mDrawableError) continue;
                dr.mutate();
                if (hasTint) {
                    dr.setTintList(tintList);
                }
                if (hasTintMode) {
                    dr.setTintBlendMode(blendMode);
                }
                if (!dr.isStateful()) continue;
                dr.setState(state);
            }
        }
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        if (left != this.mPaddingLeft || right != this.mPaddingRight || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPadding(left, top, right, bottom);
        this.invalidate();
    }

    @Override
    public void setPaddingRelative(int start, int top, int end, int bottom) {
        if (start != this.getPaddingStart() || end != this.getPaddingEnd() || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPaddingRelative(start, top, end, bottom);
        this.invalidate();
    }

    public void setFirstBaselineToTopHeight(int firstBaselineToTopHeight) {
        Preconditions.checkArgumentNonnegative(firstBaselineToTopHeight);
        Paint.FontMetricsInt fontMetrics = this.getPaint().getFontMetricsInt();
        int fontMetricsTop = this.getIncludeFontPadding() ? fontMetrics.top : fontMetrics.ascent;
        if (firstBaselineToTopHeight > Math.abs(fontMetricsTop)) {
            int paddingTop = firstBaselineToTopHeight - -fontMetricsTop;
            this.setPadding(this.getPaddingLeft(), paddingTop, this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    public void setLastBaselineToBottomHeight(int lastBaselineToBottomHeight) {
        Preconditions.checkArgumentNonnegative(lastBaselineToBottomHeight);
        Paint.FontMetricsInt fontMetrics = this.getPaint().getFontMetricsInt();
        int fontMetricsBottom = this.getIncludeFontPadding() ? fontMetrics.bottom : fontMetrics.descent;
        if (lastBaselineToBottomHeight > Math.abs(fontMetricsBottom)) {
            int paddingBottom = lastBaselineToBottomHeight - fontMetricsBottom;
            this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), paddingBottom);
        }
    }

    public int getFirstBaselineToTopHeight() {
        return this.getPaddingTop() - this.getPaint().getFontMetricsInt().top;
    }

    public int getLastBaselineToBottomHeight() {
        return this.getPaddingBottom() + this.getPaint().getFontMetricsInt().bottom;
    }

    public int getAutoLinkMask() {
        return this.mAutoLinkMask;
    }

    @RemotableViewMethod
    public void setTextSelectHandle(Drawable textSelectHandle) {
        Preconditions.checkNotNull(textSelectHandle, "The text select handle should not be null.");
        this.mTextSelectHandle = textSelectHandle;
        this.mTextSelectHandleRes = 0;
        if (this.mEditor != null) {
            this.mEditor.loadHandleDrawables(true);
        }
    }

    @RemotableViewMethod
    public void setTextSelectHandle(int textSelectHandle) {
        Preconditions.checkArgument(textSelectHandle != 0, "The text select handle should be a valid drawable resource id.");
        this.setTextSelectHandle(this.mContext.getDrawable(textSelectHandle));
    }

    public Drawable getTextSelectHandle() {
        if (this.mTextSelectHandle == null && this.mTextSelectHandleRes != 0) {
            this.mTextSelectHandle = this.mContext.getDrawable(this.mTextSelectHandleRes);
        }
        return this.mTextSelectHandle;
    }

    @RemotableViewMethod
    public void setTextSelectHandleLeft(Drawable textSelectHandleLeft) {
        Preconditions.checkNotNull(textSelectHandleLeft, "The left text select handle should not be null.");
        this.mTextSelectHandleLeft = textSelectHandleLeft;
        this.mTextSelectHandleLeftRes = 0;
        if (this.mEditor != null) {
            this.mEditor.loadHandleDrawables(true);
        }
    }

    @RemotableViewMethod
    public void setTextSelectHandleLeft(int textSelectHandleLeft) {
        Preconditions.checkArgument(textSelectHandleLeft != 0, "The text select left handle should be a valid drawable resource id.");
        this.setTextSelectHandleLeft(this.mContext.getDrawable(textSelectHandleLeft));
    }

    public Drawable getTextSelectHandleLeft() {
        if (this.mTextSelectHandleLeft == null && this.mTextSelectHandleLeftRes != 0) {
            this.mTextSelectHandleLeft = this.mContext.getDrawable(this.mTextSelectHandleLeftRes);
        }
        return this.mTextSelectHandleLeft;
    }

    @RemotableViewMethod
    public void setTextSelectHandleRight(Drawable textSelectHandleRight) {
        Preconditions.checkNotNull(textSelectHandleRight, "The right text select handle should not be null.");
        this.mTextSelectHandleRight = textSelectHandleRight;
        this.mTextSelectHandleRightRes = 0;
        if (this.mEditor != null) {
            this.mEditor.loadHandleDrawables(true);
        }
    }

    @RemotableViewMethod
    public void setTextSelectHandleRight(int textSelectHandleRight) {
        Preconditions.checkArgument(textSelectHandleRight != 0, "The text select right handle should be a valid drawable resource id.");
        this.setTextSelectHandleRight(this.mContext.getDrawable(textSelectHandleRight));
    }

    public Drawable getTextSelectHandleRight() {
        if (this.mTextSelectHandleRight == null && this.mTextSelectHandleRightRes != 0) {
            this.mTextSelectHandleRight = this.mContext.getDrawable(this.mTextSelectHandleRightRes);
        }
        return this.mTextSelectHandleRight;
    }

    public void setTextCursorDrawable(Drawable textCursorDrawable) {
        this.mCursorDrawable = textCursorDrawable;
        this.mCursorDrawableRes = 0;
        if (this.mEditor != null) {
            this.mEditor.loadCursorDrawable();
        }
    }

    public void setTextCursorDrawable(int textCursorDrawable) {
        this.setTextCursorDrawable(textCursorDrawable != 0 ? this.mContext.getDrawable(textCursorDrawable) : null);
    }

    public Drawable getTextCursorDrawable() {
        if (this.mCursorDrawable == null && this.mCursorDrawableRes != 0) {
            this.mCursorDrawable = this.mContext.getDrawable(this.mCursorDrawableRes);
        }
        return this.mCursorDrawable;
    }

    public void setTextAppearance(int resId) {
        this.setTextAppearance(this.mContext, resId);
    }

    @Deprecated
    public void setTextAppearance(Context context, int resId) {
        TypedArray ta = context.obtainStyledAttributes(resId, R.styleable.TextAppearance);
        TextAppearanceAttributes attributes = new TextAppearanceAttributes();
        this.readTextAppearance(context, ta, attributes, false);
        ta.recycle();
        this.applyTextAppearance(attributes);
    }

    private void readTextAppearance(Context context, TypedArray appearance, TextAppearanceAttributes attributes, boolean styleArray) {
        int n = appearance.getIndexCount();
        block28: for (int i = 0; i < n; ++i) {
            int attr2;
            int index = attr2 = appearance.getIndex(i);
            if (styleArray && (index = sAppearanceValues.get(attr2, -1)) == -1) continue;
            switch (index) {
                case 4: {
                    attributes.mTextColorHighlight = appearance.getColor(attr2, attributes.mTextColorHighlight);
                    continue block28;
                }
                case 22: {
                    attributes.mSearchResultHighlightColor = appearance.getColor(attr2, attributes.mSearchResultHighlightColor);
                    continue block28;
                }
                case 23: {
                    attributes.mFocusedSearchResultHighlightColor = appearance.getColor(attr2, attributes.mFocusedSearchResultHighlightColor);
                    continue block28;
                }
                case 3: {
                    attributes.mTextColor = appearance.getColorStateList(attr2);
                    continue block28;
                }
                case 5: {
                    attributes.mTextColorHint = appearance.getColorStateList(attr2);
                    continue block28;
                }
                case 6: {
                    attributes.mTextColorLink = appearance.getColorStateList(attr2);
                    continue block28;
                }
                case 0: {
                    attributes.mTextSize = appearance.getDimensionPixelSize(attr2, attributes.mTextSize);
                    attributes.mTextSizeUnit = appearance.peekValue(attr2).getComplexUnit();
                    continue block28;
                }
                case 19: {
                    LocaleList localeList;
                    String localeString = appearance.getString(attr2);
                    if (localeString == null || (localeList = LocaleList.forLanguageTags(localeString)).isEmpty()) continue block28;
                    attributes.mTextLocales = localeList;
                    continue block28;
                }
                case 1: {
                    attributes.mTypefaceIndex = appearance.getInt(attr2, attributes.mTypefaceIndex);
                    if (attributes.mTypefaceIndex == -1 || attributes.mFontFamilyExplicit) continue block28;
                    attributes.mFontFamily = null;
                    continue block28;
                }
                case 12: {
                    if (!context.isRestricted() && context.canLoadUnsafeResources()) {
                        try {
                            attributes.mFontTypeface = appearance.getFont(attr2);
                        }
                        catch (Resources.NotFoundException | UnsupportedOperationException runtimeException) {
                            // empty catch block
                        }
                    }
                    if (attributes.mFontTypeface == null) {
                        attributes.mFontFamily = appearance.getString(attr2);
                    }
                    attributes.mFontFamilyExplicit = true;
                    continue block28;
                }
                case 2: {
                    attributes.mTextStyle = appearance.getInt(attr2, attributes.mTextStyle);
                    continue block28;
                }
                case 18: {
                    attributes.mFontWeight = appearance.getInt(attr2, attributes.mFontWeight);
                    continue block28;
                }
                case 11: {
                    attributes.mAllCaps = appearance.getBoolean(attr2, attributes.mAllCaps);
                    continue block28;
                }
                case 7: {
                    attributes.mShadowColor = appearance.getInt(attr2, attributes.mShadowColor);
                    continue block28;
                }
                case 8: {
                    attributes.mShadowDx = appearance.getFloat(attr2, attributes.mShadowDx);
                    continue block28;
                }
                case 9: {
                    attributes.mShadowDy = appearance.getFloat(attr2, attributes.mShadowDy);
                    continue block28;
                }
                case 10: {
                    attributes.mShadowRadius = appearance.getFloat(attr2, attributes.mShadowRadius);
                    continue block28;
                }
                case 13: {
                    attributes.mHasElegant = true;
                    attributes.mElegant = appearance.getBoolean(attr2, attributes.mElegant);
                    continue block28;
                }
                case 17: {
                    attributes.mHasFallbackLineSpacing = true;
                    attributes.mFallbackLineSpacing = appearance.getBoolean(attr2, attributes.mFallbackLineSpacing);
                    continue block28;
                }
                case 14: {
                    attributes.mHasLetterSpacing = true;
                    attributes.mLetterSpacing = appearance.getFloat(attr2, attributes.mLetterSpacing);
                    continue block28;
                }
                case 15: {
                    attributes.mFontFeatureSettings = appearance.getString(attr2);
                    continue block28;
                }
                case 16: {
                    attributes.mFontVariationSettings = appearance.getString(attr2);
                    continue block28;
                }
                case 20: {
                    attributes.mHasLineBreakStyle = true;
                    attributes.mLineBreakStyle = appearance.getInt(attr2, attributes.mLineBreakStyle);
                    continue block28;
                }
                case 21: {
                    attributes.mHasLineBreakWordStyle = true;
                    this.mUserSpeficiedLineBreakwordStyle = true;
                    attributes.mLineBreakWordStyle = appearance.getInt(attr2, attributes.mLineBreakWordStyle);
                    continue block28;
                }
            }
        }
    }

    private void applyTextAppearance(TextAppearanceAttributes attributes) {
        if (attributes.mTextColor != null) {
            this.setTextColor(attributes.mTextColor);
        }
        if (attributes.mTextColorHint != null) {
            this.setHintTextColor(attributes.mTextColorHint);
        }
        if (attributes.mTextColorLink != null) {
            this.setLinkTextColor(attributes.mTextColorLink);
        }
        if (attributes.mTextColorHighlight != 0) {
            this.setHighlightColor(attributes.mTextColorHighlight);
        }
        if (attributes.mSearchResultHighlightColor != 0) {
            this.setSearchResultHighlightColor(attributes.mSearchResultHighlightColor);
        }
        if (attributes.mFocusedSearchResultHighlightColor != 0) {
            this.setFocusedSearchResultHighlightColor(attributes.mFocusedSearchResultHighlightColor);
        }
        if (attributes.mTextSize != -1) {
            this.mTextSizeUnit = attributes.mTextSizeUnit;
            this.setRawTextSize(attributes.mTextSize, true);
        }
        if (attributes.mTextLocales != null) {
            this.setTextLocales(attributes.mTextLocales);
        }
        if (attributes.mTypefaceIndex != -1 && !attributes.mFontFamilyExplicit) {
            attributes.mFontFamily = null;
        }
        this.setTypefaceFromAttrs(attributes.mFontTypeface, attributes.mFontFamily, attributes.mTypefaceIndex, attributes.mTextStyle, attributes.mFontWeight);
        if (attributes.mShadowColor != 0) {
            this.setShadowLayer(attributes.mShadowRadius, attributes.mShadowDx, attributes.mShadowDy, attributes.mShadowColor);
        }
        if (attributes.mAllCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        }
        if (attributes.mHasElegant) {
            this.setElegantTextHeight(attributes.mElegant);
        }
        if (attributes.mHasFallbackLineSpacing) {
            this.setFallbackLineSpacing(attributes.mFallbackLineSpacing);
        }
        if (attributes.mHasLetterSpacing) {
            this.setLetterSpacing(attributes.mLetterSpacing);
        }
        if (attributes.mFontFeatureSettings != null) {
            this.setFontFeatureSettings(attributes.mFontFeatureSettings);
        }
        if (attributes.mFontVariationSettings != null) {
            this.setFontVariationSettings(attributes.mFontVariationSettings);
        }
        if (attributes.mHasLineBreakStyle || attributes.mHasLineBreakWordStyle) {
            this.updateLineBreakConfigFromTextAppearance(attributes.mHasLineBreakStyle, attributes.mHasLineBreakWordStyle, attributes.mLineBreakStyle, attributes.mLineBreakWordStyle);
        }
    }

    private void updateLineBreakConfigFromTextAppearance(boolean isLineBreakStyleSpecified, boolean isLineBreakWordStyleSpecified, int lineBreakStyle, int lineBreakWordStyle) {
        boolean updated = false;
        if (isLineBreakStyleSpecified && this.mLineBreakStyle != lineBreakStyle) {
            this.mLineBreakStyle = lineBreakStyle;
            updated = true;
        }
        if (isLineBreakWordStyleSpecified && this.mLineBreakWordStyle != lineBreakWordStyle) {
            this.mLineBreakWordStyle = lineBreakWordStyle;
            updated = true;
        }
        if (updated && this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public Locale getTextLocale() {
        return this.mTextPaint.getTextLocale();
    }

    public LocaleList getTextLocales() {
        return this.mTextPaint.getTextLocales();
    }

    private void changeListenerLocaleTo(Locale locale) {
        if (this.mListenerChanged) {
            return;
        }
        if (this.mEditor != null) {
            KeyListener listener = this.mEditor.mKeyListener;
            if (listener instanceof DigitsKeyListener) {
                listener = DigitsKeyListener.getInstance(locale, (DigitsKeyListener)listener);
            } else if (listener instanceof DateKeyListener) {
                listener = DateKeyListener.getInstance(locale);
            } else if (listener instanceof TimeKeyListener) {
                listener = TimeKeyListener.getInstance(locale);
            } else if (listener instanceof DateTimeKeyListener) {
                listener = DateTimeKeyListener.getInstance(locale);
            } else {
                return;
            }
            boolean wasPasswordType = TextView.isPasswordInputType(this.mEditor.mInputType);
            this.setKeyListenerOnly(listener);
            this.setInputTypeFromEditor();
            if (wasPasswordType) {
                int newInputClass = this.mEditor.mInputType & 0xF;
                if (newInputClass == 1) {
                    this.mEditor.mInputType |= 0x80;
                } else if (newInputClass == 2) {
                    this.mEditor.mInputType |= 0x10;
                }
            }
        }
    }

    public void setTextLocale(Locale locale) {
        this.mLocalesChanged = true;
        this.mTextPaint.setTextLocale(locale);
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTextLocales(LocaleList locales) {
        this.mLocalesChanged = true;
        this.mTextPaint.setTextLocales(locales);
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!this.mLocalesChanged) {
            this.mTextPaint.setTextLocales(LocaleList.getDefault());
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
        if (this.mFontWeightAdjustment != newConfig.fontWeightAdjustment) {
            this.mFontWeightAdjustment = newConfig.fontWeightAdjustment;
            this.setTypeface(this.getTypeface());
        }
    }

    @ViewDebug.ExportedProperty(category="text")
    public float getTextSize() {
        return this.mTextPaint.getTextSize();
    }

    @ViewDebug.ExportedProperty(category="text")
    public float getScaledTextSize() {
        return this.mTextPaint.getTextSize() / this.mTextPaint.density;
    }

    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="NORMAL"), @ViewDebug.IntToString(from=1, to="BOLD"), @ViewDebug.IntToString(from=2, to="ITALIC"), @ViewDebug.IntToString(from=3, to="BOLD_ITALIC")})
    public int getTypefaceStyle() {
        Typeface typeface = this.mTextPaint.getTypeface();
        return typeface != null ? typeface.getStyle() : 0;
    }

    @RemotableViewMethod
    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        if (!this.isAutoSizeEnabled()) {
            this.setTextSizeInternal(unit, size, true);
        }
    }

    private DisplayMetrics getDisplayMetricsOrSystem() {
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        return r.getDisplayMetrics();
    }

    private void setTextSizeInternal(int unit, float size, boolean shouldRequestLayout) {
        this.mTextSizeUnit = unit;
        this.setRawTextSize(TypedValue.applyDimension(unit, size, this.getDisplayMetricsOrSystem()), shouldRequestLayout);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void setRawTextSize(float size, boolean shouldRequestLayout) {
        if (size != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(size);
            this.maybeRecalculateLineHeight();
            if (shouldRequestLayout && this.mLayout != null) {
                this.mNeedsAutoSizeText = false;
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public int getTextSizeUnit() {
        return this.mTextSizeUnit;
    }

    public float getTextScaleX() {
        return this.mTextPaint.getTextScaleX();
    }

    @RemotableViewMethod
    public void setTextScaleX(float size) {
        if (size != this.mTextPaint.getTextScaleX()) {
            this.mUserSetTextScaleX = true;
            this.mTextPaint.setTextScaleX(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setTypeface(Typeface tf) {
        this.mOriginalTypeface = tf;
        if (this.mFontWeightAdjustment != 0 && this.mFontWeightAdjustment != Integer.MAX_VALUE) {
            if (tf == null) {
                tf = Typeface.DEFAULT;
            } else {
                int newWeight = Math.min(Math.max(tf.getWeight() + this.mFontWeightAdjustment, 1), 1000);
                int typefaceStyle = tf != null ? tf.getStyle() : 0;
                boolean italic = (typefaceStyle & 2) != 0;
                tf = Typeface.create(tf, newWeight, italic);
            }
        }
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public Typeface getTypeface() {
        return this.mOriginalTypeface;
    }

    public void setElegantTextHeight(boolean elegant) {
        if (elegant != this.mTextPaint.isElegantTextHeight()) {
            this.mTextPaint.setElegantTextHeight(elegant);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setFallbackLineSpacing(boolean enabled) {
        int fallbackStrategy = enabled ? (CompatChanges.isChangeEnabled(210923482L) ? 2 : 1) : 0;
        if (this.mUseFallbackLineSpacing != fallbackStrategy) {
            this.mUseFallbackLineSpacing = fallbackStrategy;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public boolean isFallbackLineSpacing() {
        return this.mUseFallbackLineSpacing != 0;
    }

    private boolean isFallbackLineSpacingForBoringLayout() {
        return this.mUseFallbackLineSpacing == 2;
    }

    boolean isFallbackLineSpacingForStaticLayout() {
        return this.mUseFallbackLineSpacing == 2 || this.mUseFallbackLineSpacing == 1;
    }

    public boolean isElegantTextHeight() {
        return this.mTextPaint.isElegantTextHeight();
    }

    public float getLetterSpacing() {
        return this.mTextPaint.getLetterSpacing();
    }

    @RemotableViewMethod
    public void setLetterSpacing(float letterSpacing) {
        if (letterSpacing != this.mTextPaint.getLetterSpacing()) {
            this.mTextPaint.setLetterSpacing(letterSpacing);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public String getFontFeatureSettings() {
        return this.mTextPaint.getFontFeatureSettings();
    }

    public String getFontVariationSettings() {
        return this.mTextPaint.getFontVariationSettings();
    }

    public void setBreakStrategy(int breakStrategy) {
        this.mBreakStrategy = breakStrategy;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getBreakStrategy() {
        return this.mBreakStrategy;
    }

    public void setHyphenationFrequency(int hyphenationFrequency) {
        this.mHyphenationFrequency = hyphenationFrequency;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getHyphenationFrequency() {
        return this.mHyphenationFrequency;
    }

    public void setLineBreakStyle(int lineBreakStyle) {
        if (this.mLineBreakStyle != lineBreakStyle) {
            this.mLineBreakStyle = lineBreakStyle;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setLineBreakWordStyle(int lineBreakWordStyle) {
        this.mUserSpeficiedLineBreakwordStyle = true;
        if (this.mLineBreakWordStyle != lineBreakWordStyle) {
            this.mLineBreakWordStyle = lineBreakWordStyle;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public int getLineBreakStyle() {
        return this.mLineBreakStyle;
    }

    public int getLineBreakWordStyle() {
        return this.mLineBreakWordStyle;
    }

    public PrecomputedText.Params getTextMetricsParams() {
        boolean autoPhraseBreaking = !this.mUserSpeficiedLineBreakwordStyle && FeatureFlagUtils.isEnabled(this.mContext, "settings_auto_text_wrapping");
        return new PrecomputedText.Params(new TextPaint(this.mTextPaint), LineBreakConfig.getLineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle, autoPhraseBreaking), this.getTextDirectionHeuristic(), this.mBreakStrategy, this.mHyphenationFrequency);
    }

    public void setTextMetricsParams(PrecomputedText.Params params) {
        this.mTextPaint.set(params.getTextPaint());
        this.mUserSetTextScaleX = true;
        this.mTextDir = params.getTextDirection();
        this.mBreakStrategy = params.getBreakStrategy();
        this.mHyphenationFrequency = params.getHyphenationFrequency();
        LineBreakConfig lineBreakConfig = params.getLineBreakConfig();
        this.mLineBreakStyle = lineBreakConfig.getLineBreakStyle();
        this.mLineBreakWordStyle = lineBreakConfig.getLineBreakWordStyle();
        this.mUserSpeficiedLineBreakwordStyle = true;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setJustificationMode(int justificationMode) {
        this.mJustificationMode = justificationMode;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getJustificationMode() {
        return this.mJustificationMode;
    }

    @RemotableViewMethod
    public void setFontFeatureSettings(String fontFeatureSettings) {
        if (fontFeatureSettings != this.mTextPaint.getFontFeatureSettings()) {
            this.mTextPaint.setFontFeatureSettings(fontFeatureSettings);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public boolean setFontVariationSettings(String fontVariationSettings) {
        String existingSettings = this.mTextPaint.getFontVariationSettings();
        if (fontVariationSettings == existingSettings || fontVariationSettings != null && fontVariationSettings.equals(existingSettings)) {
            return true;
        }
        boolean effective = this.mTextPaint.setFontVariationSettings(fontVariationSettings);
        if (effective && this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
        return effective;
    }

    @RemotableViewMethod
    public void setTextColor(int color2) {
        this.mTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    @RemotableViewMethod
    public void setTextColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mTextColor = colors;
        this.updateTextColors();
    }

    public ColorStateList getTextColors() {
        return this.mTextColor;
    }

    public int getCurrentTextColor() {
        return this.mCurTextColor;
    }

    @RemotableViewMethod
    public void setHighlightColor(int color2) {
        if (this.mHighlightColor != color2) {
            this.mHighlightColor = color2;
            this.invalidate();
        }
    }

    public int getHighlightColor() {
        return this.mHighlightColor;
    }

    @RemotableViewMethod
    public void setShowSoftInputOnFocus(boolean show) {
        this.createEditorIfNeeded();
        this.mEditor.mShowSoftInputOnFocus = show;
    }

    public boolean getShowSoftInputOnFocus() {
        return this.mEditor == null || this.mEditor.mShowSoftInputOnFocus;
    }

    public void setShadowLayer(float radius, float dx, float dy, int color2) {
        this.mTextPaint.setShadowLayer(radius, dx, dy, color2);
        this.mShadowRadius = radius;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        this.mShadowColor = color2;
        if (this.mEditor != null) {
            this.mEditor.invalidateTextDisplayList();
            this.mEditor.invalidateHandlesAndActionMode();
        }
        this.invalidate();
    }

    public float getShadowRadius() {
        return this.mShadowRadius;
    }

    public float getShadowDx() {
        return this.mShadowDx;
    }

    public float getShadowDy() {
        return this.mShadowDy;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public TextPaint getPaint() {
        return this.mTextPaint;
    }

    @RemotableViewMethod
    public void setAutoLinkMask(int mask) {
        this.mAutoLinkMask = mask;
    }

    @RemotableViewMethod
    public void setLinksClickable(boolean whether) {
        this.mLinksClickable = whether;
    }

    public boolean getLinksClickable() {
        return this.mLinksClickable;
    }

    public URLSpan[] getUrls() {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpans(0, this.mText.length(), URLSpan.class);
        }
        return new URLSpan[0];
    }

    @RemotableViewMethod
    public void setHintTextColor(int color2) {
        this.mHintTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public void setHintTextColor(ColorStateList colors) {
        this.mHintTextColor = colors;
        this.updateTextColors();
    }

    public ColorStateList getHintTextColors() {
        return this.mHintTextColor;
    }

    public int getCurrentHintTextColor() {
        return this.mHintTextColor != null ? this.mCurHintTextColor : this.mCurTextColor;
    }

    @RemotableViewMethod
    public void setLinkTextColor(int color2) {
        this.mLinkTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public void setLinkTextColor(ColorStateList colors) {
        this.mLinkTextColor = colors;
        this.updateTextColors();
    }

    public ColorStateList getLinkTextColors() {
        return this.mLinkTextColor;
    }

    @RemotableViewMethod
    public void setGravity(int gravity) {
        if ((gravity & 0x800007) == 0) {
            gravity |= 0x800003;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        boolean newLayout = false;
        if ((gravity & 0x800007) != (this.mGravity & 0x800007)) {
            newLayout = true;
        }
        if (gravity != this.mGravity) {
            this.invalidate();
        }
        this.mGravity = gravity;
        if (this.mLayout != null && newLayout) {
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), true);
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    public int getPaintFlags() {
        return this.mTextPaint.getFlags();
    }

    @RemotableViewMethod
    public void setPaintFlags(int flags) {
        if (this.mTextPaint.getFlags() != flags) {
            this.mTextPaint.setFlags(flags);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setHorizontallyScrolling(boolean whether) {
        if (this.mHorizontallyScrolling != whether) {
            this.mHorizontallyScrolling = whether;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public boolean isHorizontallyScrollable() {
        return this.mHorizontallyScrolling;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean getHorizontallyScrolling() {
        return this.mHorizontallyScrolling;
    }

    @RemotableViewMethod
    public void setMinLines(int minLines) {
        this.mMinimum = minLines;
        this.mMinMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinLines() {
        return this.mMinMode == 1 ? this.mMinimum : -1;
    }

    @RemotableViewMethod
    public void setMinHeight(int minPixels) {
        this.mMinimum = minPixels;
        this.mMinMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinHeight() {
        return this.mMinMode == 2 ? this.mMinimum : -1;
    }

    @RemotableViewMethod
    public void setMaxLines(int maxLines) {
        this.mMaximum = maxLines;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxLines() {
        return this.mMaxMode == 1 ? this.mMaximum : -1;
    }

    @RemotableViewMethod
    public void setMaxHeight(int maxPixels) {
        this.mMaximum = maxPixels;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxHeight() {
        return this.mMaxMode == 2 ? this.mMaximum : -1;
    }

    @RemotableViewMethod
    public void setLines(int lines) {
        this.mMaximum = this.mMinimum = lines;
        this.mMinMode = 1;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setHeight(int pixels) {
        this.mMaximum = this.mMinimum = pixels;
        this.mMinMode = 2;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinEms(int minEms) {
        this.mMinWidth = minEms;
        this.mMinWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinEms() {
        return this.mMinWidthMode == 1 ? this.mMinWidth : -1;
    }

    @RemotableViewMethod
    public void setMinWidth(int minPixels) {
        this.mMinWidth = minPixels;
        this.mMinWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinWidth() {
        return this.mMinWidthMode == 2 ? this.mMinWidth : -1;
    }

    @RemotableViewMethod
    public void setMaxEms(int maxEms) {
        this.mMaxWidth = maxEms;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxEms() {
        return this.mMaxWidthMode == 1 ? this.mMaxWidth : -1;
    }

    @RemotableViewMethod
    public void setMaxWidth(int maxPixels) {
        this.mMaxWidth = maxPixels;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxWidth() {
        return this.mMaxWidthMode == 2 ? this.mMaxWidth : -1;
    }

    @RemotableViewMethod
    public void setEms(int ems) {
        this.mMaxWidth = this.mMinWidth = ems;
        this.mMinWidthMode = 1;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setWidth(int pixels) {
        this.mMaxWidth = this.mMinWidth = pixels;
        this.mMinWidthMode = 2;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public void setLineSpacing(float add, float mult) {
        if (this.mSpacingAdd != add || this.mSpacingMult != mult) {
            this.mSpacingAdd = add;
            this.mSpacingMult = mult;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public float getLineSpacingMultiplier() {
        return this.mSpacingMult;
    }

    public float getLineSpacingExtra() {
        return this.mSpacingAdd;
    }

    @RemotableViewMethod
    public void setLineHeight(int lineHeight) {
        this.setLineHeightPx(lineHeight);
    }

    private void setLineHeightPx(float lineHeight) {
        Preconditions.checkArgumentNonNegative(lineHeight, "Expecting non-negative lineHeight while the input is " + lineHeight);
        int fontHeight = this.getPaint().getFontMetricsInt(null);
        if (lineHeight != (float)fontHeight) {
            this.setLineSpacing(lineHeight - (float)fontHeight, 1.0f);
            this.mLineHeightComplexDimen = TypedValue.createComplexDimension(lineHeight, 0);
        }
    }

    @RemotableViewMethod
    public void setLineHeight(int unit, float lineHeight) {
        DisplayMetrics metrics = this.getDisplayMetricsOrSystem();
        if (!FontScaleConverterFactory.isNonLinearFontScalingActive(this.getResources().getConfiguration().fontScale) || unit != 2 || this.mTextSizeUnit != 2) {
            this.setLineHeightPx(TypedValue.applyDimension(unit, lineHeight, metrics));
            this.mLineHeightComplexDimen = TypedValue.createComplexDimension(lineHeight, unit);
            return;
        }
        float textSizePx = this.getTextSize();
        float textSizeSp = TypedValue.convertPixelsToDimension(2, textSizePx, metrics);
        float ratio = lineHeight / textSizeSp;
        this.setLineHeightPx(textSizePx * ratio);
        this.mLineHeightComplexDimen = TypedValue.createComplexDimension(lineHeight, unit);
    }

    private void maybeRecalculateLineHeight() {
        if (this.mLineHeightComplexDimen == 0) {
            return;
        }
        int unit = TypedValue.getUnitFromComplexDimension(this.mLineHeightComplexDimen);
        if (unit != 2) {
            return;
        }
        this.setLineHeight(unit, TypedValue.complexToFloat(this.mLineHeightComplexDimen));
    }

    public void setHighlights(Highlights highlights) {
        this.mHighlights = highlights;
        this.mHighlightPathsBogus = true;
        this.invalidate();
    }

    public Highlights getHighlights() {
        return this.mHighlights;
    }

    public void setSearchResultHighlights(int ... ranges) {
        if (ranges == null) {
            this.mSearchResultHighlights = null;
            this.mHighlightPathsBogus = true;
            return;
        }
        if (ranges.length % 2 == 1) {
            throw new IllegalArgumentException("Flatten ranges must have even numbered elements");
        }
        for (int j = 0; j < ranges.length / 2; ++j) {
            int start = ranges[j * 2];
            int end = ranges[j * 2 + 1];
            if (start <= end) continue;
            throw new IllegalArgumentException("Reverse range found in the flatten range: " + start + ", " + end + " at " + j + "-th range");
        }
        this.mHighlightPathsBogus = true;
        this.mSearchResultHighlights = ranges;
        this.mFocusedSearchResultIndex = -1;
        this.invalidate();
    }

    public int[] getSearchResultHighlights() {
        return this.mSearchResultHighlights;
    }

    public void setFocusedSearchResultIndex(int index) {
        if (this.mSearchResultHighlights == null) {
            throw new IllegalArgumentException("Search result range must be set beforehand.");
        }
        if (index < -1 || index >= this.mSearchResultHighlights.length / 2) {
            throw new IllegalArgumentException("Focused index(" + index + ") must be larger than -1 and less than range count(" + this.mSearchResultHighlights.length / 2 + ")");
        }
        this.mFocusedSearchResultIndex = index;
        this.mHighlightPathsBogus = true;
        this.invalidate();
    }

    public int getFocusedSearchResultIndex() {
        return this.mFocusedSearchResultIndex;
    }

    public void setSearchResultHighlightColor(int color2) {
        this.mSearchResultHighlightColor = color2;
    }

    public int getSearchResultHighlightColor() {
        return this.mSearchResultHighlightColor;
    }

    public void setFocusedSearchResultHighlightColor(int color2) {
        this.mFocusedSearchResultHighlightColor = color2;
    }

    public int getFocusedSearchResultHighlightColor() {
        return this.mFocusedSearchResultHighlightColor;
    }

    private void setSelectGesturePreviewHighlight(int start, int end) {
        this.setGesturePreviewHighlight(start, end, this.mHighlightColor);
    }

    private void setDeleteGesturePreviewHighlight(int start, int end) {
        int color2 = this.mTextColor.getDefaultColor();
        color2 = ColorUtils.setAlphaComponent(color2, (int)(0.2f * (float)Color.alpha(color2)));
        this.setGesturePreviewHighlight(start, end, color2);
    }

    private void setGesturePreviewHighlight(int start, int end, int color2) {
        this.mGesturePreviewHighlightStart = start;
        this.mGesturePreviewHighlightEnd = end;
        if (this.mGesturePreviewHighlightPaint == null) {
            this.mGesturePreviewHighlightPaint = new Paint();
            this.mGesturePreviewHighlightPaint.setStyle(Paint.Style.FILL);
        }
        this.mGesturePreviewHighlightPaint.setColor(color2);
        if (this.mEditor != null) {
            this.mEditor.hideCursorAndSpanControllers();
            this.mEditor.stopTextActionModeWithPreservingSelection();
        }
        this.mHighlightPathsBogus = true;
        this.invalidate();
    }

    private void clearGesturePreviewHighlight() {
        this.mGesturePreviewHighlightStart = -1;
        this.mGesturePreviewHighlightEnd = -1;
        this.mHighlightPathsBogus = true;
        this.invalidate();
    }

    boolean hasGesturePreviewHighlight() {
        return this.mGesturePreviewHighlightStart >= 0;
    }

    public void append(CharSequence text) {
        this.append(text, 0, text.length());
    }

    public void append(CharSequence text, int start, int end) {
        boolean linksWereAdded;
        if (!(this.mText instanceof Editable)) {
            this.setText(this.mText, BufferType.EDITABLE);
        }
        ((Editable)this.mText).append(text, start, end);
        if (this.mAutoLinkMask != 0 && (linksWereAdded = Linkify.addLinks(this.mSpannable, this.mAutoLinkMask)) && this.mLinksClickable && !this.textCanBeSelected()) {
            this.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private void updateTextColors() {
        boolean inval = false;
        int[] drawableState = this.getDrawableState();
        int color2 = this.mTextColor.getColorForState(drawableState, 0);
        if (color2 != this.mCurTextColor) {
            this.mCurTextColor = color2;
            inval = true;
        }
        if (this.mLinkTextColor != null && (color2 = this.mLinkTextColor.getColorForState(drawableState, 0)) != this.mTextPaint.linkColor) {
            this.mTextPaint.linkColor = color2;
            inval = true;
        }
        if (this.mHintTextColor != null && (color2 = this.mHintTextColor.getColorForState(drawableState, 0)) != this.mCurHintTextColor) {
            this.mCurHintTextColor = color2;
            if (this.mText.length() == 0) {
                inval = true;
            }
        }
        if (inval) {
            if (this.mEditor != null) {
                this.mEditor.invalidateTextDisplayList();
            }
            this.invalidate();
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mTextColor != null && this.mTextColor.isStateful() || this.mHintTextColor != null && this.mHintTextColor.isStateful() || this.mLinkTextColor != null && this.mLinkTextColor.isStateful()) {
            this.updateTextColors();
        }
        if (this.mDrawables != null) {
            int[] state = this.getDrawableState();
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null || !dr.isStateful() || !dr.setState(state)) continue;
                this.invalidateDrawable(dr);
            }
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mDrawables != null) {
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null) continue;
                dr.setHotspot(x, y);
            }
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        boolean freezesText = this.getFreezesText();
        boolean hasSelection = false;
        int start = -1;
        int end = -1;
        if (this.mText != null) {
            start = this.getSelectionStart();
            end = this.getSelectionEnd();
            if (start >= 0 || end >= 0) {
                hasSelection = true;
            }
        }
        if (freezesText || hasSelection) {
            SavedState ss = new SavedState(superState);
            if (freezesText) {
                if (this.mText instanceof Spanned) {
                    SpannableStringBuilder sp = new SpannableStringBuilder(this.mText);
                    if (this.mEditor != null) {
                        this.removeMisspelledSpans(sp);
                        sp.removeSpan(this.mEditor.mSuggestionRangeSpan);
                    }
                    ss.text = sp;
                } else {
                    ss.text = this.mText.toString();
                }
            }
            if (hasSelection) {
                ss.selStart = start;
                ss.selEnd = end;
            }
            if (this.isFocused() && start >= 0 && end >= 0) {
                ss.frozenWithFocus = true;
            }
            ss.error = this.getError();
            if (this.mEditor != null) {
                ss.editorState = this.mEditor.saveInstanceState();
            }
            return ss;
        }
        return superState;
    }

    void removeMisspelledSpans(Spannable spannable) {
        SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            int flags = suggestionSpans[i].getFlags();
            if ((flags & 1) == 0 || (flags & 2) == 0) continue;
            spannable.removeSpan(suggestionSpans[i]);
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.text != null) {
            this.setText(ss.text);
        }
        if (ss.selStart >= 0 && ss.selEnd >= 0 && this.mSpannable != null) {
            int len = this.mText.length();
            if (ss.selStart > len || ss.selEnd > len) {
                String restored = "";
                if (ss.text != null) {
                    restored = "(restored) ";
                }
                Log.e(LOG_TAG, "Saved cursor position " + ss.selStart + "/" + ss.selEnd + " out of range for " + restored + "text " + this.mText);
            } else {
                Selection.setSelection(this.mSpannable, ss.selStart, ss.selEnd);
                if (ss.frozenWithFocus) {
                    this.createEditorIfNeeded();
                    this.mEditor.mFrozenWithFocus = true;
                }
            }
        }
        if (ss.error != null) {
            final CharSequence error = ss.error;
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (TextView.this.mEditor == null || !TextView.this.mEditor.mErrorWasChanged) {
                        TextView.this.setError(error);
                    }
                }
            });
        }
        if (ss.editorState != null) {
            this.createEditorIfNeeded();
            this.mEditor.restoreInstanceState(ss.editorState);
        }
    }

    @RemotableViewMethod
    public void setFreezesText(boolean freezesText) {
        this.mFreezesText = freezesText;
    }

    public boolean getFreezesText() {
        return this.mFreezesText;
    }

    public void setEditableFactory(Editable.Factory factory) {
        this.mEditableFactory = factory;
        this.setText(this.mText);
    }

    public void setSpannableFactory(Spannable.Factory factory) {
        this.mSpannableFactory = factory;
        this.setText(this.mText);
    }

    @RemotableViewMethod
    public void setText(CharSequence text) {
        this.setText(text, this.mBufferType);
    }

    @RemotableViewMethod
    public void setTextKeepState(CharSequence text) {
        this.setTextKeepState(text, this.mBufferType);
    }

    public void setText(CharSequence text, BufferType type) {
        this.setText(text, type, true, 0);
        this.mCharWrapper = null;
    }

    @UnsupportedAppUsage
    private void setText(CharSequence text, BufferType type, boolean notifyBefore, int oldlen) {
        Spannable s2;
        PrecomputedText precomputed;
        this.mTextSetFromXmlOrResourceId = false;
        if (text == null) {
            text = "";
        }
        if (!this.isSuggestionsEnabled()) {
            text = this.removeSuggestionSpans(text);
        }
        if (!this.mUserSetTextScaleX) {
            this.mTextPaint.setTextScaleX(1.0f);
        }
        if (text instanceof Spanned && ((Spanned)text).getSpanStart((Object)TextUtils.TruncateAt.MARQUEE) >= 0) {
            if (ViewConfiguration.get(this.mContext).isFadingMarqueeEnabled()) {
                this.setHorizontalFadingEdgeEnabled(true);
                this.mMarqueeFadeMode = 0;
            } else {
                this.setHorizontalFadingEdgeEnabled(false);
                this.mMarqueeFadeMode = 1;
            }
            this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        }
        int n = this.mFilters.length;
        for (int i = 0; i < n; ++i) {
            CharSequence out = this.mFilters[i].filter(text, 0, text.length(), EMPTY_SPANNED, 0, 0);
            if (out == null) continue;
            text = out;
        }
        if (notifyBefore) {
            if (this.mText != null) {
                oldlen = this.mText.length();
                this.sendBeforeTextChanged(this.mText, 0, oldlen, text.length());
            } else {
                this.sendBeforeTextChanged("", 0, 0, text.length());
            }
        }
        boolean needEditableForNotification = false;
        if (this.mListeners != null && this.mListeners.size() != 0) {
            needEditableForNotification = true;
        }
        PrecomputedText precomputedText = precomputed = text instanceof PrecomputedText ? (PrecomputedText)text : null;
        if (type == BufferType.EDITABLE || this.getKeyListener() != null || needEditableForNotification) {
            this.createEditorIfNeeded();
            this.mEditor.forgetUndoRedo();
            this.mEditor.scheduleRestartInputForSetText();
            Editable t = this.mEditableFactory.newEditable(text);
            text = t;
            this.setFilters(t, this.mFilters);
        } else if (precomputed != null) {
            if (this.mTextDir == null) {
                this.mTextDir = this.getTextDirectionHeuristic();
            }
            boolean autoPhraseBreaking = !this.mUserSpeficiedLineBreakwordStyle && FeatureFlagUtils.isEnabled(this.mContext, "settings_auto_text_wrapping");
            int checkResult = precomputed.getParams().checkResultUsable(this.getPaint(), this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency, LineBreakConfig.getLineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle, autoPhraseBreaking));
            switch (checkResult) {
                case 0: {
                    throw new IllegalArgumentException("PrecomputedText's Parameters don't match the parameters of this TextView.Consider using setTextMetricsParams(precomputedText.getParams()) to override the settings of this TextView: PrecomputedText: " + precomputed.getParams() + "TextView: " + this.getTextMetricsParams());
                }
                case 1: {
                    precomputed = PrecomputedText.create(precomputed, this.getTextMetricsParams());
                    break;
                }
            }
        } else if (type == BufferType.SPANNABLE || this.mMovement != null) {
            text = this.mSpannableFactory.newSpannable(text);
        } else if (!(text instanceof CharWrapper)) {
            text = TextUtils.stringOrSpannedString(text);
        }
        int a11yTextChangeType = 0;
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            a11yTextChangeType = AccessibilityUtils.textOrSpanChanged(text, this.mText);
        }
        if (this.mAutoLinkMask != 0 && Linkify.addLinks(s2 = type == BufferType.EDITABLE || text instanceof Spannable ? (Spannable)text : this.mSpannableFactory.newSpannable(text), this.mAutoLinkMask)) {
            text = s2;
            type = type == BufferType.EDITABLE ? BufferType.EDITABLE : BufferType.SPANNABLE;
            this.setTextInternal(text);
            if (a11yTextChangeType == 0) {
                a11yTextChangeType = 2;
            }
            if (this.mLinksClickable && !this.textCanBeSelected()) {
                this.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
        this.mBufferType = type;
        this.setTextInternal(text);
        this.mTransformed = this.mTransformation == null ? text : this.mTransformation.getTransformation(text, this);
        if (this.mTransformed == null) {
            this.mTransformed = "";
        }
        int textLength = text.length();
        boolean isOffsetMapping = this.mTransformed instanceof OffsetMapping;
        if (text instanceof Spannable && (!this.mAllowTransformationLengthChange || isOffsetMapping)) {
            Spannable sp = (Spannable)text;
            ChangeWatcher[] watchers = sp.getSpans(0, sp.length(), ChangeWatcher.class);
            int count = watchers.length;
            for (int i = 0; i < count; ++i) {
                sp.removeSpan(watchers[i]);
            }
            if (this.mChangeWatcher == null) {
                this.mChangeWatcher = new ChangeWatcher();
            }
            sp.setSpan(this.mChangeWatcher, 0, textLength, 6553618);
            if (this.mEditor != null) {
                this.mEditor.addSpanWatchers(sp);
            }
            if (this.mTransformation != null) {
                int priority = isOffsetMapping ? 200 : 0;
                sp.setSpan(this.mTransformation, 0, textLength, 0x12 | priority << 16);
            }
            if (this.mMovement != null) {
                this.mMovement.initialize(this, (Spannable)text);
                if (this.mEditor != null) {
                    this.mEditor.mSelectionMoved = false;
                }
            }
        }
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        this.sendOnTextChanged(text, 0, oldlen, textLength);
        this.onTextChanged(text, 0, oldlen, textLength);
        this.mHideHint = false;
        if (a11yTextChangeType == 1) {
            this.notifyViewAccessibilityStateChangedIfNeeded(2);
        } else if (a11yTextChangeType == 2) {
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
        }
        if (needEditableForNotification) {
            this.sendAfterTextChanged((Editable)text);
        } else {
            this.notifyListeningManagersAfterTextChanged();
        }
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
            this.mEditor.maybeFireScheduledRestartInputForSetText();
        }
    }

    public void setText(char[] text, int start, int len) {
        int oldlen = 0;
        if (start < 0 || len < 0 || start + len > text.length) {
            throw new IndexOutOfBoundsException(start + ", " + len);
        }
        if (this.mText != null) {
            oldlen = this.mText.length();
            this.sendBeforeTextChanged(this.mText, 0, oldlen, len);
        } else {
            this.sendBeforeTextChanged("", 0, 0, len);
        }
        if (this.mCharWrapper == null) {
            this.mCharWrapper = new CharWrapper(text, start, len);
        } else {
            this.mCharWrapper.set(text, start, len);
        }
        this.setText(this.mCharWrapper, this.mBufferType, false, oldlen);
    }

    public void setTextKeepState(CharSequence text, BufferType type) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        int len = text.length();
        this.setText(text, type);
        if ((start >= 0 || end >= 0) && this.mSpannable != null) {
            Selection.setSelection(this.mSpannable, Math.max(0, Math.min(start, len)), Math.max(0, Math.min(end, len)));
        }
    }

    @RemotableViewMethod
    public void setText(int resid) {
        this.setText(this.getContext().getResources().getText(resid));
        this.mTextSetFromXmlOrResourceId = true;
        this.mTextId = resid;
    }

    public void setText(int resid, BufferType type) {
        this.setText(this.getContext().getResources().getText(resid), type);
        this.mTextSetFromXmlOrResourceId = true;
        this.mTextId = resid;
    }

    @RemotableViewMethod
    public void setHint(CharSequence hint) {
        this.setHintInternal(hint);
        if (this.mEditor != null && this.isInputMethodTarget()) {
            this.mEditor.reportExtractedText();
        }
    }

    private void setHintInternal(CharSequence hint) {
        this.mHideHint = false;
        this.mHint = TextUtils.stringOrSpannedString(hint);
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        if (this.mText.length() == 0) {
            this.invalidate();
        }
        if (this.mEditor != null && this.mText.length() == 0 && this.mHint != null) {
            this.mEditor.invalidateTextDisplayList();
        }
    }

    @RemotableViewMethod
    public void setHint(int resid) {
        this.mHintId = resid;
        this.setHint(this.getContext().getResources().getText(resid));
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getHint() {
        return this.mHint;
    }

    public void hideHint() {
        if (this.isShowingHint()) {
            this.mHideHint = true;
            this.invalidate();
        }
    }

    public boolean isSingleLine() {
        return this.mSingleLine;
    }

    private static boolean isMultilineInputType(int type) {
        return (type & 0x2000F) == 131073;
    }

    CharSequence removeSuggestionSpans(CharSequence text) {
        if (text instanceof Spanned) {
            Spannable spannable = text instanceof Spannable ? (Spannable)text : this.mSpannableFactory.newSpannable(text);
            SuggestionSpan[] spans = spannable.getSpans(0, text.length(), SuggestionSpan.class);
            if (spans.length == 0) {
                return text;
            }
            text = spannable;
            for (int i = 0; i < spans.length; ++i) {
                spannable.removeSpan(spans[i]);
            }
        }
        return text;
    }

    public void setInputType(int type) {
        InputMethodManager imm;
        boolean singleLine;
        boolean wasPassword = TextView.isPasswordInputType(this.getInputType());
        boolean wasVisiblePassword = TextView.isVisiblePasswordInputType(this.getInputType());
        this.setInputType(type, false);
        boolean isPassword = TextView.isPasswordInputType(type);
        boolean isVisiblePassword = TextView.isVisiblePasswordInputType(type);
        boolean forceUpdate = false;
        if (isPassword) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            this.setTypefaceFromAttrs(null, null, 3, 0, -1);
        } else if (isVisiblePassword) {
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
            this.setTypefaceFromAttrs(null, null, 3, 0, -1);
        } else if (wasPassword || wasVisiblePassword) {
            this.setTypefaceFromAttrs(null, null, -1, 0, -1);
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
        }
        boolean bl = singleLine = !TextView.isMultilineInputType(type);
        if (this.mSingleLine != singleLine || forceUpdate) {
            this.applySingleLine(singleLine, !isPassword, true, true);
        }
        if (!this.isSuggestionsEnabled()) {
            this.setTextInternal(this.removeSuggestionSpans(this.mText));
        }
        if ((imm = this.getInputMethodManager()) != null) {
            imm.restartInput(this);
        }
    }

    boolean hasPasswordTransformationMethod() {
        return this.mTransformation instanceof PasswordTransformationMethod;
    }

    public boolean isAnyPasswordInputType() {
        int inputType = this.getInputType();
        return TextView.isPasswordInputType(inputType) || TextView.isVisiblePasswordInputType(inputType);
    }

    static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private static boolean isVisiblePasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 145;
    }

    public void setRawInputType(int type) {
        if (type == 0 && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        this.mEditor.mInputType = type;
    }

    @Override
    public String[] getAutofillHints() {
        String[] hints = super.getAutofillHints();
        if (this.isAnyPasswordInputType() && !ArrayUtils.contains(hints, "passwordAuto")) {
            hints = ArrayUtils.appendElement(String.class, hints, "passwordAuto");
        }
        return hints;
    }

    private Locale getCustomLocaleForKeyListenerOrNull() {
        if (!this.mUseInternationalizedInput) {
            return null;
        }
        LocaleList locales = this.getImeHintLocales();
        if (locales == null) {
            return null;
        }
        return locales.get(0);
    }

    @UnsupportedAppUsage
    private void setInputType(int type, boolean direct) {
        BaseKeyListener input;
        int cls = type & 0xF;
        if (cls == 1) {
            boolean autotext;
            boolean bl = autotext = (type & 0x8000) != 0;
            TextKeyListener.Capitalize cap = (type & 0x1000) != 0 ? TextKeyListener.Capitalize.CHARACTERS : ((type & 0x2000) != 0 ? TextKeyListener.Capitalize.WORDS : ((type & 0x4000) != 0 ? TextKeyListener.Capitalize.SENTENCES : TextKeyListener.Capitalize.NONE));
            input = TextKeyListener.getInstance(autotext, cap);
        } else if (cls == 2) {
            int newType;
            int newClass;
            Locale locale = this.getCustomLocaleForKeyListenerOrNull();
            input = DigitsKeyListener.getInstance(locale, (type & 0x1000) != 0, (type & 0x2000) != 0);
            if (locale != null && (newClass = (newType = input.getInputType()) & 0xF) != 2) {
                if ((type & 0x10) != 0) {
                    newType |= 0x80;
                }
                type = newType;
            }
        } else if (cls == 4) {
            Locale locale = this.getCustomLocaleForKeyListenerOrNull();
            switch (type & 0xFF0) {
                case 16: {
                    input = DateKeyListener.getInstance(locale);
                    break;
                }
                case 32: {
                    input = TimeKeyListener.getInstance(locale);
                    break;
                }
                default: {
                    input = DateTimeKeyListener.getInstance(locale);
                }
            }
            if (this.mUseInternationalizedInput) {
                type = input.getInputType();
            }
        } else {
            input = cls == 3 ? DialerKeyListener.getInstance() : TextKeyListener.getInstance();
        }
        this.setRawInputType(type);
        this.mListenerChanged = false;
        if (direct) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = input;
        } else {
            this.setKeyListenerOnly(input);
        }
    }

    public int getInputType() {
        return this.mEditor == null ? 0 : this.mEditor.mInputType;
    }

    public void setImeOptions(int imeOptions) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeOptions = imeOptions;
    }

    public int getImeOptions() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeOptions : 0;
    }

    public void setImeActionLabel(CharSequence label, int actionId) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeActionLabel = label;
        this.mEditor.mInputContentType.imeActionId = actionId;
    }

    public CharSequence getImeActionLabel() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeActionLabel : null;
    }

    public int getImeActionId() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeActionId : 0;
    }

    public void setOnEditorActionListener(OnEditorActionListener l) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.onEditorActionListener = l;
    }

    public void onEditorAction(int actionCode) {
        ViewRootImpl viewRootImpl;
        Editor.InputContentType ict;
        Editor.InputContentType inputContentType = ict = this.mEditor == null ? null : this.mEditor.mInputContentType;
        if (ict != null) {
            if (ict.onEditorActionListener != null && ict.onEditorActionListener.onEditorAction(this, actionCode, null)) {
                return;
            }
            if (actionCode == 5) {
                View v = this.focusSearch(2);
                if (v != null && !v.requestFocus(2)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 7) {
                View v = this.focusSearch(1);
                if (v != null && !v.requestFocus(1)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 6) {
                InputMethodManager imm = this.getInputMethodManager();
                if (imm != null && imm.isActive(this)) {
                    imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                }
                return;
            }
        }
        if ((viewRootImpl = this.getViewRootImpl()) != null) {
            long eventTime = SystemClock.uptimeMillis();
            viewRootImpl.dispatchKeyFromIme(new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, -1, 0, 22));
            viewRootImpl.dispatchKeyFromIme(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, -1, 0, 22));
        }
    }

    public void setPrivateImeOptions(String type) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.privateImeOptions = type;
    }

    public String getPrivateImeOptions() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.privateImeOptions : null;
    }

    public void setInputExtras(int xmlResId) throws XmlPullParserException, IOException {
        this.createEditorIfNeeded();
        XmlResourceParser parser = this.getResources().getXml(xmlResId);
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.extras = new Bundle();
        this.getResources().parseBundleExtras(parser, this.mEditor.mInputContentType.extras);
    }

    public Bundle getInputExtras(boolean create) {
        if (this.mEditor == null && !create) {
            return null;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mInputContentType == null) {
            if (!create) {
                return null;
            }
            this.mEditor.createInputContentTypeIfNeeded();
        }
        if (this.mEditor.mInputContentType.extras == null) {
            if (!create) {
                return null;
            }
            this.mEditor.mInputContentType.extras = new Bundle();
        }
        return this.mEditor.mInputContentType.extras;
    }

    public void setImeHintLocales(LocaleList hintLocales) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeHintLocales = hintLocales;
        if (this.mUseInternationalizedInput) {
            this.changeListenerLocaleTo(hintLocales == null ? null : hintLocales.get(0));
        }
    }

    public LocaleList getImeHintLocales() {
        if (this.mEditor == null) {
            return null;
        }
        if (this.mEditor.mInputContentType == null) {
            return null;
        }
        return this.mEditor.mInputContentType.imeHintLocales;
    }

    public CharSequence getError() {
        return this.mEditor == null ? null : this.mEditor.mError;
    }

    @RemotableViewMethod
    public void setError(CharSequence error) {
        if (error == null) {
            this.setError(null, null);
        } else {
            Drawable dr = this.getContext().getDrawable(17302930);
            dr.setBounds(0, 0, dr.getIntrinsicWidth(), dr.getIntrinsicHeight());
            this.setError(error, dr);
        }
    }

    public void setError(CharSequence error, Drawable icon) {
        this.createEditorIfNeeded();
        this.mEditor.setError(error, icon);
        this.notifyViewAccessibilityStateChangedIfNeeded(3072);
    }

    @Override
    protected boolean setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.mEditor != null) {
            this.mEditor.setFrame();
        }
        this.restartMarqueeIfNeeded();
        return result;
    }

    private void restartMarqueeIfNeeded() {
        if (this.mRestartMarquee && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            this.mRestartMarquee = false;
            this.startMarquee();
        }
    }

    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
        if (this.mText instanceof Editable) {
            this.setFilters((Editable)this.mText, filters);
        }
    }

    private void setFilters(Editable e, InputFilter[] filters) {
        if (this.mEditor != null) {
            boolean undoFilter = this.mEditor.mUndoInputFilter != null;
            boolean keyFilter = this.mEditor.mKeyListener instanceof InputFilter;
            int num = 0;
            if (undoFilter) {
                ++num;
            }
            if (keyFilter) {
                ++num;
            }
            if (num > 0) {
                InputFilter[] nf = new InputFilter[filters.length + num];
                System.arraycopy(filters, 0, nf, 0, filters.length);
                num = 0;
                if (undoFilter) {
                    nf[filters.length] = this.mEditor.mUndoInputFilter;
                    ++num;
                }
                if (keyFilter) {
                    nf[filters.length + num] = (InputFilter)((Object)this.mEditor.mKeyListener);
                }
                e.setFilters(nf);
                return;
            }
        }
        e.setFilters(filters);
    }

    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    private int getBoxHeight(Layout l) {
        Insets opticalInsets = TextView.isLayoutModeOptical(this.mParent) ? this.getOpticalInsets() : Insets.NONE;
        int padding = l == this.mHintLayout ? this.getCompoundPaddingTop() + this.getCompoundPaddingBottom() : this.getExtendedPaddingTop() + this.getExtendedPaddingBottom();
        return this.getMeasuredHeight() - padding + opticalInsets.top + opticalInsets.bottom;
    }

    @UnsupportedAppUsage
    int getVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 48) {
            int boxht = this.getBoxHeight(l);
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 80 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    private int getBottomVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 80) {
            int boxht = this.getBoxHeight(l);
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 48 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateCursorPath() {
        if (this.mHighlightPathBogus) {
            this.invalidateCursor();
        } else {
            int horizontalPadding = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (this.mEditor.mDrawableForCursor == null) {
                RectF rectF = TEMP_RECTF;
                synchronized (rectF) {
                    float thick = (float)Math.ceil(this.mTextPaint.getStrokeWidth());
                    if (thick < 1.0f) {
                        thick = 1.0f;
                    }
                    this.mHighlightPath.computeBounds(TEMP_RECTF, false);
                    this.invalidate((int)Math.floor((float)horizontalPadding + TextView.TEMP_RECTF.left - (thick /= 2.0f)), (int)Math.floor((float)verticalPadding + TextView.TEMP_RECTF.top - thick), (int)Math.ceil((float)horizontalPadding + TextView.TEMP_RECTF.right + thick), (int)Math.ceil((float)verticalPadding + TextView.TEMP_RECTF.bottom + thick));
                }
            } else {
                Rect bounds = this.mEditor.mDrawableForCursor.getBounds();
                this.invalidate(bounds.left + horizontalPadding, bounds.top + verticalPadding, bounds.right + horizontalPadding, bounds.bottom + verticalPadding);
            }
        }
    }

    void invalidateCursor() {
        int where = this.getSelectionEnd();
        this.invalidateCursor(where, where, where);
    }

    private void invalidateCursor(int a, int b, int c) {
        if (a >= 0 || b >= 0 || c >= 0) {
            int start = Math.min(Math.min(a, b), c);
            int end = Math.max(Math.max(a, b), c);
            this.invalidateRegion(start, end, true);
        }
    }

    void invalidateRegion(int start, int end, boolean invalidateCursor) {
        if (this.mLayout == null) {
            this.invalidate();
        } else {
            int right;
            int left;
            start = this.originalToTransformed(start, 1);
            end = this.originalToTransformed(end, 1);
            int lineStart = this.mLayout.getLineForOffset(start);
            int top = this.mLayout.getLineTop(lineStart);
            if (lineStart > 0) {
                top -= this.mLayout.getLineDescent(lineStart - 1);
            }
            int lineEnd = start == end ? lineStart : this.mLayout.getLineForOffset(end);
            int bottom = this.mLayout.getLineBottom(lineEnd);
            if (invalidateCursor && this.mEditor != null && this.mEditor.mDrawableForCursor != null) {
                Rect bounds = this.mEditor.mDrawableForCursor.getBounds();
                top = Math.min(top, bounds.top);
                bottom = Math.max(bottom, bounds.bottom);
            }
            int compoundPaddingLeft = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (lineStart == lineEnd && !invalidateCursor) {
                left = (int)this.mLayout.getPrimaryHorizontal(start);
                right = (int)((double)this.mLayout.getPrimaryHorizontal(end) + 1.0);
                left += compoundPaddingLeft;
                right += compoundPaddingLeft;
            } else {
                left = compoundPaddingLeft;
                right = this.getWidth() - this.getCompoundPaddingRight();
            }
            this.invalidate(this.mScrollX + left, verticalPadding + top, this.mScrollX + right, verticalPadding + bottom);
        }
    }

    private void registerForPreDraw() {
        if (!this.mPreDrawRegistered) {
            this.getViewTreeObserver().addOnPreDrawListener(this);
            this.mPreDrawRegistered = true;
        }
    }

    private void unregisterForPreDraw() {
        this.getViewTreeObserver().removeOnPreDrawListener(this);
        this.mPreDrawRegistered = false;
        this.mPreDrawListenerDetached = false;
    }

    @Override
    public boolean onPreDraw() {
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        if (this.mMovement != null) {
            int curs = this.getSelectionEnd();
            if (this.mEditor != null && this.mEditor.mSelectionModifierCursorController != null && this.mEditor.mSelectionModifierCursorController.isSelectionStartDragged()) {
                curs = this.getSelectionStart();
            }
            if (curs < 0 && (this.mGravity & 0x70) == 80) {
                curs = this.mText.length();
            }
            if (curs >= 0) {
                this.bringPointIntoView(curs);
            }
        } else {
            this.bringTextIntoView();
        }
        if (this.mEditor != null && this.mEditor.mCreatedWithASelection) {
            this.mEditor.refreshTextActionMode();
            this.mEditor.mCreatedWithASelection = false;
        }
        this.unregisterForPreDraw();
        return true;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mEditor != null) {
            this.mEditor.onAttachedToWindow();
        }
        if (this.mPreDrawListenerDetached) {
            this.getViewTreeObserver().addOnPreDrawListener(this);
            this.mPreDrawListenerDetached = false;
        }
    }

    @Override
    protected void onDetachedFromWindowInternal() {
        if (this.mPreDrawRegistered) {
            this.getViewTreeObserver().removeOnPreDrawListener(this);
            this.mPreDrawListenerDetached = true;
        }
        this.resetResolvedDrawables();
        if (this.mEditor != null) {
            this.mEditor.onDetachedFromWindow();
        }
        super.onDetachedFromWindowInternal();
    }

    @Override
    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        if (this.mEditor != null) {
            this.mEditor.onScreenStateChanged(screenState);
        }
    }

    @Override
    protected boolean isPaddingOffsetRequired() {
        return this.mShadowRadius != 0.0f || this.mDrawables != null;
    }

    @Override
    protected int getLeftPaddingOffset() {
        return this.getCompoundPaddingLeft() - this.mPaddingLeft + (int)Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
    }

    @Override
    protected int getTopPaddingOffset() {
        return (int)Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
    }

    @Override
    protected int getBottomPaddingOffset() {
        return (int)Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
    }

    @Override
    protected int getRightPaddingOffset() {
        return -(this.getCompoundPaddingRight() - this.mPaddingRight) + (int)Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        boolean verified = super.verifyDrawable(who);
        if (!verified && this.mDrawables != null) {
            for (Drawable dr : this.mDrawables.mShowing) {
                if (who != dr) continue;
                return true;
            }
        }
        return verified;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawables != null) {
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null) continue;
                dr.jumpToCurrentState();
            }
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        boolean handled = false;
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            Drawables drawables = this.mDrawables;
            if (drawables != null) {
                if (drawable2 == drawables.mShowing[0]) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mPaddingLeft;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightLeft) / 2;
                    handled = true;
                } else if (drawable2 == drawables.mShowing[2]) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mRight - this.mLeft - this.mPaddingRight - drawables.mDrawableSizeRight;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightRight) / 2;
                    handled = true;
                } else if (drawable2 == drawables.mShowing[1]) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthTop) / 2;
                    scrollY += this.mPaddingTop;
                    handled = true;
                } else if (drawable2 == drawables.mShowing[3]) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthBottom) / 2;
                    scrollY += this.mBottom - this.mTop - this.mPaddingBottom - drawables.mDrawableSizeBottom;
                    handled = true;
                }
            }
            if (handled) {
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            }
        }
        if (!handled) {
            super.invalidateDrawable(drawable2);
        }
    }

    @Override
    public boolean hasOverlappingRendering() {
        return this.getBackground() != null && this.getBackground().getCurrent() != null || this.mSpannable != null || this.hasSelection() || this.isHorizontalFadingEdgeEnabled() || this.mShadowColor != 0;
    }

    public boolean isTextSelectable() {
        return this.mEditor == null ? false : this.mEditor.mTextIsSelectable;
    }

    public void setTextIsSelectable(boolean selectable) {
        if (!selectable && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mTextIsSelectable == selectable) {
            return;
        }
        this.mEditor.mTextIsSelectable = selectable;
        this.setFocusableInTouchMode(selectable);
        this.setFocusable(16);
        this.setClickable(selectable);
        this.setLongClickable(selectable);
        this.setMovementMethod(selectable ? ArrowKeyMovementMethod.getInstance() : null);
        this.setText(this.mText, selectable ? BufferType.SPANNABLE : BufferType.NORMAL);
        this.mEditor.prepareCursorControllers();
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState;
        if (this.mSingleLine) {
            drawableState = super.onCreateDrawableState(extraSpace);
        } else {
            drawableState = super.onCreateDrawableState(extraSpace + 1);
            TextView.mergeDrawableStates(drawableState, MULTILINE_STATE_SET);
        }
        if (this.isTextSelectable()) {
            int length = drawableState.length;
            for (int i = 0; i < length; ++i) {
                if (drawableState[i] != 16842919) continue;
                int[] nonPressedState = new int[length - 1];
                System.arraycopy(drawableState, 0, nonPressedState, 0, i);
                System.arraycopy(drawableState, i + 1, nonPressedState, i, length - i - 1);
                return nonPressedState;
            }
        }
        return drawableState;
    }

    private void maybeUpdateHighlightPaths() {
        if (!this.mHighlightPathsBogus) {
            return;
        }
        if (this.mHighlightPaths != null) {
            this.mPathRecyclePool.addAll(this.mHighlightPaths);
            this.mHighlightPaths.clear();
            this.mHighlightPaints.clear();
        } else {
            this.mHighlightPaths = new ArrayList<Path>();
            this.mHighlightPaints = new ArrayList<Paint>();
        }
        if (this.mHighlights != null) {
            for (int i = 0; i < this.mHighlights.getSize(); ++i) {
                Path path;
                int[] ranges = this.mHighlights.getRanges(i);
                Paint paint = this.mHighlights.getPaint(i);
                if (this.mPathRecyclePool.isEmpty()) {
                    path = new Path();
                } else {
                    path = this.mPathRecyclePool.get(this.mPathRecyclePool.size() - 1);
                    this.mPathRecyclePool.remove(this.mPathRecyclePool.size() - 1);
                    path.reset();
                }
                boolean atLeastOnePathAdded = false;
                for (int j = 0; j < ranges.length / 2; ++j) {
                    int start = ranges[2 * j];
                    int end = ranges[2 * j + 1];
                    if (start >= end) continue;
                    this.mLayout.getSelection(start, end, (left, top, right, bottom, layout2) -> path.addRect(left, top, right, bottom, Path.Direction.CW));
                    atLeastOnePathAdded = true;
                }
                if (!atLeastOnePathAdded) continue;
                this.mHighlightPaths.add(path);
                this.mHighlightPaints.add(paint);
            }
        }
        this.addSearchHighlightPaths();
        if (this.hasGesturePreviewHighlight()) {
            Path path;
            if (this.mPathRecyclePool.isEmpty()) {
                path = new Path();
            } else {
                path = this.mPathRecyclePool.get(this.mPathRecyclePool.size() - 1);
                this.mPathRecyclePool.remove(this.mPathRecyclePool.size() - 1);
                path.reset();
            }
            this.mLayout.getSelectionPath(this.mGesturePreviewHighlightStart, this.mGesturePreviewHighlightEnd, path);
            this.mHighlightPaths.add(path);
            this.mHighlightPaints.add(this.mGesturePreviewHighlightPaint);
        }
        this.mHighlightPathsBogus = false;
    }

    private void addSearchHighlightPaths() {
        if (this.mSearchResultHighlights != null) {
            Path focusedSearchResultPath;
            Path searchResultPath;
            if (this.mPathRecyclePool.isEmpty()) {
                searchResultPath = new Path();
            } else {
                searchResultPath = this.mPathRecyclePool.get(this.mPathRecyclePool.size() - 1);
                this.mPathRecyclePool.remove(this.mPathRecyclePool.size() - 1);
                searchResultPath.reset();
            }
            if (this.mFocusedSearchResultIndex == -1) {
                focusedSearchResultPath = null;
            } else if (this.mPathRecyclePool.isEmpty()) {
                focusedSearchResultPath = new Path();
            } else {
                focusedSearchResultPath = this.mPathRecyclePool.get(this.mPathRecyclePool.size() - 1);
                this.mPathRecyclePool.remove(this.mPathRecyclePool.size() - 1);
                focusedSearchResultPath.reset();
            }
            boolean atLeastOnePathAdded = false;
            for (int j = 0; j < this.mSearchResultHighlights.length / 2; ++j) {
                int start = this.mSearchResultHighlights[2 * j];
                int end = this.mSearchResultHighlights[2 * j + 1];
                if (start >= end) continue;
                if (j == this.mFocusedSearchResultIndex) {
                    this.mLayout.getSelection(start, end, (left, top, right, bottom, layout2) -> focusedSearchResultPath.addRect(left, top, right, bottom, Path.Direction.CW));
                    continue;
                }
                this.mLayout.getSelection(start, end, (left, top, right, bottom, layout2) -> searchResultPath.addRect(left, top, right, bottom, Path.Direction.CW));
                atLeastOnePathAdded = true;
            }
            if (atLeastOnePathAdded) {
                if (this.mSearchResultHighlightPaint == null) {
                    this.mSearchResultHighlightPaint = new Paint();
                }
                this.mSearchResultHighlightPaint.setColor(this.mSearchResultHighlightColor);
                this.mSearchResultHighlightPaint.setStyle(Paint.Style.FILL);
                this.mHighlightPaths.add(searchResultPath);
                this.mHighlightPaints.add(this.mSearchResultHighlightPaint);
            }
            if (focusedSearchResultPath != null) {
                if (this.mFocusedSearchResultHighlightPaint == null) {
                    this.mFocusedSearchResultHighlightPaint = new Paint();
                }
                this.mFocusedSearchResultHighlightPaint.setColor(this.mFocusedSearchResultHighlightColor);
                this.mFocusedSearchResultHighlightPaint.setStyle(Paint.Style.FILL);
                this.mHighlightPaths.add(focusedSearchResultPath);
                this.mHighlightPaints.add(this.mFocusedSearchResultHighlightPaint);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Path getUpdatedHighlightPath() {
        Path highlight = null;
        Paint highlightPaint = this.mHighlightPaint;
        int selStart = this.getSelectionStartTransformed();
        int selEnd = this.getSelectionEndTransformed();
        if (this.mMovement != null && (this.isFocused() || this.isPressed()) && selStart >= 0) {
            if (selStart == selEnd) {
                if (this.mEditor != null && this.mEditor.shouldRenderCursor()) {
                    if (this.mHighlightPathBogus) {
                        if (this.mHighlightPath == null) {
                            this.mHighlightPath = new Path();
                        }
                        this.mHighlightPath.reset();
                        this.mLayout.getCursorPath(selStart, this.mHighlightPath, this.mText);
                        this.mEditor.updateCursorPosition();
                        this.mHighlightPathBogus = false;
                    }
                    highlightPaint.setColor(this.mCurTextColor);
                    highlightPaint.setStyle(Paint.Style.STROKE);
                    highlight = this.mHighlightPath;
                }
            } else {
                if (this.mHighlightPathBogus) {
                    if (this.mHighlightPath == null) {
                        this.mHighlightPath = new Path();
                    }
                    this.mHighlightPath.reset();
                    this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                    this.mHighlightPathBogus = false;
                }
                highlightPaint.setColor(this.mHighlightColor);
                highlightPaint.setStyle(Paint.Style.FILL);
                highlight = this.mHighlightPath;
            }
        }
        return highlight;
    }

    public int getHorizontalOffsetForDrawables() {
        return 0;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        Path highlight;
        float dx;
        this.restartMarqueeIfNeeded();
        super.onDraw(canvas);
        int compoundPaddingLeft = this.getCompoundPaddingLeft();
        int compoundPaddingTop = this.getCompoundPaddingTop();
        int compoundPaddingRight = this.getCompoundPaddingRight();
        int compoundPaddingBottom = this.getCompoundPaddingBottom();
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int right = this.mRight;
        int left = this.mLeft;
        int bottom = this.mBottom;
        int top = this.mTop;
        boolean isLayoutRtl = this.isLayoutRtl();
        int offset = this.getHorizontalOffsetForDrawables();
        int leftOffset = isLayoutRtl ? 0 : offset;
        int rightOffset = isLayoutRtl ? offset : 0;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            int vspace = bottom - top - compoundPaddingBottom - compoundPaddingTop;
            int hspace = right - left - compoundPaddingRight - compoundPaddingLeft;
            if (dr.mShowing[0] != null) {
                canvas.save();
                canvas.translate(scrollX + this.mPaddingLeft + leftOffset, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightLeft) / 2);
                dr.mShowing[0].draw(canvas);
                canvas.restore();
            }
            if (dr.mShowing[2] != null) {
                canvas.save();
                canvas.translate(scrollX + right - left - this.mPaddingRight - dr.mDrawableSizeRight - rightOffset, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightRight) / 2);
                dr.mShowing[2].draw(canvas);
                canvas.restore();
            }
            if (dr.mShowing[1] != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthTop) / 2, scrollY + this.mPaddingTop);
                dr.mShowing[1].draw(canvas);
                canvas.restore();
            }
            if (dr.mShowing[3] != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthBottom) / 2, scrollY + bottom - top - this.mPaddingBottom - dr.mDrawableSizeBottom);
                dr.mShowing[3].draw(canvas);
                canvas.restore();
            }
        }
        int color2 = this.mCurTextColor;
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        Layout layout2 = this.mLayout;
        if (this.mHint != null && !this.mHideHint && this.mText.length() == 0) {
            if (this.mHintTextColor != null) {
                color2 = this.mCurHintTextColor;
            }
            layout2 = this.mHintLayout;
        }
        this.mTextPaint.setColor(color2);
        this.mTextPaint.drawableState = this.getDrawableState();
        canvas.save();
        int extendedPaddingTop = this.getExtendedPaddingTop();
        int extendedPaddingBottom = this.getExtendedPaddingBottom();
        int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
        int maxScrollY = this.mLayout.getHeight() - vspace;
        float clipLeft = compoundPaddingLeft + scrollX;
        float clipTop = scrollY == 0 ? 0.0f : (float)(extendedPaddingTop + scrollY);
        float clipRight = right - left - this.getCompoundPaddingRight() + scrollX;
        float clipBottom = bottom - top + scrollY - (scrollY == maxScrollY ? 0 : extendedPaddingBottom);
        if (this.mShadowRadius != 0.0f) {
            clipLeft += Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
            clipRight += Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
            clipTop += Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
            clipBottom += Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
        }
        canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
        int voffsetText = 0;
        int voffsetCursor = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffsetText = this.getVerticalOffset(false);
            voffsetCursor = this.getVerticalOffset(true);
        }
        canvas.translate(compoundPaddingLeft, extendedPaddingTop + voffsetText);
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        if (this.isMarqueeFadeEnabled()) {
            if (!this.mSingleLine && this.getLineCount() == 1 && this.canMarquee() && (absoluteGravity & 7) != 3) {
                int width = this.mRight - this.mLeft;
                int padding = this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
                dx = this.mLayout.getLineRight(0) - (float)(width - padding);
                canvas.translate((float)layout2.getParagraphDirection(0) * dx, 0.0f);
            }
            if (this.mMarquee != null && this.mMarquee.isRunning()) {
                float dx2 = -this.mMarquee.getScroll();
                canvas.translate((float)layout2.getParagraphDirection(0) * dx2, 0.0f);
            }
        }
        int cursorOffsetVertical = voffsetCursor - voffsetText;
        this.maybeUpdateHighlightPaths();
        Path path = highlight = this.hasGesturePreviewHighlight() ? null : this.getUpdatedHighlightPath();
        if (this.mEditor != null) {
            this.mEditor.onDraw(canvas, layout2, this.mHighlightPaths, this.mHighlightPaints, highlight, this.mHighlightPaint, cursorOffsetVertical);
        } else {
            layout2.draw(canvas, this.mHighlightPaths, this.mHighlightPaints, highlight, this.mHighlightPaint, cursorOffsetVertical);
        }
        if (this.mMarquee != null && this.mMarquee.shouldDrawGhost()) {
            dx = this.mMarquee.getGhostOffset();
            canvas.translate((float)layout2.getParagraphDirection(0) * dx, 0.0f);
            layout2.draw(canvas, this.mHighlightPaths, this.mHighlightPaints, highlight, this.mHighlightPaint, cursorOffsetVertical);
        }
        canvas.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFocusedRect(Rect r) {
        if (this.mLayout == null) {
            super.getFocusedRect(r);
            return;
        }
        int selEnd = this.getSelectionEndTransformed();
        if (selEnd < 0) {
            super.getFocusedRect(r);
            return;
        }
        int selStart = this.getSelectionStartTransformed();
        if (selStart < 0 || selStart >= selEnd) {
            int line = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(line);
            r.bottom = this.mLayout.getLineBottom(line);
            r.left = (int)this.mLayout.getPrimaryHorizontal(selEnd) - 2;
            r.right = r.left + 4;
        } else {
            int lineStart = this.mLayout.getLineForOffset(selStart);
            int lineEnd = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(lineStart);
            r.bottom = this.mLayout.getLineBottom(lineEnd);
            if (lineStart == lineEnd) {
                r.left = (int)this.mLayout.getPrimaryHorizontal(selStart);
                r.right = (int)this.mLayout.getPrimaryHorizontal(selEnd);
            } else {
                if (this.mHighlightPathBogus) {
                    if (this.mHighlightPath == null) {
                        this.mHighlightPath = new Path();
                    }
                    this.mHighlightPath.reset();
                    this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                    this.mHighlightPathBogus = false;
                }
                RectF rectF = TEMP_RECTF;
                synchronized (rectF) {
                    this.mHighlightPath.computeBounds(TEMP_RECTF, true);
                    r.left = (int)TextView.TEMP_RECTF.left - 1;
                    r.right = (int)TextView.TEMP_RECTF.right + 1;
                }
            }
        }
        int paddingLeft = this.getCompoundPaddingLeft();
        int paddingTop = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            paddingTop += this.getVerticalOffset(false);
        }
        r.offset(paddingLeft, paddingTop);
        int paddingBottom = this.getExtendedPaddingBottom();
        r.bottom += paddingBottom;
    }

    public int getLineCount() {
        return this.mLayout != null ? this.mLayout.getLineCount() : 0;
    }

    public int getLineBounds(int line, Rect bounds) {
        if (this.mLayout == null) {
            if (bounds != null) {
                bounds.set(0, 0, 0, 0);
            }
            return 0;
        }
        int baseline = this.mLayout.getLineBounds(line, bounds);
        int voffset = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            voffset += this.getVerticalOffset(true);
        }
        if (bounds != null) {
            bounds.offset(this.getCompoundPaddingLeft(), voffset);
        }
        return baseline + voffset;
    }

    @Override
    public int getBaseline() {
        if (this.mLayout == null) {
            return super.getBaseline();
        }
        return this.getBaselineOffset() + this.mLayout.getLineBaseline(0);
    }

    int getBaselineOffset() {
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        if (TextView.isLayoutModeOptical(this.mParent)) {
            voffset -= this.getOpticalInsets().top;
        }
        return this.getExtendedPaddingTop() + voffset;
    }

    @Override
    protected int getFadeTop(boolean offsetRequired) {
        if (this.mLayout == null) {
            return 0;
        }
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        if (offsetRequired) {
            voffset += this.getTopPaddingOffset();
        }
        return this.getExtendedPaddingTop() + voffset;
    }

    @Override
    protected int getFadeHeight(boolean offsetRequired) {
        return this.mLayout != null ? this.mLayout.getHeight() : 0;
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        float y;
        float x;
        int offset;
        ClickableSpan[] clickables;
        if (this.mSpannable != null && this.mLinksClickable && (clickables = this.mSpannable.getSpans(offset = this.getOffsetForPosition(x = event.getX(pointerIndex), y = event.getY(pointerIndex)), offset, ClickableSpan.class)).length > 0) {
            return PointerIcon.getSystemIcon(this.mContext, 1002);
        }
        if (this.isTextSelectable() || this.isTextEditable()) {
            return PointerIcon.getSystemIcon(this.mContext, 1008);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    @Override
    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.handleBackInTextActionModeIfNeeded(event)) {
            return true;
        }
        return super.onKeyPreIme(keyCode, event);
    }

    public boolean handleBackInTextActionModeIfNeeded(KeyEvent event) {
        if (this.mEditor == null || this.mEditor.getTextActionMode() == null) {
            return false;
        }
        if (event.getAction() == 0 && event.getRepeatCount() == 0) {
            KeyEvent.DispatcherState state = this.getKeyDispatcherState();
            if (state != null) {
                state.startTracking(event, this);
            }
            return true;
        }
        if (event.getAction() == 1) {
            KeyEvent.DispatcherState state = this.getKeyDispatcherState();
            if (state != null) {
                state.handleUpEvent(event);
            }
            if (event.isTracking() && !event.isCanceled()) {
                this.stopTextActionMode();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        int which = this.doKeyDown(keyCode, event, null);
        if (which == 0) {
            return super.onKeyDown(keyCode, event);
        }
        return true;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        KeyEvent down = KeyEvent.changeAction(event, 0);
        int which = this.doKeyDown(keyCode, down, event);
        if (which == 0) {
            return super.onKeyMultiple(keyCode, repeatCount, event);
        }
        if (which == -1) {
            return true;
        }
        --repeatCount;
        KeyEvent up = KeyEvent.changeAction(event, 1);
        if (which == 1) {
            this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mEditor.mKeyListener.onKeyDown(this, (Editable)this.mText, keyCode, down);
                this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, up);
            }
            this.hideErrorIfUnchanged();
        } else if (which == 2) {
            this.mMovement.onKeyUp(this, this.mSpannable, keyCode, up);
            while (--repeatCount > 0) {
                this.mMovement.onKeyDown(this, this.mSpannable, keyCode, down);
                this.mMovement.onKeyUp(this, this.mSpannable, keyCode, up);
            }
        }
        return true;
    }

    private boolean shouldAdvanceFocusOnEnter() {
        int variation;
        if (this.getKeyListener() == null) {
            return false;
        }
        if (this.mSingleLine) {
            return true;
        }
        return this.mEditor != null && (this.mEditor.mInputType & 0xF) == 1 && ((variation = this.mEditor.mInputType & 0xFF0) == 32 || variation == 48);
    }

    private boolean isDirectionalNavigationKey(int keyCode) {
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doKeyDown(int keyCode, KeyEvent event, KeyEvent otherEvent) {
        boolean handled;
        boolean doDown;
        if (!this.isEnabled()) {
            return 0;
        }
        if (event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyCode)) {
            this.mPreventDefaultMovement = false;
        }
        switch (keyCode) {
            case 66: 
            case 160: {
                if (!event.hasNoModifiers()) break;
                if (this.mEditor != null && this.mEditor.mInputContentType != null && this.mEditor.mInputContentType.onEditorActionListener != null && this.mEditor.mInputContentType.onEditorActionListener.onEditorAction(this, this.getActionIdForEnterEvent(), event)) {
                    this.mEditor.mInputContentType.enterDown = true;
                    return -1;
                }
                if ((event.getFlags() & 0x10) == 0 && !this.shouldAdvanceFocusOnEnter()) break;
                if (this.hasOnClickListeners()) {
                    return 0;
                }
                return -1;
            }
            case 23: {
                if (!event.hasNoModifiers() || !this.shouldAdvanceFocusOnEnter()) break;
                return 0;
            }
            case 61: {
                if (!event.hasNoModifiers() && !event.hasModifiers(1)) break;
                return 0;
            }
            case 4: {
                if (this.mEditor == null || this.mEditor.getTextActionMode() == null) break;
                this.stopTextActionMode();
                return -1;
            }
            case 277: {
                if (!event.hasNoModifiers() || !this.canCut() || !this.onTextContextMenuItem(0x1020020)) break;
                return -1;
            }
            case 278: {
                if (!event.hasNoModifiers() || !this.canCopy() || !this.onTextContextMenuItem(0x1020021)) break;
                return -1;
            }
            case 279: {
                if (!event.hasNoModifiers() || !this.canPaste() || !this.onTextContextMenuItem(0x1020022)) break;
                return -1;
            }
            case 112: {
                if (!event.hasModifiers(1) || !this.canCut() || !this.onTextContextMenuItem(0x1020020)) break;
                return -1;
            }
            case 124: {
                if (!(event.hasModifiers(4096) && this.canCopy() ? this.onTextContextMenuItem(0x1020021) : event.hasModifiers(1) && this.canPaste() && this.onTextContextMenuItem(0x1020022))) break;
                return -1;
            }
        }
        if (this.mEditor != null && this.mEditor.mKeyListener != null) {
            doDown = true;
            if (otherEvent != null) {
                try {
                    this.beginBatchEdit();
                    handled = this.mEditor.mKeyListener.onKeyOther(this, (Editable)this.mText, otherEvent);
                    this.hideErrorIfUnchanged();
                    doDown = false;
                    if (handled) {
                        int n = -1;
                        return n;
                    }
                }
                catch (AbstractMethodError handled2) {
                }
                finally {
                    this.endBatchEdit();
                }
            }
            if (doDown) {
                this.beginBatchEdit();
                handled = this.mEditor.mKeyListener.onKeyDown(this, (Editable)this.mText, keyCode, event);
                this.endBatchEdit();
                this.hideErrorIfUnchanged();
                if (handled) {
                    return 1;
                }
            }
        }
        if (this.mMovement != null && this.mLayout != null) {
            doDown = true;
            if (otherEvent != null) {
                try {
                    handled = this.mMovement.onKeyOther(this, this.mSpannable, otherEvent);
                    doDown = false;
                    if (handled) {
                        return -1;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            if (doDown && this.mMovement.onKeyDown(this, this.mSpannable, keyCode, event)) {
                if (event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyCode)) {
                    this.mPreventDefaultMovement = true;
                }
                return 2;
            }
            if (event.getSource() == 257 && this.isDirectionalNavigationKey(keyCode)) {
                return -1;
            }
        }
        return this.mPreventDefaultMovement && !KeyEvent.isModifierKey(keyCode) ? -1 : 0;
    }

    public void resetErrorChangedFlag() {
        if (this.mEditor != null) {
            this.mEditor.mErrorWasChanged = false;
        }
    }

    public void hideErrorIfUnchanged() {
        if (this.mEditor != null && this.mEditor.mError != null && !this.mEditor.mErrorWasChanged) {
            this.setError(null, null);
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyUp(keyCode, event);
        }
        if (!KeyEvent.isModifierKey(keyCode)) {
            this.mPreventDefaultMovement = false;
        }
        switch (keyCode) {
            case 23: {
                if (event.hasNoModifiers() && !this.hasOnClickListeners() && this.mMovement != null && this.mText instanceof Editable && this.mLayout != null && this.onCheckIsTextEditor()) {
                    InputMethodManager imm = this.getInputMethodManager();
                    this.viewClicked(imm);
                    if (imm != null && this.getShowSoftInputOnFocus()) {
                        imm.showSoftInput(this, 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
            case 66: 
            case 160: {
                if (!event.hasNoModifiers()) break;
                if (this.mEditor != null && this.mEditor.mInputContentType != null && this.mEditor.mInputContentType.onEditorActionListener != null && this.mEditor.mInputContentType.enterDown) {
                    this.mEditor.mInputContentType.enterDown = false;
                    if (this.mEditor.mInputContentType.onEditorActionListener.onEditorAction(this, this.getActionIdForEnterEvent(), event)) {
                        return true;
                    }
                }
                if (((event.getFlags() & 0x10) != 0 || this.shouldAdvanceFocusOnEnter()) && !this.hasOnClickListeners()) {
                    InputMethodManager imm;
                    View v = this.focusSearch(130);
                    if (v != null) {
                        if (!v.requestFocus(130)) {
                            throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                        }
                        super.onKeyUp(keyCode, event);
                        return true;
                    }
                    if ((event.getFlags() & 0x10) != 0 && (imm = this.getInputMethodManager()) != null && imm.isActive(this)) {
                        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
        }
        if (this.mEditor != null && this.mEditor.mKeyListener != null && this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, event)) {
            return true;
        }
        if (this.mMovement != null && this.mLayout != null && this.mMovement.onKeyUp(this, this.mSpannable, keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private int getActionIdForEnterEvent() {
        if (!this.isSingleLine()) {
            return 0;
        }
        return this.getImeOptions() & 0xFF;
    }

    @Override
    public boolean onCheckIsTextEditor() {
        return this.mEditor != null && this.mEditor.mInputType != 0;
    }

    private boolean hasEditorInFocusSearchDirection(int direction) {
        View nextView = this.focusSearch(direction);
        return nextView != null && nextView.onCheckIsTextEditor();
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (this.onCheckIsTextEditor() && this.isEnabled()) {
            this.mEditor.createInputMethodStateIfNeeded();
            this.mEditor.mInputMethodState.mUpdateCursorAnchorInfoMode = 0;
            this.mEditor.mInputMethodState.mUpdateCursorAnchorInfoFilter = 0;
            outAttrs.inputType = this.getInputType();
            if (this.mEditor.mInputContentType != null) {
                outAttrs.imeOptions = this.mEditor.mInputContentType.imeOptions;
                outAttrs.privateImeOptions = this.mEditor.mInputContentType.privateImeOptions;
                outAttrs.actionLabel = this.mEditor.mInputContentType.imeActionLabel;
                outAttrs.actionId = this.mEditor.mInputContentType.imeActionId;
                outAttrs.extras = this.mEditor.mInputContentType.extras;
                outAttrs.hintLocales = this.mEditor.mInputContentType.imeHintLocales;
            } else {
                outAttrs.imeOptions = 0;
                outAttrs.hintLocales = null;
            }
            if (this.hasEditorInFocusSearchDirection(130)) {
                outAttrs.imeOptions |= 0x8000000;
            }
            if (this.hasEditorInFocusSearchDirection(33)) {
                outAttrs.imeOptions |= 0x4000000;
            }
            if ((outAttrs.imeOptions & 0xFF) == 0) {
                outAttrs.imeOptions = (outAttrs.imeOptions & 0x8000000) != 0 ? (outAttrs.imeOptions |= 5) : (outAttrs.imeOptions |= 6);
                if (!this.shouldAdvanceFocusOnEnter()) {
                    outAttrs.imeOptions |= 0x40000000;
                }
            }
            if (this.getResources().getConfiguration().orientation == 1) {
                outAttrs.internalImeOptions |= 1;
            }
            if (TextView.isMultilineInputType(outAttrs.inputType)) {
                outAttrs.imeOptions |= 0x40000000;
            }
            outAttrs.hintText = this.mHint;
            outAttrs.targetInputMethodUser = this.mTextOperationUser;
            if (this.mText instanceof Editable) {
                EditableInputConnection ic = new EditableInputConnection(this);
                outAttrs.initialSelStart = this.getSelectionStart();
                outAttrs.initialSelEnd = this.getSelectionEnd();
                outAttrs.initialCapsMode = ic.getCursorCapsMode(this.getInputType());
                outAttrs.setInitialSurroundingText(this.mText);
                outAttrs.contentMimeTypes = this.getReceiveContentMimeTypes();
                ArrayList<Class<? extends HandwritingGesture>> gestures = new ArrayList<Class<? extends HandwritingGesture>>();
                gestures.add(SelectGesture.class);
                gestures.add(SelectRangeGesture.class);
                gestures.add(DeleteGesture.class);
                gestures.add(DeleteRangeGesture.class);
                gestures.add(InsertGesture.class);
                gestures.add(RemoveSpaceGesture.class);
                gestures.add(JoinOrSplitGesture.class);
                gestures.add(InsertModeGesture.class);
                outAttrs.setSupportedHandwritingGestures(gestures);
                ArraySet<Class<? extends PreviewableHandwritingGesture>> previews = new ArraySet<Class<? extends PreviewableHandwritingGesture>>();
                previews.add(SelectGesture.class);
                previews.add(SelectRangeGesture.class);
                previews.add(DeleteGesture.class);
                previews.add(DeleteRangeGesture.class);
                outAttrs.setSupportedHandwritingGesturePreviews(previews);
                return ic;
            }
        }
        return null;
    }

    public void onRequestCursorUpdatesInternal(int cursorUpdateMode, int cursorUpdateFilter) {
        this.mEditor.mInputMethodState.mUpdateCursorAnchorInfoMode = cursorUpdateMode;
        this.mEditor.mInputMethodState.mUpdateCursorAnchorInfoFilter = cursorUpdateFilter;
        if ((cursorUpdateMode & 1) == 0) {
            return;
        }
        if (!this.isInLayout()) {
            this.requestLayout();
        }
    }

    public boolean extractText(ExtractedTextRequest request, ExtractedText outText) {
        this.createEditorIfNeeded();
        return this.mEditor.extractText(request, outText);
    }

    static void removeParcelableSpans(Spannable spannable, int start, int end) {
        ParcelableSpan[] spans = spannable.getSpans(start, end, ParcelableSpan.class);
        int i = spans.length;
        while (i > 0) {
            spannable.removeSpan(spans[--i]);
        }
    }

    public void setExtractedText(ExtractedText text) {
        Editable content = this.getEditableText();
        if (text.text != null) {
            if (content == null) {
                this.setText(text.text, BufferType.EDITABLE);
            } else {
                int start = 0;
                int end = content.length();
                if (text.partialStartOffset >= 0) {
                    start = text.partialStartOffset;
                    int N = content.length();
                    if (start > N) {
                        start = N;
                    }
                    if ((end = text.partialEndOffset) > N) {
                        end = N;
                    }
                }
                TextView.removeParcelableSpans(content, start, end);
                if (TextUtils.equals(content.subSequence(start, end), text.text)) {
                    if (text.text instanceof Spanned) {
                        TextUtils.copySpansFrom((Spanned)text.text, 0, end - start, Object.class, content, start);
                    }
                } else {
                    content.replace(start, end, text.text);
                }
            }
        }
        Spannable sp = (Spannable)this.getText();
        int N = sp.length();
        int start = text.selectionStart;
        if (start < 0) {
            start = 0;
        } else if (start > N) {
            start = N;
        }
        int end = text.selectionEnd;
        if (end < 0) {
            end = 0;
        } else if (end > N) {
            end = N;
        }
        Selection.setSelection(sp, start, end);
        if ((text.flags & 2) != 0) {
            MetaKeyKeyListener.startSelecting(this, sp);
        } else {
            MetaKeyKeyListener.stopSelecting(this, sp);
        }
        this.setHintInternal(text.hint);
    }

    public void setExtracting(ExtractedTextRequest req) {
        if (this.mEditor.mInputMethodState != null) {
            this.mEditor.mInputMethodState.mExtractedTextRequest = req;
        }
        this.mEditor.hideCursorAndSpanControllers();
        this.stopTextActionMode();
        if (this.mEditor.mSelectionModifierCursorController != null) {
            this.mEditor.mSelectionModifierCursorController.resetTouchOffsets();
        }
    }

    public void onCommitCompletion(CompletionInfo text) {
    }

    public void onCommitCorrection(CorrectionInfo info) {
        if (this.mEditor != null) {
            this.mEditor.onCommitCorrection(info);
        }
    }

    public void beginBatchEdit() {
        if (this.mEditor != null) {
            this.mEditor.beginBatchEdit();
        }
    }

    public void endBatchEdit() {
        if (this.mEditor != null) {
            this.mEditor.endBatchEdit();
        }
    }

    public void onBeginBatchEdit() {
    }

    public void onEndBatchEdit() {
    }

    public void onPerformSpellCheck() {
        if (this.mEditor != null && this.mEditor.mSpellChecker != null) {
            this.mEditor.mSpellChecker.onPerformSpellCheck();
        }
    }

    public boolean onPrivateIMECommand(String action, Bundle data) {
        return false;
    }

    public boolean isOffsetMappingAvailable() {
        return this.mTransformation != null && this.mTransformed instanceof OffsetMapping;
    }

    public boolean previewHandwritingGesture(PreviewableHandwritingGesture gesture, CancellationSignal cancellationSignal) {
        if (gesture instanceof SelectGesture) {
            this.performHandwritingSelectGesture((SelectGesture)gesture, true);
        } else if (gesture instanceof SelectRangeGesture) {
            this.performHandwritingSelectRangeGesture((SelectRangeGesture)gesture, true);
        } else if (gesture instanceof DeleteGesture) {
            this.performHandwritingDeleteGesture((DeleteGesture)gesture, true);
        } else if (gesture instanceof DeleteRangeGesture) {
            this.performHandwritingDeleteRangeGesture((DeleteRangeGesture)gesture, true);
        } else {
            return false;
        }
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(this::clearGesturePreviewHighlight);
        }
        return true;
    }

    public int performHandwritingSelectGesture(SelectGesture gesture) {
        return this.performHandwritingSelectGesture(gesture, false);
    }

    private int performHandwritingSelectGesture(SelectGesture gesture, boolean isPreview) {
        if (this.isOffsetMappingAvailable()) {
            return 3;
        }
        int[] range = this.getRangeForRect(this.convertFromScreenToContentCoordinates(gesture.getSelectionArea()), gesture.getGranularity());
        if (range == null) {
            return this.handleGestureFailure(gesture, isPreview);
        }
        return this.performHandwritingSelectGesture(range, isPreview);
    }

    private int performHandwritingSelectGesture(int[] range, boolean isPreview) {
        if (isPreview) {
            this.setSelectGesturePreviewHighlight(range[0], range[1]);
        } else {
            Selection.setSelection(this.getEditableText(), range[0], range[1]);
            this.mEditor.startSelectionActionModeAsync(false);
        }
        return 1;
    }

    public int performHandwritingSelectRangeGesture(SelectRangeGesture gesture) {
        return this.performHandwritingSelectRangeGesture(gesture, false);
    }

    private int performHandwritingSelectRangeGesture(SelectRangeGesture gesture, boolean isPreview) {
        if (this.isOffsetMappingAvailable()) {
            return 3;
        }
        int[] startRange = this.getRangeForRect(this.convertFromScreenToContentCoordinates(gesture.getSelectionStartArea()), gesture.getGranularity());
        if (startRange == null) {
            return this.handleGestureFailure(gesture, isPreview);
        }
        int[] endRange = this.getRangeForRect(this.convertFromScreenToContentCoordinates(gesture.getSelectionEndArea()), gesture.getGranularity());
        if (endRange == null) {
            return this.handleGestureFailure(gesture, isPreview);
        }
        int[] range = new int[]{Math.min(startRange[0], endRange[0]), Math.max(startRange[1], endRange[1])};
        return this.performHandwritingSelectGesture(range, isPreview);
    }

    public int performHandwritingDeleteGesture(DeleteGesture gesture) {
        return this.performHandwritingDeleteGesture(gesture, false);
    }

    private int performHandwritingDeleteGesture(DeleteGesture gesture, boolean isPreview) {
        if (this.isOffsetMappingAvailable()) {
            return 3;
        }
        int[] range = this.getRangeForRect(this.convertFromScreenToContentCoordinates(gesture.getDeletionArea()), gesture.getGranularity());
        if (range == null) {
            return this.handleGestureFailure(gesture, isPreview);
        }
        return this.performHandwritingDeleteGesture(range, gesture.getGranularity(), isPreview);
    }

    private int performHandwritingDeleteGesture(int[] range, int granularity, boolean isPreview) {
        if (isPreview) {
            this.setDeleteGesturePreviewHighlight(range[0], range[1]);
        } else {
            if (granularity == 1) {
                range = this.adjustHandwritingDeleteGestureRange(range);
            }
            Selection.setSelection(this.getEditableText(), range[0]);
            this.getEditableText().delete(range[0], range[1]);
        }
        return 1;
    }

    public int performHandwritingDeleteRangeGesture(DeleteRangeGesture gesture) {
        return this.performHandwritingDeleteRangeGesture(gesture, false);
    }

    private int performHandwritingDeleteRangeGesture(DeleteRangeGesture gesture, boolean isPreview) {
        if (this.isOffsetMappingAvailable()) {
            return 3;
        }
        int[] startRange = this.getRangeForRect(this.convertFromScreenToContentCoordinates(gesture.getDeletionStartArea()), gesture.getGranularity());
        if (startRange == null) {
            return this.handleGestureFailure(gesture, isPreview);
        }
        int[] endRange = this.getRangeForRect(this.convertFromScreenToContentCoordinates(gesture.getDeletionEndArea()), gesture.getGranularity());
        if (endRange == null) {
            return this.handleGestureFailure(gesture, isPreview);
        }
        int[] range = new int[]{Math.min(startRange[0], endRange[0]), Math.max(startRange[1], endRange[1])};
        return this.performHandwritingDeleteGesture(range, gesture.getGranularity(), isPreview);
    }

    private int[] adjustHandwritingDeleteGestureRange(int[] range) {
        int codePointAtEnd;
        int start = range[0];
        int end = range[1];
        int codePointBeforeStart = start > 0 ? Character.codePointBefore(this.mText, start) : 10;
        int n = codePointAtEnd = end < this.mText.length() ? Character.codePointAt(this.mText, end) : 10;
        if (TextUtils.isWhitespaceExceptNewline(codePointBeforeStart) && (TextUtils.isWhitespace(codePointAtEnd) || TextUtils.isPunctuation(codePointAtEnd))) {
            while ((start -= Character.charCount(codePointBeforeStart)) != 0 && TextUtils.isWhitespaceExceptNewline(codePointBeforeStart = Character.codePointBefore(this.mText, start))) {
            }
            return new int[]{start, end};
        }
        if (TextUtils.isWhitespaceExceptNewline(codePointAtEnd) && (TextUtils.isWhitespace(codePointBeforeStart) || TextUtils.isPunctuation(codePointBeforeStart))) {
            while ((end += Character.charCount(codePointAtEnd)) != this.mText.length() && TextUtils.isWhitespaceExceptNewline(codePointAtEnd = Character.codePointAt(this.mText, end))) {
            }
            return new int[]{start, end};
        }
        return range;
    }

    public int performHandwritingInsertGesture(InsertGesture gesture) {
        if (this.isOffsetMappingAvailable()) {
            return 3;
        }
        PointF point = this.convertFromScreenToContentCoordinates(gesture.getInsertionPoint());
        int line = this.getLineForHandwritingGesture(point);
        if (line == -1) {
            return this.handleGestureFailure(gesture);
        }
        int offset = this.mLayout.getOffsetForHorizontal(line, point.x);
        String textToInsert = gesture.getTextToInsert();
        return this.tryInsertTextForHandwritingGesture(offset, textToInsert, gesture);
    }

    public int performHandwritingRemoveSpaceGesture(RemoveSpaceGesture gesture) {
        int line;
        if (this.isOffsetMappingAvailable()) {
            return 3;
        }
        PointF startPoint = this.convertFromScreenToContentCoordinates(gesture.getStartPoint());
        PointF endPoint = this.convertFromScreenToContentCoordinates(gesture.getEndPoint());
        int startPointLine = this.getLineForHandwritingGesture(startPoint);
        int endPointLine = this.getLineForHandwritingGesture(endPoint);
        if (startPointLine == -1) {
            if (endPointLine == -1) {
                return this.handleGestureFailure(gesture);
            }
            line = endPointLine;
        } else {
            line = endPointLine == -1 ? startPointLine : Math.min(startPointLine, endPointLine);
        }
        float lineVerticalCenter = (float)(this.mLayout.getLineTop(line) + this.mLayout.getLineBottom(line, false)) / 2.0f;
        RectF area = new RectF(Math.min(startPoint.x, endPoint.x), lineVerticalCenter + 0.1f, Math.max(startPoint.x, endPoint.x), lineVerticalCenter - 0.1f);
        int[] range = this.mLayout.getRangeForRect(area, new GraphemeClusterSegmentFinder(this.mText, this.mTextPaint), Layout.INCLUSION_STRATEGY_ANY_OVERLAP);
        if (range == null) {
            return this.handleGestureFailure(gesture);
        }
        int startOffset = range[0];
        int endOffset = range[1];
        Pattern whitespacePattern = this.getWhitespacePattern();
        Matcher matcher = whitespacePattern.matcher(this.mText.subSequence(startOffset, endOffset));
        int lastRemoveOffset = -1;
        while (matcher.find()) {
            lastRemoveOffset = startOffset + matcher.start();
            this.getEditableText().delete(lastRemoveOffset, startOffset + matcher.end());
            startOffset = lastRemoveOffset;
            if (startOffset == (endOffset -= matcher.end() - matcher.start())) break;
            matcher = whitespacePattern.matcher(this.mText.subSequence(startOffset, endOffset));
        }
        if (lastRemoveOffset == -1) {
            return this.handleGestureFailure(gesture);
        }
        Selection.setSelection(this.getEditableText(), lastRemoveOffset);
        return 1;
    }

    public int performHandwritingJoinOrSplitGesture(JoinOrSplitGesture gesture) {
        int codePointAtEnd;
        int codePointBeforeStart;
        if (this.isOffsetMappingAvailable()) {
            return 3;
        }
        PointF point = this.convertFromScreenToContentCoordinates(gesture.getJoinOrSplitPoint());
        int line = this.getLineForHandwritingGesture(point);
        if (line == -1) {
            return this.handleGestureFailure(gesture);
        }
        int startOffset = this.mLayout.getOffsetForHorizontal(line, point.x);
        if (this.mLayout.isLevelBoundary(startOffset)) {
            return this.handleGestureFailure(gesture);
        }
        int endOffset = startOffset;
        while (startOffset > 0 && TextUtils.isWhitespace(codePointBeforeStart = Character.codePointBefore(this.mText, startOffset))) {
            startOffset -= Character.charCount(codePointBeforeStart);
        }
        while (endOffset < this.mText.length() && TextUtils.isWhitespace(codePointAtEnd = Character.codePointAt(this.mText, endOffset))) {
            endOffset += Character.charCount(codePointAtEnd);
        }
        if (startOffset < endOffset) {
            Selection.setSelection(this.getEditableText(), startOffset);
            this.getEditableText().delete(startOffset, endOffset);
            return 1;
        }
        return this.tryInsertTextForHandwritingGesture(startOffset, " ", gesture);
    }

    public int performHandwritingInsertModeGesture(InsertModeGesture gesture) {
        PointF insertPoint = this.convertFromScreenToContentCoordinates(gesture.getInsertionPoint());
        int line = this.getLineForHandwritingGesture(insertPoint);
        CancellationSignal cancellationSignal = gesture.getCancellationSignal();
        if (line == -1 || cancellationSignal == null) {
            return this.handleGestureFailure(gesture);
        }
        int offset = this.mLayout.getOffsetForHorizontal(line, insertPoint.x);
        if (!this.mEditor.enterInsertMode(offset)) {
            return 3;
        }
        cancellationSignal.setOnCancelListener(() -> this.mEditor.exitInsertMode());
        return 1;
    }

    private int handleGestureFailure(HandwritingGesture gesture) {
        return this.handleGestureFailure(gesture, false);
    }

    private int handleGestureFailure(HandwritingGesture gesture, boolean isPreview) {
        this.clearGesturePreviewHighlight();
        if (!isPreview && !TextUtils.isEmpty(gesture.getFallbackText())) {
            this.getEditableText().replace(this.getSelectionStart(), this.getSelectionEnd(), gesture.getFallbackText());
            return 5;
        }
        return 3;
    }

    private int getLineForHandwritingGesture(PointF point) {
        int line = this.mLayout.getLineForVertical((int)point.y);
        int lineMargin = ViewConfiguration.get(this.mContext).getScaledHandwritingGestureLineMargin();
        if (line < this.mLayout.getLineCount() - 1 && point.y > (float)(this.mLayout.getLineBottom(line) - lineMargin) && point.y > (float)(this.mLayout.getLineBottom(line, false) + this.mLayout.getLineBottom(line)) / 2.0f) {
            ++line;
        } else if (point.y < (float)(this.mLayout.getLineTop(line) - lineMargin) || point.y > (float)(this.mLayout.getLineBottom(line, false) + lineMargin)) {
            return -1;
        }
        if (point.x < (float)(-lineMargin) || point.x > (float)(this.mLayout.getWidth() + lineMargin)) {
            return -1;
        }
        return line;
    }

    private int[] getRangeForRect(RectF area, int granularity) {
        SegmentFinder segmentFinder;
        if (granularity == 1) {
            WordIterator wordIterator = this.getWordIterator();
            wordIterator.setCharSequence(this.mText, 0, this.mText.length());
            segmentFinder = new WordSegmentFinder(this.mText, wordIterator);
        } else {
            segmentFinder = new GraphemeClusterSegmentFinder(this.mText, this.mTextPaint);
        }
        return this.mLayout.getRangeForRect(area, segmentFinder, Layout.INCLUSION_STRATEGY_CONTAINS_CENTER);
    }

    private int tryInsertTextForHandwritingGesture(int offset, String textToInsert, HandwritingGesture gesture) {
        Editable editableText = this.getEditableText();
        if (this.mTempCursor == null) {
            this.mTempCursor = new NoCopySpan.Concrete();
        }
        editableText.setSpan(this.mTempCursor, offset, offset, 34);
        editableText.insert(offset, textToInsert);
        int newOffset = editableText.getSpanStart(this.mTempCursor);
        editableText.removeSpan(this.mTempCursor);
        if (newOffset == offset) {
            return this.handleGestureFailure(gesture);
        }
        Selection.setSelection(editableText, newOffset);
        return 1;
    }

    private Pattern getWhitespacePattern() {
        if (this.mWhitespacePattern == null) {
            this.mWhitespacePattern = Pattern.compile("\\s+");
        }
        return this.mWhitespacePattern;
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    public void nullLayouts() {
        if (this.mLayout instanceof BoringLayout && this.mSavedLayout == null) {
            this.mSavedLayout = (BoringLayout)this.mLayout;
        }
        if (this.mHintLayout instanceof BoringLayout && this.mSavedHintLayout == null) {
            this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
        }
        this.mHintLayout = null;
        this.mLayout = null;
        this.mSavedMarqueeModeLayout = null;
        this.mHintBoring = null;
        this.mBoring = null;
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    @UnsupportedAppUsage
    private void assumeLayout() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (width < 1) {
            width = 0;
        }
        int physicalWidth = width;
        if (this.mHorizontallyScrolling) {
            width = 0x100000;
        }
        this.makeNewLayout(width, physicalWidth, UNKNOWN_BORING, UNKNOWN_BORING, physicalWidth, false);
    }

    @UnsupportedAppUsage
    private Layout.Alignment getLayoutAlignment() {
        Layout.Alignment alignment;
        block0 : switch (this.getTextAlignment()) {
            case 1: {
                switch (this.mGravity & 0x800007) {
                    case 0x800003: {
                        alignment = Layout.Alignment.ALIGN_NORMAL;
                        break block0;
                    }
                    case 0x800005: {
                        alignment = Layout.Alignment.ALIGN_OPPOSITE;
                        break block0;
                    }
                    case 3: {
                        alignment = Layout.Alignment.ALIGN_LEFT;
                        break block0;
                    }
                    case 5: {
                        alignment = Layout.Alignment.ALIGN_RIGHT;
                        break block0;
                    }
                    case 1: {
                        alignment = Layout.Alignment.ALIGN_CENTER;
                        break block0;
                    }
                }
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 2: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 4: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 5: {
                alignment = this.getLayoutDirection() == 1 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
                break;
            }
            case 6: {
                alignment = this.getLayoutDirection() == 1 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
                break;
            }
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return alignment;
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    public void makeNewLayout(int wantWidth, int hintWidth, BoringLayout.Metrics boring, BoringLayout.Metrics hintBoring, int ellipsisWidth, boolean bringIntoView) {
        this.stopMarquee();
        this.mOldMaximum = this.mMaximum;
        this.mOldMaxMode = this.mMaxMode;
        this.mHighlightPathBogus = true;
        this.mHighlightPathsBogus = true;
        if (wantWidth < 0) {
            wantWidth = 0;
        }
        if (hintWidth < 0) {
            hintWidth = 0;
        }
        Layout.Alignment alignment = this.getLayoutAlignment();
        boolean testDirChange = this.mSingleLine && this.mLayout != null && (alignment == Layout.Alignment.ALIGN_NORMAL || alignment == Layout.Alignment.ALIGN_OPPOSITE);
        int oldDir = 0;
        if (testDirChange) {
            oldDir = this.mLayout.getParagraphDirection(0);
        }
        boolean shouldEllipsize = this.mEllipsize != null && this.getKeyListener() == null;
        boolean switchEllipsize = this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 0;
        TextUtils.TruncateAt effectiveEllipsize = this.mEllipsize;
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode == 1) {
            effectiveEllipsize = TextUtils.TruncateAt.END_SMALL;
        }
        if (this.mTextDir == null) {
            this.mTextDir = this.getTextDirectionHeuristic();
        }
        this.mLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, effectiveEllipsize, effectiveEllipsize == this.mEllipsize);
        if (switchEllipsize) {
            TextUtils.TruncateAt oppositeEllipsize = effectiveEllipsize == TextUtils.TruncateAt.MARQUEE ? TextUtils.TruncateAt.END : TextUtils.TruncateAt.MARQUEE;
            this.mSavedMarqueeModeLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, oppositeEllipsize, effectiveEllipsize != this.mEllipsize);
        }
        shouldEllipsize = this.mEllipsize != null;
        this.mHintLayout = null;
        if (this.mHint != null) {
            if (shouldEllipsize) {
                hintWidth = wantWidth;
            }
            if (hintBoring == UNKNOWN_BORING && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mTextDir, this.isFallbackLineSpacingForBoringLayout(), this.mHintBoring)) != null) {
                this.mHintBoring = hintBoring;
            }
            if (hintBoring != null) {
                if (!(hintBoring.width > hintWidth || shouldEllipsize && hintBoring.width > ellipsisWidth)) {
                    this.mHintLayout = this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad);
                    this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
                } else if (shouldEllipsize && hintBoring.width <= hintWidth) {
                    this.mHintLayout = this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth);
                }
            }
            if (this.mHintLayout == null) {
                boolean autoPhraseBreaking = !this.mUserSpeficiedLineBreakwordStyle && FeatureFlagUtils.isEnabled(this.mContext, "settings_auto_text_wrapping");
                StaticLayout.Builder builder = StaticLayout.Builder.obtain(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth).setAlignment(alignment).setTextDirection(this.mTextDir).setLineSpacing(this.mSpacingAdd, this.mSpacingMult).setIncludePad(this.mIncludePad).setUseLineSpacingFromFallbacks(this.isFallbackLineSpacingForStaticLayout()).setBreakStrategy(this.mBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency).setJustificationMode(this.mJustificationMode).setMaxLines(this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE).setLineBreakConfig(LineBreakConfig.getLineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle, autoPhraseBreaking));
                if (shouldEllipsize) {
                    builder.setEllipsize(this.mEllipsize).setEllipsizedWidth(ellipsisWidth);
                }
                this.mHintLayout = builder.build();
            }
        }
        if (bringIntoView || testDirChange && oldDir != this.mLayout.getParagraphDirection(0)) {
            this.registerForPreDraw();
        }
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && !this.compressText(ellipsisWidth)) {
            int height = this.mLayoutParams.height;
            if (height != -2 && height != -1) {
                this.startMarquee();
            } else {
                this.mRestartMarquee = true;
            }
        }
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    @VisibleForTesting
    public boolean useDynamicLayout() {
        return this.isTextSelectable() || this.mSpannable != null && this.mPrecomputed == null;
    }

    protected Layout makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        Layout result = null;
        if (this.useDynamicLayout()) {
            DynamicLayout.Builder builder = DynamicLayout.Builder.obtain(this.mText, this.mTextPaint, wantWidth).setDisplayText(this.mTransformed).setAlignment(alignment).setTextDirection(this.mTextDir).setLineSpacing(this.mSpacingAdd, this.mSpacingMult).setIncludePad(this.mIncludePad).setUseLineSpacingFromFallbacks(this.isFallbackLineSpacingForStaticLayout()).setBreakStrategy(this.mBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency).setJustificationMode(this.mJustificationMode).setEllipsize(this.getKeyListener() == null ? effectiveEllipsize : null).setEllipsizedWidth(ellipsisWidth);
            result = builder.build();
        } else {
            if (boring == UNKNOWN_BORING && (boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.isFallbackLineSpacingForBoringLayout(), this.mBoring)) != null) {
                this.mBoring = boring;
            }
            if (boring != null) {
                if (boring.width <= wantWidth && (effectiveEllipsize == null || boring.width <= ellipsisWidth)) {
                    result = useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad);
                    if (useSaved) {
                        this.mSavedLayout = result;
                    }
                } else if (shouldEllipsize && boring.width <= wantWidth) {
                    result = useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth);
                }
            }
        }
        if (result == null) {
            boolean autoPhraseBreaking = !this.mUserSpeficiedLineBreakwordStyle && FeatureFlagUtils.isEnabled(this.mContext, "settings_auto_text_wrapping");
            StaticLayout.Builder builder = StaticLayout.Builder.obtain(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, wantWidth).setAlignment(alignment).setTextDirection(this.mTextDir).setLineSpacing(this.mSpacingAdd, this.mSpacingMult).setIncludePad(this.mIncludePad).setUseLineSpacingFromFallbacks(this.isFallbackLineSpacingForStaticLayout()).setBreakStrategy(this.mBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency).setJustificationMode(this.mJustificationMode).setMaxLines(this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE).setLineBreakConfig(LineBreakConfig.getLineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle, autoPhraseBreaking));
            if (shouldEllipsize) {
                builder.setEllipsize(effectiveEllipsize).setEllipsizedWidth(ellipsisWidth);
            }
            result = builder.build();
        }
        return result;
    }

    @UnsupportedAppUsage
    private boolean compressText(float width) {
        float textWidth;
        float overflow;
        if (this.isHardwareAccelerated()) {
            return false;
        }
        if (width > 0.0f && this.mLayout != null && this.getLineCount() == 1 && !this.mUserSetTextScaleX && this.mTextPaint.getTextScaleX() == 1.0f && (overflow = ((textWidth = this.mLayout.getLineWidth(0)) + 1.0f - width) / width) > 0.0f && overflow <= 0.07f) {
            this.mTextPaint.setTextScaleX(1.0f - overflow - 0.005f);
            this.post(new Runnable(){

                @Override
                public void run() {
                    TextView.this.requestLayout();
                }
            });
            return true;
        }
        return false;
    }

    private static int desired(Layout layout2) {
        int i;
        int n = layout2.getLineCount();
        CharSequence text = layout2.getText();
        float max = 0.0f;
        for (i = 0; i < n - 1; ++i) {
            if (text.charAt(layout2.getLineEnd(i) - 1) == '\n') continue;
            return -1;
        }
        for (i = 0; i < n; ++i) {
            max = Math.max(max, layout2.getLineMax(i));
        }
        return (int)Math.ceil(max);
    }

    public void setIncludeFontPadding(boolean includepad) {
        if (this.mIncludePad != includepad) {
            this.mIncludePad = includepad;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public boolean getIncludeFontPadding() {
        return this.mIncludePad;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int hintWidth;
        int want;
        int width;
        float widthLimit;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        BoringLayout.Metrics boring = UNKNOWN_BORING;
        BoringLayout.Metrics hintBoring = UNKNOWN_BORING;
        if (this.mTextDir == null) {
            this.mTextDir = this.getTextDirectionHeuristic();
        }
        int des = -1;
        boolean fromexisting = false;
        float f = widthLimit = widthMode == Integer.MIN_VALUE ? (float)widthSize : Float.MAX_VALUE;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (this.mLayout != null && this.mEllipsize == null) {
                des = TextView.desired(this.mLayout);
            }
            if (des < 0) {
                boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.isFallbackLineSpacingForBoringLayout(), this.mBoring);
                if (boring != null) {
                    this.mBoring = boring;
                }
            } else {
                fromexisting = true;
            }
            if (boring == null || boring == UNKNOWN_BORING) {
                if (des < 0) {
                    des = (int)Math.ceil(Layout.getDesiredWidthWithLimit(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, this.mTextDir, widthLimit));
                }
                width = des;
            } else {
                width = boring.width;
            }
            Drawables dr = this.mDrawables;
            if (dr != null) {
                width = Math.max(width, dr.mDrawableWidthTop);
                width = Math.max(width, dr.mDrawableWidthBottom);
            }
            if (this.mHint != null) {
                int hintWidth2;
                int hintDes = -1;
                if (this.mHintLayout != null && this.mEllipsize == null) {
                    hintDes = TextView.desired(this.mHintLayout);
                }
                if (hintDes < 0 && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mTextDir, this.isFallbackLineSpacingForBoringLayout(), this.mHintBoring)) != null) {
                    this.mHintBoring = hintBoring;
                }
                if (hintBoring == null || hintBoring == UNKNOWN_BORING) {
                    if (hintDes < 0) {
                        hintDes = (int)Math.ceil(Layout.getDesiredWidthWithLimit(this.mHint, 0, this.mHint.length(), this.mTextPaint, this.mTextDir, widthLimit));
                    }
                    hintWidth2 = hintDes;
                } else {
                    hintWidth2 = hintBoring.width;
                }
                if (hintWidth2 > width) {
                    width = hintWidth2;
                }
            }
            width += this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
            width = this.mMaxWidthMode == 1 ? Math.min(width, this.mMaxWidth * this.getLineHeight()) : Math.min(width, this.mMaxWidth);
            width = this.mMinWidthMode == 1 ? Math.max(width, this.mMinWidth * this.getLineHeight()) : Math.max(width, this.mMinWidth);
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        int unpaddedWidth = want = width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (this.mHorizontallyScrolling) {
            want = 0x100000;
        }
        int hintWant = want;
        int n = hintWidth = this.mHintLayout == null ? hintWant : this.mHintLayout.getWidth();
        if (this.mLayout == null) {
            this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
        } else {
            boolean maximumChanged;
            boolean layoutChanged = this.mLayout.getWidth() != want || hintWidth != hintWant || this.mLayout.getEllipsizedWidth() != width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            boolean widthChanged = this.mHint == null && this.mEllipsize == null && want > this.mLayout.getWidth() && (this.mLayout instanceof BoringLayout || fromexisting && des >= 0 && des <= want);
            boolean bl = maximumChanged = this.mMaxMode != this.mOldMaxMode || this.mMaximum != this.mOldMaximum;
            if (layoutChanged || maximumChanged) {
                if (!maximumChanged && widthChanged) {
                    this.mLayout.increaseWidthTo(want);
                } else {
                    this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
                }
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
            this.mDesiredHeightAtMeasure = -1;
        } else {
            int desired;
            height = desired = this.getDesiredHeight();
            this.mDesiredHeightAtMeasure = desired;
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(desired, heightSize);
            }
        }
        int unpaddedHeight = height - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
        if (this.mMaxMode == 1 && this.mLayout.getLineCount() > this.mMaximum) {
            unpaddedHeight = Math.min(unpaddedHeight, this.mLayout.getLineTop(this.mMaximum));
        }
        if (this.mMovement != null || this.mLayout.getWidth() > unpaddedWidth || this.mLayout.getHeight() > unpaddedHeight) {
            this.registerForPreDraw();
        } else {
            this.scrollTo(0, 0);
        }
        this.setMeasuredDimension(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoSizeText() {
        if (!this.isAutoSizeEnabled()) {
            return;
        }
        if (this.mNeedsAutoSizeText) {
            if (this.getMeasuredWidth() <= 0 || this.getMeasuredHeight() <= 0) {
                return;
            }
            int availableWidth = this.mHorizontallyScrolling ? 0x100000 : this.getMeasuredWidth() - this.getTotalPaddingLeft() - this.getTotalPaddingRight();
            int availableHeight = this.getMeasuredHeight() - this.getExtendedPaddingBottom() - this.getExtendedPaddingTop();
            if (availableWidth <= 0 || availableHeight <= 0) {
                return;
            }
            RectF rectF = TEMP_RECTF;
            synchronized (rectF) {
                TEMP_RECTF.setEmpty();
                TextView.TEMP_RECTF.right = availableWidth;
                TextView.TEMP_RECTF.bottom = availableHeight;
                float optimalTextSize = this.findLargestTextSizeWhichFits(TEMP_RECTF);
                if (optimalTextSize != this.getTextSize()) {
                    this.setTextSizeInternal(0, optimalTextSize, false);
                    this.makeNewLayout(availableWidth, 0, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
                }
            }
        }
        this.mNeedsAutoSizeText = true;
    }

    private int findLargestTextSizeWhichFits(RectF availableSpace) {
        int sizesCount = this.mAutoSizeTextSizesInPx.length;
        if (sizesCount == 0) {
            throw new IllegalStateException("No available text sizes to choose from.");
        }
        int bestSizeIndex = 0;
        int lowIndex = bestSizeIndex + 1;
        int highIndex = sizesCount - 1;
        while (lowIndex <= highIndex) {
            int sizeToTryIndex = (lowIndex + highIndex) / 2;
            if (this.suggestedSizeFitsInSpace(this.mAutoSizeTextSizesInPx[sizeToTryIndex], availableSpace)) {
                bestSizeIndex = lowIndex;
                lowIndex = sizeToTryIndex + 1;
                continue;
            }
            bestSizeIndex = highIndex = sizeToTryIndex - 1;
        }
        return this.mAutoSizeTextSizesInPx[bestSizeIndex];
    }

    private boolean suggestedSizeFitsInSpace(int suggestedSizeInPx, RectF availableSpace) {
        CharSequence text = this.mTransformed != null ? this.mTransformed : this.getText();
        int maxLines = this.getMaxLines();
        if (this.mTempTextPaint == null) {
            this.mTempTextPaint = new TextPaint();
        } else {
            this.mTempTextPaint.reset();
        }
        this.mTempTextPaint.set(this.getPaint());
        this.mTempTextPaint.setTextSize(suggestedSizeInPx);
        StaticLayout.Builder layoutBuilder = StaticLayout.Builder.obtain(text, 0, text.length(), this.mTempTextPaint, Math.round(availableSpace.right));
        boolean autoPhraseBreaking = !this.mUserSpeficiedLineBreakwordStyle && FeatureFlagUtils.isEnabled(this.mContext, "settings_auto_text_wrapping");
        layoutBuilder.setAlignment(this.getLayoutAlignment()).setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier()).setIncludePad(this.getIncludeFontPadding()).setUseLineSpacingFromFallbacks(this.isFallbackLineSpacingForStaticLayout()).setBreakStrategy(this.getBreakStrategy()).setHyphenationFrequency(this.getHyphenationFrequency()).setJustificationMode(this.getJustificationMode()).setMaxLines(this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE).setTextDirection(this.getTextDirectionHeuristic()).setLineBreakConfig(LineBreakConfig.getLineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle, autoPhraseBreaking));
        StaticLayout layout2 = layoutBuilder.build();
        if (maxLines != -1 && layout2.getLineCount() > maxLines) {
            return false;
        }
        return !((float)layout2.getHeight() > availableSpace.bottom);
    }

    private int getDesiredHeight() {
        return Math.max(this.getDesiredHeight(this.mLayout, true), this.getDesiredHeight(this.mHintLayout, this.mEllipsize != null));
    }

    private int getDesiredHeight(Layout layout2, boolean cap) {
        if (layout2 == null) {
            return 0;
        }
        int desired = layout2.getHeight(cap);
        Drawables dr = this.mDrawables;
        if (dr != null) {
            desired = Math.max(desired, dr.mDrawableHeightLeft);
            desired = Math.max(desired, dr.mDrawableHeightRight);
        }
        int linecount = layout2.getLineCount();
        int padding = this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
        desired += padding;
        if (this.mMaxMode != 1) {
            desired = Math.min(desired, this.mMaximum);
        } else if (cap && linecount > this.mMaximum && (layout2 instanceof DynamicLayout || layout2 instanceof BoringLayout)) {
            desired = layout2.getLineTop(this.mMaximum);
            if (dr != null) {
                desired = Math.max(desired, dr.mDrawableHeightLeft);
                desired = Math.max(desired, dr.mDrawableHeightRight);
            }
            desired += padding;
            linecount = this.mMaximum;
        }
        if (this.mMinMode == 1) {
            if (linecount < this.mMinimum) {
                desired += this.getLineHeight() * (this.mMinimum - linecount);
            }
        } else {
            desired = Math.max(desired, this.mMinimum);
        }
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }

    private void checkForResize() {
        boolean sizeChanged = false;
        if (this.mLayout != null) {
            int desiredHeight;
            if (this.mLayoutParams.width == -2) {
                sizeChanged = true;
                this.invalidate();
            }
            if (this.mLayoutParams.height == -2) {
                int desiredHeight2 = this.getDesiredHeight();
                if (desiredHeight2 != this.getHeight()) {
                    sizeChanged = true;
                }
            } else if (this.mLayoutParams.height == -1 && this.mDesiredHeightAtMeasure >= 0 && (desiredHeight = this.getDesiredHeight()) != this.mDesiredHeightAtMeasure) {
                sizeChanged = true;
            }
        }
        if (sizeChanged) {
            this.requestLayout();
        }
    }

    @UnsupportedAppUsage
    private void checkForRelayout() {
        if ((this.mLayoutParams.width != -2 || this.mMaxWidthMode == this.mMinWidthMode && this.mMaxWidth == this.mMinWidth) && (this.mHint == null || this.mHintLayout != null) && this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight() > 0) {
            int oldht = this.mLayout.getHeight();
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
            if (this.mEllipsize != TextUtils.TruncateAt.MARQUEE) {
                if (this.mLayoutParams.height != -2 && this.mLayoutParams.height != -1) {
                    this.autoSizeText();
                    this.invalidate();
                    return;
                }
                if (this.mLayout.getHeight() == oldht && (this.mHintLayout == null || this.mHintLayout.getHeight() == oldht)) {
                    this.autoSizeText();
                    this.invalidate();
                    return;
                }
            }
            this.requestLayout();
            this.invalidate();
        } else {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mDeferScroll >= 0) {
            int curs = this.mDeferScroll;
            this.mDeferScroll = -1;
            this.bringPointIntoView(Math.min(curs, this.mText.length()));
        }
        this.autoSizeText();
    }

    private boolean isShowingHint() {
        return TextUtils.isEmpty(this.mText) && !TextUtils.isEmpty(this.mHint) && !this.mHideHint;
    }

    @UnsupportedAppUsage
    private boolean bringTextIntoView() {
        int scrollx;
        Layout layout2 = this.isShowingHint() ? this.mHintLayout : this.mLayout;
        int line = 0;
        if ((this.mGravity & 0x70) == 80) {
            line = layout2.getLineCount() - 1;
        }
        Layout.Alignment a = layout2.getParagraphAlignment(line);
        int dir = layout2.getParagraphDirection(line);
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        int ht = layout2.getHeight();
        if (a == Layout.Alignment.ALIGN_NORMAL) {
            a = dir == 1 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
        } else if (a == Layout.Alignment.ALIGN_OPPOSITE) {
            Layout.Alignment alignment = a = dir == 1 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
        }
        if (a == Layout.Alignment.ALIGN_CENTER) {
            int left = (int)Math.floor(layout2.getLineLeft(line));
            int right = (int)Math.ceil(layout2.getLineRight(line));
            scrollx = right - left < hspace ? (right + left) / 2 - hspace / 2 : (dir < 0 ? right - hspace : left);
        } else if (a == Layout.Alignment.ALIGN_RIGHT) {
            int right = (int)Math.ceil(layout2.getLineRight(line));
            scrollx = right - hspace;
        } else {
            scrollx = (int)Math.floor(layout2.getLineLeft(line));
        }
        int scrolly = ht < vspace ? 0 : ((this.mGravity & 0x70) == 80 ? ht - vspace : 0);
        if (scrollx != this.mScrollX || scrolly != this.mScrollY) {
            this.scrollTo(scrollx, scrolly);
            return true;
        }
        return false;
    }

    public boolean bringPointIntoView(int offset) {
        return this.bringPointIntoView(offset, false);
    }

    public boolean bringPointIntoView(int offset, boolean requestRectWithoutFocus) {
        int hslack;
        int vslack;
        int grav;
        Layout layout2;
        if (this.isLayoutRequested()) {
            this.mDeferScroll = offset;
            return false;
        }
        int offsetTransformed = this.originalToTransformed(offset, 1);
        boolean changed = false;
        Layout layout3 = layout2 = this.isShowingHint() ? this.mHintLayout : this.mLayout;
        if (layout2 == null) {
            return changed;
        }
        int line = layout2.getLineForOffset(offsetTransformed);
        switch (layout2.getParagraphAlignment(line)) {
            case ALIGN_LEFT: {
                grav = 1;
                break;
            }
            case ALIGN_RIGHT: {
                grav = -1;
                break;
            }
            case ALIGN_NORMAL: {
                grav = layout2.getParagraphDirection(line);
                break;
            }
            case ALIGN_OPPOSITE: {
                grav = -layout2.getParagraphDirection(line);
                break;
            }
            default: {
                grav = 0;
            }
        }
        boolean clamped = grav > 0;
        int x = (int)layout2.getPrimaryHorizontal(offsetTransformed, clamped);
        int top = layout2.getLineTop(line);
        int bottom = layout2.getLineTop(line + 1);
        int left = (int)Math.floor(layout2.getLineLeft(line));
        int right = (int)Math.ceil(layout2.getLineRight(line));
        int ht = layout2.getHeight();
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        if (!this.mHorizontallyScrolling && right - left > hspace && right > x) {
            right = Math.max(x, left + hspace);
        }
        if ((vslack = (hslack = (bottom - top) / 2)) > vspace / 4) {
            vslack = vspace / 4;
        }
        if (hslack > hspace / 4) {
            hslack = hspace / 4;
        }
        int hs = this.mScrollX;
        int vs = this.mScrollY;
        if (top - vs < vslack) {
            vs = top - vslack;
        }
        if (bottom - vs > vspace - vslack) {
            vs = bottom - (vspace - vslack);
        }
        if (ht - vs < vspace) {
            vs = ht - vspace;
        }
        if (0 - vs > 0) {
            vs = 0;
        }
        if (grav != 0) {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (grav < 0) {
            if (left - hs > 0) {
                hs = left;
            }
            if (right - hs < hspace) {
                hs = right - hspace;
            }
        } else if (grav > 0) {
            if (right - hs < hspace) {
                hs = right - hspace;
            }
            if (left - hs > 0) {
                hs = left;
            }
        } else if (right - left <= hspace) {
            hs = left - (hspace - (right - left)) / 2;
        } else if (x > right - hslack) {
            hs = right - hspace;
        } else if (x < left + hslack) {
            hs = left;
        } else if (left > hs) {
            hs = left;
        } else if (right < hs + hspace) {
            hs = right - hspace;
        } else {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (hs != this.mScrollX || vs != this.mScrollY) {
            if (this.mScroller == null) {
                this.scrollTo(hs, vs);
            } else {
                long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
                int dx = hs - this.mScrollX;
                int dy = vs - this.mScrollY;
                if (duration > 250L) {
                    this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy);
                    this.awakenScrollBars(this.mScroller.getDuration());
                    this.invalidate();
                } else {
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    this.scrollBy(dx, dy);
                }
                this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
            }
            changed = true;
        }
        if (requestRectWithoutFocus || this.isFocused()) {
            if (this.mTempRect == null) {
                this.mTempRect = new Rect();
            }
            this.mTempRect.set(x - 2, top, x + 2, bottom);
            this.getInterestingRect(this.mTempRect, line);
            this.mTempRect.offset(this.mScrollX, this.mScrollY);
            if (this.requestRectangleOnScreen(this.mTempRect)) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean moveCursorToVisibleOffset() {
        int vs;
        int vspace;
        int end;
        if (!(this.mText instanceof Spannable)) {
            return false;
        }
        int start = this.getSelectionStartTransformed();
        if (start != (end = this.getSelectionEndTransformed())) {
            return false;
        }
        int line = this.mLayout.getLineForOffset(start);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        int vslack = (bottom - top) / 2;
        if (vslack > (vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom()) / 4) {
            vslack = vspace / 4;
        }
        if (top < (vs = this.mScrollY) + vslack) {
            line = this.mLayout.getLineForVertical(vs + vslack + (bottom - top));
        } else if (bottom > vspace + vs - vslack) {
            line = this.mLayout.getLineForVertical(vspace + vs - vslack - (bottom - top));
        }
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int hs = this.mScrollX;
        int leftChar = this.mLayout.getOffsetForHorizontal(line, hs);
        int rightChar = this.mLayout.getOffsetForHorizontal(line, hspace + hs);
        int lowChar = leftChar < rightChar ? leftChar : rightChar;
        int highChar = leftChar > rightChar ? leftChar : rightChar;
        int newStart = start;
        if (newStart < lowChar) {
            newStart = lowChar;
        } else if (newStart > highChar) {
            newStart = highChar;
        }
        if (newStart != start) {
            Selection.setSelection(this.mSpannable, this.transformedToOriginal(newStart, 1));
            return true;
        }
        return false;
    }

    @Override
    public void computeScroll() {
        if (this.mScroller != null && this.mScroller.computeScrollOffset()) {
            this.mScrollX = this.mScroller.getCurrX();
            this.mScrollY = this.mScroller.getCurrY();
            this.invalidateParentCaches();
            this.postInvalidate();
        }
    }

    private void getInterestingRect(Rect r, int line) {
        this.convertFromViewportToContentCoordinates(r);
        if (line == 0) {
            r.top -= this.getExtendedPaddingTop();
        }
        if (line == this.mLayout.getLineCount() - 1) {
            r.bottom += this.getExtendedPaddingBottom();
        }
    }

    private void convertFromViewportToContentCoordinates(Rect r) {
        int horizontalOffset = this.viewportToContentHorizontalOffset();
        r.left += horizontalOffset;
        r.right += horizontalOffset;
        int verticalOffset = this.viewportToContentVerticalOffset();
        r.top += verticalOffset;
        r.bottom += verticalOffset;
    }

    private PointF convertFromScreenToContentCoordinates(PointF point) {
        int[] screenToViewport = this.getLocationOnScreen();
        PointF copy = new PointF(point);
        copy.offset(-(screenToViewport[0] + this.viewportToContentHorizontalOffset()), -(screenToViewport[1] + this.viewportToContentVerticalOffset()));
        return copy;
    }

    private RectF convertFromScreenToContentCoordinates(RectF rect) {
        int[] screenToViewport = this.getLocationOnScreen();
        RectF copy = new RectF(rect);
        copy.offset(-(screenToViewport[0] + this.viewportToContentHorizontalOffset()), -(screenToViewport[1] + this.viewportToContentVerticalOffset()));
        return copy;
    }

    int viewportToContentHorizontalOffset() {
        return this.getCompoundPaddingLeft() - this.mScrollX;
    }

    @UnsupportedAppUsage
    int viewportToContentVerticalOffset() {
        int offset = this.getExtendedPaddingTop() - this.mScrollY;
        if ((this.mGravity & 0x70) != 48) {
            offset += this.getVerticalOffset(false);
        }
        return offset;
    }

    @Override
    public void debug(int depth) {
        super.debug(depth);
        String output = TextView.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        if (this.mText != null) {
            output = output + "mText=\"" + this.mText + "\" ";
            if (this.mLayout != null) {
                output = output + "mLayout width=" + this.mLayout.getWidth() + " height=" + this.mLayout.getHeight();
            }
        } else {
            output = output + "mText=NULL";
        }
        Log.d("View", output);
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionStart() {
        return Selection.getSelectionStart(this.getText());
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionEnd() {
        return Selection.getSelectionEnd(this.getText());
    }

    public void getSelection(int start, int end, Layout.SelectionRectangleConsumer consumer) {
        int transformedStart = this.originalToTransformed(start, 1);
        int transformedEnd = this.originalToTransformed(end, 1);
        this.mLayout.getSelection(transformedStart, transformedEnd, consumer);
    }

    int getSelectionStartTransformed() {
        int start = this.getSelectionStart();
        if (start < 0) {
            return start;
        }
        return this.originalToTransformed(start, 1);
    }

    int getSelectionEndTransformed() {
        int end = this.getSelectionEnd();
        if (end < 0) {
            return end;
        }
        return this.originalToTransformed(end, 1);
    }

    public boolean hasSelection() {
        int selectionMax;
        int selectionMin;
        int selectionEnd;
        int selectionStart = this.getSelectionStart();
        if (selectionStart < (selectionEnd = this.getSelectionEnd())) {
            selectionMin = selectionStart;
            selectionMax = selectionEnd;
        } else {
            selectionMin = selectionEnd;
            selectionMax = selectionStart;
        }
        return selectionMin >= 0 && selectionMax > 0 && selectionMin != selectionMax;
    }

    String getSelectedText() {
        int end;
        if (!this.hasSelection()) {
            return null;
        }
        int start = this.getSelectionStart();
        return String.valueOf(start > (end = this.getSelectionEnd()) ? this.mText.subSequence(end, start) : this.mText.subSequence(start, end));
    }

    public void setSingleLine() {
        this.setSingleLine(true);
    }

    @RemotableViewMethod
    public void setAllCaps(boolean allCaps) {
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        } else {
            this.setTransformationMethod(null);
        }
    }

    public boolean isAllCaps() {
        TransformationMethod method = this.getTransformationMethod();
        return method != null && method instanceof AllCapsTransformationMethod;
    }

    @RemotableViewMethod
    public void setSingleLine(boolean singleLine) {
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, true, true, true);
    }

    private void setInputTypeSingleLine(boolean singleLine) {
        if (this.mEditor != null && (this.mEditor.mInputType & 0xF) == 1) {
            this.mEditor.mInputType = singleLine ? (this.mEditor.mInputType &= 0xFFFDFFFF) : (this.mEditor.mInputType |= 0x20000);
        }
    }

    private void applySingleLine(boolean singleLine, boolean applyTransformation, boolean changeMaxLines, boolean changeMaxLength) {
        this.mSingleLine = singleLine;
        if (singleLine) {
            this.setLines(1);
            this.setHorizontallyScrolling(true);
            if (applyTransformation) {
                this.setTransformationMethod(SingleLineTransformationMethod.getInstance());
            }
            if (!changeMaxLength) {
                return;
            }
            if (this.mBufferType != BufferType.EDITABLE) {
                return;
            }
            InputFilter[] prevFilters = this.getFilters();
            for (InputFilter filter : this.getFilters()) {
                if (!(filter instanceof InputFilter.LengthFilter)) continue;
                return;
            }
            if (this.mSingleLineLengthFilter == null) {
                this.mSingleLineLengthFilter = new InputFilter.LengthFilter(5000);
            }
            InputFilter[] newFilters = new InputFilter[prevFilters.length + 1];
            System.arraycopy(prevFilters, 0, newFilters, 0, prevFilters.length);
            newFilters[prevFilters.length] = this.mSingleLineLengthFilter;
            this.setFilters(newFilters);
            this.setText(this.getText());
        } else {
            if (changeMaxLines) {
                this.setMaxLines(Integer.MAX_VALUE);
            }
            this.setHorizontallyScrolling(false);
            if (applyTransformation) {
                this.setTransformationMethod(null);
            }
            if (!changeMaxLength) {
                return;
            }
            if (this.mBufferType != BufferType.EDITABLE) {
                return;
            }
            InputFilter[] prevFilters = this.getFilters();
            if (prevFilters.length == 0) {
                return;
            }
            if (this.mSingleLineLengthFilter == null) {
                return;
            }
            int targetIndex = -1;
            for (int i = 0; i < prevFilters.length; ++i) {
                if (prevFilters[i] != this.mSingleLineLengthFilter) continue;
                targetIndex = i;
                break;
            }
            if (targetIndex == -1) {
                return;
            }
            if (prevFilters.length == 1) {
                this.setFilters(NO_FILTERS);
                return;
            }
            InputFilter[] newFilters = new InputFilter[prevFilters.length - 1];
            System.arraycopy(prevFilters, 0, newFilters, 0, targetIndex);
            System.arraycopy(prevFilters, targetIndex + 1, newFilters, targetIndex, prevFilters.length - targetIndex - 1);
            this.setFilters(newFilters);
            this.mSingleLineLengthFilter = null;
        }
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        if (this.mEllipsize != where) {
            this.mEllipsize = where;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setMarqueeRepeatLimit(int marqueeLimit) {
        this.mMarqueeRepeatLimit = marqueeLimit;
    }

    public int getMarqueeRepeatLimit() {
        return this.mMarqueeRepeatLimit;
    }

    @ViewDebug.ExportedProperty
    public TextUtils.TruncateAt getEllipsize() {
        return this.mEllipsize;
    }

    @RemotableViewMethod
    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.createEditorIfNeeded();
        this.mEditor.mSelectAllOnFocus = selectAllOnFocus;
        if (selectAllOnFocus && !(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
    }

    @RemotableViewMethod
    public void setCursorVisible(boolean visible) {
        this.mCursorVisibleFromAttr = visible;
        this.updateCursorVisibleInternal();
    }

    public void setImeConsumesInput(boolean imeConsumesInput) {
        this.mImeIsConsumingInput = imeConsumesInput;
        this.updateCursorVisibleInternal();
    }

    private void updateCursorVisibleInternal() {
        boolean visible;
        boolean bl = visible = this.mCursorVisibleFromAttr && !this.mImeIsConsumingInput;
        if (visible && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mCursorVisible != visible) {
            this.mEditor.mCursorVisible = visible;
            this.invalidate();
            this.mEditor.makeBlink();
            this.mEditor.prepareCursorControllers();
        }
    }

    public boolean isCursorVisible() {
        return this.mEditor == null ? true : this.mEditor.mCursorVisible;
    }

    public boolean isCursorVisibleFromAttr() {
        return this.mCursorVisibleFromAttr;
    }

    private boolean canMarquee() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        return width > 0 && (this.mLayout.getLineWidth(0) > (float)width || this.mMarqueeFadeMode != 0 && this.mSavedMarqueeModeLayout != null && this.mSavedMarqueeModeLayout.getLineWidth(0) > (float)width);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    protected void startMarquee() {
        if (this.getKeyListener() != null) {
            return;
        }
        if (this.compressText(this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) {
            return;
        }
        if ((this.mMarquee == null || this.mMarquee.isStopped()) && this.isAggregatedVisible() && (this.isFocused() || this.isSelected()) && this.getLineCount() == 1 && this.canMarquee()) {
            if (this.mMarqueeFadeMode == 1) {
                this.mMarqueeFadeMode = 2;
                Layout tmp = this.mLayout;
                this.mLayout = this.mSavedMarqueeModeLayout;
                this.mSavedMarqueeModeLayout = tmp;
                this.setHorizontalFadingEdgeEnabled(true);
                this.requestLayout();
                this.invalidate();
            }
            if (this.mMarquee == null) {
                this.mMarquee = new Marquee(this);
            }
            this.mMarquee.start(this.mMarqueeRepeatLimit);
        }
    }

    protected void stopMarquee() {
        if (this.mMarquee != null && !this.mMarquee.isStopped()) {
            this.mMarquee.stop();
        }
        if (this.mMarqueeFadeMode == 2) {
            this.mMarqueeFadeMode = 1;
            Layout tmp = this.mSavedMarqueeModeLayout;
            this.mSavedMarqueeModeLayout = this.mLayout;
            this.mLayout = tmp;
            this.setHorizontalFadingEdgeEnabled(false);
            this.requestLayout();
            this.invalidate();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private void startStopMarquee(boolean start) {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (start) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        this.sendAccessibilityEvent(8192);
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (this.mListeners != null && (i = this.mListeners.indexOf(watcher)) >= 0) {
            this.mListeners.remove(i);
        }
    }

    private void sendBeforeTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).beforeTextChanged(text, start, before, after);
            }
        }
        this.removeIntersectingNonAdjacentSpans(start, start + before, SpellCheckSpan.class);
        this.removeIntersectingNonAdjacentSpans(start, start + before, SuggestionSpan.class);
    }

    private <T> void removeIntersectingNonAdjacentSpans(int start, int end, Class<T> type) {
        if (!(this.mText instanceof Editable)) {
            return;
        }
        Editable text = (Editable)this.mText;
        T[] spans = text.getSpans(start, end, type);
        ArrayList<T> spansToRemove = new ArrayList<T>();
        for (T span : spans) {
            int spanStart = text.getSpanStart(span);
            int spanEnd = text.getSpanEnd(span);
            if (spanEnd == start || spanStart == end) continue;
            spansToRemove.add(span);
        }
        for (Object span : spansToRemove) {
            text.removeSpan(span);
        }
    }

    void removeAdjacentSuggestionSpans(int pos) {
        if (!(this.mText instanceof Editable)) {
            return;
        }
        Editable text = (Editable)this.mText;
        SuggestionSpan[] spans = text.getSpans(pos, pos, SuggestionSpan.class);
        int length = spans.length;
        for (int i = 0; i < length; ++i) {
            int spanStart = text.getSpanStart(spans[i]);
            int spanEnd = text.getSpanEnd(spans[i]);
            if (spanEnd != pos && spanStart != pos || !SpellChecker.haveWordBoundariesChanged(text, pos, pos, spanStart, spanEnd)) continue;
            text.removeSpan(spans[i]);
        }
    }

    void sendOnTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).onTextChanged(text, start, before, after);
            }
        }
        if (this.mEditor != null) {
            this.mEditor.sendOnTextChanged(start, before, after);
        }
    }

    void sendAfterTextChanged(Editable text) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).afterTextChanged(text);
            }
        }
        this.notifyListeningManagersAfterTextChanged();
        this.hideErrorIfUnchanged();
    }

    private void notifyListeningManagersAfterTextChanged() {
        AutofillManager afm;
        if (this.isAutofillable() && (afm = this.mContext.getSystemService(AutofillManager.class)) != null) {
            if (Helper.sVerbose) {
                Log.v(LOG_TAG, "notifyAutoFillManagerAfterTextChanged");
            }
            afm.notifyValueChanged(this);
        }
        this.notifyContentCaptureTextChanged();
    }

    public void notifyContentCaptureTextChanged() {
        ContentCaptureSession session;
        ContentCaptureManager cm;
        if (this.isLaidOut() && this.isImportantForContentCapture() && this.getNotifiedContentCaptureAppeared() && (cm = this.mContext.getSystemService(ContentCaptureManager.class)) != null && cm.isContentCaptureEnabled() && (session = this.getContentCaptureSession()) != null) {
            session.notifyViewTextChanged(this.getAutofillId(), this.getText());
        }
    }

    private boolean isAutofillable() {
        return this.getAutofillType() != 0;
    }

    void updateAfterEdit() {
        this.invalidate();
        int curs = this.getSelectionStart();
        if (curs >= 0 || (this.mGravity & 0x70) == 80) {
            this.registerForPreDraw();
        }
        this.checkForResize();
        if (curs >= 0) {
            this.mHighlightPathBogus = true;
            if (this.mEditor != null) {
                this.mEditor.makeBlink();
            }
            this.bringPointIntoView(curs);
        }
    }

    void handleTextChanged(CharSequence buffer, int start, int before, int after) {
        Editor.InputMethodState ims;
        sLastCutCopyOrTextChangedTime = 0L;
        Editor.InputMethodState inputMethodState = ims = this.mEditor == null ? null : this.mEditor.mInputMethodState;
        if (ims == null || ims.mBatchEditNesting == 0) {
            this.updateAfterEdit();
        }
        if (ims != null) {
            ims.mContentChanged = true;
            if (ims.mChangedStart < 0) {
                ims.mChangedStart = start;
                ims.mChangedEnd = start + before;
            } else {
                ims.mChangedStart = Math.min(ims.mChangedStart, start);
                ims.mChangedEnd = Math.max(ims.mChangedEnd, start + before - ims.mChangedDelta);
            }
            ims.mChangedDelta += after - before;
        }
        this.resetErrorChangedFlag();
        this.sendOnTextChanged(buffer, start, before, after);
        this.onTextChanged(buffer, start, before, after);
        this.mHideHint = false;
        this.clearGesturePreviewHighlight();
    }

    void spanChange(Spanned buf, Object what, int oldStart, int newStart, int oldEnd, int newEnd) {
        Editor.InputMethodState ims;
        boolean selChanged = false;
        int newSelStart = -1;
        int newSelEnd = -1;
        Editor.InputMethodState inputMethodState = ims = this.mEditor == null ? null : this.mEditor.mInputMethodState;
        if (what == Selection.SELECTION_END) {
            selChanged = true;
            newSelEnd = newStart;
            if (oldStart >= 0 || newStart >= 0) {
                this.invalidateCursor(Selection.getSelectionStart(buf), oldStart, newStart);
                this.checkForResize();
                this.registerForPreDraw();
                if (this.mEditor != null) {
                    this.mEditor.makeBlink();
                }
            }
        }
        if (what == Selection.SELECTION_START) {
            selChanged = true;
            newSelStart = newStart;
            if (oldStart >= 0 || newStart >= 0) {
                int end = Selection.getSelectionEnd(buf);
                this.invalidateCursor(end, oldStart, newStart);
            }
        }
        if (selChanged) {
            this.clearGesturePreviewHighlight();
            this.mHighlightPathBogus = true;
            if (this.mEditor != null && !this.isFocused()) {
                this.mEditor.mSelectionMoved = true;
            }
            if ((buf.getSpanFlags(what) & 0x200) == 0) {
                if (newSelStart < 0) {
                    newSelStart = Selection.getSelectionStart(buf);
                }
                if (newSelEnd < 0) {
                    newSelEnd = Selection.getSelectionEnd(buf);
                }
                if (this.mEditor != null) {
                    this.mEditor.refreshTextActionMode();
                    if (!this.hasSelection() && this.mEditor.getTextActionMode() == null && this.hasTransientState()) {
                        this.setHasTransientState(false);
                    }
                }
                this.onSelectionChanged(newSelStart, newSelEnd);
            }
        }
        if (what instanceof UpdateAppearance || what instanceof ParagraphStyle || what instanceof CharacterStyle) {
            if (ims == null || ims.mBatchEditNesting == 0) {
                this.invalidate();
                this.mHighlightPathBogus = true;
                this.checkForResize();
            } else {
                ims.mContentChanged = true;
            }
            if (this.mEditor != null) {
                if (oldStart >= 0) {
                    this.mEditor.invalidateTextDisplayList(this.mLayout, oldStart, oldEnd);
                }
                if (newStart >= 0) {
                    this.mEditor.invalidateTextDisplayList(this.mLayout, newStart, newEnd);
                }
                this.mEditor.invalidateHandlesAndActionMode();
            }
        }
        if (MetaKeyKeyListener.isMetaTracker(buf, what)) {
            this.mHighlightPathBogus = true;
            if (ims != null && MetaKeyKeyListener.isSelectingMetaTracker(buf, what)) {
                ims.mSelectionModeChanged = true;
            }
            if (Selection.getSelectionStart(buf) >= 0) {
                if (ims == null || ims.mBatchEditNesting == 0) {
                    this.invalidateCursor();
                } else {
                    ims.mCursorChanged = true;
                }
            }
        }
        if (what instanceof ParcelableSpan && ims != null && ims.mExtractedTextRequest != null) {
            if (ims.mBatchEditNesting != 0) {
                if (oldStart >= 0) {
                    if (ims.mChangedStart > oldStart) {
                        ims.mChangedStart = oldStart;
                    }
                    if (ims.mChangedStart > oldEnd) {
                        ims.mChangedStart = oldEnd;
                    }
                }
                if (newStart >= 0) {
                    if (ims.mChangedStart > newStart) {
                        ims.mChangedStart = newStart;
                    }
                    if (ims.mChangedStart > newEnd) {
                        ims.mChangedStart = newEnd;
                    }
                }
            } else {
                ims.mContentChanged = true;
            }
        }
        if (this.mEditor != null && this.mEditor.mSpellChecker != null && newStart < 0 && what instanceof SpellCheckSpan) {
            this.mEditor.mSpellChecker.onSpellCheckSpanRemoved((SpellCheckSpan)what);
        }
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (this.isTemporarilyDetached()) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            return;
        }
        this.mHideHint = false;
        if (this.mEditor != null) {
            this.mEditor.onFocusChanged(focused, direction);
        }
        if (focused && this.mSpannable != null) {
            MetaKeyKeyListener.resetMetaState(this.mSpannable);
        }
        this.startStopMarquee(focused);
        if (this.mTransformation != null) {
            this.mTransformation.onFocusChanged(this, this.mText, focused, direction, previouslyFocusedRect);
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mEditor != null) {
            this.mEditor.onWindowFocusChanged(hasWindowFocus);
        }
        this.startStopMarquee(hasWindowFocus);
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mEditor != null && visibility != 0) {
            this.mEditor.hideCursorAndSpanControllers();
            this.stopTextActionMode();
        }
    }

    @Override
    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        this.startStopMarquee(isVisible);
    }

    public void clearComposingText() {
        if (this.mText instanceof Spannable) {
            BaseInputConnection.removeComposingSpans(this.mSpannable);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        boolean wasSelected = this.isSelected();
        super.setSelected(selected);
        if (selected != wasSelected && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (selected) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    boolean isFromPrimePointer(MotionEvent event, boolean fromHandleView) {
        boolean res = true;
        if (this.mPrimePointerId == -1) {
            this.mPrimePointerId = event.getPointerId(0);
            this.mIsPrimePointerFromHandleView = fromHandleView;
        } else if (this.mPrimePointerId != event.getPointerId(0)) {
            boolean bl = res = this.mIsPrimePointerFromHandleView && fromHandleView;
        }
        if (event.getActionMasked() == 1 || event.getActionMasked() == 3) {
            this.mPrimePointerId = -1;
        }
        return res;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        boolean touchIsFinished;
        this.mLastInputSource = event.getSource();
        int action = event.getActionMasked();
        if (this.mEditor != null) {
            if (!this.isFromPrimePointer(event, false)) {
                return true;
            }
            this.mEditor.onTouchEvent(event);
            if (this.mEditor.mInsertionPointCursorController != null && this.mEditor.mInsertionPointCursorController.isCursorBeingModified()) {
                return true;
            }
            if (this.mEditor.mSelectionModifierCursorController != null && this.mEditor.mSelectionModifierCursorController.isDragAcceleratorActive()) {
                return true;
            }
        }
        boolean superResult = super.onTouchEvent(event);
        if (this.mEditor != null && this.mEditor.mDiscardNextActionUp && action == 1) {
            this.mEditor.mDiscardNextActionUp = false;
            if (this.mEditor.mIsInsertionActionModeStartPending) {
                this.mEditor.startInsertionActionMode();
                this.mEditor.mIsInsertionActionModeStartPending = false;
            }
            return superResult;
        }
        boolean bl = touchIsFinished = action == 1 && (this.mEditor == null || !this.mEditor.mIgnoreActionUpEvent) && this.isFocused();
        if ((this.mMovement != null || this.onCheckIsTextEditor()) && this.isEnabled() && this.mText instanceof Spannable && this.mLayout != null) {
            ClickableSpan[] links;
            boolean handled = false;
            if (this.mMovement != null) {
                handled |= this.mMovement.onTouchEvent(this, this.mSpannable, event);
            }
            boolean textIsSelectable = this.isTextSelectable();
            if (touchIsFinished && this.mLinksClickable && this.mAutoLinkMask != 0 && textIsSelectable && (links = this.mSpannable.getSpans(this.getSelectionStart(), this.getSelectionEnd(), ClickableSpan.class)).length > 0) {
                links[0].onClick(this);
                handled = true;
            }
            if (touchIsFinished && (this.isTextEditable() || textIsSelectable)) {
                InputMethodManager imm = this.getInputMethodManager();
                this.viewClicked(imm);
                if (this.isTextEditable() && this.mEditor.mShowSoftInputOnFocus && imm != null && !this.showAutofillDialog()) {
                    imm.showSoftInput(this, 0);
                }
                this.mEditor.onTouchUpEvent(event);
                handled = true;
            }
            if (handled) {
                return true;
            }
        }
        return superResult;
    }

    public boolean showUIForTouchScreen() {
        return (this.mLastInputSource & 0x1002) == 4098;
    }

    private boolean showAutofillDialog() {
        AutofillManager afm = this.mContext.getSystemService(AutofillManager.class);
        if (afm != null) {
            return afm.showAutofillDialog(this);
        }
        return false;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null) {
            try {
                if (this.mMovement.onGenericMotionEvent(this, this.mSpannable, event)) {
                    return true;
                }
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return super.onGenericMotionEvent(event);
    }

    @Override
    protected void onCreateContextMenu(ContextMenu menu2) {
        if (this.mEditor != null) {
            this.mEditor.onCreateContextMenu(menu2);
        }
    }

    @Override
    public boolean showContextMenu() {
        if (this.mEditor != null) {
            this.mEditor.setContextMenuAnchor(Float.NaN, Float.NaN);
        }
        return super.showContextMenu();
    }

    @Override
    public boolean showContextMenu(float x, float y) {
        if (this.mEditor != null) {
            this.mEditor.setContextMenuAnchor(x, y);
        }
        return super.showContextMenu(x, y);
    }

    @UnsupportedAppUsage
    boolean isTextEditable() {
        return this.mText instanceof Editable && this.onCheckIsTextEditor() && this.isEnabled();
    }

    public boolean didTouchFocusSelect() {
        return this.mEditor != null && this.mEditor.mTouchFocusSelected;
    }

    @Override
    public void cancelLongPress() {
        super.cancelLongPress();
        if (this.mEditor != null) {
            this.mEditor.mIgnoreActionUpEvent = true;
        }
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        if (this.mMovement != null && this.mSpannable != null && this.mLayout != null && this.mMovement.onTrackballEvent(this, this.mSpannable, event)) {
            return true;
        }
        return super.onTrackballEvent(event);
    }

    public void setScroller(Scroller s) {
        this.mScroller = s;
    }

    @Override
    protected float getLeftFadingEdgeStrength() {
        if (this.isMarqueeFadeEnabled() && this.mMarquee != null && !this.mMarquee.isStopped()) {
            Marquee marquee = this.mMarquee;
            if (marquee.shouldDrawLeftFade()) {
                return this.getHorizontalFadingEdgeStrength(marquee.getScroll(), 0.0f);
            }
            return 0.0f;
        }
        if (this.getLineCount() == 1) {
            float lineLeft = this.getLayout().getLineLeft(0);
            if (lineLeft > (float)this.mScrollX) {
                return 0.0f;
            }
            return this.getHorizontalFadingEdgeStrength(this.mScrollX, lineLeft);
        }
        return super.getLeftFadingEdgeStrength();
    }

    @Override
    protected float getRightFadingEdgeStrength() {
        if (this.isMarqueeFadeEnabled() && this.mMarquee != null && !this.mMarquee.isStopped()) {
            Marquee marquee = this.mMarquee;
            return this.getHorizontalFadingEdgeStrength(marquee.getMaxFadeScroll(), marquee.getScroll());
        }
        if (this.getLineCount() == 1) {
            float rightEdge = this.mScrollX + (this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight());
            float lineRight = this.getLayout().getLineRight(0);
            if (lineRight < rightEdge) {
                return 0.0f;
            }
            return this.getHorizontalFadingEdgeStrength(rightEdge, lineRight);
        }
        return super.getRightFadingEdgeStrength();
    }

    private float getHorizontalFadingEdgeStrength(float position1, float position2) {
        int horizontalFadingEdgeLength = this.getHorizontalFadingEdgeLength();
        if (horizontalFadingEdgeLength == 0) {
            return 0.0f;
        }
        float diff = Math.abs(position1 - position2);
        if (diff > (float)horizontalFadingEdgeLength) {
            return 1.0f;
        }
        return diff / (float)horizontalFadingEdgeLength;
    }

    private boolean isMarqueeFadeEnabled() {
        return this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1;
    }

    @Override
    protected int computeHorizontalScrollRange() {
        if (this.mLayout != null) {
            return this.mSingleLine && (this.mGravity & 7) == 3 ? (int)this.mLayout.getLineWidth(0) : this.mLayout.getWidth();
        }
        return super.computeHorizontalScrollRange();
    }

    @Override
    protected int computeVerticalScrollRange() {
        if (this.mLayout != null) {
            return this.mLayout.getHeight();
        }
        return super.computeVerticalScrollRange();
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return this.getHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
    }

    @Override
    public void findViewsWithText(ArrayList<View> outViews, CharSequence searched, int flags) {
        super.findViewsWithText(outViews, searched, flags);
        if (!(outViews.contains(this) || (flags & 1) == 0 || TextUtils.isEmpty(searched) || TextUtils.isEmpty(this.mText))) {
            String searchedLowerCase = searched.toString().toLowerCase();
            String textLowerCase = this.mText.toString().toLowerCase();
            if (textLowerCase.contains(searchedLowerCase)) {
                outViews.add(this);
            }
        }
    }

    public static ColorStateList getTextColors(Context context, TypedArray attrs) {
        int ap;
        if (attrs == null) {
            throw new NullPointerException();
        }
        TypedArray a = context.obtainStyledAttributes(R.styleable.TextView);
        ColorStateList colors = a.getColorStateList(5);
        if (colors == null && (ap = a.getResourceId(1, 0)) != 0) {
            TypedArray appearance = context.obtainStyledAttributes(ap, R.styleable.TextAppearance);
            colors = appearance.getColorStateList(3);
            appearance.recycle();
        }
        a.recycle();
        return colors;
    }

    public static int getTextColor(Context context, TypedArray attrs, int def) {
        ColorStateList colors = TextView.getTextColors(context, attrs);
        if (colors == null) {
            return def;
        }
        return colors.getDefaultColor();
    }

    @Override
    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        if (event.hasModifiers(4096)) {
            switch (keyCode) {
                case 29: {
                    if (!this.canSelectText()) break;
                    return this.onTextContextMenuItem(16908319);
                }
                case 54: {
                    if (!this.canUndo()) break;
                    return this.onTextContextMenuItem(16908338);
                }
                case 52: {
                    if (!this.canCut()) break;
                    return this.onTextContextMenuItem(0x1020020);
                }
                case 31: {
                    if (!this.canCopy()) break;
                    return this.onTextContextMenuItem(0x1020021);
                }
                case 50: {
                    if (!this.canPaste()) break;
                    return this.onTextContextMenuItem(0x1020022);
                }
                case 53: {
                    if (!this.canRedo()) break;
                    return this.onTextContextMenuItem(16908339);
                }
            }
        } else if (event.hasModifiers(4097)) {
            switch (keyCode) {
                case 54: {
                    if (!this.canRedo()) break;
                    return this.onTextContextMenuItem(16908339);
                }
                case 50: {
                    if (!this.canPaste()) break;
                    return this.onTextContextMenuItem(16908337);
                }
            }
        }
        return super.onKeyShortcut(keyCode, event);
    }

    boolean canSelectText() {
        return this.mText.length() != 0 && this.mEditor != null && this.mEditor.hasSelectionController();
    }

    boolean textCanBeSelected() {
        if (this.mMovement == null || !this.mMovement.canSelectArbitrarily()) {
            return false;
        }
        return this.isTextEditable() || this.isTextSelectable() && this.mText instanceof Spannable && this.isEnabled();
    }

    @UnsupportedAppUsage
    private Locale getTextServicesLocale(boolean allowNullLocale) {
        this.updateTextServicesLocaleAsync();
        return this.mCurrentSpellCheckerLocaleCache == null && !allowNullLocale ? AndroidLocale.getDefault() : this.mCurrentSpellCheckerLocaleCache;
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public void setTextOperationUser(UserHandle user) {
        if (Objects.equals(this.mTextOperationUser, user)) {
            return;
        }
        if (user != null && !Process.myUserHandle().equals(user) && this.getContext().checkSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            throw new SecurityException("INTERACT_ACROSS_USERS_FULL is required. userId=" + user.getIdentifier() + " callingUserId" + UserHandle.myUserId());
        }
        this.mTextOperationUser = user;
        this.mCurrentSpellCheckerLocaleCache = null;
        if (this.mEditor != null) {
            this.mEditor.onTextOperationUserChanged();
        }
    }

    @Override
    public boolean isAutoHandwritingEnabled() {
        return super.isAutoHandwritingEnabled() && !this.isAnyPasswordInputType();
    }

    @Override
    public boolean isStylusHandwritingAvailable() {
        if (this.mTextOperationUser == null) {
            return super.isStylusHandwritingAvailable();
        }
        int userId = this.mTextOperationUser.getIdentifier();
        InputMethodManager imm = this.getInputMethodManager();
        return imm.isStylusHandwritingAvailableAsUser(userId);
    }

    TextServicesManager getTextServicesManagerForUser() {
        return this.getServiceManagerForUser("android", TextServicesManager.class);
    }

    ClipboardManager getClipboardManagerForUser() {
        return this.getServiceManagerForUser(this.getContext().getPackageName(), ClipboardManager.class);
    }

    TextClassificationManager getTextClassificationManagerForUser() {
        return this.getServiceManagerForUser(this.getContext().getPackageName(), TextClassificationManager.class);
    }

    <T> T getServiceManagerForUser(String packageName, Class<T> managerClazz) {
        if (this.mTextOperationUser == null) {
            return this.getContext().getSystemService(managerClazz);
        }
        try {
            Context context = this.getContext().createPackageContextAsUser(packageName, 0, this.mTextOperationUser);
            return context.getSystemService(managerClazz);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    void startActivityAsTextOperationUserIfNecessary(Intent intent) {
        if (this.mTextOperationUser != null) {
            this.getContext().startActivityAsUser(intent, this.mTextOperationUser);
        } else {
            this.getContext().startActivity(intent);
        }
    }

    public Locale getTextServicesLocale() {
        return this.getTextServicesLocale(false);
    }

    public boolean isInExtractedMode() {
        return false;
    }

    private boolean isAutoSizeEnabled() {
        return this.supportsAutoSizeText() && this.mAutoSizeTextType != 0;
    }

    protected boolean supportsAutoSizeText() {
        return true;
    }

    public Locale getSpellCheckerLocale() {
        return this.getTextServicesLocale(true);
    }

    private void updateTextServicesLocaleAsync() {
        AsyncTask.execute(new Runnable(){

            @Override
            public void run() {
                TextView.this.updateTextServicesLocaleLocked();
            }
        });
    }

    @UnsupportedAppUsage
    private void updateTextServicesLocaleLocked() {
        TextServicesManager textServicesManager = this.getTextServicesManagerForUser();
        if (textServicesManager == null) {
            return;
        }
        SpellCheckerSubtype subtype = textServicesManager.getCurrentSpellCheckerSubtype(true);
        Locale locale = subtype != null ? subtype.getLocaleObject() : null;
        this.mCurrentSpellCheckerLocaleCache = locale;
    }

    void onLocaleChanged() {
        this.mEditor.onLocaleChanged();
    }

    public WordIterator getWordIterator() {
        if (this.mEditor != null) {
            return this.mEditor.getWordIterator();
        }
        return null;
    }

    @Override
    public void onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        super.onPopulateAccessibilityEventInternal(event);
        if (this.isAccessibilityDataSensitive() && !event.isAccessibilityDataSensitive()) {
            return;
        }
        CharSequence text = this.getTextForAccessibility();
        if (!TextUtils.isEmpty(text)) {
            event.getText().add(text);
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return TextView.class.getName();
    }

    @Override
    protected void onProvideStructure(ViewStructure structure, int viewFor, int flags) {
        block38: {
            boolean isPassword;
            super.onProvideStructure(structure, viewFor, flags);
            boolean bl = isPassword = this.hasPasswordTransformationMethod() || TextView.isPasswordInputType(this.getInputType());
            if (viewFor == 1 || viewFor == 2) {
                String[] mimeTypes;
                block37: {
                    if (viewFor == 1) {
                        structure.setDataIsSensitive(!this.mTextSetFromXmlOrResourceId);
                    }
                    if (this.mTextId != 0) {
                        try {
                            structure.setTextIdEntry(this.getResources().getResourceEntryName(this.mTextId));
                        }
                        catch (Resources.NotFoundException e) {
                            if (!Helper.sVerbose) break block37;
                            Log.v(LOG_TAG, "onProvideAutofillStructure(): cannot set name for text id " + this.mTextId + ": " + e.getMessage());
                        }
                    }
                }
                if ((mimeTypes = this.getReceiveContentMimeTypes()) == null && this.mEditor != null) {
                    mimeTypes = this.mEditor.getDefaultOnReceiveContentListener().getFallbackMimeTypesForAutofill(this);
                }
                structure.setReceiveContentMimeTypes(mimeTypes);
            }
            if (!isPassword || viewFor == 1 || viewFor == 2) {
                Layout layout2;
                int lineCount;
                if (this.mLayout == null) {
                    if (viewFor == 2) {
                        Log.w(LOG_TAG, "onProvideContentCaptureStructure(): calling assumeLayout()");
                    }
                    this.assumeLayout();
                }
                if ((lineCount = (layout2 = this.mLayout).getLineCount()) <= 1) {
                    CharSequence text = this.getText();
                    if (viewFor == 1) {
                        structure.setText(text);
                    } else {
                        structure.setText(text, this.getSelectionStart(), this.getSelectionEnd());
                    }
                } else {
                    CharSequence text;
                    int selEnd;
                    int expandedBottomLine;
                    int bottomLine;
                    int topLine;
                    int[] tmpCords = new int[2];
                    this.getLocationInWindow(tmpCords);
                    int topWindowLocation = tmpCords[1];
                    View root = this;
                    ViewParent viewParent = this.getParent();
                    while (viewParent instanceof View) {
                        root = (View)((Object)viewParent);
                        viewParent = root.getParent();
                    }
                    int windowHeight = root.getHeight();
                    if (topWindowLocation >= 0) {
                        topLine = this.getLineAtCoordinateUnclamped(0.0f);
                        bottomLine = this.getLineAtCoordinateUnclamped(windowHeight - 1);
                    } else {
                        topLine = this.getLineAtCoordinateUnclamped(-topWindowLocation);
                        bottomLine = this.getLineAtCoordinateUnclamped(windowHeight - 1 - topWindowLocation);
                    }
                    int expandedTopLine = topLine - (bottomLine - topLine) / 2;
                    if (expandedTopLine < 0) {
                        expandedTopLine = 0;
                    }
                    if ((expandedBottomLine = bottomLine + (bottomLine - topLine) / 2) >= lineCount) {
                        expandedBottomLine = lineCount - 1;
                    }
                    int expandedTopChar = this.transformedToOriginal(layout2.getLineStart(expandedTopLine), 0);
                    int expandedBottomChar = this.transformedToOriginal(layout2.getLineEnd(expandedBottomLine), 0);
                    int selStart = this.getSelectionStart();
                    if (selStart < (selEnd = this.getSelectionEnd())) {
                        if (selStart < expandedTopChar) {
                            expandedTopChar = selStart;
                        }
                        if (selEnd > expandedBottomChar) {
                            expandedBottomChar = selEnd;
                        }
                    }
                    if ((text = this.getText()) != null) {
                        if (expandedTopChar > 0 || expandedBottomChar < text.length()) {
                            expandedTopChar = Math.min(expandedTopChar, text.length());
                            expandedBottomChar = Math.min(expandedBottomChar, text.length());
                            text = text.subSequence(expandedTopChar, expandedBottomChar);
                        }
                        if (viewFor == 1) {
                            structure.setText(text);
                        } else {
                            structure.setText(text, selStart - expandedTopChar, selEnd - expandedTopChar);
                            int[] lineOffsets = new int[bottomLine - topLine + 1];
                            int[] lineBaselines = new int[bottomLine - topLine + 1];
                            int baselineOffset = this.getBaselineOffset();
                            for (int i = topLine; i <= bottomLine; ++i) {
                                lineOffsets[i - topLine] = this.transformedToOriginal(layout2.getLineStart(i), 0);
                                lineBaselines[i - topLine] = layout2.getLineBaseline(i) + baselineOffset;
                            }
                            structure.setTextLines(lineOffsets, lineBaselines);
                        }
                    }
                }
                if (viewFor == 0 || viewFor == 2) {
                    int paintFlags;
                    int style2 = 0;
                    int typefaceStyle = this.getTypefaceStyle();
                    if ((typefaceStyle & 1) != 0) {
                        style2 |= 1;
                    }
                    if ((typefaceStyle & 2) != 0) {
                        style2 |= 2;
                    }
                    if (((paintFlags = this.mTextPaint.getFlags()) & 0x20) != 0) {
                        style2 |= 1;
                    }
                    if ((paintFlags & 8) != 0) {
                        style2 |= 4;
                    }
                    if ((paintFlags & 0x10) != 0) {
                        style2 |= 8;
                    }
                    structure.setTextStyle(this.getTextSize(), this.getCurrentTextColor(), 1, style2);
                }
                if (viewFor == 1 || viewFor == 2) {
                    structure.setMinTextEms(this.getMinEms());
                    structure.setMaxTextEms(this.getMaxEms());
                    int maxLength = -1;
                    for (InputFilter filter : this.getFilters()) {
                        if (!(filter instanceof InputFilter.LengthFilter)) continue;
                        maxLength = ((InputFilter.LengthFilter)filter).getMax();
                        break;
                    }
                    structure.setMaxTextLength(maxLength);
                }
            }
            if (this.mHintId != 0) {
                try {
                    structure.setHintIdEntry(this.getResources().getResourceEntryName(this.mHintId));
                }
                catch (Resources.NotFoundException e) {
                    if (!Helper.sVerbose) break block38;
                    Log.v(LOG_TAG, "onProvideAutofillStructure(): cannot set name for hint id " + this.mHintId + ": " + e.getMessage());
                }
            }
        }
        structure.setHint(this.getHint());
        structure.setInputType(this.getInputType());
    }

    boolean canRequestAutofill() {
        if (!this.isAutofillable()) {
            return false;
        }
        AutofillManager afm = this.mContext.getSystemService(AutofillManager.class);
        if (afm != null) {
            return afm.isEnabled();
        }
        return false;
    }

    private void requestAutofill() {
        AutofillManager afm = this.mContext.getSystemService(AutofillManager.class);
        if (afm != null) {
            afm.requestAutofill(this);
        }
    }

    @Override
    public void autofill(AutofillValue value) {
        if (!this.isTextEditable()) {
            Log.w(LOG_TAG, "cannot autofill non-editable TextView: " + this);
            return;
        }
        if (!value.isText()) {
            Log.w(LOG_TAG, "value of type " + value.describeContents() + " cannot be autofilled into " + this);
            return;
        }
        ClipData clip = ClipData.newPlainText("", value.getTextValue());
        ContentInfo payload = new ContentInfo.Builder(clip, 4).build();
        this.performReceiveContent(payload);
    }

    @Override
    public int getAutofillType() {
        return this.isTextEditable() ? 1 : 0;
    }

    @Override
    public AutofillValue getAutofillValue() {
        if (this.isTextEditable()) {
            CharSequence text = TextUtils.trimToParcelableSize(this.getText());
            return AutofillValue.forText(text);
        }
        return null;
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        boolean isPassword = this.hasPasswordTransformationMethod();
        event.setPassword(isPassword);
        if (event.getEventType() == 8192) {
            event.setFromIndex(Selection.getSelectionStart(this.mText));
            event.setToIndex(Selection.getSelectionEnd(this.mText));
            event.setItemCount(this.mText.length());
        }
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        boolean isPassword = this.hasPasswordTransformationMethod();
        info.setPassword(isPassword);
        info.setText(this.getTextForAccessibility());
        info.setHintText(this.mHint);
        info.setShowingHintText(this.isShowingHint());
        if (this.mBufferType == BufferType.EDITABLE) {
            info.setEditable(true);
            if (this.isEnabled()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SET_TEXT);
            }
        }
        if (this.mEditor != null) {
            info.setInputType(this.mEditor.mInputType);
            if (this.mEditor.mError != null) {
                info.setContentInvalid(true);
                info.setError(this.mEditor.mError);
            }
            if (this.isTextEditable() && this.isFocused()) {
                CharSequence imeActionLabel = this.mContext.getResources().getString(17040512);
                if (this.getImeActionLabel() != null) {
                    imeActionLabel = this.getImeActionLabel();
                }
                AccessibilityNodeInfo.AccessibilityAction action = new AccessibilityNodeInfo.AccessibilityAction(16908372, imeActionLabel);
                info.addAction(action);
            }
        }
        if (!TextUtils.isEmpty(this.mText)) {
            info.addAction(256);
            info.addAction(512);
            info.setMovementGranularities(31);
            info.addAction(131072);
            info.setAvailableExtraData(Arrays.asList("android.view.accessibility.extra.DATA_RENDERING_INFO_KEY", "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY"));
            info.setTextSelectable(this.isTextSelectable() || this.isTextEditable());
        } else {
            info.setAvailableExtraData(Arrays.asList("android.view.accessibility.extra.DATA_RENDERING_INFO_KEY"));
        }
        if (this.isFocused()) {
            if (this.canCopy()) {
                info.addAction(16384);
            }
            if (this.canPaste()) {
                info.addAction(32768);
            }
            if (this.canCut()) {
                info.addAction(65536);
            }
            if (this.canReplace()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SHOW_TEXT_SUGGESTIONS);
            }
            if (this.canShare()) {
                info.addAction(new AccessibilityNodeInfo.AccessibilityAction(0x10000000, this.getResources().getString(17041540)));
            }
            if (this.canProcessText()) {
                this.mEditor.mProcessTextIntentActionsHandler.onInitializeAccessibilityNodeInfo(info);
                this.mEditor.onInitializeSmartActionsAccessibilityNodeInfo(info);
            }
        }
        for (InputFilter filter : this.mFilters) {
            if (!(filter instanceof InputFilter.LengthFilter)) continue;
            info.setMaxTextLength(((InputFilter.LengthFilter)filter).getMax());
        }
        if (!this.isSingleLine()) {
            info.setMultiLine(true);
        }
        if ((info.isClickable() || info.isLongClickable()) && (this.mMovement instanceof LinkMovementMethod || this.isTextSelectable() && !this.isTextEditable())) {
            if (!this.hasOnClickListeners()) {
                info.setClickable(false);
                info.removeAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            }
            if (!this.hasOnLongClickListeners()) {
                info.setLongClickable(false);
                info.removeAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_LONG_CLICK);
            }
        }
    }

    @Override
    public void addExtraDataToAccessibilityNodeInfo(AccessibilityNodeInfo info, String extraDataKey, Bundle arguments) {
        if (arguments != null && extraDataKey.equals("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY")) {
            int positionInfoStartIndex = arguments.getInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX", -1);
            int positionInfoLength = arguments.getInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH", -1);
            if (positionInfoLength <= 0 || positionInfoStartIndex < 0 || positionInfoStartIndex >= this.mText.length()) {
                Log.e(LOG_TAG, "Invalid arguments for accessibility character locations");
                return;
            }
            Parcelable[] boundingRects = new RectF[positionInfoLength];
            CursorAnchorInfo.Builder builder = new CursorAnchorInfo.Builder();
            this.populateCharacterBounds(builder, positionInfoStartIndex, Math.min(positionInfoStartIndex + positionInfoLength, this.length()), this.viewportToContentHorizontalOffset(), this.viewportToContentVerticalOffset());
            CursorAnchorInfo cursorAnchorInfo = builder.setMatrix(null).build();
            for (int i = 0; i < positionInfoLength; ++i) {
                RectF bounds;
                int flags = cursorAnchorInfo.getCharacterBoundsFlags(positionInfoStartIndex + i);
                if ((flags & 1) != 1 || (bounds = cursorAnchorInfo.getCharacterBounds(positionInfoStartIndex + i)) == null) continue;
                this.mapRectFromViewToScreenCoords(bounds, true);
                boundingRects[i] = bounds;
            }
            info.getExtras().putParcelableArray(extraDataKey, boundingRects);
            return;
        }
        if (extraDataKey.equals("android.view.accessibility.extra.DATA_RENDERING_INFO_KEY")) {
            AccessibilityNodeInfo.ExtraRenderingInfo extraRenderingInfo = AccessibilityNodeInfo.ExtraRenderingInfo.obtain();
            extraRenderingInfo.setLayoutSize(this.getLayoutParams().width, this.getLayoutParams().height);
            extraRenderingInfo.setTextSizeInPx(this.getTextSize());
            extraRenderingInfo.setTextSizeUnit(this.getTextSizeUnit());
            info.setExtraRenderingInfo(extraRenderingInfo);
        }
    }

    private boolean getContentVisibleRect(Rect rect) {
        if (!this.getLocalVisibleRect(rect)) {
            return false;
        }
        rect.offset(-this.getScrollX(), -this.getScrollY());
        return rect.intersect(this.getCompoundPaddingLeft(), this.getCompoundPaddingTop(), this.getWidth() - this.getCompoundPaddingRight(), this.getHeight() - this.getCompoundPaddingBottom());
    }

    public void populateCharacterBounds(CursorAnchorInfo.Builder builder, int startIndex, int endIndex, float viewportToContentHorizontalOffset, float viewportToContentVerticalOffset) {
        if (this.isOffsetMappingAvailable()) {
            return;
        }
        Rect rect = new Rect();
        this.getContentVisibleRect(rect);
        RectF visibleRect = new RectF(rect);
        float[] characterBounds = this.getCharacterBounds(startIndex, endIndex, viewportToContentHorizontalOffset, viewportToContentVerticalOffset);
        int limit = endIndex - startIndex;
        for (int offset = 0; offset < limit; ++offset) {
            float left = characterBounds[offset * 4];
            float top = characterBounds[offset * 4 + 1];
            float right = characterBounds[offset * 4 + 2];
            float bottom = characterBounds[offset * 4 + 3];
            boolean hasVisibleRegion = visibleRect.intersects(left, top, right, bottom);
            boolean hasInVisibleRegion = !visibleRect.contains(left, top, right, bottom);
            int characterBoundsFlags = 0;
            if (hasVisibleRegion) {
                characterBoundsFlags |= 1;
            }
            if (hasInVisibleRegion) {
                characterBoundsFlags |= 2;
            }
            if (this.mLayout.isRtlCharAt(offset)) {
                characterBoundsFlags |= 4;
            }
            builder.addCharacterBounds(offset + startIndex, left, top, right, bottom, characterBoundsFlags);
        }
    }

    private float[] getCharacterBounds(int start, int end, float layoutLeft, float layoutTop) {
        float[] characterBounds = new float[4 * (end - start)];
        this.mLayout.fillCharacterBounds(start, end, characterBounds, 0);
        for (int offset = 0; offset < end - start; ++offset) {
            int n = 4 * offset;
            characterBounds[n] = characterBounds[n] + layoutLeft;
            int n2 = 4 * offset + 1;
            characterBounds[n2] = characterBounds[n2] + layoutTop;
            int n3 = 4 * offset + 2;
            characterBounds[n3] = characterBounds[n3] + layoutLeft;
            int n4 = 4 * offset + 3;
            characterBounds[n4] = characterBounds[n4] + layoutTop;
        }
        return characterBounds;
    }

    @VisibleForTesting
    public CursorAnchorInfo getCursorAnchorInfo(int filter, CursorAnchorInfo.Builder cursorAnchorInfoBuilder, Matrix viewToScreenMatrix) {
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return null;
        }
        boolean includeEditorBounds = (filter & 4) != 0;
        boolean includeCharacterBounds = (filter & 8) != 0;
        boolean includeInsertionMarker = (filter & 0x10) != 0;
        boolean includeVisibleLineBounds = (filter & 0x20) != 0;
        boolean includeTextAppearance = (filter & 0x40) != 0;
        boolean includeAll = !includeEditorBounds && !includeCharacterBounds && !includeInsertionMarker && !includeVisibleLineBounds && !includeTextAppearance;
        includeEditorBounds |= includeAll;
        includeCharacterBounds |= includeAll;
        includeInsertionMarker |= includeAll;
        includeVisibleLineBounds |= includeAll;
        includeTextAppearance |= includeAll;
        CursorAnchorInfo.Builder builder = cursorAnchorInfoBuilder;
        builder.reset();
        int selectionStart = this.getSelectionStart();
        builder.setSelectionRange(selectionStart, this.getSelectionEnd());
        viewToScreenMatrix.reset();
        this.transformMatrixToGlobal(viewToScreenMatrix);
        builder.setMatrix(viewToScreenMatrix);
        if (includeEditorBounds) {
            RectF editorBounds = new RectF();
            editorBounds.set(0.0f, 0.0f, this.getWidth(), this.getHeight());
            RectF handwritingBounds = new RectF(-this.getHandwritingBoundsOffsetLeft(), -this.getHandwritingBoundsOffsetTop(), (float)this.getWidth() + this.getHandwritingBoundsOffsetRight(), (float)this.getHeight() + this.getHandwritingBoundsOffsetBottom());
            EditorBoundsInfo.Builder boundsBuilder = new EditorBoundsInfo.Builder();
            EditorBoundsInfo editorBoundsInfo = boundsBuilder.setEditorBounds(editorBounds).setHandwritingBounds(handwritingBounds).build();
            builder.setEditorBoundsInfo(editorBoundsInfo);
        }
        if (includeCharacterBounds || includeInsertionMarker || includeVisibleLineBounds) {
            Rect visibleRect;
            CharSequence text;
            boolean isTextTransformed;
            float viewportToContentHorizontalOffset = this.viewportToContentHorizontalOffset();
            float viewportToContentVerticalOffset = this.viewportToContentVerticalOffset();
            boolean bl = isTextTransformed = this.getTransformationMethod() != null && this.getTransformed() instanceof OffsetMapping;
            if (includeCharacterBounds && !isTextTransformed && (text = this.getText()) instanceof Spannable) {
                boolean hasComposingText;
                Spannable sp = (Spannable)text;
                int composingTextStart = EditableInputConnection.getComposingSpanStart(sp);
                int composingTextEnd = EditableInputConnection.getComposingSpanEnd(sp);
                if (composingTextEnd < composingTextStart) {
                    int temp = composingTextEnd;
                    composingTextEnd = composingTextStart;
                    composingTextStart = temp;
                }
                boolean bl2 = hasComposingText = 0 <= composingTextStart && composingTextStart < composingTextEnd;
                if (hasComposingText) {
                    CharSequence composingText = text.subSequence(composingTextStart, composingTextEnd);
                    builder.setComposingText(composingTextStart, composingText);
                    this.populateCharacterBounds(builder, composingTextStart, composingTextEnd, viewportToContentHorizontalOffset, viewportToContentVerticalOffset);
                }
            }
            if (includeInsertionMarker && 0 <= selectionStart) {
                int offsetTransformed = this.originalToTransformed(selectionStart, 1);
                int line = layout2.getLineForOffset(offsetTransformed);
                float insertionMarkerX = layout2.getPrimaryHorizontal(offsetTransformed) + viewportToContentHorizontalOffset;
                float insertionMarkerTop = (float)layout2.getLineTop(line) + viewportToContentVerticalOffset;
                float insertionMarkerBaseline = (float)layout2.getLineBaseline(line) + viewportToContentVerticalOffset;
                float insertionMarkerBottom = (float)layout2.getLineBottom(line, false) + viewportToContentVerticalOffset;
                boolean isTopVisible = this.isPositionVisible(insertionMarkerX, insertionMarkerTop);
                boolean isBottomVisible = this.isPositionVisible(insertionMarkerX, insertionMarkerBottom);
                int insertionMarkerFlags = 0;
                if (isTopVisible || isBottomVisible) {
                    insertionMarkerFlags |= 1;
                }
                if (!isTopVisible || !isBottomVisible) {
                    insertionMarkerFlags |= 2;
                }
                if (layout2.isRtlCharAt(offsetTransformed)) {
                    insertionMarkerFlags |= 4;
                }
                builder.setInsertionMarkerLocation(insertionMarkerX, insertionMarkerTop, insertionMarkerBaseline, insertionMarkerBottom, insertionMarkerFlags);
            }
            if (includeVisibleLineBounds && this.getContentVisibleRect(visibleRect = new Rect())) {
                float visibleTop = (float)visibleRect.top - viewportToContentVerticalOffset;
                float visibleBottom = (float)visibleRect.bottom - viewportToContentVerticalOffset;
                int firstLine = layout2.getLineForVertical((int)Math.floor(visibleTop));
                int lastLine = layout2.getLineForVertical((int)Math.ceil(visibleBottom));
                for (int line = firstLine; line <= lastLine; ++line) {
                    float left = layout2.getLineLeft(line) + viewportToContentHorizontalOffset;
                    float top = (float)layout2.getLineTop(line) + viewportToContentVerticalOffset;
                    float right = layout2.getLineRight(line) + viewportToContentHorizontalOffset;
                    float bottom = (float)layout2.getLineBottom(line, false) + viewportToContentVerticalOffset;
                    builder.addVisibleLineBounds(left, top, right, bottom);
                }
            }
        }
        if (includeTextAppearance) {
            builder.setTextAppearanceInfo(TextAppearanceInfo.createFromTextView(this));
        }
        return builder.build();
    }

    public TextBoundsInfo getTextBoundsInfo(RectF bounds) {
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return null;
        }
        CharSequence text = layout2.getText();
        if (text == null || this.isOffsetMappingAvailable()) {
            return null;
        }
        Matrix localToGlobalMatrix = new Matrix();
        this.transformMatrixToGlobal(localToGlobalMatrix);
        Matrix globalToLocalMatrix = new Matrix();
        if (!localToGlobalMatrix.invert(globalToLocalMatrix)) {
            return null;
        }
        float layoutLeft = this.viewportToContentHorizontalOffset();
        float layoutTop = this.viewportToContentVerticalOffset();
        RectF localBounds = new RectF(bounds);
        globalToLocalMatrix.mapRect(localBounds);
        localBounds.offset(-layoutLeft, -layoutTop);
        if (!localBounds.intersects(0.0f, 0.0f, layout2.getWidth(), layout2.getHeight()) || text.length() == 0) {
            TextBoundsInfo.Builder builder = new TextBoundsInfo.Builder(0, 0);
            SegmentFinder.PrescribedSegmentFinder emptySegmentFinder = new SegmentFinder.PrescribedSegmentFinder(new int[0]);
            builder.setMatrix(localToGlobalMatrix).setCharacterBounds(new float[0]).setCharacterBidiLevel(new int[0]).setCharacterFlags(new int[0]).setGraphemeSegmentFinder(emptySegmentFinder).setLineSegmentFinder(emptySegmentFinder).setWordSegmentFinder(emptySegmentFinder);
            return builder.build();
        }
        int startLine = layout2.getLineForVertical((int)Math.floor(localBounds.top));
        int endLine = layout2.getLineForVertical((int)Math.floor(localBounds.bottom));
        int start = layout2.getLineStart(startLine);
        int end = layout2.getLineEnd(endLine);
        float[] characterBounds = this.getCharacterBounds(start, end, layoutLeft, layoutTop);
        int[] characterFlags = new int[end - start];
        int[] characterBidiLevels = new int[end - start];
        for (int line = startLine; line <= endLine; ++line) {
            int lineStart = layout2.getLineStart(line);
            int lineEnd = layout2.getLineEnd(line);
            Layout.Directions directions = layout2.getLineDirections(line);
            for (int i = 0; i < directions.getRunCount(); ++i) {
                int runStart = directions.getRunStart(i) + lineStart;
                int runEnd = Math.min(runStart + directions.getRunLength(i), lineEnd);
                int runLevel = directions.getRunLevel(i);
                Arrays.fill(characterBidiLevels, runStart - start, runEnd - start, runLevel);
            }
            boolean lineIsRtl = layout2.getParagraphDirection(line) == -1;
            for (int index = lineStart; index < lineEnd; ++index) {
                int flags = 0;
                if (TextUtils.isWhitespace(text.charAt(index))) {
                    flags |= 1;
                }
                if (TextUtils.isPunctuation(Character.codePointAt(text, index))) {
                    flags |= 4;
                }
                if (TextUtils.isNewline(Character.codePointAt(text, index))) {
                    flags |= 2;
                }
                if (lineIsRtl) {
                    flags |= 8;
                }
                characterFlags[index - start] = flags;
            }
        }
        GraphemeClusterSegmentFinder graphemeSegmentFinder = new GraphemeClusterSegmentFinder(text, layout2.getPaint());
        WordIterator wordIterator = this.getWordIterator();
        wordIterator.setCharSequence(text, 0, text.length());
        WordSegmentFinder wordSegmentFinder = new WordSegmentFinder(text, wordIterator);
        int lineCount = endLine - startLine + 1;
        int[] lineRanges = new int[2 * lineCount];
        for (int line = startLine; line <= endLine; ++line) {
            int offset = line - startLine;
            lineRanges[2 * offset] = layout2.getLineStart(line);
            lineRanges[2 * offset + 1] = layout2.getLineEnd(line);
        }
        SegmentFinder.PrescribedSegmentFinder lineSegmentFinder = new SegmentFinder.PrescribedSegmentFinder(lineRanges);
        return new TextBoundsInfo.Builder(start, end).setMatrix(localToGlobalMatrix).setCharacterBounds(characterBounds).setCharacterBidiLevel(characterBidiLevels).setCharacterFlags(characterFlags).setGraphemeSegmentFinder(graphemeSegmentFinder).setLineSegmentFinder(lineSegmentFinder).setWordSegmentFinder(wordSegmentFinder).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPositionVisible(float positionX, float positionY) {
        float[] fArray = TEMP_POSITION;
        synchronized (TEMP_POSITION) {
            float[] position = TEMP_POSITION;
            position[0] = positionX;
            position[1] = positionY;
            View view = this;
            while (view != null) {
                if (view != this) {
                    position[0] = position[0] - (float)view.getScrollX();
                    position[1] = position[1] - (float)view.getScrollY();
                }
                if (position[0] < 0.0f || position[1] < 0.0f || position[0] > (float)view.getWidth() || position[1] > (float)view.getHeight()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                if (!view.getMatrix().isIdentity()) {
                    view.getMatrix().mapPoints(position);
                }
                position[0] = position[0] + (float)view.getLeft();
                position[1] = position[1] + (float)view.getTop();
                ViewParent parent = view.getParent();
                if (parent instanceof View) {
                    view = (View)((Object)parent);
                    continue;
                }
                view = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performAccessibilityActionInternal(int action, Bundle arguments) {
        if (this.mEditor != null && (this.mEditor.mProcessTextIntentActionsHandler.performAccessibilityAction(action) || this.mEditor.performSmartActionsAccessibilityAction(action))) {
            return true;
        }
        switch (action) {
            case 16: {
                return this.performAccessibilityActionClick(arguments);
            }
            case 16384: {
                return this.isFocused() && this.canCopy() && this.onTextContextMenuItem(0x1020021);
            }
            case 32768: {
                return this.isFocused() && this.canPaste() && this.onTextContextMenuItem(0x1020022);
            }
            case 65536: {
                return this.isFocused() && this.canCut() && this.onTextContextMenuItem(0x1020020);
            }
            case 131072: {
                int end;
                this.ensureIterableTextForAccessibilitySelectable();
                CharSequence text = this.getIterableTextForAccessibility();
                if (text == null) {
                    return false;
                }
                int start = arguments != null ? arguments.getInt("ACTION_ARGUMENT_SELECTION_START_INT", -1) : -1;
                int n = end = arguments != null ? arguments.getInt("ACTION_ARGUMENT_SELECTION_END_INT", -1) : -1;
                if (this.getSelectionStart() != start || this.getSelectionEnd() != end) {
                    if (start == end && end == -1) {
                        Selection.removeSelection((Spannable)text);
                        return true;
                    }
                    if (start >= 0 && start <= end && end <= text.length()) {
                        this.requestFocusOnNonEditableSelectableText();
                        Selection.setSelection((Spannable)text, start, end);
                        if (this.mEditor != null) {
                            this.mEditor.startSelectionActionModeAsync(false);
                        }
                        return true;
                    }
                }
                return false;
            }
            case 256: 
            case 512: {
                this.ensureIterableTextForAccessibilitySelectable();
                return super.performAccessibilityActionInternal(action, arguments);
            }
            case 0x10000000: {
                return this.isFocused() && this.canShare() && this.onTextContextMenuItem(16908341);
            }
            case 0x200000: {
                int updatedTextLength;
                if (!this.isEnabled() || this.mBufferType != BufferType.EDITABLE) {
                    return false;
                }
                CharSequence text = arguments != null ? arguments.getCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE") : null;
                this.setText(text);
                if (this.mText != null && (updatedTextLength = this.mText.length()) > 0) {
                    Selection.setSelection(this.mSpannable, updatedTextLength);
                }
                return true;
            }
            case 16908372: {
                if (this.isFocused() && this.isTextEditable()) {
                    this.onEditorAction(this.getImeActionId());
                }
                return true;
            }
            case 32: {
                if (this.isLongClickable()) {
                    boolean handled;
                    if (this.isEnabled() && this.mBufferType == BufferType.EDITABLE) {
                        this.mEditor.mIsBeingLongClickedByAccessibility = true;
                        try {
                            handled = this.performLongClick();
                        }
                        finally {
                            this.mEditor.mIsBeingLongClickedByAccessibility = false;
                        }
                    } else {
                        handled = this.performLongClick();
                    }
                    return handled;
                }
                return false;
            }
        }
        if (action == 16908376) {
            return this.isFocused() && this.canReplace() && this.onTextContextMenuItem(16908340);
        }
        return super.performAccessibilityActionInternal(action, arguments);
    }

    private boolean performAccessibilityActionClick(Bundle arguments) {
        boolean handled = false;
        if (!this.isEnabled()) {
            return false;
        }
        if (this.isClickable() || this.isLongClickable()) {
            if (this.isFocusable() && !this.isFocused()) {
                this.requestFocus();
            }
            this.performClick();
            handled = true;
        }
        if ((this.mMovement != null || this.onCheckIsTextEditor()) && this.hasSpannableText() && this.mLayout != null && (this.isTextEditable() || this.isTextSelectable()) && this.isFocused()) {
            InputMethodManager imm = this.getInputMethodManager();
            this.viewClicked(imm);
            if (!this.isTextSelectable() && this.mEditor.mShowSoftInputOnFocus && imm != null) {
                handled |= imm.showSoftInput(this, 0);
            }
        }
        return handled;
    }

    private void requestFocusOnNonEditableSelectableText() {
        if (!this.isTextEditable() && this.isTextSelectable()) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.isFocusable() && !this.isFocused()) {
                this.requestFocus();
            }
        }
    }

    private boolean hasSpannableText() {
        return this.mText != null && this.mText instanceof Spannable;
    }

    @Override
    public void sendAccessibilityEventInternal(int eventType) {
        if (eventType == 32768 && this.mEditor != null) {
            this.mEditor.mProcessTextIntentActionsHandler.initializeAccessibilityActions();
        }
        super.sendAccessibilityEventInternal(eventType);
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (event.getEventType() == 4096) {
            return;
        }
        super.sendAccessibilityEventUnchecked(event);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private CharSequence getTextForAccessibility() {
        if (TextUtils.isEmpty(this.mText)) {
            return this.mHint;
        }
        return TextUtils.trimToParcelableSize(this.mTransformed);
    }

    boolean isVisibleToAccessibility() {
        return AccessibilityManager.getInstance(this.mContext).isEnabled() && (this.isFocused() || this.isSelected() && this.isShown());
    }

    void sendAccessibilityEventTypeViewTextChanged(CharSequence beforeText, int fromIndex, int removedCount, int addedCount) {
        AccessibilityEvent event = AccessibilityEvent.obtain(16);
        event.setFromIndex(fromIndex);
        event.setRemovedCount(removedCount);
        event.setAddedCount(addedCount);
        event.setBeforeText(beforeText);
        this.sendAccessibilityEventUnchecked(event);
    }

    void sendAccessibilityEventTypeViewTextChanged(CharSequence beforeText, int fromIndex, int toIndex) {
        AccessibilityEvent event = AccessibilityEvent.obtain(16);
        event.setFromIndex(fromIndex);
        event.setToIndex(toIndex);
        event.setBeforeText(beforeText);
        this.sendAccessibilityEventUnchecked(event);
    }

    private InputMethodManager getInputMethodManager() {
        return this.getContext().getSystemService(InputMethodManager.class);
    }

    public boolean isInputMethodTarget() {
        InputMethodManager imm = this.getInputMethodManager();
        return imm != null && imm.isActive(this);
    }

    public boolean onTextContextMenuItem(int id2) {
        int min = 0;
        int max = this.mText.length();
        if (this.isFocused()) {
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            min = Math.max(0, Math.min(selStart, selEnd));
            max = Math.max(0, Math.max(selStart, selEnd));
        }
        switch (id2) {
            case 16908319: {
                boolean hadSelection = this.hasSelection();
                this.selectAllText();
                if (this.mEditor != null && hadSelection) {
                    this.mEditor.invalidateActionModeAsync();
                }
                return true;
            }
            case 16908338: {
                if (this.mEditor != null) {
                    this.mEditor.undo();
                }
                return true;
            }
            case 16908339: {
                if (this.mEditor != null) {
                    this.mEditor.redo();
                }
                return true;
            }
            case 0x1020022: {
                this.paste(true);
                return true;
            }
            case 16908337: {
                this.paste(false);
                return true;
            }
            case 0x1020020: {
                ClipData cutData = ClipData.newPlainText(null, this.getTransformedText(min, max));
                if (this.setPrimaryClip(cutData)) {
                    this.deleteText_internal(min, max);
                } else {
                    Toast.makeText(this.getContext(), 17040311, 0).show();
                }
                return true;
            }
            case 0x1020021: {
                int selStart = this.getSelectionStart();
                int selEnd = this.getSelectionEnd();
                min = Math.max(0, Math.min(selStart, selEnd));
                max = Math.max(0, Math.max(selStart, selEnd));
                ClipData copyData = ClipData.newPlainText(null, this.getTransformedText(min, max));
                if (this.setPrimaryClip(copyData)) {
                    this.stopTextActionMode();
                } else {
                    Toast.makeText(this.getContext(), 17040311, 0).show();
                }
                return true;
            }
            case 16908340: {
                if (this.mEditor != null) {
                    this.mEditor.replace();
                }
                return true;
            }
            case 16908341: {
                this.shareSelectedText();
                return true;
            }
            case 16908355: {
                this.requestAutofill();
                this.stopTextActionMode();
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    CharSequence getTransformedText(int start, int end) {
        return this.removeSuggestionSpans(this.mTransformed.subSequence(start, end));
    }

    @Override
    public boolean performLongClick() {
        boolean handled = false;
        boolean performedHapticFeedback = false;
        if (this.mEditor != null) {
            this.mEditor.mIsBeingLongClicked = true;
        }
        if (super.performLongClick()) {
            handled = true;
            performedHapticFeedback = true;
        }
        if (this.mEditor != null) {
            handled |= this.mEditor.performLongClick(handled);
            this.mEditor.mIsBeingLongClicked = false;
        }
        if (handled) {
            if (!performedHapticFeedback) {
                this.performHapticFeedback(0);
            }
            if (this.mEditor != null) {
                this.mEditor.mDiscardNextActionUp = true;
            }
        } else {
            MetricsLogger.action(this.mContext, 629, 0);
        }
        return handled;
    }

    @Override
    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        if (this.mEditor != null) {
            this.mEditor.onScrollChanged();
        }
    }

    public boolean isSuggestionsEnabled() {
        if (this.mEditor == null) {
            return false;
        }
        if ((this.mEditor.mInputType & 0xF) != 1) {
            return false;
        }
        if ((this.mEditor.mInputType & 0x80000) > 0) {
            return false;
        }
        int variation = this.mEditor.mInputType & 0xFF0;
        return variation == 0 || variation == 48 || variation == 80 || variation == 64 || variation == 160;
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback actionModeCallback) {
        this.createEditorIfNeeded();
        this.mEditor.mCustomSelectionActionModeCallback = actionModeCallback;
    }

    public ActionMode.Callback getCustomSelectionActionModeCallback() {
        return this.mEditor == null ? null : this.mEditor.mCustomSelectionActionModeCallback;
    }

    public void setCustomInsertionActionModeCallback(ActionMode.Callback actionModeCallback) {
        this.createEditorIfNeeded();
        this.mEditor.mCustomInsertionActionModeCallback = actionModeCallback;
    }

    public ActionMode.Callback getCustomInsertionActionModeCallback() {
        return this.mEditor == null ? null : this.mEditor.mCustomInsertionActionModeCallback;
    }

    public void setTextClassifier(TextClassifier textClassifier) {
        this.mTextClassifier = textClassifier;
    }

    public TextClassifier getTextClassifier() {
        if (this.mTextClassifier == null) {
            TextClassificationManager tcm = this.getTextClassificationManagerForUser();
            if (tcm != null) {
                return tcm.getTextClassifier();
            }
            return TextClassifier.NO_OP;
        }
        return this.mTextClassifier;
    }

    TextClassifier getTextClassificationSession() {
        if (this.mTextClassificationSession == null || this.mTextClassificationSession.isDestroyed()) {
            TextClassificationManager tcm = this.getTextClassificationManagerForUser();
            if (tcm != null) {
                String widgetType = this.isTextEditable() ? "edittext" : (this.isTextSelectable() ? "textview" : "nosel-textview");
                this.mTextClassificationContext = new TextClassificationContext.Builder(this.mContext.getPackageName(), widgetType).build();
                this.mTextClassificationSession = this.mTextClassifier != null ? tcm.createTextClassificationSession(this.mTextClassificationContext, this.mTextClassifier) : tcm.createTextClassificationSession(this.mTextClassificationContext);
            } else {
                this.mTextClassificationSession = TextClassifier.NO_OP;
            }
        }
        return this.mTextClassificationSession;
    }

    TextClassificationContext getTextClassificationContext() {
        return this.mTextClassificationContext;
    }

    boolean usesNoOpTextClassifier() {
        return this.getTextClassifier() == TextClassifier.NO_OP;
    }

    public boolean requestActionMode(TextLinks.TextLinkSpan clickedSpan) {
        Preconditions.checkNotNull(clickedSpan);
        if (!(this.mText instanceof Spanned)) {
            return false;
        }
        int start = ((Spanned)this.mText).getSpanStart(clickedSpan);
        int end = ((Spanned)this.mText).getSpanEnd(clickedSpan);
        if (start < 0 || end > this.mText.length() || start >= end) {
            return false;
        }
        this.createEditorIfNeeded();
        this.mEditor.startLinkActionModeAsync(start, end);
        return true;
    }

    public boolean handleClick(TextLinks.TextLinkSpan clickedSpan) {
        Preconditions.checkNotNull(clickedSpan);
        if (this.mText instanceof Spanned) {
            Spanned spanned = (Spanned)this.mText;
            int start = spanned.getSpanStart(clickedSpan);
            int end = spanned.getSpanEnd(clickedSpan);
            if (start >= 0 && end <= this.mText.length() && start < end) {
                TextClassification.Request request = new TextClassification.Request.Builder(this.mText, start, end).setDefaultLocales(this.getTextLocales()).build();
                Supplier<TextClassification> supplier = () -> this.getTextClassificationSession().classifyText(request);
                Consumer<TextClassification> consumer = classification -> {
                    if (classification != null) {
                        if (!classification.getActions().isEmpty()) {
                            try {
                                classification.getActions().get(0).getActionIntent().send();
                            }
                            catch (PendingIntent.CanceledException e) {
                                Log.e(LOG_TAG, "Error sending PendingIntent", e);
                            }
                        } else {
                            Log.d(LOG_TAG, "No link action to perform");
                        }
                    } else {
                        Log.d(LOG_TAG, "Timeout while classifying text");
                    }
                };
                CompletableFuture.supplyAsync(supplier).completeOnTimeout(null, 1L, TimeUnit.SECONDS).thenAccept(consumer);
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    protected void stopTextActionMode() {
        if (this.mEditor != null) {
            this.mEditor.stopTextActionMode();
        }
    }

    public void hideFloatingToolbar(int durationMs) {
        if (this.mEditor != null) {
            this.mEditor.hideFloatingToolbar(durationMs);
        }
    }

    boolean canUndo() {
        return this.mEditor != null && this.mEditor.canUndo();
    }

    boolean canRedo() {
        return this.mEditor != null && this.mEditor.canRedo();
    }

    boolean canCut() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection() && this.mText instanceof Editable && this.mEditor != null && this.mEditor.mKeyListener != null;
    }

    boolean canCopy() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection() && this.mEditor != null;
    }

    boolean canReplace() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.mText instanceof Editable && this.mEditor != null && this.isSuggestionsEnabled() && this.mEditor.shouldOfferToShowSuggestions();
    }

    boolean canShare() {
        if (!this.getContext().canStartActivityForResult() || !this.isDeviceProvisioned()) {
            return false;
        }
        return this.canCopy();
    }

    boolean isDeviceProvisioned() {
        if (this.mDeviceProvisionedState == 0) {
            this.mDeviceProvisionedState = Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0 ? 2 : 1;
        }
        return this.mDeviceProvisionedState == 2;
    }

    @UnsupportedAppUsage
    boolean canPaste() {
        return this.mText instanceof Editable && this.mEditor != null && this.mEditor.mKeyListener != null && this.getSelectionStart() >= 0 && this.getSelectionEnd() >= 0 && this.getClipboardManagerForUser().hasPrimaryClip();
    }

    boolean canPasteAsPlainText() {
        if (!this.canPaste()) {
            return false;
        }
        ClipDescription description = this.getClipboardManagerForUser().getPrimaryClipDescription();
        boolean isPlainType = description.hasMimeType("text/plain");
        return isPlainType && description.isStyledText() || description.hasMimeType("text/html");
    }

    boolean canProcessText() {
        if (this.getId() == -1) {
            return false;
        }
        return this.canShare();
    }

    boolean canSelectAllText() {
        return this.canSelectText() && !this.hasPasswordTransformationMethod() && (this.getSelectionStart() != 0 || this.getSelectionEnd() != this.mText.length());
    }

    boolean selectAllText() {
        if (this.mEditor != null) {
            this.hideFloatingToolbar(500);
        }
        int length = this.mText.length();
        Selection.setSelection(this.mSpannable, 0, length);
        return length > 0;
    }

    private void paste(boolean withFormatting) {
        ClipboardManager clipboard = this.getClipboardManagerForUser();
        ClipData clip = clipboard.getPrimaryClip();
        if (clip == null) {
            return;
        }
        ContentInfo payload = new ContentInfo.Builder(clip, 1).setFlags(withFormatting ? 0 : 1).build();
        this.performReceiveContent(payload);
        sLastCutCopyOrTextChangedTime = 0L;
    }

    private void shareSelectedText() {
        String selectedText = this.getSelectedText();
        if (selectedText != null && !selectedText.isEmpty()) {
            Intent sharingIntent = new Intent("android.intent.action.SEND");
            sharingIntent.setType("text/plain");
            sharingIntent.removeExtra("android.intent.extra.TEXT");
            selectedText = TextUtils.trimToParcelableSize(selectedText);
            sharingIntent.putExtra("android.intent.extra.TEXT", selectedText);
            this.getContext().startActivity(Intent.createChooser(sharingIntent, null));
            Selection.setSelection(this.mSpannable, this.getSelectionEnd());
        }
    }

    private boolean setPrimaryClip(ClipData clip) {
        ClipboardManager clipboard = this.getClipboardManagerForUser();
        try {
            clipboard.setPrimaryClip(clip);
        }
        catch (Throwable t) {
            return false;
        }
        sLastCutCopyOrTextChangedTime = SystemClock.uptimeMillis();
        return true;
    }

    public int getOffsetForPosition(float x, float y) {
        if (this.getLayout() == null) {
            return -1;
        }
        int line = this.getLineAtCoordinate(y);
        int offset = this.getOffsetAtCoordinate(line, x);
        return offset;
    }

    float convertToLocalHorizontalCoordinate(float x) {
        x -= (float)this.getTotalPaddingLeft();
        x = Math.max(0.0f, x);
        x = Math.min((float)(this.getWidth() - this.getTotalPaddingRight() - 1), x);
        return x += (float)this.getScrollX();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    int getLineAtCoordinate(float y) {
        y -= (float)this.getTotalPaddingTop();
        y = Math.max(0.0f, y);
        y = Math.min((float)(this.getHeight() - this.getTotalPaddingBottom() - 1), y);
        return this.getLayout().getLineForVertical((int)(y += (float)this.getScrollY()));
    }

    int getLineAtCoordinateUnclamped(float y) {
        y -= (float)this.getTotalPaddingTop();
        return this.getLayout().getLineForVertical((int)(y += (float)this.getScrollY()));
    }

    int getOffsetAtCoordinate(int line, float x) {
        x = this.convertToLocalHorizontalCoordinate(x);
        int offset = this.getLayout().getOffsetForHorizontal(line, x);
        return this.transformedToOriginal(offset, 1);
    }

    public int transformedToOriginal(int offset, int strategy) {
        if (this.getTransformationMethod() == null) {
            return offset;
        }
        if (this.mTransformed instanceof OffsetMapping) {
            OffsetMapping transformedText = (OffsetMapping)((Object)this.mTransformed);
            return transformedText.transformedToOriginal(offset, strategy);
        }
        return offset;
    }

    public int originalToTransformed(int offset, int strategy) {
        if (this.getTransformationMethod() == null) {
            return offset;
        }
        if (this.mTransformed instanceof OffsetMapping) {
            OffsetMapping transformedText = (OffsetMapping)((Object)this.mTransformed);
            return transformedText.originalToTransformed(offset, strategy);
        }
        return offset;
    }

    @Override
    public boolean onDragEvent(DragEvent event) {
        if (this.mEditor == null || !this.mEditor.hasInsertionController()) {
            return super.onDragEvent(event);
        }
        switch (event.getAction()) {
            case 1: {
                return true;
            }
            case 5: {
                this.requestFocus();
                return true;
            }
            case 2: {
                if (this.mText instanceof Spannable) {
                    int offset = this.getOffsetForPosition(event.getX(), event.getY());
                    Selection.setSelection(this.mSpannable, offset);
                }
                return true;
            }
            case 3: {
                if (this.mEditor != null) {
                    this.mEditor.onDrop(event);
                }
                return true;
            }
        }
        return true;
    }

    boolean isInBatchEditMode() {
        if (this.mEditor == null) {
            return false;
        }
        Editor.InputMethodState ims = this.mEditor.mInputMethodState;
        if (ims != null) {
            return ims.mBatchEditNesting > 0;
        }
        return this.mEditor.mInBatchEditControllers;
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        TextDirectionHeuristic newTextDir = this.getTextDirectionHeuristic();
        if (this.mTextDir != newTextDir) {
            this.mTextDir = newTextDir;
            if (this.mLayout != null) {
                this.checkForRelayout();
            }
        }
    }

    public TextDirectionHeuristic getTextDirectionHeuristic() {
        if (this.hasPasswordTransformationMethod()) {
            return TextDirectionHeuristics.LTR;
        }
        if (this.mEditor != null && (this.mEditor.mInputType & 0xF) == 3) {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(this.getTextLocale());
            String zero = symbols.getDigitStrings()[0];
            int firstCodepoint = zero.codePointAt(0);
            byte digitDirection = Character.getDirectionality(firstCodepoint);
            if (digitDirection == 1 || digitDirection == 2) {
                return TextDirectionHeuristics.RTL;
            }
            return TextDirectionHeuristics.LTR;
        }
        boolean defaultIsRtl = this.getLayoutDirection() == 1;
        switch (this.getTextDirection()) {
            default: {
                return defaultIsRtl ? TextDirectionHeuristics.FIRSTSTRONG_RTL : TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
            case 2: {
                return TextDirectionHeuristics.ANYRTL_LTR;
            }
            case 3: {
                return TextDirectionHeuristics.LTR;
            }
            case 4: {
                return TextDirectionHeuristics.RTL;
            }
            case 5: {
                return TextDirectionHeuristics.LOCALE;
            }
            case 6: {
                return TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
            case 7: 
        }
        return TextDirectionHeuristics.FIRSTSTRONG_RTL;
    }

    @Override
    public void onResolveDrawables(int layoutDirection) {
        if (this.mLastLayoutDirection == layoutDirection) {
            return;
        }
        this.mLastLayoutDirection = layoutDirection;
        if (this.mDrawables != null && this.mDrawables.resolveWithLayoutDirection(layoutDirection)) {
            this.prepareDrawableForDisplay(this.mDrawables.mShowing[0]);
            this.prepareDrawableForDisplay(this.mDrawables.mShowing[2]);
            this.applyCompoundDrawableTint();
        }
    }

    private void prepareDrawableForDisplay(Drawable dr) {
        if (dr == null) {
            return;
        }
        dr.setLayoutDirection(this.getLayoutDirection());
        if (dr.isStateful()) {
            dr.setState(this.getDrawableState());
            dr.jumpToCurrentState();
        }
    }

    @Override
    protected void resetResolvedDrawables() {
        super.resetResolvedDrawables();
        this.mLastLayoutDirection = -1;
    }

    protected void viewClicked(InputMethodManager imm) {
        if (imm != null) {
            imm.viewClicked(this);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    protected void deleteText_internal(int start, int end) {
        ((Editable)this.mText).delete(start, end);
    }

    protected void replaceText_internal(int start, int end, CharSequence text) {
        ((Editable)this.mText).replace(start, end, text);
    }

    protected void setSpan_internal(Object span, int start, int end, int flags) {
        ((Editable)this.mText).setSpan(span, start, end, flags);
    }

    protected void setCursorPosition_internal(int start, int end) {
        Selection.setSelection((Editable)this.mText, start, end);
    }

    @UnsupportedAppUsage
    private void createEditorIfNeeded() {
        if (this.mEditor == null) {
            this.mEditor = new Editor(this);
        }
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public CharSequence getIterableTextForAccessibility() {
        return this.mText;
    }

    private void ensureIterableTextForAccessibilitySelectable() {
        if (!(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
    }

    @Override
    public AccessibilityIterators.TextSegmentIterator getIteratorForGranularity(int granularity) {
        switch (granularity) {
            case 4: {
                Spannable text = (Spannable)this.getIterableTextForAccessibility();
                if (TextUtils.isEmpty(text) || this.getLayout() == null) break;
                AccessibilityIterators.LineTextSegmentIterator iterator = AccessibilityIterators.LineTextSegmentIterator.getInstance();
                iterator.initialize(text, this.getLayout());
                return iterator;
            }
            case 16: {
                Spannable text = (Spannable)this.getIterableTextForAccessibility();
                if (TextUtils.isEmpty(text) || this.getLayout() == null) break;
                AccessibilityIterators.PageTextSegmentIterator iterator = AccessibilityIterators.PageTextSegmentIterator.getInstance();
                iterator.initialize(this);
                return iterator;
            }
        }
        return super.getIteratorForGranularity(granularity);
    }

    @Override
    public int getAccessibilitySelectionStart() {
        return this.getSelectionStart();
    }

    @Override
    public boolean isAccessibilitySelectionExtendable() {
        return true;
    }

    @Override
    public void prepareForExtendedAccessibilitySelection() {
        this.requestFocusOnNonEditableSelectableText();
    }

    @Override
    public int getAccessibilitySelectionEnd() {
        return this.getSelectionEnd();
    }

    @Override
    public void setAccessibilitySelection(int start, int end) {
        if (this.getAccessibilitySelectionStart() == start && this.getAccessibilitySelectionEnd() == end) {
            return;
        }
        CharSequence text = this.getIterableTextForAccessibility();
        if (Math.min(start, end) >= 0 && Math.max(start, end) <= text.length()) {
            Selection.setSelection((Spannable)text, start, end);
        } else {
            Selection.removeSelection((Spannable)text);
        }
        if (this.mEditor != null) {
            this.mEditor.hideCursorAndSpanControllers();
            this.mEditor.stopTextActionMode();
        }
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        TextUtils.TruncateAt ellipsize = this.getEllipsize();
        stream.addProperty("text:ellipsize", ellipsize == null ? null : ellipsize.name());
        stream.addProperty("text:textSize", this.getTextSize());
        stream.addProperty("text:scaledTextSize", this.getScaledTextSize());
        stream.addProperty("text:typefaceStyle", this.getTypefaceStyle());
        stream.addProperty("text:selectionStart", this.getSelectionStart());
        stream.addProperty("text:selectionEnd", this.getSelectionEnd());
        stream.addProperty("text:curTextColor", this.mCurTextColor);
        stream.addUserProperty("text:text", this.mText == null ? null : this.mText.toString());
        stream.addProperty("text:gravity", this.mGravity);
    }

    @Override
    public void onInputConnectionOpenedInternal(InputConnection ic, EditorInfo editorInfo, Handler handler) {
        if (this.mEditor != null) {
            this.mEditor.getDefaultOnReceiveContentListener().setInputConnectionInfo(this, ic, editorInfo);
        }
    }

    @Override
    public void onInputConnectionClosedInternal() {
        if (this.mEditor != null) {
            this.mEditor.getDefaultOnReceiveContentListener().clearInputConnectionInfo();
        }
    }

    @Override
    public ContentInfo onReceiveContent(ContentInfo payload) {
        if (this.mEditor != null) {
            return this.mEditor.getDefaultOnReceiveContentListener().onReceiveContent(this, payload);
        }
        return payload;
    }

    private static void logCursor(String location, String msgFormat, Object ... msgArgs) {
        if (msgFormat == null) {
            Log.d(LOG_TAG, location);
        } else {
            Log.d(LOG_TAG, location + ": " + String.format(msgFormat, msgArgs));
        }
    }

    @Override
    public void onCreateViewTranslationRequest(int[] supportedFormats, Consumer<ViewTranslationRequest> requestsCollector) {
        if (supportedFormats == null || supportedFormats.length == 0) {
            if (UiTranslationController.DEBUG) {
                Log.w(LOG_TAG, "Do not provide the support translation formats.");
            }
            return;
        }
        ViewTranslationRequest.Builder requestBuilder = new ViewTranslationRequest.Builder(this.getAutofillId());
        if (ArrayUtils.contains(supportedFormats, 1)) {
            boolean isPassword;
            if (this.mText == null || this.mText.length() == 0) {
                if (UiTranslationController.DEBUG) {
                    Log.w(LOG_TAG, "Cannot create translation request for the empty text.");
                }
                return;
            }
            boolean bl = isPassword = this.isAnyPasswordInputType() || this.hasPasswordTransformationMethod();
            if (this.isTextEditable() || isPassword) {
                Log.w(LOG_TAG, "Cannot create translation request. editable = " + this.isTextEditable() + ", isPassword = " + isPassword);
                return;
            }
            requestBuilder.setValue("android:text", TranslationRequestValue.forText(this.mText));
            if (!TextUtils.isEmpty(this.getContentDescription())) {
                requestBuilder.setValue("android:content_description", TranslationRequestValue.forText(this.getContentDescription()));
            }
        }
        requestsCollector.accept(requestBuilder.build());
    }

    static {
        sAppearanceValues = new SparseIntArray();
        sAppearanceValues.put(6, 4);
        sAppearanceValues.put(99, 22);
        sAppearanceValues.put(100, 23);
        sAppearanceValues.put(5, 3);
        sAppearanceValues.put(7, 5);
        sAppearanceValues.put(8, 6);
        sAppearanceValues.put(2, 0);
        sAppearanceValues.put(96, 19);
        sAppearanceValues.put(3, 1);
        sAppearanceValues.put(75, 12);
        sAppearanceValues.put(4, 2);
        sAppearanceValues.put(95, 18);
        sAppearanceValues.put(72, 11);
        sAppearanceValues.put(36, 7);
        sAppearanceValues.put(37, 8);
        sAppearanceValues.put(38, 9);
        sAppearanceValues.put(39, 10);
        sAppearanceValues.put(76, 13);
        sAppearanceValues.put(91, 17);
        sAppearanceValues.put(77, 14);
        sAppearanceValues.put(78, 15);
        sAppearanceValues.put(90, 16);
        sAppearanceValues.put(97, 20);
        sAppearanceValues.put(98, 21);
        UNKNOWN_BORING = new BoringLayout.Metrics();
    }

    public static enum BufferType {
        NORMAL,
        SPANNABLE,
        EDITABLE;

    }

    private static class TextAppearanceAttributes {
        int mTextColorHighlight = 0;
        int mSearchResultHighlightColor = 0;
        int mFocusedSearchResultHighlightColor = 0;
        ColorStateList mTextColor = null;
        ColorStateList mTextColorHint = null;
        ColorStateList mTextColorLink = null;
        int mTextSize = -1;
        int mTextSizeUnit = -1;
        LocaleList mTextLocales = null;
        String mFontFamily = null;
        Typeface mFontTypeface = null;
        boolean mFontFamilyExplicit = false;
        int mTypefaceIndex = -1;
        int mTextStyle = 0;
        int mFontWeight = -1;
        boolean mAllCaps = false;
        int mShadowColor = 0;
        float mShadowDx = 0.0f;
        float mShadowDy = 0.0f;
        float mShadowRadius = 0.0f;
        boolean mHasElegant = false;
        boolean mElegant = false;
        boolean mHasFallbackLineSpacing = false;
        boolean mFallbackLineSpacing = false;
        boolean mHasLetterSpacing = false;
        float mLetterSpacing = 0.0f;
        String mFontFeatureSettings = null;
        String mFontVariationSettings = null;
        boolean mHasLineBreakStyle = false;
        boolean mHasLineBreakWordStyle = false;
        int mLineBreakStyle = 0;
        int mLineBreakWordStyle = 0;

        private TextAppearanceAttributes() {
        }

        public String toString() {
            return "TextAppearanceAttributes {\n    mTextColorHighlight:" + this.mTextColorHighlight + "\n    mSearchResultHighlightColor: " + this.mSearchResultHighlightColor + "\n    mFocusedSearchResultHighlightColor: " + this.mFocusedSearchResultHighlightColor + "\n    mTextColor:" + this.mTextColor + "\n    mTextColorHint:" + this.mTextColorHint + "\n    mTextColorLink:" + this.mTextColorLink + "\n    mTextSize:" + this.mTextSize + "\n    mTextSizeUnit:" + this.mTextSizeUnit + "\n    mTextLocales:" + this.mTextLocales + "\n    mFontFamily:" + this.mFontFamily + "\n    mFontTypeface:" + this.mFontTypeface + "\n    mFontFamilyExplicit:" + this.mFontFamilyExplicit + "\n    mTypefaceIndex:" + this.mTypefaceIndex + "\n    mTextStyle:" + this.mTextStyle + "\n    mFontWeight:" + this.mFontWeight + "\n    mAllCaps:" + this.mAllCaps + "\n    mShadowColor:" + this.mShadowColor + "\n    mShadowDx:" + this.mShadowDx + "\n    mShadowDy:" + this.mShadowDy + "\n    mShadowRadius:" + this.mShadowRadius + "\n    mHasElegant:" + this.mHasElegant + "\n    mElegant:" + this.mElegant + "\n    mHasFallbackLineSpacing:" + this.mHasFallbackLineSpacing + "\n    mFallbackLineSpacing:" + this.mFallbackLineSpacing + "\n    mHasLetterSpacing:" + this.mHasLetterSpacing + "\n    mLetterSpacing:" + this.mLetterSpacing + "\n    mFontFeatureSettings:" + this.mFontFeatureSettings + "\n    mFontVariationSettings:" + this.mFontVariationSettings + "\n    mHasLineBreakStyle:" + this.mHasLineBreakStyle + "\n    mHasLineBreakWordStyle:" + this.mHasLineBreakWordStyle + "\n    mLineBreakStyle:" + this.mLineBreakStyle + "\n    mLineBreakWordStyle:" + this.mLineBreakWordStyle + "\n}";
        }
    }

    static class Drawables {
        static final int LEFT = 0;
        static final int TOP = 1;
        static final int RIGHT = 2;
        static final int BOTTOM = 3;
        static final int DRAWABLE_NONE = -1;
        static final int DRAWABLE_RIGHT = 0;
        static final int DRAWABLE_LEFT = 1;
        final Rect mCompoundRect = new Rect();
        final Drawable[] mShowing = new Drawable[4];
        ColorStateList mTintList;
        BlendMode mBlendMode;
        boolean mHasTint;
        boolean mHasTintMode;
        Drawable mDrawableStart;
        Drawable mDrawableEnd;
        Drawable mDrawableError;
        Drawable mDrawableTemp;
        Drawable mDrawableLeftInitial;
        Drawable mDrawableRightInitial;
        boolean mIsRtlCompatibilityMode;
        boolean mOverride;
        int mDrawableSizeTop;
        int mDrawableSizeBottom;
        int mDrawableSizeLeft;
        int mDrawableSizeRight;
        int mDrawableSizeStart;
        int mDrawableSizeEnd;
        int mDrawableSizeError;
        int mDrawableSizeTemp;
        int mDrawableWidthTop;
        int mDrawableWidthBottom;
        int mDrawableHeightLeft;
        int mDrawableHeightRight;
        int mDrawableHeightStart;
        int mDrawableHeightEnd;
        int mDrawableHeightError;
        int mDrawableHeightTemp;
        int mDrawablePadding;
        int mDrawableSaved = -1;

        public Drawables(Context context) {
            int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
            this.mIsRtlCompatibilityMode = targetSdkVersion < 17 || !context.getApplicationInfo().hasRtlSupport();
            this.mOverride = false;
        }

        public boolean hasMetadata() {
            return this.mDrawablePadding != 0 || this.mHasTintMode || this.mHasTint;
        }

        public boolean resolveWithLayoutDirection(int layoutDirection) {
            Drawable previousLeft = this.mShowing[0];
            Drawable previousRight = this.mShowing[2];
            this.mShowing[0] = this.mDrawableLeftInitial;
            this.mShowing[2] = this.mDrawableRightInitial;
            if (this.mIsRtlCompatibilityMode) {
                if (this.mDrawableStart != null && this.mShowing[0] == null) {
                    this.mShowing[0] = this.mDrawableStart;
                    this.mDrawableSizeLeft = this.mDrawableSizeStart;
                    this.mDrawableHeightLeft = this.mDrawableHeightStart;
                }
                if (this.mDrawableEnd != null && this.mShowing[2] == null) {
                    this.mShowing[2] = this.mDrawableEnd;
                    this.mDrawableSizeRight = this.mDrawableSizeEnd;
                    this.mDrawableHeightRight = this.mDrawableHeightEnd;
                }
            } else {
                switch (layoutDirection) {
                    case 1: {
                        if (!this.mOverride) break;
                        this.mShowing[2] = this.mDrawableStart;
                        this.mDrawableSizeRight = this.mDrawableSizeStart;
                        this.mDrawableHeightRight = this.mDrawableHeightStart;
                        this.mShowing[0] = this.mDrawableEnd;
                        this.mDrawableSizeLeft = this.mDrawableSizeEnd;
                        this.mDrawableHeightLeft = this.mDrawableHeightEnd;
                        break;
                    }
                    default: {
                        if (!this.mOverride) break;
                        this.mShowing[0] = this.mDrawableStart;
                        this.mDrawableSizeLeft = this.mDrawableSizeStart;
                        this.mDrawableHeightLeft = this.mDrawableHeightStart;
                        this.mShowing[2] = this.mDrawableEnd;
                        this.mDrawableSizeRight = this.mDrawableSizeEnd;
                        this.mDrawableHeightRight = this.mDrawableHeightEnd;
                    }
                }
            }
            this.applyErrorDrawableIfNeeded(layoutDirection);
            return this.mShowing[0] != previousLeft || this.mShowing[2] != previousRight;
        }

        public void setErrorDrawable(Drawable dr, TextView tv) {
            if (this.mDrawableError != dr && this.mDrawableError != null) {
                this.mDrawableError.setCallback(null);
            }
            this.mDrawableError = dr;
            if (this.mDrawableError != null) {
                Rect compoundRect = this.mCompoundRect;
                int[] state = tv.getDrawableState();
                this.mDrawableError.setState(state);
                this.mDrawableError.copyBounds(compoundRect);
                this.mDrawableError.setCallback(tv);
                this.mDrawableSizeError = compoundRect.width();
                this.mDrawableHeightError = compoundRect.height();
            } else {
                this.mDrawableHeightError = 0;
                this.mDrawableSizeError = 0;
            }
        }

        private void applyErrorDrawableIfNeeded(int layoutDirection) {
            switch (this.mDrawableSaved) {
                case 1: {
                    this.mShowing[0] = this.mDrawableTemp;
                    this.mDrawableSizeLeft = this.mDrawableSizeTemp;
                    this.mDrawableHeightLeft = this.mDrawableHeightTemp;
                    break;
                }
                case 0: {
                    this.mShowing[2] = this.mDrawableTemp;
                    this.mDrawableSizeRight = this.mDrawableSizeTemp;
                    this.mDrawableHeightRight = this.mDrawableHeightTemp;
                    break;
                }
            }
            if (this.mDrawableError != null) {
                switch (layoutDirection) {
                    case 1: {
                        this.mDrawableSaved = 1;
                        this.mDrawableTemp = this.mShowing[0];
                        this.mDrawableSizeTemp = this.mDrawableSizeLeft;
                        this.mDrawableHeightTemp = this.mDrawableHeightLeft;
                        this.mShowing[0] = this.mDrawableError;
                        this.mDrawableSizeLeft = this.mDrawableSizeError;
                        this.mDrawableHeightLeft = this.mDrawableHeightError;
                        break;
                    }
                    default: {
                        this.mDrawableSaved = 0;
                        this.mDrawableTemp = this.mShowing[2];
                        this.mDrawableSizeTemp = this.mDrawableSizeRight;
                        this.mDrawableHeightTemp = this.mDrawableHeightRight;
                        this.mShowing[2] = this.mDrawableError;
                        this.mDrawableSizeRight = this.mDrawableSizeError;
                        this.mDrawableHeightRight = this.mDrawableHeightError;
                    }
                }
            }
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int selStart = -1;
        int selEnd = -1;
        @UnsupportedAppUsage
        CharSequence text;
        boolean frozenWithFocus;
        CharSequence error;
        ParcelableParcel editorState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.selStart);
            out.writeInt(this.selEnd);
            out.writeInt(this.frozenWithFocus ? 1 : 0);
            TextUtils.writeToParcel(this.text, out, flags);
            if (this.error == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                TextUtils.writeToParcel(this.error, out, flags);
            }
            if (this.editorState == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                this.editorState.writeToParcel(out, flags);
            }
        }

        public String toString() {
            String str = "TextView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " start=" + this.selStart + " end=" + this.selEnd;
            if (this.text != null) {
                str = str + " text=" + this.text;
            }
            return str + "}";
        }

        private SavedState(Parcel in) {
            super(in);
            this.selStart = in.readInt();
            this.selEnd = in.readInt();
            this.frozenWithFocus = in.readInt() != 0;
            this.text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() != 0) {
                this.error = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
            if (in.readInt() != 0) {
                this.editorState = (ParcelableParcel)ParcelableParcel.CREATOR.createFromParcel(in);
            }
        }
    }

    private static class CharWrapper
    implements CharSequence,
    GetChars,
    GraphicsOperations {
        private char[] mChars;
        private int mStart;
        private int mLength;

        CharWrapper(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        void set(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        @Override
        public int length() {
            return this.mLength;
        }

        @Override
        public char charAt(int off) {
            return this.mChars[off + this.mStart];
        }

        @Override
        public String toString() {
            return new String(this.mChars, this.mStart, this.mLength);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            return new String(this.mChars, start + this.mStart, end - start);
        }

        @Override
        public void getChars(int start, int end, char[] buf, int off) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            System.arraycopy(this.mChars, start + this.mStart, buf, off, end - start);
        }

        @Override
        public void drawText(BaseCanvas c, int start, int end, float x, float y, Paint p) {
            c.drawText(this.mChars, start + this.mStart, end - start, x, y, p);
        }

        @Override
        public void drawTextRun(BaseCanvas c, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            c.drawTextRun(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, x, y, isRtl, p);
        }

        @Override
        public float measureText(int start, int end, Paint p) {
            return p.measureText(this.mChars, start + this.mStart, end - start);
        }

        @Override
        public int getTextWidths(int start, int end, float[] widths, Paint p) {
            return p.getTextWidths(this.mChars, start + this.mStart, end - start, widths);
        }

        @Override
        public float getTextRunAdvances(int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            return p.getTextRunAdvances(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, isRtl, advances, advancesIndex);
        }

        @Override
        public int getTextRunCursor(int contextStart, int contextEnd, boolean isRtl, int offset, int cursorOpt, Paint p) {
            int contextCount = contextEnd - contextStart;
            return p.getTextRunCursor(this.mChars, contextStart + this.mStart, contextCount, isRtl, offset + this.mStart, cursorOpt);
        }
    }

    private class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private CharSequence mBeforeText;

        private ChangeWatcher() {
        }

        @Override
        public void beforeTextChanged(CharSequence buffer, int start, int before, int after) {
            if (AccessibilityManager.getInstance(TextView.this.mContext).isEnabled() && TextView.this.mTransformed != null) {
                this.mBeforeText = TextView.this.mTransformed.toString();
            }
            TextView.this.sendBeforeTextChanged(buffer, start, before, after);
        }

        @Override
        public void onTextChanged(CharSequence buffer, int start, int before, int after) {
            TextView.this.handleTextChanged(buffer, start, before, after);
            if (TextView.this.isVisibleToAccessibility()) {
                TextView.this.sendAccessibilityEventTypeViewTextChanged(this.mBeforeText, start, before, after);
                this.mBeforeText = null;
            }
        }

        @Override
        public void afterTextChanged(Editable buffer) {
            TextView.this.sendAfterTextChanged(buffer);
            if (MetaKeyKeyListener.getMetaState((CharSequence)buffer, 2048) != 0) {
                MetaKeyKeyListener.stopSelecting(TextView.this, buffer);
            }
        }

        @Override
        public void onSpanChanged(Spannable buf, Object what, int s, int e, int st, int en) {
            TextView.this.spanChange(buf, what, s, st, e, en);
        }

        @Override
        public void onSpanAdded(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, -1, s, -1, e);
        }

        @Override
        public void onSpanRemoved(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, s, -1, e, -1);
        }
    }

    public static interface OnEditorActionListener {
        public boolean onEditorAction(TextView var1, int var2, KeyEvent var3);
    }

    private static class Marquee {
        private static final float MARQUEE_DELTA_MAX = 0.07f;
        private static final int MARQUEE_DELAY = 1200;
        private static final int MARQUEE_DP_PER_SECOND = 30;
        private static final byte MARQUEE_STOPPED = 0;
        private static final byte MARQUEE_STARTING = 1;
        private static final byte MARQUEE_RUNNING = 2;
        private final WeakReference<TextView> mView;
        private final Choreographer mChoreographer;
        private byte mStatus = 0;
        private final float mPixelsPerMs;
        private float mMaxScroll;
        private float mMaxFadeScroll;
        private float mGhostStart;
        private float mGhostOffset;
        private float mFadeStop;
        private int mRepeatLimit;
        private float mScroll;
        private long mLastAnimationMs;
        private Choreographer.FrameCallback mTickCallback = new Choreographer.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                this.tick();
            }
        };
        private Choreographer.FrameCallback mStartCallback = new Choreographer.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                mStatus = (byte)2;
                mLastAnimationMs = mChoreographer.getFrameTime();
                this.tick();
            }
        };
        private Choreographer.FrameCallback mRestartCallback = new Choreographer.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                if (mStatus == 2) {
                    if (mRepeatLimit >= 0) {
                        --mRepeatLimit;
                    }
                    this.start(mRepeatLimit);
                }
            }
        };

        Marquee(TextView v) {
            float density = v.getContext().getResources().getDisplayMetrics().density;
            this.mPixelsPerMs = 30.0f * density / 1000.0f;
            this.mView = new WeakReference<TextView>(v);
            this.mChoreographer = Choreographer.getInstance();
        }

        void tick() {
            if (this.mStatus != 2) {
                return;
            }
            this.mChoreographer.removeFrameCallback(this.mTickCallback);
            TextView textView = (TextView)this.mView.get();
            if (textView != null && textView.isAggregatedVisible() && (textView.isFocused() || textView.isSelected())) {
                long currentMs = this.mChoreographer.getFrameTime();
                long deltaMs = currentMs - this.mLastAnimationMs;
                this.mLastAnimationMs = currentMs;
                float deltaPx = (float)deltaMs * this.mPixelsPerMs;
                this.mScroll += deltaPx;
                if (this.mScroll > this.mMaxScroll) {
                    this.mScroll = this.mMaxScroll;
                    this.mChoreographer.postFrameCallbackDelayed(this.mRestartCallback, 1200L);
                } else {
                    this.mChoreographer.postFrameCallback(this.mTickCallback);
                }
                textView.invalidate();
            }
        }

        void stop() {
            this.mStatus = 0;
            this.mChoreographer.removeFrameCallback(this.mStartCallback);
            this.mChoreographer.removeFrameCallback(this.mRestartCallback);
            this.mChoreographer.removeFrameCallback(this.mTickCallback);
            this.resetScroll();
        }

        private void resetScroll() {
            this.mScroll = 0.0f;
            TextView textView = (TextView)this.mView.get();
            if (textView != null) {
                textView.invalidate();
            }
        }

        void start(int repeatLimit) {
            if (repeatLimit == 0) {
                this.stop();
                return;
            }
            this.mRepeatLimit = repeatLimit;
            TextView textView = (TextView)this.mView.get();
            if (textView != null && textView.mLayout != null) {
                this.mStatus = 1;
                this.mScroll = 0.0f;
                int textWidth = textView.getWidth() - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight();
                float lineWidth = textView.mLayout.getLineWidth(0);
                float gap = (float)textWidth / 3.0f;
                this.mGhostStart = lineWidth - (float)textWidth + gap;
                this.mMaxScroll = this.mGhostStart + (float)textWidth;
                this.mGhostOffset = lineWidth + gap;
                this.mFadeStop = lineWidth + (float)textWidth / 6.0f;
                this.mMaxFadeScroll = this.mGhostStart + lineWidth + lineWidth;
                textView.invalidate();
                this.mChoreographer.postFrameCallback(this.mStartCallback);
            }
        }

        float getGhostOffset() {
            return this.mGhostOffset;
        }

        float getScroll() {
            return this.mScroll;
        }

        float getMaxFadeScroll() {
            return this.mMaxFadeScroll;
        }

        boolean shouldDrawLeftFade() {
            return this.mScroll <= this.mFadeStop;
        }

        boolean shouldDrawGhost() {
            return this.mStatus == 2 && this.mScroll > this.mGhostStart;
        }

        boolean isRunning() {
            return this.mStatus == 2;
        }

        boolean isStopped() {
            return this.mStatus == 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AutoSizeTextType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface XMLTypefaceAttr {
    }
}

