/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.util.FloatProperty;
import android.window.BackEvent;
import android.window.BackMotionEvent;
import com.android.internal.dynamicanimation.animation.DynamicAnimation;
import com.android.internal.dynamicanimation.animation.SpringAnimation;
import com.android.internal.dynamicanimation.animation.SpringForce;

public class BackProgressAnimator {
    private static final float SCALE_FACTOR = 100.0f;
    private final SpringAnimation mSpring = new SpringAnimation(this, PROGRESS_PROP);
    private ProgressCallback mCallback;
    private float mProgress = 0.0f;
    private BackMotionEvent mLastBackEvent;
    private boolean mBackAnimationInProgress = false;
    private static final FloatProperty<BackProgressAnimator> PROGRESS_PROP = new FloatProperty<BackProgressAnimator>("progress"){

        @Override
        public void setValue(BackProgressAnimator animator2, float value) {
            animator2.setProgress(value);
            animator2.updateProgressValue(value);
        }

        @Override
        public Float get(BackProgressAnimator object) {
            return Float.valueOf(object.getProgress());
        }
    };

    private void setProgress(float progress) {
        this.mProgress = progress;
    }

    private float getProgress() {
        return this.mProgress;
    }

    public BackProgressAnimator() {
        this.mSpring.setSpring(new SpringForce().setStiffness(1500.0f).setDampingRatio(1.0f));
    }

    public void onBackProgressed(BackMotionEvent event) {
        if (!this.mBackAnimationInProgress) {
            return;
        }
        this.mLastBackEvent = event;
        if (this.mSpring == null) {
            return;
        }
        this.mSpring.animateToFinalPosition(event.getProgress() * 100.0f);
    }

    public void onBackStarted(BackMotionEvent event, ProgressCallback callback) {
        this.reset();
        this.mLastBackEvent = event;
        this.mCallback = callback;
        this.mBackAnimationInProgress = true;
    }

    public void reset() {
        this.mSpring.animateToFinalPosition(0.0f);
        if (this.mSpring.canSkipToEnd()) {
            this.mSpring.skipToEnd();
        } else {
            this.mSpring.cancel();
        }
        this.mBackAnimationInProgress = false;
        this.mLastBackEvent = null;
        this.mCallback = null;
        this.mProgress = 0.0f;
    }

    public void onBackCancelled(final Runnable finishCallback) {
        DynamicAnimation.OnAnimationEndListener listener = new DynamicAnimation.OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(DynamicAnimation animation, boolean canceled, float value, float velocity) {
                BackProgressAnimator.this.mSpring.removeEndListener(this);
                finishCallback.run();
                BackProgressAnimator.this.reset();
            }
        };
        this.mSpring.addEndListener(listener);
        this.mSpring.animateToFinalPosition(0.0f);
    }

    boolean isBackAnimationInProgress() {
        return this.mBackAnimationInProgress;
    }

    private void updateProgressValue(float progress) {
        if (this.mLastBackEvent == null || this.mCallback == null || !this.mBackAnimationInProgress) {
            return;
        }
        this.mCallback.onProgressUpdate(new BackEvent(this.mLastBackEvent.getTouchX(), this.mLastBackEvent.getTouchY(), progress / 100.0f, this.mLastBackEvent.getSwipeEdge()));
    }

    public static interface ProgressCallback {
        public void onProgressUpdate(BackEvent var1);
    }
}

