/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

public class ClientWindowFrames
implements Parcelable {
    public final Rect frame = new Rect();
    public final Rect displayFrame = new Rect();
    public final Rect parentFrame = new Rect();
    public Rect attachedFrame;
    public boolean isParentFrameClippedByDisplayCutout;
    public float compatScale = 1.0f;
    public static final Parcelable.Creator<ClientWindowFrames> CREATOR = new Parcelable.Creator<ClientWindowFrames>(){

        @Override
        public ClientWindowFrames createFromParcel(Parcel in) {
            return new ClientWindowFrames(in);
        }

        public ClientWindowFrames[] newArray(int size) {
            return new ClientWindowFrames[size];
        }
    };

    public ClientWindowFrames() {
    }

    public ClientWindowFrames(ClientWindowFrames other) {
        this.frame.set(other.frame);
        this.displayFrame.set(other.displayFrame);
        this.parentFrame.set(other.parentFrame);
        if (other.attachedFrame != null) {
            this.attachedFrame = new Rect(other.attachedFrame);
        }
        this.isParentFrameClippedByDisplayCutout = other.isParentFrameClippedByDisplayCutout;
        this.compatScale = other.compatScale;
    }

    private ClientWindowFrames(Parcel in) {
        this.readFromParcel(in);
    }

    public void readFromParcel(Parcel in) {
        this.frame.readFromParcel(in);
        this.displayFrame.readFromParcel(in);
        this.parentFrame.readFromParcel(in);
        this.attachedFrame = in.readTypedObject(Rect.CREATOR);
        this.isParentFrameClippedByDisplayCutout = in.readBoolean();
        this.compatScale = in.readFloat();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.frame.writeToParcel(dest, flags);
        this.displayFrame.writeToParcel(dest, flags);
        this.parentFrame.writeToParcel(dest, flags);
        dest.writeTypedObject(this.attachedFrame, flags);
        dest.writeBoolean(this.isParentFrameClippedByDisplayCutout);
        dest.writeFloat(this.compatScale);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        return "ClientWindowFrames{frame=" + this.frame.toShortString(sb) + " display=" + this.displayFrame.toShortString(sb) + " parentFrame=" + this.parentFrame.toShortString(sb) + (this.attachedFrame != null ? " attachedFrame=" + this.attachedFrame.toShortString() : "") + (this.isParentFrameClippedByDisplayCutout ? " parentClippedByDisplayCutout" : "") + (this.compatScale != 1.0f ? " sizeCompatScale=" + this.compatScale : "") + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

