/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.BackMotionEvent;

public interface IOnBackInvokedCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IOnBackInvokedCallback";

    public void onBackStarted(BackMotionEvent var1) throws RemoteException;

    public void onBackProgressed(BackMotionEvent var1) throws RemoteException;

    public void onBackCancelled() throws RemoteException;

    public void onBackInvoked() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOnBackInvokedCallback {
        static final int TRANSACTION_onBackStarted = 1;
        static final int TRANSACTION_onBackProgressed = 2;
        static final int TRANSACTION_onBackCancelled = 3;
        static final int TRANSACTION_onBackInvoked = 4;

        public Stub() {
            this.attachInterface(this, IOnBackInvokedCallback.DESCRIPTOR);
        }

        public static IOnBackInvokedCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOnBackInvokedCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IOnBackInvokedCallback) {
                return (IOnBackInvokedCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onBackStarted";
                }
                case 2: {
                    return "onBackProgressed";
                }
                case 3: {
                    return "onBackCancelled";
                }
                case 4: {
                    return "onBackInvoked";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOnBackInvokedCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BackMotionEvent _arg0 = data.readTypedObject(BackMotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBackStarted(_arg0);
                    break;
                }
                case 2: {
                    BackMotionEvent _arg0 = data.readTypedObject(BackMotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBackProgressed(_arg0);
                    break;
                }
                case 3: {
                    this.onBackCancelled();
                    break;
                }
                case 4: {
                    this.onBackInvoked();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IOnBackInvokedCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOnBackInvokedCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackStarted(BackMotionEvent backMotionEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOnBackInvokedCallback.DESCRIPTOR);
                    _data.writeTypedObject(backMotionEvent, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackProgressed(BackMotionEvent backMotionEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOnBackInvokedCallback.DESCRIPTOR);
                    _data.writeTypedObject(backMotionEvent, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBackCancelled() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOnBackInvokedCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBackInvoked() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOnBackInvokedCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOnBackInvokedCallback {
        @Override
        public void onBackStarted(BackMotionEvent backMotionEvent) throws RemoteException {
        }

        @Override
        public void onBackProgressed(BackMotionEvent backMotionEvent) throws RemoteException {
        }

        @Override
        public void onBackCancelled() throws RemoteException {
        }

        @Override
        public void onBackInvoked() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

