/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.IRemoteTransitionFinishedCallback;
import android.window.TransitionInfo;

public interface IRemoteTransition
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IRemoteTransition";

    public void startAnimation(IBinder var1, TransitionInfo var2, SurfaceControl.Transaction var3, IRemoteTransitionFinishedCallback var4) throws RemoteException;

    public void mergeAnimation(IBinder var1, TransitionInfo var2, SurfaceControl.Transaction var3, IBinder var4, IRemoteTransitionFinishedCallback var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteTransition {
        static final int TRANSACTION_startAnimation = 1;
        static final int TRANSACTION_mergeAnimation = 2;

        public Stub() {
            this.attachInterface(this, IRemoteTransition.DESCRIPTOR);
        }

        public static IRemoteTransition asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteTransition.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteTransition) {
                return (IRemoteTransition)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startAnimation";
                }
                case 2: {
                    return "mergeAnimation";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteTransition.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionInfo _arg1 = data.readTypedObject(TransitionInfo.CREATOR);
                    SurfaceControl.Transaction _arg2 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    IRemoteTransitionFinishedCallback _arg3 = IRemoteTransitionFinishedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startAnimation(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionInfo _arg1 = data.readTypedObject(TransitionInfo.CREATOR);
                    SurfaceControl.Transaction _arg2 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    IBinder _arg3 = data.readStrongBinder();
                    IRemoteTransitionFinishedCallback _arg4 = IRemoteTransitionFinishedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.mergeAnimation(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IRemoteTransition {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteTransition.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAnimation(IBinder token, TransitionInfo info, SurfaceControl.Transaction t, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteTransition.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(info, 0);
                    _data.writeTypedObject(t, 0);
                    _data.writeStrongInterface(finishCallback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mergeAnimation(IBinder transition2, TransitionInfo info, SurfaceControl.Transaction t, IBinder mergeTarget, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteTransition.DESCRIPTOR);
                    _data.writeStrongBinder(transition2);
                    _data.writeTypedObject(info, 0);
                    _data.writeTypedObject(t, 0);
                    _data.writeStrongBinder(mergeTarget);
                    _data.writeStrongInterface(finishCallback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteTransition {
        @Override
        public void startAnimation(IBinder token, TransitionInfo info, SurfaceControl.Transaction t, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
        }

        @Override
        public void mergeAnimation(IBinder transition2, TransitionInfo info, SurfaceControl.Transaction t, IBinder mergeTarget, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

