/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;

public interface IWindowlessStartingSurfaceCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IWindowlessStartingSurfaceCallback";

    public void onSurfaceAdded(SurfaceControl var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowlessStartingSurfaceCallback {
        static final int TRANSACTION_onSurfaceAdded = 1;

        public Stub() {
            this.attachInterface(this, IWindowlessStartingSurfaceCallback.DESCRIPTOR);
        }

        public static IWindowlessStartingSurfaceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWindowlessStartingSurfaceCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IWindowlessStartingSurfaceCallback) {
                return (IWindowlessStartingSurfaceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSurfaceAdded";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWindowlessStartingSurfaceCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SurfaceControl _arg0 = data.readTypedObject(SurfaceControl.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSurfaceAdded(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IWindowlessStartingSurfaceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWindowlessStartingSurfaceCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSurfaceAdded(SurfaceControl addedSurface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowlessStartingSurfaceCallback.DESCRIPTOR);
                    _data.writeTypedObject(addedSurface, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowlessStartingSurfaceCallback {
        @Override
        public void onSurfaceAdded(SurfaceControl addedSurface) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

