/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.ViewRootImpl;
import android.window.IOnBackInvokedCallback;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import android.window.WindowOnBackInvokedDispatcher;
import java.util.ArrayList;

public class ImeOnBackInvokedDispatcher
implements OnBackInvokedDispatcher,
Parcelable {
    private static final String TAG = "ImeBackDispatcher";
    static final String RESULT_KEY_ID = "id";
    static final String RESULT_KEY_CALLBACK = "callback";
    static final String RESULT_KEY_PRIORITY = "priority";
    static final int RESULT_CODE_REGISTER = 0;
    static final int RESULT_CODE_UNREGISTER = 1;
    private final ResultReceiver mResultReceiver;
    public static final Parcelable.Creator<ImeOnBackInvokedDispatcher> CREATOR = new Parcelable.Creator<ImeOnBackInvokedDispatcher>(){

        @Override
        public ImeOnBackInvokedDispatcher createFromParcel(Parcel in) {
            return new ImeOnBackInvokedDispatcher(in);
        }

        public ImeOnBackInvokedDispatcher[] newArray(int size) {
            return new ImeOnBackInvokedDispatcher[size];
        }
    };
    private final ArrayList<ImeOnBackInvokedCallback> mImeCallbacks = new ArrayList();

    public ImeOnBackInvokedDispatcher(Handler handler) {
        this.mResultReceiver = new ResultReceiver(handler){

            @Override
            public void onReceiveResult(int resultCode, Bundle resultData) {
                WindowOnBackInvokedDispatcher dispatcher = ImeOnBackInvokedDispatcher.this.getReceivingDispatcher();
                if (dispatcher != null) {
                    ImeOnBackInvokedDispatcher.this.receive(resultCode, resultData, dispatcher);
                }
            }
        };
    }

    protected WindowOnBackInvokedDispatcher getReceivingDispatcher() {
        return null;
    }

    ImeOnBackInvokedDispatcher(Parcel in) {
        this.mResultReceiver = in.readTypedObject(ResultReceiver.CREATOR);
    }

    @Override
    public void registerOnBackInvokedCallback(int priority, OnBackInvokedCallback callback) {
        Bundle bundle = new Bundle();
        WindowOnBackInvokedDispatcher.OnBackInvokedCallbackWrapper iCallback = new WindowOnBackInvokedDispatcher.OnBackInvokedCallbackWrapper(callback, false);
        bundle.putBinder(RESULT_KEY_CALLBACK, iCallback.asBinder());
        bundle.putInt(RESULT_KEY_PRIORITY, priority);
        bundle.putInt(RESULT_KEY_ID, callback.hashCode());
        this.mResultReceiver.send(0, bundle);
    }

    @Override
    public void unregisterOnBackInvokedCallback(OnBackInvokedCallback callback) {
        Bundle bundle = new Bundle();
        bundle.putInt(RESULT_KEY_ID, callback.hashCode());
        this.mResultReceiver.send(1, bundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mResultReceiver, flags);
    }

    private void receive(int resultCode, Bundle resultData, WindowOnBackInvokedDispatcher receivingDispatcher) {
        int callbackId = resultData.getInt(RESULT_KEY_ID);
        if (resultCode == 0) {
            int priority = resultData.getInt(RESULT_KEY_PRIORITY);
            IOnBackInvokedCallback callback = IOnBackInvokedCallback.Stub.asInterface(resultData.getBinder(RESULT_KEY_CALLBACK));
            this.registerReceivedCallback(callback, priority, callbackId, receivingDispatcher);
        } else if (resultCode == 1) {
            this.unregisterReceivedCallback(callbackId, receivingDispatcher);
        }
    }

    private void registerReceivedCallback(IOnBackInvokedCallback iCallback, int priority, int callbackId, WindowOnBackInvokedDispatcher receivingDispatcher) {
        ImeOnBackInvokedCallback imeCallback = new ImeOnBackInvokedCallback(iCallback, callbackId, priority);
        this.mImeCallbacks.add(imeCallback);
        receivingDispatcher.registerOnBackInvokedCallbackUnchecked(imeCallback, priority);
    }

    private void unregisterReceivedCallback(int callbackId, OnBackInvokedDispatcher receivingDispatcher) {
        ImeOnBackInvokedCallback callback = null;
        for (ImeOnBackInvokedCallback imeCallback : this.mImeCallbacks) {
            if (imeCallback.getId() != callbackId) continue;
            callback = imeCallback;
            break;
        }
        if (callback == null) {
            Log.e(TAG, "Ime callback not found. Ignoring unregisterReceivedCallback. callbackId: " + callbackId);
            return;
        }
        receivingDispatcher.unregisterOnBackInvokedCallback(callback);
        this.mImeCallbacks.remove(callback);
    }

    public void clear() {
        if (this.getReceivingDispatcher() != null) {
            for (ImeOnBackInvokedCallback callback : this.mImeCallbacks) {
                this.getReceivingDispatcher().unregisterOnBackInvokedCallback(callback);
            }
        }
        this.mImeCallbacks.clear();
    }

    public void switchRootView(ViewRootImpl previous, ViewRootImpl current) {
        for (ImeOnBackInvokedCallback imeCallback : this.mImeCallbacks) {
            if (previous != null) {
                previous.getOnBackInvokedDispatcher().unregisterOnBackInvokedCallback(imeCallback);
            }
            if (current == null) continue;
            current.getOnBackInvokedDispatcher().registerOnBackInvokedCallbackUnchecked(imeCallback, imeCallback.mPriority);
        }
    }

    static class ImeOnBackInvokedCallback
    implements OnBackInvokedCallback {
        private final IOnBackInvokedCallback mIOnBackInvokedCallback;
        private final int mId;
        private final int mPriority;

        ImeOnBackInvokedCallback(IOnBackInvokedCallback iCallback, int id2, int priority) {
            this.mIOnBackInvokedCallback = iCallback;
            this.mId = id2;
            this.mPriority = priority;
        }

        @Override
        public void onBackInvoked() {
            try {
                if (this.mIOnBackInvokedCallback != null) {
                    this.mIOnBackInvokedCallback.onBackInvoked();
                }
            }
            catch (RemoteException e) {
                Log.e(ImeOnBackInvokedDispatcher.TAG, "Exception when invoking forwarded callback. e: ", e);
            }
        }

        private int getId() {
            return this.mId;
        }

        IOnBackInvokedCallback getIOnBackInvokedCallback() {
            return this.mIOnBackInvokedCallback;
        }

        public String toString() {
            return "ImeCallback=ImeOnBackInvokedCallback@" + this.mId + " Callback=" + this.mIOnBackInvokedCallback;
        }
    }
}

