/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.app.IApplicationThread;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.IRemoteTransition;
import com.android.internal.util.AnnotationValidations;

public class RemoteTransition
implements Parcelable {
    private IRemoteTransition mRemoteTransition;
    private IApplicationThread mAppThread;
    private String mDebugName;
    public static final Parcelable.Creator<RemoteTransition> CREATOR = new Parcelable.Creator<RemoteTransition>(){

        public RemoteTransition[] newArray(int size) {
            return new RemoteTransition[size];
        }

        @Override
        public RemoteTransition createFromParcel(Parcel in) {
            return new RemoteTransition(in);
        }
    };

    public RemoteTransition(IRemoteTransition remoteTransition) {
        this(remoteTransition, null, null);
    }

    public RemoteTransition(IRemoteTransition remoteTransition, String debugName) {
        this(remoteTransition, null, debugName);
    }

    public IBinder asBinder() {
        return this.mRemoteTransition.asBinder();
    }

    public RemoteTransition(IRemoteTransition remoteTransition, IApplicationThread appThread, String debugName) {
        this.mRemoteTransition = remoteTransition;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mRemoteTransition);
        this.mAppThread = appThread;
        this.mDebugName = debugName;
    }

    public IRemoteTransition getRemoteTransition() {
        return this.mRemoteTransition;
    }

    public IApplicationThread getAppThread() {
        return this.mAppThread;
    }

    public String getDebugName() {
        return this.mDebugName;
    }

    public RemoteTransition setRemoteTransition(IRemoteTransition value) {
        this.mRemoteTransition = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mRemoteTransition);
        return this;
    }

    public RemoteTransition setAppThread(IApplicationThread value) {
        this.mAppThread = value;
        return this;
    }

    public RemoteTransition setDebugName(String value) {
        this.mDebugName = value;
        return this;
    }

    public String toString() {
        return "RemoteTransition { remoteTransition = " + this.mRemoteTransition + ", appThread = " + this.mAppThread + ", debugName = " + this.mDebugName + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAppThread != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mDebugName != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeStrongInterface(this.mRemoteTransition);
        if (this.mAppThread != null) {
            dest.writeStrongInterface(this.mAppThread);
        }
        if (this.mDebugName != null) {
            dest.writeString(this.mDebugName);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected RemoteTransition(Parcel in) {
        byte flg = in.readByte();
        IRemoteTransition remoteTransition = IRemoteTransition.Stub.asInterface(in.readStrongBinder());
        IApplicationThread appThread = (flg & 2) == 0 ? null : IApplicationThread.Stub.asInterface(in.readStrongBinder());
        String debugName = (flg & 4) == 0 ? null : in.readString();
        this.mRemoteTransition = remoteTransition;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mRemoteTransition);
        this.mAppThread = appThread;
        this.mDebugName = debugName;
    }

    @Deprecated
    private void __metadata() {
    }
}

