/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.SurfaceControl;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import libcore.util.NativeAllocationRegistry;

public class ScreenCapture {
    private static final String TAG = "ScreenCapture";
    private static final int SCREENSHOT_WAIT_TIME_S = 1;

    private static int nativeCaptureDisplay(DisplayCaptureArgs displayCaptureArgs, long l) {
        return OverrideMethod.invokeI("android.window.ScreenCapture#nativeCaptureDisplay(Landroid/window/ScreenCapture$DisplayCaptureArgs;J)I", true, null);
    }

    private static int nativeCaptureLayers(LayerCaptureArgs layerCaptureArgs, long l) {
        return OverrideMethod.invokeI("android.window.ScreenCapture#nativeCaptureLayers(Landroid/window/ScreenCapture$LayerCaptureArgs;J)I", true, null);
    }

    private static long nativeCreateScreenCaptureListener(Consumer<ScreenshotHardwareBuffer> consumer) {
        return OverrideMethod.invokeL("android.window.ScreenCapture#nativeCreateScreenCaptureListener(Ljava/util/function/Consumer;)J", true, null);
    }

    private static void nativeWriteListenerToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.window.ScreenCapture#nativeWriteListenerToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static long nativeReadListenerFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.window.ScreenCapture#nativeReadListenerFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static long getNativeListenerFinalizer() {
        return OverrideMethod.invokeL("android.window.ScreenCapture#getNativeListenerFinalizer()J", true, null);
    }

    public static int captureDisplay(DisplayCaptureArgs captureArgs, ScreenCaptureListener captureListener) {
        return ScreenCapture.nativeCaptureDisplay(captureArgs, captureListener.mNativeObject);
    }

    public static ScreenshotHardwareBuffer captureDisplay(DisplayCaptureArgs captureArgs) {
        SynchronousScreenCaptureListener syncScreenCapture = ScreenCapture.createSyncCaptureListener();
        int status = ScreenCapture.captureDisplay(captureArgs, syncScreenCapture);
        if (status != 0) {
            return null;
        }
        try {
            return syncScreenCapture.getBuffer();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ScreenshotHardwareBuffer captureLayers(SurfaceControl layer, Rect sourceCrop, float frameScale) {
        return ScreenCapture.captureLayers(layer, sourceCrop, frameScale, 1);
    }

    public static ScreenshotHardwareBuffer captureLayers(SurfaceControl layer, Rect sourceCrop, float frameScale, int format) {
        LayerCaptureArgs captureArgs = ((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)new LayerCaptureArgs.Builder(layer).setSourceCrop(sourceCrop)).setFrameScale(frameScale)).setPixelFormat(format)).build();
        return ScreenCapture.captureLayers(captureArgs);
    }

    public static ScreenshotHardwareBuffer captureLayers(LayerCaptureArgs captureArgs) {
        SynchronousScreenCaptureListener syncScreenCapture = ScreenCapture.createSyncCaptureListener();
        int status = ScreenCapture.captureLayers(captureArgs, syncScreenCapture);
        if (status != 0) {
            return null;
        }
        try {
            return syncScreenCapture.getBuffer();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ScreenshotHardwareBuffer captureLayersExcluding(SurfaceControl layer, Rect sourceCrop, float frameScale, int format, SurfaceControl[] exclude) {
        LayerCaptureArgs captureArgs = ((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)new LayerCaptureArgs.Builder(layer).setSourceCrop(sourceCrop)).setFrameScale(frameScale)).setPixelFormat(format)).setExcludeLayers(exclude)).build();
        return ScreenCapture.captureLayers(captureArgs);
    }

    public static int captureLayers(LayerCaptureArgs captureArgs, ScreenCaptureListener captureListener) {
        return ScreenCapture.nativeCaptureLayers(captureArgs, captureListener.mNativeObject);
    }

    public static SynchronousScreenCaptureListener createSyncCaptureListener() {
        final ScreenshotHardwareBuffer[] bufferRef = new ScreenshotHardwareBuffer[1];
        final CountDownLatch latch = new CountDownLatch(1);
        final Consumer<ScreenshotHardwareBuffer> consumer = buffer -> {
            bufferRef[0] = buffer;
            latch.countDown();
        };
        return new SynchronousScreenCaptureListener(consumer){
            private Consumer<ScreenshotHardwareBuffer> mConsumer;
            {
                super(consumer3);
                this.mConsumer = consumer;
            }

            @Override
            public ScreenshotHardwareBuffer getBuffer() {
                try {
                    latch.await(1L, TimeUnit.SECONDS);
                    return bufferRef[0];
                }
                catch (Exception e) {
                    Log.e(ScreenCapture.TAG, "Failed to wait for screen capture result", e);
                    return null;
                }
            }
        };
    }

    public static class ScreenCaptureListener
    implements Parcelable {
        private final long mNativeObject;
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(ScreenCaptureListener.class.getClassLoader(), ScreenCapture.getNativeListenerFinalizer());
        public static final Parcelable.Creator<ScreenCaptureListener> CREATOR = new Parcelable.Creator<ScreenCaptureListener>(){

            @Override
            public ScreenCaptureListener createFromParcel(Parcel in) {
                return new ScreenCaptureListener(in);
            }

            public ScreenCaptureListener[] newArray(int size) {
                return new ScreenCaptureListener[0];
            }
        };

        public ScreenCaptureListener(Consumer<ScreenshotHardwareBuffer> consumer) {
            this.mNativeObject = ScreenCapture.nativeCreateScreenCaptureListener(consumer);
            sRegistry.registerNativeAllocation(this, this.mNativeObject);
        }

        private ScreenCaptureListener(Parcel in) {
            if (in.readBoolean()) {
                this.mNativeObject = ScreenCapture.nativeReadListenerFromParcel(in);
                sRegistry.registerNativeAllocation(this, this.mNativeObject);
            } else {
                this.mNativeObject = 0L;
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mNativeObject == 0L) {
                dest.writeBoolean(false);
            } else {
                dest.writeBoolean(true);
                ScreenCapture.nativeWriteListenerToParcel(this.mNativeObject, dest);
            }
        }
    }

    public static class DisplayCaptureArgs
    extends CaptureArgs {
        private final IBinder mDisplayToken;
        private final int mWidth;
        private final int mHeight;
        private final boolean mUseIdentityTransform;

        private DisplayCaptureArgs(Builder builder) {
            super(builder);
            this.mDisplayToken = builder.mDisplayToken;
            this.mWidth = builder.mWidth;
            this.mHeight = builder.mHeight;
            this.mUseIdentityTransform = builder.mUseIdentityTransform;
        }

        public static class Builder
        extends CaptureArgs.Builder<Builder> {
            private IBinder mDisplayToken;
            private int mWidth;
            private int mHeight;
            private boolean mUseIdentityTransform;

            @Override
            public DisplayCaptureArgs build() {
                if (this.mDisplayToken == null) {
                    throw new IllegalStateException("Can't take screenshot with null display token");
                }
                return new DisplayCaptureArgs(this);
            }

            public Builder(IBinder displayToken) {
                this.setDisplayToken(displayToken);
            }

            public Builder setDisplayToken(IBinder displayToken) {
                this.mDisplayToken = displayToken;
                return this;
            }

            public Builder setSize(int width, int height) {
                this.mWidth = width;
                this.mHeight = height;
                return this;
            }

            public Builder setUseIdentityTransform(boolean useIdentityTransform) {
                this.mUseIdentityTransform = useIdentityTransform;
                return this;
            }

            @Override
            Builder getThis() {
                return this;
            }
        }
    }

    public static abstract class SynchronousScreenCaptureListener
    extends ScreenCaptureListener {
        SynchronousScreenCaptureListener(Consumer<ScreenshotHardwareBuffer> consumer) {
            super(consumer);
        }

        public abstract ScreenshotHardwareBuffer getBuffer();
    }

    public static class ScreenshotHardwareBuffer {
        private final HardwareBuffer mHardwareBuffer;
        private final ColorSpace mColorSpace;
        private final boolean mContainsSecureLayers;
        private final boolean mContainsHdrLayers;

        public ScreenshotHardwareBuffer(HardwareBuffer hardwareBuffer, ColorSpace colorSpace, boolean containsSecureLayers, boolean containsHdrLayers) {
            this.mHardwareBuffer = hardwareBuffer;
            this.mColorSpace = colorSpace;
            this.mContainsSecureLayers = containsSecureLayers;
            this.mContainsHdrLayers = containsHdrLayers;
        }

        private static ScreenshotHardwareBuffer createFromNative(HardwareBuffer hardwareBuffer, int dataspace, boolean containsSecureLayers, boolean containsHdrLayers) {
            ColorSpace colorSpace = ColorSpace.getFromDataSpace(dataspace);
            return new ScreenshotHardwareBuffer(hardwareBuffer, colorSpace != null ? colorSpace : ColorSpace.get(ColorSpace.Named.SRGB), containsSecureLayers, containsHdrLayers);
        }

        public ColorSpace getColorSpace() {
            return this.mColorSpace;
        }

        public HardwareBuffer getHardwareBuffer() {
            return this.mHardwareBuffer;
        }

        public boolean containsSecureLayers() {
            return this.mContainsSecureLayers;
        }

        public boolean containsHdrLayers() {
            return this.mContainsHdrLayers;
        }

        public Bitmap asBitmap() {
            if (this.mHardwareBuffer == null) {
                Log.w(ScreenCapture.TAG, "Failed to take screenshot. Null screenshot object");
                return null;
            }
            return Bitmap.wrapHardwareBuffer(this.mHardwareBuffer, this.mColorSpace);
        }
    }

    public static class LayerCaptureArgs
    extends CaptureArgs {
        private final long mNativeLayer;
        private final boolean mChildrenOnly;

        private LayerCaptureArgs(Builder builder) {
            super(builder);
            this.mChildrenOnly = builder.mChildrenOnly;
            this.mNativeLayer = builder.mLayer.mNativeObject;
        }

        public static class Builder
        extends CaptureArgs.Builder<Builder> {
            private SurfaceControl mLayer;
            private boolean mChildrenOnly = true;

            @Override
            public LayerCaptureArgs build() {
                if (this.mLayer == null) {
                    throw new IllegalStateException("Can't take screenshot with null layer");
                }
                return new LayerCaptureArgs(this);
            }

            public Builder(SurfaceControl layer, CaptureArgs args) {
                this.setLayer(layer);
                this.setPixelFormat(args.mPixelFormat);
                this.setSourceCrop(args.mSourceCrop);
                this.setFrameScale(args.mFrameScaleX, args.mFrameScaleY);
                this.setCaptureSecureLayers(args.mCaptureSecureLayers);
                this.setAllowProtected(args.mAllowProtected);
                this.setUid(args.mUid);
                this.setGrayscale(args.mGrayscale);
                this.setExcludeLayers(args.mExcludeLayers);
                this.setHintForSeamlessTransition(args.mHintForSeamlessTransition);
            }

            public Builder(SurfaceControl layer) {
                this.setLayer(layer);
            }

            public Builder setLayer(SurfaceControl layer) {
                this.mLayer = layer;
                return this;
            }

            public Builder setChildrenOnly(boolean childrenOnly) {
                this.mChildrenOnly = childrenOnly;
                return this;
            }

            @Override
            Builder getThis() {
                return this;
            }
        }
    }

    public static class CaptureArgs
    implements Parcelable {
        public final int mPixelFormat;
        public final Rect mSourceCrop = new Rect();
        public final float mFrameScaleX;
        public final float mFrameScaleY;
        public final boolean mCaptureSecureLayers;
        public final boolean mAllowProtected;
        public final long mUid;
        public final boolean mGrayscale;
        final SurfaceControl[] mExcludeLayers;
        public final boolean mHintForSeamlessTransition;
        public static final Parcelable.Creator<CaptureArgs> CREATOR = new Parcelable.Creator<CaptureArgs>(){

            @Override
            public CaptureArgs createFromParcel(Parcel in) {
                return new CaptureArgs(in);
            }

            public CaptureArgs[] newArray(int size) {
                return new CaptureArgs[size];
            }
        };

        private CaptureArgs(Builder<? extends Builder<?>> builder) {
            this.mPixelFormat = builder.mPixelFormat;
            this.mSourceCrop.set(builder.mSourceCrop);
            this.mFrameScaleX = builder.mFrameScaleX;
            this.mFrameScaleY = builder.mFrameScaleY;
            this.mCaptureSecureLayers = builder.mCaptureSecureLayers;
            this.mAllowProtected = builder.mAllowProtected;
            this.mUid = builder.mUid;
            this.mGrayscale = builder.mGrayscale;
            this.mExcludeLayers = builder.mExcludeLayers;
            this.mHintForSeamlessTransition = builder.mHintForSeamlessTransition;
        }

        private CaptureArgs(Parcel in) {
            this.mPixelFormat = in.readInt();
            this.mSourceCrop.readFromParcel(in);
            this.mFrameScaleX = in.readFloat();
            this.mFrameScaleY = in.readFloat();
            this.mCaptureSecureLayers = in.readBoolean();
            this.mAllowProtected = in.readBoolean();
            this.mUid = in.readLong();
            this.mGrayscale = in.readBoolean();
            int excludeLayersLength = in.readInt();
            if (excludeLayersLength > 0) {
                this.mExcludeLayers = new SurfaceControl[excludeLayersLength];
                for (int index = 0; index < excludeLayersLength; ++index) {
                    this.mExcludeLayers[index] = SurfaceControl.CREATOR.createFromParcel(in);
                }
            } else {
                this.mExcludeLayers = null;
            }
            this.mHintForSeamlessTransition = in.readBoolean();
        }

        public void release() {
            if (this.mExcludeLayers == null || this.mExcludeLayers.length == 0) {
                return;
            }
            for (SurfaceControl surfaceControl : this.mExcludeLayers) {
                if (surfaceControl == null) continue;
                surfaceControl.release();
            }
        }

        private long[] getNativeExcludeLayers() {
            if (this.mExcludeLayers == null || this.mExcludeLayers.length == 0) {
                return new long[0];
            }
            long[] nativeExcludeLayers = new long[this.mExcludeLayers.length];
            for (int index = 0; index < this.mExcludeLayers.length; ++index) {
                nativeExcludeLayers[index] = this.mExcludeLayers[index].mNativeObject;
            }
            return nativeExcludeLayers;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mPixelFormat);
            this.mSourceCrop.writeToParcel(dest, flags);
            dest.writeFloat(this.mFrameScaleX);
            dest.writeFloat(this.mFrameScaleY);
            dest.writeBoolean(this.mCaptureSecureLayers);
            dest.writeBoolean(this.mAllowProtected);
            dest.writeLong(this.mUid);
            dest.writeBoolean(this.mGrayscale);
            if (this.mExcludeLayers != null) {
                dest.writeInt(this.mExcludeLayers.length);
                for (SurfaceControl excludeLayer : this.mExcludeLayers) {
                    excludeLayer.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
            dest.writeBoolean(this.mHintForSeamlessTransition);
        }

        public static class Builder<T extends Builder<T>> {
            private int mPixelFormat = 1;
            private final Rect mSourceCrop = new Rect();
            private float mFrameScaleX = 1.0f;
            private float mFrameScaleY = 1.0f;
            private boolean mCaptureSecureLayers;
            private boolean mAllowProtected;
            private long mUid = -1L;
            private boolean mGrayscale;
            private SurfaceControl[] mExcludeLayers;
            private boolean mHintForSeamlessTransition;

            public CaptureArgs build() {
                return new CaptureArgs(this);
            }

            public T setPixelFormat(int pixelFormat) {
                this.mPixelFormat = pixelFormat;
                return this.getThis();
            }

            public T setSourceCrop(Rect sourceCrop) {
                if (sourceCrop == null) {
                    this.mSourceCrop.setEmpty();
                } else {
                    this.mSourceCrop.set(sourceCrop);
                }
                return this.getThis();
            }

            public T setFrameScale(float frameScale) {
                this.mFrameScaleX = frameScale;
                this.mFrameScaleY = frameScale;
                return this.getThis();
            }

            public T setFrameScale(float frameScaleX, float frameScaleY) {
                this.mFrameScaleX = frameScaleX;
                this.mFrameScaleY = frameScaleY;
                return this.getThis();
            }

            public T setCaptureSecureLayers(boolean captureSecureLayers) {
                this.mCaptureSecureLayers = captureSecureLayers;
                return this.getThis();
            }

            public T setAllowProtected(boolean allowProtected) {
                this.mAllowProtected = allowProtected;
                return this.getThis();
            }

            public T setUid(long uid) {
                this.mUid = uid;
                return this.getThis();
            }

            public T setGrayscale(boolean grayscale) {
                this.mGrayscale = grayscale;
                return this.getThis();
            }

            public T setExcludeLayers(SurfaceControl[] excludeLayers) {
                this.mExcludeLayers = excludeLayers;
                return this.getThis();
            }

            public T setHintForSeamlessTransition(boolean hintForSeamlessTransition) {
                this.mHintForSeamlessTransition = hintForSeamlessTransition;
                return this.getThis();
            }

            T getThis() {
                return (T)this;
            }
        }
    }
}

