/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.BinderProxy;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.Trace;
import android.os._Original_Build;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.view.AttachedSurfaceControl;
import android.view.SurfaceControl;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceView;
import android.view.WindowManagerGlobal;
import android.window.AddToSurfaceSyncGroupResult;
import android.window.ISurfaceSyncGroup;
import android.window.ISurfaceSyncGroupCompletedListener;
import android.window.ITransactionReadyCallback;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SurfaceSyncGroup {
    private static final String TAG = "SurfaceSyncGroup";
    private static final boolean DEBUG = false;
    private static final int MAX_COUNT = 100;
    private static final AtomicInteger sCounter = new AtomicInteger(0);
    @VisibleForTesting
    public static final int TRANSACTION_READY_TIMEOUT = 1000 * _Original_Build.HW_TIMEOUT_MULTIPLIER;
    private static Supplier<SurfaceControl.Transaction> sTransactionFactory = SurfaceControl.Transaction::new;
    private final Object mLock = new Object();
    private final String mName;
    @GuardedBy(value={"mLock"})
    private final ArraySet<ITransactionReadyCallback> mPendingSyncs = new ArraySet();
    @GuardedBy(value={"mLock"})
    private final SurfaceControl.Transaction mTransaction = sTransactionFactory.get();
    @GuardedBy(value={"mLock"})
    private boolean mSyncReady;
    @GuardedBy(value={"mLock"})
    private boolean mFinished;
    @GuardedBy(value={"mLock"})
    private Consumer<SurfaceControl.Transaction> mTransactionReadyConsumer;
    @GuardedBy(value={"mLock"})
    private ISurfaceSyncGroup mParentSyncGroup;
    @GuardedBy(value={"mLock"})
    private final ArraySet<Pair<Executor, Runnable>> mSyncCompleteCallbacks = new ArraySet();
    @GuardedBy(value={"mLock"})
    private boolean mHasWMSync;
    @GuardedBy(value={"mLock"})
    private ISurfaceSyncGroupCompletedListener mSurfaceSyncGroupCompletedListener;
    public final ISurfaceSyncGroup mISurfaceSyncGroup = new ISurfaceSyncGroupImpl();
    @GuardedBy(value={"mLock"})
    private Runnable mAddedToSyncListener;
    private final Binder mToken = new Binder();
    private static final Object sHandlerThreadLock = new Object();
    @GuardedBy(value={"sHandlerThreadLock"})
    private static HandlerThread sHandlerThread;
    private Handler mHandler;
    @GuardedBy(value={"mLock"})
    private boolean mTimeoutAdded;
    @GuardedBy(value={"mLock"})
    private boolean mTimeoutDisabled;
    private final String mTrackName;

    private static boolean isLocalBinder(IBinder binder) {
        return !(binder instanceof BinderProxy);
    }

    private static SurfaceSyncGroup getSurfaceSyncGroup(ISurfaceSyncGroup iSurfaceSyncGroup) {
        if (iSurfaceSyncGroup instanceof ISurfaceSyncGroupImpl) {
            return ((ISurfaceSyncGroupImpl)iSurfaceSyncGroup).getSurfaceSyncGroup();
        }
        return null;
    }

    public static void setTransactionFactory(Supplier<SurfaceControl.Transaction> transactionFactory) {
        sTransactionFactory = transactionFactory;
    }

    public SurfaceSyncGroup(String name) {
        this(name, transaction -> {
            if (transaction != null) {
                transaction.apply();
            }
        });
    }

    public SurfaceSyncGroup(String name, Consumer<SurfaceControl.Transaction> transactionReadyConsumer) {
        if (sCounter.get() >= 100) {
            sCounter.set(0);
        }
        this.mName = name + "#" + sCounter.getAndIncrement();
        this.mTrackName = "SurfaceSyncGroup " + name;
        this.mTransactionReadyConsumer = transaction -> {
            if (Trace.isTagEnabled(8L)) {
                Trace.instantForTrack(8L, this.mTrackName, "Final TransactionCallback with " + transaction);
            }
            Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
            transactionReadyConsumer.accept((SurfaceControl.Transaction)transaction);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSurfaceSyncGroupCompletedListener == null) {
                    this.invokeSyncCompleteCallbacks();
                }
            }
        };
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackBegin(8L, this.mTrackName, this.mName, this.hashCode());
        }
    }

    @GuardedBy(value={"mLock"})
    private void invokeSyncCompleteCallbacks() {
        this.mSyncCompleteCallbacks.forEach((Consumer<Pair<Executor, Runnable>>)((Consumer<Pair>)executorRunnablePair -> ((Executor)executorRunnablePair.first).execute((Runnable)executorRunnablePair.second)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyncCompleteCallback(Executor executor, Runnable runnable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFinished) {
                executor.execute(runnable);
                return;
            }
            this.mSyncCompleteCallbacks.add(new Pair<Executor, Runnable>(executor, runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSyncReady() {
        if (Trace.isTagEnabled(8L)) {
            Trace.instantForTrack(8L, this.mTrackName, "markSyncReady");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHasWMSync) {
                try {
                    WindowManagerGlobal.getWindowManagerService().markSurfaceSyncGroupReady(this.mToken);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mSyncReady = true;
            this.checkIfSyncIsComplete();
        }
    }

    public boolean add(SurfaceView surfaceView, Consumer<SurfaceViewFrameCallback> frameCallbackConsumer) {
        SurfaceSyncGroup surfaceSyncGroup = new SurfaceSyncGroup(surfaceView.getName());
        if (this.add(surfaceSyncGroup.mISurfaceSyncGroup, false, null)) {
            frameCallbackConsumer.accept(() -> surfaceView.syncNextFrame(transaction -> {
                surfaceSyncGroup.addTransaction((SurfaceControl.Transaction)transaction);
                surfaceSyncGroup.markSyncReady();
            }));
            return true;
        }
        return false;
    }

    public boolean add(AttachedSurfaceControl attachedSurfaceControl, Runnable runnable) {
        if (attachedSurfaceControl == null) {
            return false;
        }
        SurfaceSyncGroup surfaceSyncGroup = attachedSurfaceControl.getOrCreateSurfaceSyncGroup();
        if (surfaceSyncGroup == null) {
            return false;
        }
        return this.add(surfaceSyncGroup, runnable);
    }

    public boolean add(SurfaceControlViewHost.SurfacePackage surfacePackage, Runnable runnable) {
        ISurfaceSyncGroup surfaceSyncGroup;
        try {
            surfaceSyncGroup = surfacePackage.getRemoteInterface().getSurfaceSyncGroup();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to add SurfaceControlViewHost to SurfaceSyncGroup");
            return false;
        }
        if (surfaceSyncGroup == null) {
            Log.e(TAG, "Failed to add SurfaceControlViewHost to SurfaceSyncGroup. SCVH returned null SurfaceSyncGroup");
            return false;
        }
        return this.add(surfaceSyncGroup, false, runnable);
    }

    public boolean add(SurfaceSyncGroup surfaceSyncGroup, Runnable runnable) {
        return this.add(surfaceSyncGroup.mISurfaceSyncGroup, false, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ISurfaceSyncGroup surfaceSyncGroup, boolean parentSyncGroupMerge, Runnable runnable) {
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackBegin(8L, this.mTrackName, "addToSync token=" + this.mToken.hashCode(), this.hashCode());
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSyncReady) {
                Log.w(TAG, "Trying to add to sync when already marked as ready " + this.mName);
                if (Trace.isTagEnabled(8L)) {
                    Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
                }
                return false;
            }
        }
        if (runnable != null) {
            runnable.run();
        }
        if (SurfaceSyncGroup.isLocalBinder(surfaceSyncGroup.asBinder())) {
            boolean didAddLocalSync = this.addLocalSync(surfaceSyncGroup, parentSyncGroupMerge);
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
            }
            return didAddLocalSync;
        }
        Object didAddLocalSync = this.mLock;
        synchronized (didAddLocalSync) {
            if (!this.mHasWMSync) {
                this.mSurfaceSyncGroupCompletedListener = new ISurfaceSyncGroupCompletedListener.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSurfaceSyncGroupComplete() {
                        Object object = SurfaceSyncGroup.this.mLock;
                        synchronized (object) {
                            SurfaceSyncGroup.this.invokeSyncCompleteCallbacks();
                        }
                    }
                };
                if (!this.addSyncToWm(this.mToken, false, this.mSurfaceSyncGroupCompletedListener)) {
                    this.mSurfaceSyncGroupCompletedListener = null;
                    if (Trace.isTagEnabled(8L)) {
                        Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
                    }
                    return false;
                }
                this.mHasWMSync = true;
            }
        }
        try {
            surfaceSyncGroup.onAddedToSyncGroup(this.mToken, parentSyncGroupMerge);
        }
        catch (RemoteException e) {
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
            }
            return false;
        }
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(SurfaceControl.Transaction transaction) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFinished) {
                Log.w(TAG, "Adding transaction to a completed SurfaceSyncGroup(" + this.mName + ").  Applying immediately");
                transaction.apply();
            } else {
                this.mTransaction.merge(transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddedToSyncListener(Runnable addedToSyncListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAddedToSyncListener = addedToSyncListener;
        }
    }

    private boolean addSyncToWm(IBinder token, boolean parentSyncGroupMerge, ISurfaceSyncGroupCompletedListener surfaceSyncGroupCompletedListener) {
        try {
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackBegin(8L, this.mTrackName, "addSyncToWm=" + token.hashCode(), this.hashCode());
            }
            AddToSurfaceSyncGroupResult addToSyncGroupResult = new AddToSurfaceSyncGroupResult();
            if (!WindowManagerGlobal.getWindowManagerService().addToSurfaceSyncGroup(token, parentSyncGroupMerge, surfaceSyncGroupCompletedListener, addToSyncGroupResult)) {
                if (Trace.isTagEnabled(8L)) {
                    Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
                }
                return false;
            }
            this.setTransactionCallbackFromParent(addToSyncGroupResult.mParentSyncGroup, addToSyncGroupResult.mTransactionReadyCallback);
        }
        catch (RemoteException e) {
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
            }
            return false;
        }
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
        }
        return true;
    }

    private boolean addLocalSync(ISurfaceSyncGroup childSyncToken, boolean parentSyncGroupMerge) {
        ITransactionReadyCallback callback;
        SurfaceSyncGroup childSurfaceSyncGroup = SurfaceSyncGroup.getSurfaceSyncGroup(childSyncToken);
        if (childSurfaceSyncGroup == null) {
            Log.e(TAG, "Trying to add a local sync that's either not valid or not from the local process=" + childSyncToken);
            return false;
        }
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackBegin(8L, this.mTrackName, "addLocalSync=" + childSurfaceSyncGroup.mName, this.hashCode());
        }
        if ((callback = this.createTransactionReadyCallback(parentSyncGroupMerge)) == null) {
            return false;
        }
        childSurfaceSyncGroup.setTransactionCallbackFromParent(this.mISurfaceSyncGroup, callback);
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransactionCallbackFromParent(ISurfaceSyncGroup parentSyncGroup, ITransactionReadyCallback transactionReadyCallback) {
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackBegin(8L, this.mTrackName, "setTransactionCallbackFromParent " + this.mName + " callback=" + transactionReadyCallback.hashCode(), this.hashCode());
        }
        this.addTimeout();
        boolean finished = false;
        Runnable addedToSyncListener = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFinished) {
                finished = true;
            } else {
                if (this.mParentSyncGroup != null && this.mParentSyncGroup != parentSyncGroup) {
                    try {
                        parentSyncGroup.addToSync(this.mParentSyncGroup, true);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                Consumer<SurfaceControl.Transaction> lastCallback = this.mTransactionReadyConsumer;
                this.mParentSyncGroup = parentSyncGroup;
                this.mTransactionReadyConsumer = transaction -> {
                    if (Trace.isTagEnabled(8L)) {
                        Trace.asyncTraceForTrackBegin(8L, this.mTrackName, "Invoke transactionReadyCallback=" + transactionReadyCallback.hashCode(), this.hashCode());
                    }
                    lastCallback.accept(null);
                    try {
                        transactionReadyCallback.onTransactionReady((SurfaceControl.Transaction)transaction);
                    }
                    catch (RemoteException e) {
                        transaction.apply();
                    }
                    if (Trace.isTagEnabled(8L)) {
                        Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
                    }
                };
                addedToSyncListener = this.mAddedToSyncListener;
            }
        }
        if (finished) {
            try {
                transactionReadyCallback.onTransactionReady(null);
            }
            catch (RemoteException remoteException) {}
        } else if (addedToSyncListener != null) {
            addedToSyncListener.run();
        }
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceForTrackEnd(8L, this.mTrackName, this.hashCode());
        }
    }

    public String getName() {
        return this.mName;
    }

    @GuardedBy(value={"mLock"})
    private void checkIfSyncIsComplete() {
        if (this.mFinished) {
            this.mTransaction.apply();
            return;
        }
        if (Trace.isTagEnabled(8L)) {
            Trace.instantForTrack(8L, this.mTrackName, "checkIfSyncIsComplete mSyncReady=" + this.mSyncReady + " mPendingSyncs=" + this.mPendingSyncs.size());
        }
        if (!this.mSyncReady || !this.mPendingSyncs.isEmpty()) {
            return;
        }
        this.mTransactionReadyConsumer.accept(this.mTransaction);
        this.mFinished = true;
        if (this.mTimeoutAdded) {
            this.mHandler.removeCallbacksAndMessages(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransactionReadyCallback createTransactionReadyCallback(final boolean parentSyncGroupMerge) {
        ITransactionReadyCallback.Stub transactionReadyCallback = new ITransactionReadyCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTransactionReady(SurfaceControl.Transaction t) {
                Object object = SurfaceSyncGroup.this.mLock;
                synchronized (object) {
                    if (t != null) {
                        t.sanitize(Binder.getCallingPid(), Binder.getCallingUid());
                        if (parentSyncGroupMerge) {
                            t.merge(SurfaceSyncGroup.this.mTransaction);
                        }
                        SurfaceSyncGroup.this.mTransaction.merge(t);
                    }
                    SurfaceSyncGroup.this.mPendingSyncs.remove(this);
                    if (Trace.isTagEnabled(8L)) {
                        Trace.instantForTrack(8L, SurfaceSyncGroup.this.mTrackName, "onTransactionReady callback=" + this.hashCode());
                    }
                    SurfaceSyncGroup.this.checkIfSyncIsComplete();
                }
            }
        };
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSyncReady) {
                Log.e(TAG, "Sync " + this.mName + " was already marked as ready. No more SurfaceSyncGroups can be added.");
                return null;
            }
            this.mPendingSyncs.add(transactionReadyCallback);
            if (Trace.isTagEnabled(8L)) {
                Trace.instantForTrack(8L, this.mTrackName, "createTransactionReadyCallback mPendingSyncs=" + this.mPendingSyncs.size() + " transactionReady=" + transactionReadyCallback.hashCode());
            }
        }
        this.addTimeout();
        return transactionReadyCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleTimeout(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.mTimeoutDisabled = !enable;
            if (this.mTimeoutAdded && !enable) {
                this.mHandler.removeCallbacksAndMessages(this);
                this.mTimeoutAdded = false;
            } else if (!this.mTimeoutAdded && enable) {
                this.addTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimeout() {
        Looper looper = null;
        Object object = sHandlerThreadLock;
        synchronized (object) {
            if (sHandlerThread == null) {
                sHandlerThread = new HandlerThread("SurfaceSyncGroupTimer");
                sHandlerThread.start();
            }
            looper = sHandlerThread.getLooper();
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mTimeoutAdded || this.mTimeoutDisabled || looper == null) {
                return;
            }
            if (this.mHandler == null) {
                this.mHandler = new Handler(looper);
            }
            this.mTimeoutAdded = true;
        }
        Runnable runnable = () -> {
            Log.e(TAG, "Failed to receive transaction ready in " + TRANSACTION_READY_TIMEOUT + "ms. Marking SurfaceSyncGroup(" + this.mName + ") as ready");
            Object object = this.mLock;
            synchronized (object) {
                this.mPendingSyncs.clear();
            }
            this.markSyncReady();
        };
        this.mHandler.postDelayed(runnable, this, (long)TRANSACTION_READY_TIMEOUT);
    }

    private class ISurfaceSyncGroupImpl
    extends ISurfaceSyncGroup.Stub {
        private ISurfaceSyncGroupImpl() {
        }

        @Override
        public boolean onAddedToSyncGroup(IBinder parentSyncGroupToken, boolean parentSyncGroupMerge) {
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackBegin(8L, SurfaceSyncGroup.this.mTrackName, "onAddedToSyncGroup token=" + parentSyncGroupToken.hashCode(), this.hashCode());
            }
            boolean didAdd = SurfaceSyncGroup.this.addSyncToWm(parentSyncGroupToken, parentSyncGroupMerge, null);
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackEnd(8L, SurfaceSyncGroup.this.mTrackName, this.hashCode());
            }
            return didAdd;
        }

        @Override
        public boolean addToSync(ISurfaceSyncGroup surfaceSyncGroup, boolean parentSyncGroupMerge) {
            return SurfaceSyncGroup.this.add(surfaceSyncGroup, parentSyncGroupMerge, null);
        }

        SurfaceSyncGroup getSurfaceSyncGroup() {
            return SurfaceSyncGroup.this;
        }
    }

    public static interface SurfaceViewFrameCallback {
        public void onFrameStarted();
    }
}

