/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.WindowConfiguration;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.TaskFragmentOrganizerToken;

public class TaskFragmentCreationParams
implements Parcelable {
    private final TaskFragmentOrganizerToken mOrganizer;
    private final IBinder mFragmentToken;
    private final IBinder mOwnerToken;
    private final Rect mInitialRelativeBounds = new Rect();
    @WindowConfiguration.WindowingMode
    private final int mWindowingMode;
    private final IBinder mPairedPrimaryFragmentToken;
    private final IBinder mPairedActivityToken;
    public static final Parcelable.Creator<TaskFragmentCreationParams> CREATOR = new Parcelable.Creator<TaskFragmentCreationParams>(){

        @Override
        public TaskFragmentCreationParams createFromParcel(Parcel in) {
            return new TaskFragmentCreationParams(in);
        }

        public TaskFragmentCreationParams[] newArray(int size) {
            return new TaskFragmentCreationParams[size];
        }
    };

    private TaskFragmentCreationParams(TaskFragmentOrganizerToken organizer, IBinder fragmentToken, IBinder ownerToken, Rect initialRelativeBounds, @WindowConfiguration.WindowingMode int windowingMode, IBinder pairedPrimaryFragmentToken, IBinder pairedActivityToken) {
        if (pairedPrimaryFragmentToken != null && pairedActivityToken != null) {
            throw new IllegalArgumentException("pairedPrimaryFragmentToken and pairedActivityToken should not be set at the same time.");
        }
        this.mOrganizer = organizer;
        this.mFragmentToken = fragmentToken;
        this.mOwnerToken = ownerToken;
        this.mInitialRelativeBounds.set(initialRelativeBounds);
        this.mWindowingMode = windowingMode;
        this.mPairedPrimaryFragmentToken = pairedPrimaryFragmentToken;
        this.mPairedActivityToken = pairedActivityToken;
    }

    public TaskFragmentOrganizerToken getOrganizer() {
        return this.mOrganizer;
    }

    public IBinder getFragmentToken() {
        return this.mFragmentToken;
    }

    public IBinder getOwnerToken() {
        return this.mOwnerToken;
    }

    public Rect getInitialRelativeBounds() {
        return this.mInitialRelativeBounds;
    }

    @WindowConfiguration.WindowingMode
    public int getWindowingMode() {
        return this.mWindowingMode;
    }

    public IBinder getPairedPrimaryFragmentToken() {
        return this.mPairedPrimaryFragmentToken;
    }

    public IBinder getPairedActivityToken() {
        return this.mPairedActivityToken;
    }

    private TaskFragmentCreationParams(Parcel in) {
        this.mOrganizer = TaskFragmentOrganizerToken.CREATOR.createFromParcel(in);
        this.mFragmentToken = in.readStrongBinder();
        this.mOwnerToken = in.readStrongBinder();
        this.mInitialRelativeBounds.readFromParcel(in);
        this.mWindowingMode = in.readInt();
        this.mPairedPrimaryFragmentToken = in.readStrongBinder();
        this.mPairedActivityToken = in.readStrongBinder();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mOrganizer.writeToParcel(dest, flags);
        dest.writeStrongBinder(this.mFragmentToken);
        dest.writeStrongBinder(this.mOwnerToken);
        this.mInitialRelativeBounds.writeToParcel(dest, flags);
        dest.writeInt(this.mWindowingMode);
        dest.writeStrongBinder(this.mPairedPrimaryFragmentToken);
        dest.writeStrongBinder(this.mPairedActivityToken);
    }

    public String toString() {
        return "TaskFragmentCreationParams{ organizer=" + this.mOrganizer + " fragmentToken=" + this.mFragmentToken + " ownerToken=" + this.mOwnerToken + " initialRelativeBounds=" + this.mInitialRelativeBounds + " windowingMode=" + this.mWindowingMode + " pairedFragmentToken=" + this.mPairedPrimaryFragmentToken + " pairedActivityToken=" + this.mPairedActivityToken + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private final TaskFragmentOrganizerToken mOrganizer;
        private final IBinder mFragmentToken;
        private final IBinder mOwnerToken;
        private final Rect mInitialRelativeBounds = new Rect();
        @WindowConfiguration.WindowingMode
        private int mWindowingMode = 0;
        private IBinder mPairedPrimaryFragmentToken;
        private IBinder mPairedActivityToken;

        public Builder(TaskFragmentOrganizerToken organizer, IBinder fragmentToken, IBinder ownerToken) {
            this.mOrganizer = organizer;
            this.mFragmentToken = fragmentToken;
            this.mOwnerToken = ownerToken;
        }

        public Builder setInitialRelativeBounds(Rect bounds) {
            this.mInitialRelativeBounds.set(bounds);
            return this;
        }

        public Builder setWindowingMode(@WindowConfiguration.WindowingMode int windowingMode) {
            this.mWindowingMode = windowingMode;
            return this;
        }

        public Builder setPairedPrimaryFragmentToken(IBinder fragmentToken) {
            this.mPairedPrimaryFragmentToken = fragmentToken;
            return this;
        }

        public Builder setPairedActivityToken(IBinder activityToken) {
            this.mPairedActivityToken = activityToken;
            return this;
        }

        public TaskFragmentCreationParams build() {
            return new TaskFragmentCreationParams(this.mOrganizer, this.mFragmentToken, this.mOwnerToken, this.mInitialRelativeBounds, this.mWindowingMode, this.mPairedPrimaryFragmentToken, this.mPairedActivityToken);
        }
    }
}

