/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;

public class TaskFragmentParentInfo
implements Parcelable {
    private final Configuration mConfiguration = new Configuration();
    private final int mDisplayId;
    private final boolean mVisible;
    public static final Parcelable.Creator<TaskFragmentParentInfo> CREATOR = new Parcelable.Creator<TaskFragmentParentInfo>(){

        @Override
        public TaskFragmentParentInfo createFromParcel(Parcel in) {
            return new TaskFragmentParentInfo(in);
        }

        public TaskFragmentParentInfo[] newArray(int size) {
            return new TaskFragmentParentInfo[size];
        }
    };

    public TaskFragmentParentInfo(Configuration configuration, int displayId, boolean visible) {
        this.mConfiguration.setTo(configuration);
        this.mDisplayId = displayId;
        this.mVisible = visible;
    }

    public TaskFragmentParentInfo(TaskFragmentParentInfo info) {
        this.mConfiguration.setTo(info.getConfiguration());
        this.mDisplayId = info.mDisplayId;
        this.mVisible = info.mVisible;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public boolean equalsForTaskFragmentOrganizer(TaskFragmentParentInfo that) {
        if (that == null) {
            return false;
        }
        return this.getWindowingMode() == that.getWindowingMode() && this.mDisplayId == that.mDisplayId && this.mVisible == that.mVisible;
    }

    @WindowConfiguration.WindowingMode
    private int getWindowingMode() {
        return this.mConfiguration.windowConfiguration.getWindowingMode();
    }

    public String toString() {
        return TaskFragmentParentInfo.class.getSimpleName() + ":{config=" + this.mConfiguration + ", displayId=" + this.mDisplayId + ", visible=" + this.mVisible + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskFragmentParentInfo)) {
            return false;
        }
        TaskFragmentParentInfo that = (TaskFragmentParentInfo)obj;
        return this.mConfiguration.equals(that.mConfiguration) && this.mDisplayId == that.mDisplayId && this.mVisible == that.mVisible;
    }

    public int hashCode() {
        int result = this.mConfiguration.hashCode();
        result = 31 * result + this.mDisplayId;
        result = 31 * result + (this.mVisible ? 1 : 0);
        return result;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mConfiguration.writeToParcel(dest, flags);
        dest.writeInt(this.mDisplayId);
        dest.writeBoolean(this.mVisible);
    }

    private TaskFragmentParentInfo(Parcel in) {
        this.mConfiguration.readFromParcel(in);
        this.mDisplayId = in.readInt();
        this.mVisible = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

