/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.TaskFragmentInfo;
import android.window.TaskFragmentParentInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaskFragmentTransaction
implements Parcelable {
    private final IBinder mTransactionToken;
    private final ArrayList<Change> mChanges = new ArrayList();
    public static final Parcelable.Creator<TaskFragmentTransaction> CREATOR = new Parcelable.Creator<TaskFragmentTransaction>(){

        @Override
        public TaskFragmentTransaction createFromParcel(Parcel in) {
            return new TaskFragmentTransaction(in);
        }

        public TaskFragmentTransaction[] newArray(int size) {
            return new TaskFragmentTransaction[size];
        }
    };
    public static final int TYPE_TASK_FRAGMENT_APPEARED = 1;
    public static final int TYPE_TASK_FRAGMENT_INFO_CHANGED = 2;
    public static final int TYPE_TASK_FRAGMENT_VANISHED = 3;
    public static final int TYPE_TASK_FRAGMENT_PARENT_INFO_CHANGED = 4;
    public static final int TYPE_TASK_FRAGMENT_ERROR = 5;
    public static final int TYPE_ACTIVITY_REPARENTED_TO_TASK = 6;

    public TaskFragmentTransaction() {
        this.mTransactionToken = new Binder();
    }

    private TaskFragmentTransaction(Parcel in) {
        this.mTransactionToken = in.readStrongBinder();
        in.readTypedList(this.mChanges, Change.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.mTransactionToken);
        dest.writeTypedList(this.mChanges);
    }

    public IBinder getTransactionToken() {
        return this.mTransactionToken;
    }

    public void addChange(Change change) {
        if (change != null) {
            this.mChanges.add(change);
        }
    }

    public boolean isEmpty() {
        return this.mChanges.isEmpty();
    }

    public List<Change> getChanges() {
        return this.mChanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskFragmentTransaction{token=");
        sb.append(this.mTransactionToken);
        sb.append(" changes=[");
        for (int i = 0; i < this.mChanges.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.mChanges.get(i));
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Change
    implements Parcelable {
        private final int mType;
        private IBinder mTaskFragmentToken;
        private TaskFragmentInfo mTaskFragmentInfo;
        private int mTaskId;
        private IBinder mErrorCallbackToken;
        private Bundle mErrorBundle;
        private Intent mActivityIntent;
        private IBinder mActivityToken;
        private TaskFragmentParentInfo mTaskFragmentParentInfo;
        public static final Parcelable.Creator<Change> CREATOR = new Parcelable.Creator<Change>(){

            @Override
            public Change createFromParcel(Parcel in) {
                return new Change(in);
            }

            public Change[] newArray(int size) {
                return new Change[size];
            }
        };

        public Change(int type) {
            this.mType = type;
        }

        private Change(Parcel in) {
            this.mType = in.readInt();
            this.mTaskFragmentToken = in.readStrongBinder();
            this.mTaskFragmentInfo = in.readTypedObject(TaskFragmentInfo.CREATOR);
            this.mTaskId = in.readInt();
            this.mErrorCallbackToken = in.readStrongBinder();
            this.mErrorBundle = in.readBundle(TaskFragmentTransaction.class.getClassLoader());
            this.mActivityIntent = in.readTypedObject(Intent.CREATOR);
            this.mActivityToken = in.readStrongBinder();
            this.mTaskFragmentParentInfo = in.readTypedObject(TaskFragmentParentInfo.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeStrongBinder(this.mTaskFragmentToken);
            dest.writeTypedObject(this.mTaskFragmentInfo, flags);
            dest.writeInt(this.mTaskId);
            dest.writeStrongBinder(this.mErrorCallbackToken);
            dest.writeBundle(this.mErrorBundle);
            dest.writeTypedObject(this.mActivityIntent, flags);
            dest.writeStrongBinder(this.mActivityToken);
            dest.writeTypedObject(this.mTaskFragmentParentInfo, flags);
        }

        public Change setTaskFragmentToken(IBinder taskFragmentToken) {
            this.mTaskFragmentToken = Objects.requireNonNull(taskFragmentToken);
            return this;
        }

        public Change setTaskFragmentInfo(TaskFragmentInfo info) {
            this.mTaskFragmentInfo = Objects.requireNonNull(info);
            return this;
        }

        public Change setTaskId(int taskId) {
            this.mTaskId = taskId;
            return this;
        }

        public Change setTaskConfiguration(Configuration configuration) {
            return this;
        }

        public Change setErrorCallbackToken(IBinder errorCallbackToken) {
            this.mErrorCallbackToken = errorCallbackToken;
            return this;
        }

        public Change setErrorBundle(Bundle errorBundle) {
            this.mErrorBundle = Objects.requireNonNull(errorBundle);
            return this;
        }

        public Change setActivityIntent(Intent intent) {
            this.mActivityIntent = Objects.requireNonNull(intent);
            return this;
        }

        public Change setActivityToken(IBinder activityToken) {
            this.mActivityToken = Objects.requireNonNull(activityToken);
            return this;
        }

        public Change setTaskFragmentParentInfo(TaskFragmentParentInfo info) {
            this.mTaskFragmentParentInfo = Objects.requireNonNull(info);
            return this;
        }

        public int getType() {
            return this.mType;
        }

        public IBinder getTaskFragmentToken() {
            return this.mTaskFragmentToken;
        }

        public TaskFragmentInfo getTaskFragmentInfo() {
            return this.mTaskFragmentInfo;
        }

        public int getTaskId() {
            return this.mTaskId;
        }

        public Configuration getTaskConfiguration() {
            return this.mTaskFragmentParentInfo.getConfiguration();
        }

        public IBinder getErrorCallbackToken() {
            return this.mErrorCallbackToken;
        }

        public Bundle getErrorBundle() {
            return this.mErrorBundle != null ? this.mErrorBundle : Bundle.EMPTY;
        }

        @SuppressLint(value={"IntentBuilderName"})
        public Intent getActivityIntent() {
            return this.mActivityIntent;
        }

        public IBinder getActivityToken() {
            return this.mActivityToken;
        }

        public TaskFragmentParentInfo getTaskFragmentParentInfo() {
            return this.mTaskFragmentParentInfo;
        }

        public String toString() {
            return "Change{ type=" + this.mType + " }";
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ChangeType {
    }
}

