/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.window.WindowContainerToken;
import java.util.ArrayList;
import java.util.List;

public class TransitionInfo
implements Parcelable {
    private static final String TAG = "TransitionInfo";
    public static final int FLAG_NONE = 0;
    public static final int FLAG_SHOW_WALLPAPER = 1;
    public static final int FLAG_IS_WALLPAPER = 2;
    public static final int FLAG_TRANSLUCENT = 4;
    public static final int FLAG_STARTING_WINDOW_TRANSFER_RECIPIENT = 8;
    public static final int FLAG_IS_VOICE_INTERACTION = 16;
    public static final int FLAG_IS_DISPLAY = 32;
    public static final int FLAG_DISPLAY_HAS_ALERT_WINDOWS = 128;
    public static final int FLAG_IS_INPUT_METHOD = 256;
    public static final int FLAG_IN_TASK_WITH_EMBEDDED_ACTIVITY = 512;
    public static final int FLAG_FILLS_TASK = 1024;
    public static final int FLAG_WILL_IME_SHOWN = 2048;
    public static final int FLAG_CROSS_PROFILE_OWNER_THUMBNAIL = 4096;
    public static final int FLAG_CROSS_PROFILE_WORK_THUMBNAIL = 8192;
    public static final int FLAG_IS_BEHIND_STARTING_WINDOW = 16384;
    public static final int FLAG_IS_OCCLUDED = 32768;
    public static final int FLAG_IS_SYSTEM_WINDOW = 65536;
    public static final int FLAG_BACK_GESTURE_ANIMATED = 131072;
    public static final int FLAG_NO_ANIMATION = 262144;
    public static final int FLAG_TASK_LAUNCHING_BEHIND = 524288;
    public static final int FLAG_MOVED_TO_TOP = 0x100000;
    public static final int FLAG_SYNC = 0x200000;
    public static final int FLAG_FIRST_CUSTOM = 0x400000;
    public static final int FLAGS_IS_NON_APP_WINDOW = 65794;
    private final int mType;
    private int mFlags;
    private int mTrack = 0;
    private final ArrayList<Change> mChanges = new ArrayList();
    private final ArrayList<Root> mRoots = new ArrayList();
    private AnimationOptions mOptions;
    private int mDebugId = -1;
    public static final Parcelable.Creator<TransitionInfo> CREATOR = new Parcelable.Creator<TransitionInfo>(){

        @Override
        public TransitionInfo createFromParcel(Parcel in) {
            return new TransitionInfo(in);
        }

        public TransitionInfo[] newArray(int size) {
            return new TransitionInfo[size];
        }
    };

    public TransitionInfo(int type, int flags) {
        this.mType = type;
        this.mFlags = flags;
    }

    private TransitionInfo(Parcel in) {
        this.mType = in.readInt();
        this.mFlags = in.readInt();
        in.readTypedList(this.mChanges, Change.CREATOR);
        in.readTypedList(this.mRoots, Root.CREATOR);
        this.mOptions = in.readTypedObject(AnimationOptions.CREATOR);
        this.mDebugId = in.readInt();
        this.mTrack = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mFlags);
        dest.writeTypedList(this.mChanges);
        dest.writeTypedList(this.mRoots, flags);
        dest.writeTypedObject(this.mOptions, flags);
        dest.writeInt(this.mDebugId);
        dest.writeInt(this.mTrack);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void addRootLeash(int displayId, SurfaceControl leash, int offsetLeft, int offsetTop) {
        this.mRoots.add(new Root(displayId, leash, offsetLeft, offsetTop));
    }

    public void addRoot(Root other) {
        this.mRoots.add(other);
    }

    public void setAnimationOptions(AnimationOptions options) {
        this.mOptions = options;
    }

    public int getType() {
        return this.mType;
    }

    public void setFlags(int flags) {
        this.mFlags = flags;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int getRootCount() {
        return this.mRoots.size();
    }

    public Root getRoot(int idx) {
        return this.mRoots.get(idx);
    }

    public int findRootIndex(int displayId) {
        for (int i = 0; i < this.mRoots.size(); ++i) {
            if (this.mRoots.get((int)i).mDisplayId != displayId) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public SurfaceControl getRootLeash() {
        if (this.mRoots.isEmpty()) {
            throw new IllegalStateException("Trying to get a root leash from a no-op transition.");
        }
        if (this.mRoots.size() > 1) {
            Log.e(TAG, "Assuming one animation root when there are more.", new Throwable());
        }
        return this.mRoots.get((int)0).mLeash;
    }

    public AnimationOptions getAnimationOptions() {
        return this.mOptions;
    }

    public List<Change> getChanges() {
        return this.mChanges;
    }

    public Change getChange(WindowContainerToken token) {
        for (int i = this.mChanges.size() - 1; i >= 0; --i) {
            if (!token.equals(this.mChanges.get((int)i).mContainer)) continue;
            return this.mChanges.get(i);
        }
        return null;
    }

    public void addChange(Change change) {
        this.mChanges.add(change);
    }

    public boolean isKeyguardGoingAway() {
        return (this.mFlags & 0x100) != 0;
    }

    public int getTrack() {
        return this.mTrack;
    }

    public void setTrack(int track) {
        this.mTrack = track;
    }

    public void setDebugId(int id2) {
        this.mDebugId = id2;
    }

    public int getDebugId() {
        return this.mDebugId;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("{id=").append(this.mDebugId).append(" t=").append(WindowManager.transitTypeToString(this.mType)).append(" f=0x").append(Integer.toHexString(this.mFlags)).append(" trk=").append(this.mTrack).append(" r=[");
        for (i = 0; i < this.mRoots.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.mRoots.get((int)i).mDisplayId).append("@").append(this.mRoots.get((int)i).mOffset);
        }
        sb.append("] c=[");
        for (i = 0; i < this.mChanges.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.mChanges.get(i));
        }
        sb.append("]}");
        return sb.toString();
    }

    public static String modeToString(@TransitionMode int mode) {
        switch (mode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "OPEN";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "TO_FRONT";
            }
            case 4: {
                return "TO_BACK";
            }
            case 6: {
                return "CHANGE";
            }
        }
        return "<unknown:" + mode + ">";
    }

    public static String flagsToString(@ChangeFlags int flags) {
        if (flags == 0) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("SHOW_WALLPAPER");
        }
        if ((flags & 2) != 0) {
            sb.append("IS_WALLPAPER");
        }
        if ((flags & 0x100) != 0) {
            sb.append("IS_INPUT_METHOD");
        }
        if ((flags & 4) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("TRANSLUCENT");
        }
        if ((flags & 8) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("STARTING_WINDOW_TRANSFER");
        }
        if ((flags & 0x10) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("IS_VOICE_INTERACTION");
        }
        if ((flags & 0x20) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("IS_DISPLAY");
        }
        if ((flags & 0x80) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("DISPLAY_HAS_ALERT_WINDOWS");
        }
        if ((flags & 0x200) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("IN_TASK_WITH_EMBEDDED_ACTIVITY");
        }
        if ((flags & 0x400) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("FILLS_TASK");
        }
        if ((flags & 0x4000) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("IS_BEHIND_STARTING_WINDOW");
        }
        if ((flags & 0x8000) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("IS_OCCLUDED");
        }
        if ((flags & 0x10000) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("FLAG_IS_SYSTEM_WINDOW");
        }
        if ((flags & 0x20000) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("FLAG_BACK_GESTURE_ANIMATED");
        }
        if ((flags & 0x40000) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("NO_ANIMATION");
        }
        if ((flags & 0x80000) != 0) {
            sb.append((sb.length() == 0 ? "" : "|") + "TASK_LAUNCHING_BEHIND");
        }
        if ((flags & 0x200000) != 0) {
            sb.append((sb.length() == 0 ? "" : "|") + "SYNC");
        }
        if ((flags & 0x400000) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("FIRST_CUSTOM");
        }
        if ((flags & 0x100000) != 0) {
            sb.append(sb.length() == 0 ? "" : "|").append("MOVE_TO_TOP");
        }
        return sb.toString();
    }

    public static boolean isIndependent(Change change, TransitionInfo info) {
        if (change.getParent() == null) {
            return true;
        }
        if (change.getMode() == 6) {
            return false;
        }
        Change parentChg = info.getChange(change.getParent());
        while (parentChg != null) {
            if (parentChg.getMode() != 6) {
                return false;
            }
            if (parentChg.getParent() == null) {
                return true;
            }
            parentChg = info.getChange(parentChg.getParent());
        }
        return false;
    }

    public void releaseAnimSurfaces() {
        int i;
        for (i = this.mChanges.size() - 1; i >= 0; --i) {
            Change c = this.mChanges.get(i);
            if (c.mSnapshot == null) continue;
            c.mSnapshot.release();
            c.mSnapshot = null;
        }
        for (i = 0; i < this.mRoots.size(); ++i) {
            this.mRoots.get((int)i).mLeash.release();
        }
    }

    public void releaseAllSurfaces() {
        this.releaseAnimSurfaces();
        for (int i = this.mChanges.size() - 1; i >= 0; --i) {
            this.mChanges.get(i).getLeash().release();
        }
    }

    public void setUnreleasedWarningCallSiteForAllSurfaces(String callsite) {
        for (int i = this.mChanges.size() - 1; i >= 0; --i) {
            this.mChanges.get(i).getLeash().setUnreleasedWarningCallSite(callsite);
        }
    }

    public TransitionInfo localRemoteCopy() {
        int i;
        TransitionInfo out = new TransitionInfo(this.mType, this.mFlags);
        out.mTrack = this.mTrack;
        out.mDebugId = this.mDebugId;
        for (i = 0; i < this.mChanges.size(); ++i) {
            out.mChanges.add(this.mChanges.get(i).localRemoteCopy());
        }
        for (i = 0; i < this.mRoots.size(); ++i) {
            out.mRoots.add(this.mRoots.get(i).localRemoteCopy());
        }
        out.mOptions = this.mOptions;
        return out;
    }

    public static class Change
    implements Parcelable {
        private final WindowContainerToken mContainer;
        private WindowContainerToken mParent;
        private WindowContainerToken mLastParent;
        private final SurfaceControl mLeash;
        @TransitionMode
        private int mMode = 0;
        @ChangeFlags
        private int mFlags = 0;
        private final Rect mStartAbsBounds = new Rect();
        private final Rect mEndAbsBounds = new Rect();
        private final Point mEndRelOffset = new Point();
        private ActivityManager.RunningTaskInfo mTaskInfo = null;
        private boolean mAllowEnterPip;
        private int mStartDisplayId = -1;
        private int mEndDisplayId = -1;
        private int mStartRotation = -1;
        private int mEndRotation = -1;
        private int mEndFixedRotation = -1;
        private int mRotationAnimation = -1;
        private int mBackgroundColor;
        private SurfaceControl mSnapshot = null;
        private float mSnapshotLuma;
        public static final Parcelable.Creator<Change> CREATOR = new Parcelable.Creator<Change>(){

            @Override
            public Change createFromParcel(Parcel in) {
                return new Change(in);
            }

            public Change[] newArray(int size) {
                return new Change[size];
            }
        };

        public Change(WindowContainerToken container, SurfaceControl leash) {
            this.mContainer = container;
            this.mLeash = leash;
        }

        private Change(Parcel in) {
            this.mContainer = in.readTypedObject(WindowContainerToken.CREATOR);
            this.mParent = in.readTypedObject(WindowContainerToken.CREATOR);
            this.mLastParent = in.readTypedObject(WindowContainerToken.CREATOR);
            this.mLeash = new SurfaceControl();
            this.mLeash.readFromParcel(in);
            this.mMode = in.readInt();
            this.mFlags = in.readInt();
            this.mStartAbsBounds.readFromParcel(in);
            this.mEndAbsBounds.readFromParcel(in);
            this.mEndRelOffset.readFromParcel(in);
            this.mTaskInfo = in.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
            this.mAllowEnterPip = in.readBoolean();
            this.mStartDisplayId = in.readInt();
            this.mEndDisplayId = in.readInt();
            this.mStartRotation = in.readInt();
            this.mEndRotation = in.readInt();
            this.mEndFixedRotation = in.readInt();
            this.mRotationAnimation = in.readInt();
            this.mBackgroundColor = in.readInt();
            this.mSnapshot = in.readTypedObject(SurfaceControl.CREATOR);
            this.mSnapshotLuma = in.readFloat();
        }

        private Change localRemoteCopy() {
            Change out = new Change(this.mContainer, new SurfaceControl(this.mLeash, "localRemote"));
            out.mParent = this.mParent;
            out.mLastParent = this.mLastParent;
            out.mMode = this.mMode;
            out.mFlags = this.mFlags;
            out.mStartAbsBounds.set(this.mStartAbsBounds);
            out.mEndAbsBounds.set(this.mEndAbsBounds);
            out.mEndRelOffset.set(this.mEndRelOffset);
            out.mTaskInfo = this.mTaskInfo;
            out.mAllowEnterPip = this.mAllowEnterPip;
            out.mStartDisplayId = this.mStartDisplayId;
            out.mEndDisplayId = this.mEndDisplayId;
            out.mStartRotation = this.mStartRotation;
            out.mEndRotation = this.mEndRotation;
            out.mEndFixedRotation = this.mEndFixedRotation;
            out.mRotationAnimation = this.mRotationAnimation;
            out.mBackgroundColor = this.mBackgroundColor;
            out.mSnapshot = this.mSnapshot != null ? new SurfaceControl(this.mSnapshot, "localRemote") : null;
            out.mSnapshotLuma = this.mSnapshotLuma;
            return out;
        }

        public void setParent(WindowContainerToken parent) {
            this.mParent = parent;
        }

        public void setLastParent(WindowContainerToken lastParent) {
            this.mLastParent = lastParent;
        }

        public void setMode(@TransitionMode int mode) {
            this.mMode = mode;
        }

        public void setFlags(@ChangeFlags int flags) {
            this.mFlags = flags;
        }

        public void setStartAbsBounds(Rect rect) {
            this.mStartAbsBounds.set(rect);
        }

        public void setEndAbsBounds(Rect rect) {
            this.mEndAbsBounds.set(rect);
        }

        public void setEndRelOffset(int left, int top) {
            this.mEndRelOffset.set(left, top);
        }

        public void setTaskInfo(ActivityManager.RunningTaskInfo taskInfo) {
            this.mTaskInfo = taskInfo;
        }

        public void setAllowEnterPip(boolean allowEnterPip) {
            this.mAllowEnterPip = allowEnterPip;
        }

        public void setDisplayId(int start, int end) {
            this.mStartDisplayId = start;
            this.mEndDisplayId = end;
        }

        public void setRotation(int start, int end) {
            this.mStartRotation = start;
            this.mEndRotation = end;
        }

        public void setEndFixedRotation(int endFixedRotation) {
            this.mEndFixedRotation = endFixedRotation;
        }

        public void setRotationAnimation(int anim2) {
            this.mRotationAnimation = anim2;
        }

        public void setBackgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
        }

        public void setSnapshot(SurfaceControl snapshot, float luma) {
            this.mSnapshot = snapshot;
            this.mSnapshotLuma = luma;
        }

        public WindowContainerToken getContainer() {
            return this.mContainer;
        }

        public WindowContainerToken getParent() {
            return this.mParent;
        }

        public WindowContainerToken getLastParent() {
            return this.mLastParent;
        }

        @TransitionMode
        public int getMode() {
            return this.mMode;
        }

        @ChangeFlags
        public int getFlags() {
            return this.mFlags;
        }

        public boolean hasFlags(@ChangeFlags int flags) {
            return (this.mFlags & flags) != 0;
        }

        public boolean hasAllFlags(@ChangeFlags int flags) {
            return (this.mFlags & flags) == flags;
        }

        public Rect getStartAbsBounds() {
            return this.mStartAbsBounds;
        }

        public Rect getEndAbsBounds() {
            return this.mEndAbsBounds;
        }

        public Point getEndRelOffset() {
            return this.mEndRelOffset;
        }

        public SurfaceControl getLeash() {
            return this.mLeash;
        }

        public ActivityManager.RunningTaskInfo getTaskInfo() {
            return this.mTaskInfo;
        }

        public boolean getAllowEnterPip() {
            return this.mAllowEnterPip;
        }

        public int getStartDisplayId() {
            return this.mStartDisplayId;
        }

        public int getEndDisplayId() {
            return this.mEndDisplayId;
        }

        public int getStartRotation() {
            return this.mStartRotation;
        }

        public int getEndRotation() {
            return this.mEndRotation;
        }

        public int getEndFixedRotation() {
            return this.mEndFixedRotation;
        }

        public int getRotationAnimation() {
            return this.mRotationAnimation;
        }

        public int getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public SurfaceControl getSnapshot() {
            return this.mSnapshot;
        }

        public float getSnapshotLuma() {
            return this.mSnapshotLuma;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedObject(this.mContainer, flags);
            dest.writeTypedObject(this.mParent, flags);
            dest.writeTypedObject(this.mLastParent, flags);
            this.mLeash.writeToParcel(dest, flags);
            dest.writeInt(this.mMode);
            dest.writeInt(this.mFlags);
            this.mStartAbsBounds.writeToParcel(dest, flags);
            this.mEndAbsBounds.writeToParcel(dest, flags);
            this.mEndRelOffset.writeToParcel(dest, flags);
            dest.writeTypedObject(this.mTaskInfo, flags);
            dest.writeBoolean(this.mAllowEnterPip);
            dest.writeInt(this.mStartDisplayId);
            dest.writeInt(this.mEndDisplayId);
            dest.writeInt(this.mStartRotation);
            dest.writeInt(this.mEndRotation);
            dest.writeInt(this.mEndFixedRotation);
            dest.writeInt(this.mRotationAnimation);
            dest.writeInt(this.mBackgroundColor);
            dest.writeTypedObject(this.mSnapshot, flags);
            dest.writeFloat(this.mSnapshotLuma);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            sb.append(this.mContainer);
            sb.append(" m=");
            sb.append(TransitionInfo.modeToString(this.mMode));
            sb.append(" f=");
            sb.append(TransitionInfo.flagsToString(this.mFlags));
            if (this.mParent != null) {
                sb.append(" p=");
                sb.append(this.mParent);
            }
            if (this.mLeash != null) {
                sb.append(" leash=");
                sb.append(this.mLeash);
            }
            sb.append(" sb=");
            sb.append(this.mStartAbsBounds);
            sb.append(" eb=");
            sb.append(this.mEndAbsBounds);
            if (this.mEndRelOffset.x != 0 || this.mEndRelOffset.y != 0) {
                sb.append(" eo=");
                sb.append(this.mEndRelOffset);
            }
            sb.append(" d=");
            if (this.mStartDisplayId != this.mEndDisplayId) {
                sb.append(this.mStartDisplayId).append("->");
            }
            sb.append(this.mEndDisplayId);
            if (this.mStartRotation != this.mEndRotation) {
                sb.append(" r=");
                sb.append(this.mStartRotation);
                sb.append("->");
                sb.append(this.mEndRotation);
                sb.append(':');
                sb.append(this.mRotationAnimation);
            }
            if (this.mEndFixedRotation != -1) {
                sb.append(" endFixedRotation=");
                sb.append(this.mEndFixedRotation);
            }
            if (this.mSnapshot != null) {
                sb.append(" snapshot=");
                sb.append(this.mSnapshot);
            }
            if (this.mLastParent != null) {
                sb.append(" lastParent=");
                sb.append(this.mLastParent);
            }
            sb.append('}');
            return sb.toString();
        }
    }

    public static class Root
    implements Parcelable {
        private final int mDisplayId;
        private final SurfaceControl mLeash;
        private final Point mOffset = new Point();
        public static final Parcelable.Creator<Root> CREATOR = new Parcelable.Creator<Root>(){

            @Override
            public Root createFromParcel(Parcel in) {
                return new Root(in);
            }

            public Root[] newArray(int size) {
                return new Root[size];
            }
        };

        public Root(int displayId, SurfaceControl leash, int offsetLeft, int offsetTop) {
            this.mDisplayId = displayId;
            this.mLeash = leash;
            this.mOffset.set(offsetLeft, offsetTop);
        }

        private Root(Parcel in) {
            this.mDisplayId = in.readInt();
            this.mLeash = new SurfaceControl();
            this.mLeash.readFromParcel(in);
            this.mLeash.setUnreleasedWarningCallSite("TransitionInfo.Root");
            this.mOffset.readFromParcel(in);
        }

        private Root localRemoteCopy() {
            return new Root(this.mDisplayId, new SurfaceControl(this.mLeash, "localRemote"), this.mOffset.x, this.mOffset.y);
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public SurfaceControl getLeash() {
            return this.mLeash;
        }

        public Point getOffset() {
            return this.mOffset;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mDisplayId);
            this.mLeash.writeToParcel(dest, flags);
            this.mOffset.writeToParcel(dest, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return this.mDisplayId + "@" + this.mOffset + ":" + this.mLeash;
        }
    }

    public static class AnimationOptions
    implements Parcelable {
        private int mType;
        private int mEnterResId;
        private int mExitResId;
        private boolean mOverrideTaskTransition;
        private String mPackageName;
        private final Rect mTransitionBounds = new Rect();
        private HardwareBuffer mThumbnail;
        private int mAnimations;
        private int mBackgroundColor;
        private CustomActivityTransition mCustomActivityOpenTransition;
        private CustomActivityTransition mCustomActivityCloseTransition;
        public static final Parcelable.Creator<AnimationOptions> CREATOR = new Parcelable.Creator<AnimationOptions>(){

            @Override
            public AnimationOptions createFromParcel(Parcel in) {
                return new AnimationOptions(in);
            }

            public AnimationOptions[] newArray(int size) {
                return new AnimationOptions[size];
            }
        };

        private AnimationOptions(int type) {
            this.mType = type;
        }

        public AnimationOptions(Parcel in) {
            this.mType = in.readInt();
            this.mEnterResId = in.readInt();
            this.mExitResId = in.readInt();
            this.mBackgroundColor = in.readInt();
            this.mOverrideTaskTransition = in.readBoolean();
            this.mPackageName = in.readString();
            this.mTransitionBounds.readFromParcel(in);
            this.mThumbnail = in.readTypedObject(HardwareBuffer.CREATOR);
            this.mAnimations = in.readInt();
            this.mCustomActivityOpenTransition = in.readTypedObject(CustomActivityTransition.CREATOR);
            this.mCustomActivityCloseTransition = in.readTypedObject(CustomActivityTransition.CREATOR);
        }

        public static AnimationOptions makeCommonAnimOptions(String packageName) {
            AnimationOptions options = new AnimationOptions(14);
            options.mPackageName = packageName;
            return options;
        }

        public static AnimationOptions makeAnimOptionsFromLayoutParameters(WindowManager.LayoutParams lp) {
            AnimationOptions options = new AnimationOptions(14);
            options.mPackageName = lp.packageName;
            options.mAnimations = lp.windowAnimations;
            return options;
        }

        public void addOptionsFromLayoutParameters(WindowManager.LayoutParams lp) {
            this.mAnimations = lp.windowAnimations;
        }

        public void addCustomActivityTransition(boolean isOpen, int enterResId, int exitResId, int backgroundColor) {
            CustomActivityTransition customTransition;
            CustomActivityTransition customActivityTransition = customTransition = isOpen ? this.mCustomActivityOpenTransition : this.mCustomActivityCloseTransition;
            if (customTransition == null) {
                customTransition = new CustomActivityTransition();
                if (isOpen) {
                    this.mCustomActivityOpenTransition = customTransition;
                } else {
                    this.mCustomActivityCloseTransition = customTransition;
                }
            }
            customTransition.addCustomActivityTransition(enterResId, exitResId, backgroundColor);
        }

        public static AnimationOptions makeCustomAnimOptions(String packageName, int enterResId, int exitResId, int backgroundColor, boolean overrideTaskTransition) {
            AnimationOptions options = new AnimationOptions(1);
            options.mPackageName = packageName;
            options.mEnterResId = enterResId;
            options.mExitResId = exitResId;
            options.mBackgroundColor = backgroundColor;
            options.mOverrideTaskTransition = overrideTaskTransition;
            return options;
        }

        public static AnimationOptions makeClipRevealAnimOptions(int startX, int startY, int width, int height) {
            AnimationOptions options = new AnimationOptions(11);
            options.mTransitionBounds.set(startX, startY, startX + width, startY + height);
            return options;
        }

        public static AnimationOptions makeScaleUpAnimOptions(int startX, int startY, int width, int height) {
            AnimationOptions options = new AnimationOptions(2);
            options.mTransitionBounds.set(startX, startY, startX + width, startY + height);
            return options;
        }

        public static AnimationOptions makeThumbnailAnimOptions(HardwareBuffer srcThumb, int startX, int startY, boolean scaleUp) {
            AnimationOptions options = new AnimationOptions(scaleUp ? 3 : 4);
            options.mTransitionBounds.set(startX, startY, startX, startY);
            options.mThumbnail = srcThumb;
            return options;
        }

        public static AnimationOptions makeCrossProfileAnimOptions() {
            AnimationOptions options = new AnimationOptions(12);
            return options;
        }

        public static AnimationOptions makeSceneTransitionAnimOptions() {
            AnimationOptions options = new AnimationOptions(5);
            return options;
        }

        public int getType() {
            return this.mType;
        }

        public int getEnterResId() {
            return this.mEnterResId;
        }

        public int getExitResId() {
            return this.mExitResId;
        }

        public int getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public boolean getOverrideTaskTransition() {
            return this.mOverrideTaskTransition;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public Rect getTransitionBounds() {
            return this.mTransitionBounds;
        }

        public HardwareBuffer getThumbnail() {
            return this.mThumbnail;
        }

        public int getAnimations() {
            return this.mAnimations;
        }

        public CustomActivityTransition getCustomActivityTransition(boolean open) {
            return open ? this.mCustomActivityOpenTransition : this.mCustomActivityCloseTransition;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeInt(this.mEnterResId);
            dest.writeInt(this.mExitResId);
            dest.writeInt(this.mBackgroundColor);
            dest.writeBoolean(this.mOverrideTaskTransition);
            dest.writeString(this.mPackageName);
            this.mTransitionBounds.writeToParcel(dest, flags);
            dest.writeTypedObject(this.mThumbnail, flags);
            dest.writeInt(this.mAnimations);
            dest.writeTypedObject(this.mCustomActivityOpenTransition, flags);
            dest.writeTypedObject(this.mCustomActivityCloseTransition, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        private static String typeToString(int mode) {
            switch (mode) {
                case 1: {
                    return "ANIM_CUSTOM";
                }
                case 11: {
                    return "ANIM_CLIP_REVEAL";
                }
                case 2: {
                    return "ANIM_SCALE_UP";
                }
                case 3: {
                    return "ANIM_THUMBNAIL_SCALE_UP";
                }
                case 4: {
                    return "ANIM_THUMBNAIL_SCALE_DOWN";
                }
                case 12: {
                    return "ANIM_OPEN_CROSS_PROFILE_APPS";
                }
            }
            return "<unknown:" + mode + ">";
        }

        public String toString() {
            return "{ AnimationOptions type= " + AnimationOptions.typeToString(this.mType) + " package=" + this.mPackageName + " override=" + this.mOverrideTaskTransition + " b=" + this.mTransitionBounds + "}";
        }

        public static class CustomActivityTransition
        implements Parcelable {
            private int mCustomEnterResId;
            private int mCustomExitResId;
            private int mCustomBackgroundColor;
            public static final Parcelable.Creator<CustomActivityTransition> CREATOR = new Parcelable.Creator<CustomActivityTransition>(){

                @Override
                public CustomActivityTransition createFromParcel(Parcel in) {
                    return new CustomActivityTransition(in);
                }

                public CustomActivityTransition[] newArray(int size) {
                    return new CustomActivityTransition[size];
                }
            };

            public int getCustomEnterResId() {
                return this.mCustomEnterResId;
            }

            public int getCustomExitResId() {
                return this.mCustomExitResId;
            }

            public int getCustomBackgroundColor() {
                return this.mCustomBackgroundColor;
            }

            CustomActivityTransition() {
            }

            CustomActivityTransition(Parcel in) {
                this.mCustomEnterResId = in.readInt();
                this.mCustomExitResId = in.readInt();
                this.mCustomBackgroundColor = in.readInt();
            }

            public void addCustomActivityTransition(int enterResId, int exitResId, int backgroundColor) {
                this.mCustomEnterResId = enterResId;
                this.mCustomExitResId = exitResId;
                this.mCustomBackgroundColor = backgroundColor;
            }

            @Override
            public int describeContents() {
                return 0;
            }

            @Override
            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.mCustomEnterResId);
                dest.writeInt(this.mCustomExitResId);
                dest.writeInt(this.mCustomBackgroundColor);
            }
        }
    }

    public static @interface ChangeFlags {
    }

    public static @interface TransitionMode {
    }
}

