/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ResourcesManager;
import android.app.WindowConfiguration;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.DisplayInfo;
import android.view.InsetsState;
import android.view.WindowInsets;
import android.view.WindowManagerGlobal;
import android.view.WindowMetrics;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class WindowMetricsController {
    private final Context mContext;

    public WindowMetricsController(Context context) {
        this.mContext = context;
    }

    public WindowMetrics getCurrentWindowMetrics() {
        return this.getWindowMetricsInternal(false);
    }

    public WindowMetrics getMaximumWindowMetrics() {
        return this.getWindowMetricsInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowMetrics getWindowMetricsInternal(boolean isMaximum) {
        int windowingMode;
        boolean isScreenRound;
        float density;
        Rect bounds;
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            Configuration config = this.mContext.getResources().getConfiguration();
            WindowConfiguration winConfig = config.windowConfiguration;
            bounds = isMaximum ? winConfig.getMaxBounds() : winConfig.getBounds();
            density = (float)config.densityDpi * 0.00625f;
            isScreenRound = config.isScreenRound();
            windowingMode = winConfig.getWindowingMode();
        }
        IBinder token = Context.getToken(this.mContext);
        Supplier<WindowInsets> insetsSupplier = () -> WindowMetricsController.getWindowInsetsFromServerForDisplay(this.mContext.getDisplayId(), token, bounds, isScreenRound, windowingMode);
        return new WindowMetrics(new Rect(bounds), insetsSupplier, density);
    }

    private static WindowInsets getWindowInsetsFromServerForDisplay(int displayId, IBinder token, Rect bounds, boolean isScreenRound, int windowingMode) {
        try {
            InsetsState insetsState = new InsetsState();
            boolean alwaysConsumeSystemBars = WindowManagerGlobal.getWindowManagerService().getWindowInsets(displayId, token, insetsState);
            float overrideInvScale = CompatibilityInfo.getOverrideInvertedScale();
            if (overrideInvScale != 1.0f) {
                insetsState.scale(overrideInvScale);
            }
            return insetsState.calculateInsets(bounds, null, isScreenRound, alwaysConsumeSystemBars, 48, 0, 0, -1, windowingMode, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Set<WindowMetrics> getPossibleMaximumWindowMetrics(int displayId) {
        List<DisplayInfo> possibleDisplayInfos;
        try {
            possibleDisplayInfos = WindowManagerGlobal.getWindowManagerService().getPossibleDisplayInfo(displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        HashSet<WindowMetrics> maxMetrics = new HashSet<WindowMetrics>();
        for (int i = 0; i < possibleDisplayInfos.size(); ++i) {
            DisplayInfo currentDisplayInfo = possibleDisplayInfos.get(i);
            Rect maxBounds = new Rect(0, 0, currentDisplayInfo.logicalWidth, currentDisplayInfo.logicalHeight);
            boolean isScreenRound = (currentDisplayInfo.flags & 0x10) != 0;
            WindowInsets windowInsets = WindowMetricsController.getWindowInsetsFromServerForDisplay(currentDisplayInfo.displayId, null, new Rect(0, 0, currentDisplayInfo.getNaturalWidth(), currentDisplayInfo.getNaturalHeight()), isScreenRound, 1);
            windowInsets = new WindowInsets.Builder(windowInsets).setRoundedCorners(currentDisplayInfo.roundedCorners).setDisplayCutout(currentDisplayInfo.displayCutout).build();
            float density = (float)currentDisplayInfo.logicalDensityDpi * 0.00625f;
            maxMetrics.add(new WindowMetrics(maxBounds, windowInsets, density));
        }
        return maxMetrics;
    }
}

