/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.view.IWindow;
import android.view.IWindowSession;
import android.window.BackEvent;
import android.window.BackMotionEvent;
import android.window.BackProgressAnimator;
import android.window.CompatOnBackInvokedCallback;
import android.window.IOnBackInvokedCallback;
import android.window.ImeOnBackInvokedDispatcher;
import android.window.OnBackAnimationCallback;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedCallbackInfo;
import android.window.OnBackInvokedDispatcher;
import androidx.annotation.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;

public class WindowOnBackInvokedDispatcher
implements OnBackInvokedDispatcher {
    private IWindowSession mWindowSession;
    private IWindow mWindow;
    private static final String TAG = "WindowOnBackDispatcher";
    private static final boolean ENABLE_PREDICTIVE_BACK = SystemProperties.getInt("persist.wm.debug.predictive_back", 1) != 0;
    private static final boolean ALWAYS_ENFORCE_PREDICTIVE_BACK = SystemProperties.getInt("persist.wm.debug.predictive_back_always_enforce", 0) != 0;
    private ImeOnBackInvokedDispatcher mImeDispatcher;
    private final HashMap<OnBackInvokedCallback, Integer> mAllCallbacks = new HashMap();
    @VisibleForTesting
    public final TreeMap<Integer, ArrayList<OnBackInvokedCallback>> mOnBackInvokedCallbacks = new TreeMap();
    private Checker mChecker;
    private static final BackProgressAnimator mProgressAnimator = new BackProgressAnimator();

    public WindowOnBackInvokedDispatcher(Context context) {
        this.mChecker = new Checker(context);
    }

    public void attachToWindow(IWindowSession windowSession, IWindow window) {
        this.mWindowSession = windowSession;
        this.mWindow = window;
        if (!this.mAllCallbacks.isEmpty()) {
            this.setTopOnBackInvokedCallback(this.getTopCallback());
        }
    }

    public void detachFromWindow() {
        this.clear();
        this.mWindow = null;
        this.mWindowSession = null;
    }

    @Override
    public void registerOnBackInvokedCallback(int priority, OnBackInvokedCallback callback) {
        if (this.mChecker.checkApplicationCallbackRegistration(priority, callback)) {
            this.registerOnBackInvokedCallbackUnchecked(callback, priority);
        }
    }

    public void registerOnBackInvokedCallbackUnchecked(OnBackInvokedCallback callback, int priority) {
        if (this.mImeDispatcher != null) {
            this.mImeDispatcher.registerOnBackInvokedCallback(priority, callback);
            return;
        }
        if (!this.mOnBackInvokedCallbacks.containsKey(priority)) {
            this.mOnBackInvokedCallbacks.put(priority, new ArrayList());
        }
        ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
        if (this.mAllCallbacks.containsKey(callback)) {
            Integer prevPriority = this.mAllCallbacks.get(callback);
            this.mOnBackInvokedCallbacks.get(prevPriority).remove(callback);
        }
        OnBackInvokedCallback previousTopCallback = this.getTopCallback();
        callbacks.add(callback);
        this.mAllCallbacks.put(callback, priority);
        if (previousTopCallback == null || previousTopCallback != callback && this.mAllCallbacks.get(previousTopCallback) <= priority) {
            this.setTopOnBackInvokedCallback(callback);
        }
    }

    @Override
    public void unregisterOnBackInvokedCallback(OnBackInvokedCallback callback) {
        if (this.mImeDispatcher != null) {
            this.mImeDispatcher.unregisterOnBackInvokedCallback(callback);
            return;
        }
        if (!this.mAllCallbacks.containsKey(callback)) {
            return;
        }
        OnBackInvokedCallback previousTopCallback = this.getTopCallback();
        Integer priority = this.mAllCallbacks.get(callback);
        ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
        callbacks.remove(callback);
        if (callbacks.isEmpty()) {
            this.mOnBackInvokedCallbacks.remove(priority);
        }
        this.mAllCallbacks.remove(callback);
        if (previousTopCallback == callback) {
            this.sendCancelledIfInProgress(callback);
            this.setTopOnBackInvokedCallback(this.getTopCallback());
        }
    }

    private void sendCancelledIfInProgress(OnBackInvokedCallback callback) {
        boolean isInProgress = mProgressAnimator.isBackAnimationInProgress();
        if (isInProgress && callback instanceof OnBackAnimationCallback) {
            OnBackAnimationCallback animatedCallback = (OnBackAnimationCallback)callback;
            animatedCallback.onBackCancelled();
        } else {
            Log.w(TAG, "sendCancelIfRunning: isInProgress=" + isInProgress + "callback=" + callback);
        }
    }

    @Override
    public void registerSystemOnBackInvokedCallback(OnBackInvokedCallback callback) {
        this.registerOnBackInvokedCallbackUnchecked(callback, -1);
    }

    public void clear() {
        if (this.mImeDispatcher != null) {
            this.mImeDispatcher.clear();
            this.mImeDispatcher = null;
        }
        if (!this.mAllCallbacks.isEmpty()) {
            OnBackInvokedCallback topCallback = this.getTopCallback();
            if (topCallback != null) {
                this.sendCancelledIfInProgress(topCallback);
            } else {
                Log.e(TAG, "There is no topCallback, even if mAllCallbacks is not empty");
            }
            this.setTopOnBackInvokedCallback(null);
        }
        Handler.getMain().post(mProgressAnimator::reset);
        this.mAllCallbacks.clear();
        this.mOnBackInvokedCallbacks.clear();
    }

    private void setTopOnBackInvokedCallback(OnBackInvokedCallback callback) {
        if (this.mWindowSession == null || this.mWindow == null) {
            return;
        }
        try {
            OnBackInvokedCallbackInfo callbackInfo = null;
            if (callback != null) {
                int priority = this.mAllCallbacks.get(callback);
                IOnBackInvokedCallback iCallback = callback instanceof ImeOnBackInvokedDispatcher.ImeOnBackInvokedCallback ? ((ImeOnBackInvokedDispatcher.ImeOnBackInvokedCallback)callback).getIOnBackInvokedCallback() : new OnBackInvokedCallbackWrapper(callback);
                callbackInfo = new OnBackInvokedCallbackInfo(iCallback, priority, callback instanceof OnBackAnimationCallback);
            }
            this.mWindowSession.setOnBackInvokedCallbackInfo(this.mWindow, callbackInfo);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set OnBackInvokedCallback to WM. Error: " + e);
        }
    }

    public OnBackInvokedCallback getTopCallback() {
        if (this.mAllCallbacks.isEmpty()) {
            return null;
        }
        for (Integer priority : this.mOnBackInvokedCallbacks.descendingKeySet()) {
            ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
            if (callbacks.isEmpty()) continue;
            return callbacks.get(callbacks.size() - 1);
        }
        return null;
    }

    public void updateContext(Context context) {
        this.mChecker = new Checker(context);
    }

    public boolean isOnBackInvokedCallbackEnabled() {
        return Checker.isOnBackInvokedCallbackEnabled(this.mChecker.getContext());
    }

    public void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "    ";
        writer.println(prefix + "WindowOnBackDispatcher:");
        if (this.mAllCallbacks.isEmpty()) {
            writer.println(prefix + "<None>");
            return;
        }
        writer.println(innerPrefix + "Top Callback: " + this.getTopCallback());
        writer.println(innerPrefix + "Callbacks: ");
        this.mAllCallbacks.forEach((callback, priority) -> writer.println(innerPrefix + "  Callback: " + callback + " Priority=" + priority));
    }

    public static boolean isOnBackInvokedCallbackEnabled(Context context) {
        return Checker.isOnBackInvokedCallbackEnabled(context);
    }

    @Override
    public void setImeOnBackInvokedDispatcher(ImeOnBackInvokedDispatcher imeDispatcher) {
        this.mImeDispatcher = imeDispatcher;
    }

    public boolean hasImeOnBackInvokedDispatcher() {
        return this.mImeDispatcher != null;
    }

    public static class Checker {
        private WeakReference<Context> mContext;

        public Checker(Context context) {
            this.mContext = new WeakReference<Context>(context);
        }

        public boolean checkApplicationCallbackRegistration(int priority, OnBackInvokedCallback callback) {
            if (!Checker.isOnBackInvokedCallbackEnabled(this.getContext()) && !(callback instanceof CompatOnBackInvokedCallback)) {
                Log.w(WindowOnBackInvokedDispatcher.TAG, "OnBackInvokedCallback is not enabled for the application.\nSet 'android:enableOnBackInvokedCallback=\"true\"' in the application manifest.");
                return false;
            }
            if (priority < 0) {
                throw new IllegalArgumentException("Application registered OnBackInvokedCallback cannot have negative priority. Priority: " + priority);
            }
            Objects.requireNonNull(callback);
            return true;
        }

        private Context getContext() {
            return (Context)this.mContext.get();
        }

        private static boolean isOnBackInvokedCallbackEnabled(Context context) {
            boolean featureFlagEnabled = ENABLE_PREDICTIVE_BACK;
            if (!featureFlagEnabled) {
                return false;
            }
            if (ALWAYS_ENFORCE_PREDICTIVE_BACK) {
                return true;
            }
            if (context == null) {
                Log.w(WindowOnBackInvokedDispatcher.TAG, "OnBackInvokedCallback is not enabled because context is null.");
                return false;
            }
            boolean requestsPredictiveBack = false;
            while (context instanceof ContextWrapper && !(context instanceof Activity)) {
                context = ((ContextWrapper)context).getBaseContext();
            }
            boolean shouldCheckActivity = false;
            if (context instanceof Activity) {
                Activity activity = (Activity)context;
                ActivityInfo activityInfo = activity.getActivityInfo();
                if (activityInfo != null) {
                    if (activityInfo.hasOnBackInvokedCallbackEnabled()) {
                        shouldCheckActivity = true;
                        requestsPredictiveBack = activityInfo.isOnBackInvokedCallbackEnabled();
                    }
                } else {
                    Log.w(WindowOnBackInvokedDispatcher.TAG, "The ActivityInfo is null, so we cannot verify if this Activity has the 'android:enableOnBackInvokedCallback' attribute. The application attribute will be used as a fallback.");
                }
            }
            if (!shouldCheckActivity) {
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                requestsPredictiveBack = applicationInfo.isOnBackInvokedCallbackEnabled();
            }
            return requestsPredictiveBack;
        }
    }

    static class OnBackInvokedCallbackWrapper
    extends IOnBackInvokedCallback.Stub {
        final CallbackRef mCallbackRef;

        OnBackInvokedCallbackWrapper(OnBackInvokedCallback callback) {
            this.mCallbackRef = new CallbackRef(callback, true);
        }

        OnBackInvokedCallbackWrapper(OnBackInvokedCallback callback, boolean useWeakRef) {
            this.mCallbackRef = new CallbackRef(callback, useWeakRef);
        }

        @Override
        public void onBackStarted(BackMotionEvent backEvent) {
            Handler.getMain().post(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                if (callback != null) {
                    mProgressAnimator.onBackStarted(backEvent, event -> callback.onBackProgressed(event));
                    callback.onBackStarted(new BackEvent(backEvent.getTouchX(), backEvent.getTouchY(), backEvent.getProgress(), backEvent.getSwipeEdge()));
                }
            });
        }

        @Override
        public void onBackProgressed(BackMotionEvent backEvent) {
            Handler.getMain().post(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                if (callback != null) {
                    mProgressAnimator.onBackProgressed(backEvent);
                }
            });
        }

        @Override
        public void onBackCancelled() {
            Handler.getMain().post(() -> mProgressAnimator.onBackCancelled(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                if (callback != null) {
                    callback.onBackCancelled();
                }
            }));
        }

        @Override
        public void onBackInvoked() throws RemoteException {
            Handler.getMain().post(() -> {
                boolean isInProgress = mProgressAnimator.isBackAnimationInProgress();
                mProgressAnimator.reset();
                OnBackInvokedCallback callback = this.mCallbackRef.get();
                if (callback == null) {
                    Log.d(WindowOnBackInvokedDispatcher.TAG, "Trying to call onBackInvoked() on a null callback reference.");
                    return;
                }
                if (callback instanceof OnBackAnimationCallback && !isInProgress) {
                    Log.w(WindowOnBackInvokedDispatcher.TAG, "ProgressAnimator was not in progress, skip onBackInvoked().");
                    return;
                }
                callback.onBackInvoked();
            });
        }

        private OnBackAnimationCallback getBackAnimationCallback() {
            OnBackInvokedCallback callback = this.mCallbackRef.get();
            return callback instanceof OnBackAnimationCallback ? (OnBackAnimationCallback)callback : null;
        }

        static class CallbackRef {
            final WeakReference<OnBackInvokedCallback> mWeakRef;
            final OnBackInvokedCallback mStrongRef;

            CallbackRef(OnBackInvokedCallback callback, boolean useWeakRef) {
                if (useWeakRef) {
                    this.mWeakRef = new WeakReference<OnBackInvokedCallback>(callback);
                    this.mStrongRef = null;
                } else {
                    this.mStrongRef = callback;
                    this.mWeakRef = null;
                }
            }

            OnBackInvokedCallback get() {
                if (this.mStrongRef != null) {
                    return this.mStrongRef;
                }
                return (OnBackInvokedCallback)this.mWeakRef.get();
            }
        }
    }
}

