/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityThread;
import android.app.IWindowToken;
import android.app.ResourcesManager;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.inputmethodservice.AbstractInputMethodService;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os._Original_Build;
import android.util.Log;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import android.window.ConfigurationHelper;
import android.window.WindowContext;
import android.window.WindowProviderService;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.function.pooled.PooledLambda;
import java.lang.ref.WeakReference;

public class WindowTokenClient
extends IWindowToken.Stub {
    private static final String TAG = WindowTokenClient.class.getSimpleName();
    private WeakReference<Context> mContextRef = null;
    private final ResourcesManager mResourcesManager = ResourcesManager.getInstance();
    private IWindowManager mWms;
    @GuardedBy(value={"itself"})
    private final Configuration mConfiguration = new Configuration();
    private boolean mShouldDumpConfigForIme;
    private boolean mAttachToWindowContainer;
    private final Handler mHandler = ActivityThread.currentActivityThread().getHandler();

    public void attachContext(Context context) {
        if (this.mContextRef != null) {
            throw new IllegalStateException("Context is already attached.");
        }
        this.mContextRef = new WeakReference<Context>(context);
        this.mShouldDumpConfigForIme = _Original_Build.IS_DEBUGGABLE && context instanceof AbstractInputMethodService;
    }

    public boolean attachToDisplayArea(int type, int displayId, Bundle options) {
        try {
            Configuration configuration = this.getWindowManagerService().attachWindowContextToDisplayArea(this, type, displayId, options);
            if (configuration == null) {
                return false;
            }
            this.onConfigurationChanged(configuration, displayId, false);
            this.mAttachToWindowContainer = true;
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean attachToDisplayContent(int displayId) {
        IWindowManager wms = this.getWindowManagerService();
        if (wms == null) {
            return false;
        }
        try {
            Configuration configuration = wms.attachToDisplayContent(this, displayId);
            if (configuration == null) {
                return false;
            }
            this.onConfigurationChanged(configuration, displayId, false);
            this.mAttachToWindowContainer = true;
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void attachToWindowToken(IBinder windowToken) {
        try {
            this.getWindowManagerService().attachWindowContextToWindowToken(this, windowToken);
            this.mAttachToWindowContainer = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void detachFromWindowContainerIfNeeded() {
        if (!this.mAttachToWindowContainer) {
            return;
        }
        try {
            this.getWindowManagerService().detachWindowContextFromWindowContainer(this);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IWindowManager getWindowManagerService() {
        if (this.mWms == null) {
            this.mWms = WindowManagerGlobal.getWindowManagerService();
        }
        return this.mWms;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig, int newDisplayId) {
        this.mHandler.post(PooledLambda.obtainRunnable(this::onConfigurationChanged, newConfig, newDisplayId, true).recycleOnUse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void onConfigurationChanged(Configuration newConfig, int newDisplayId, boolean shouldReportConfigChange) {
        Configuration currentConfig;
        int diff;
        boolean shouldUpdateResources;
        boolean displayChanged;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        CompatibilityInfo.applyOverrideScaleIfNeeded(newConfig);
        Configuration configuration = this.mConfiguration;
        synchronized (configuration) {
            displayChanged = ConfigurationHelper.isDifferentDisplay(context.getDisplayId(), newDisplayId);
            shouldUpdateResources = ConfigurationHelper.shouldUpdateResources(this, this.mConfiguration, newConfig, newConfig, displayChanged, null);
            diff = this.mConfiguration.diffPublicOnly(newConfig);
            Configuration configuration2 = currentConfig = this.mShouldDumpConfigForIme ? new Configuration(this.mConfiguration) : null;
            if (shouldUpdateResources) {
                this.mConfiguration.setTo(newConfig);
            }
        }
        if (!shouldUpdateResources && this.mShouldDumpConfigForIme) {
            Log.d(TAG, "Configuration not dispatch to IME because configuration is up to date. Current config=" + context.getResources().getConfiguration() + ", reported config=" + currentConfig + ", updated config=" + newConfig);
        }
        if (shouldUpdateResources) {
            this.mResourcesManager.updateResourcesForActivity(this, newConfig, newDisplayId);
            if (shouldReportConfigChange && context instanceof WindowContext) {
                WindowContext windowContext = (WindowContext)context;
                windowContext.dispatchConfigurationChanged(newConfig);
            }
            if (shouldReportConfigChange && diff != 0 && context instanceof WindowProviderService) {
                WindowProviderService windowProviderService = (WindowProviderService)context;
                windowProviderService.onConfigurationChanged(newConfig);
            }
            ConfigurationHelper.freeTextLayoutCachesIfNeeded(diff);
            if (this.mShouldDumpConfigForIme) {
                if (!shouldReportConfigChange) {
                    Log.d(TAG, "Only apply configuration update to Resources because shouldReportConfigChange is false.\n" + Debug.getCallers(5));
                } else if (diff == 0) {
                    Log.d(TAG, "Configuration not dispatch to IME because configuration has no  public difference with updated config.  Current config=" + context.getResources().getConfiguration() + ", reported config=" + currentConfig + ", updated config=" + newConfig);
                }
            }
        }
        if (displayChanged) {
            context.updateDisplay(newDisplayId);
        }
    }

    @Override
    public void onWindowTokenRemoved() {
        this.mHandler.post(PooledLambda.obtainRunnable(WindowTokenClient::onWindowTokenRemovedInner, this).recycleOnUse());
    }

    private void onWindowTokenRemovedInner() {
        Context context = (Context)this.mContextRef.get();
        if (context != null) {
            context.destroy();
            this.mContextRef.clear();
        }
    }
}

