/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import com.android.adservices.LogUtil;
import java.util.List;

public class AdServicesCommon {
    public static final String ACTION_TOPICS_SERVICE = "android.adservices.TOPICS_SERVICE";
    public static final String ACTION_CUSTOM_AUDIENCE_SERVICE = "android.adservices.customaudience.CUSTOM_AUDIENCE_SERVICE";
    public static final String ACTION_AD_SELECTION_SERVICE = "android.adservices.adselection.AD_SELECTION_SERVICE";
    public static final String ACTION_MEASUREMENT_SERVICE = "android.adservices.MEASUREMENT_SERVICE";
    public static final String ACTION_ADID_SERVICE = "android.adservices.ADID_SERVICE";
    public static final String ACTION_ADID_PROVIDER_SERVICE = "android.adservices.adid.AdIdProviderService";
    public static final String ACTION_APPSETID_SERVICE = "android.adservices.APPSETID_SERVICE";
    public static final String ACTION_APPSETID_PROVIDER_SERVICE = "android.adservices.appsetid.AppSetIdProviderService";
    public static final String ACTION_AD_SERVICES_COMMON_SERVICE = "android.adservices.AD_SERVICES_COMMON_SERVICE";
    public static final String ADSERVICES_APK_PACKAGE_NAME_SUFFIX = "android.adservices";
    public static final String ADEXTSERVICES_PACKAGE_NAME_SUFFIX = "android.ext.adservices.api";
    public static final String EXTSERVICES_APEX_NAME_SUFFIX = "android.extservices";

    private AdServicesCommon() {
    }

    public static ServiceInfo resolveAdServicesService(List<ResolveInfo> intentResolveInfos, String intentAction) {
        if (intentResolveInfos == null || intentResolveInfos.isEmpty()) {
            LogUtil.e("Failed to find resolveInfo for adServices service. Intent action: " + intentAction);
            return null;
        }
        if (intentResolveInfos.size() > 2) {
            StringBuilder intents = new StringBuilder("");
            for (ResolveInfo intentResolveInfo : intentResolveInfos) {
                if (intentResolveInfo == null || intentResolveInfo.serviceInfo == null) continue;
                intents.append(intentResolveInfo.serviceInfo.packageName);
            }
            LogUtil.e("Found multiple services " + intents + " for " + intentAction);
            return null;
        }
        ServiceInfo serviceInfo = null;
        switch (intentResolveInfos.size()) {
            case 2: {
                if (intentResolveInfos.get(0) != null && intentResolveInfos.get((int)0).serviceInfo != null && intentResolveInfos.get((int)0).serviceInfo.packageName != null && intentResolveInfos.get((int)0).serviceInfo.packageName.contains(ADSERVICES_APK_PACKAGE_NAME_SUFFIX)) {
                    serviceInfo = intentResolveInfos.get((int)0).serviceInfo;
                    break;
                }
                if (intentResolveInfos.get(1) == null || intentResolveInfos.get((int)1).serviceInfo == null || intentResolveInfos.get((int)1).serviceInfo.packageName == null || !intentResolveInfos.get((int)1).serviceInfo.packageName.contains(ADSERVICES_APK_PACKAGE_NAME_SUFFIX)) break;
                serviceInfo = intentResolveInfos.get((int)1).serviceInfo;
                break;
            }
            case 1: {
                serviceInfo = intentResolveInfos.get((int)0).serviceInfo;
            }
        }
        return serviceInfo;
    }
}

