/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import com.android.adservices.LogUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AdServicesParcelableUtil {
    public static <T> void writeNullableToParcel(Parcel targetParcel, T nullableField, ParcelWriter<T> parcelWriter) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(parcelWriter);
        boolean isFieldPresent = nullableField != null;
        targetParcel.writeBoolean(isFieldPresent);
        if (isFieldPresent) {
            parcelWriter.write(targetParcel, nullableField);
        }
    }

    public static <T> T readNullableFromParcel(Parcel sourceParcel, ParcelReader<T> parcelReader) {
        Objects.requireNonNull(sourceParcel);
        Objects.requireNonNull(parcelReader);
        if (sourceParcel.readBoolean()) {
            return parcelReader.read(sourceParcel);
        }
        return null;
    }

    public static <K, V extends Parcelable> void writeMapToParcel(Parcel targetParcel, Map<K, V> sourceMap) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceMap);
        Bundle tempBundle = new Bundle();
        for (Map.Entry<K, V> entry : sourceMap.entrySet()) {
            tempBundle.putParcelable(entry.getKey().toString(), (Parcelable)entry.getValue());
        }
        targetParcel.writeBundle(tempBundle);
    }

    public static <K, V extends Parcelable> Map<K, V> readMapFromParcel(Parcel sourceParcel, StringToObjectConverter<K> stringToKeyConverter, Class<V> valueClass) {
        Objects.requireNonNull(sourceParcel);
        Objects.requireNonNull(stringToKeyConverter);
        Objects.requireNonNull(valueClass);
        Bundle tempBundle = Bundle.CREATOR.createFromParcel(sourceParcel);
        tempBundle.setClassLoader(valueClass.getClassLoader());
        HashMap resultMap = new HashMap();
        for (String key : tempBundle.keySet()) {
            Object value = _Original_Build.VERSION.SDK_INT < 33 ? tempBundle.getParcelable(key) : (Parcelable)tempBundle.getParcelable(key, valueClass);
            resultMap.put(stringToKeyConverter.convertFromString(key), value);
        }
        return resultMap;
    }

    public static <T extends Parcelable> void writeSetToParcel(Parcel targetParcel, Set<T> sourceSet) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceSet);
        ArrayList<T> tempList = new ArrayList<T>(sourceSet);
        targetParcel.writeTypedList(tempList);
    }

    public static <T extends Parcelable> Set<T> readSetFromParcel(Parcel sourceParcel, Parcelable.Creator<T> creator) {
        Objects.requireNonNull(sourceParcel);
        Objects.requireNonNull(creator);
        return new HashSet(Objects.requireNonNull(sourceParcel.createTypedArrayList(creator)));
    }

    public static void writeStringSetToParcel(Parcel targetParcel, Set<String> sourceSet) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceSet);
        ArrayList<String> tempList = new ArrayList<String>(sourceSet);
        targetParcel.writeStringList(tempList);
    }

    public static Set<String> readStringSetFromParcel(Parcel sourceParcel) {
        Objects.requireNonNull(sourceParcel);
        return new HashSet<String>((Collection)Objects.requireNonNull(sourceParcel.createStringArrayList()));
    }

    public static void writeInstantListToParcel(Parcel targetParcel, List<Instant> sourceList) {
        Objects.requireNonNull(targetParcel);
        Objects.requireNonNull(sourceList);
        long[] tempArray = new long[sourceList.size()];
        int actualArraySize = 0;
        for (Instant instant : sourceList) {
            long instantAsEpochMilli;
            try {
                instantAsEpochMilli = instant.toEpochMilli();
            }
            catch (Exception exception) {
                LogUtil.w(exception, "Error encountered while parceling Instant %s to long; skipping element", instant);
                continue;
            }
            tempArray[actualArraySize++] = instantAsEpochMilli;
        }
        long[] writeArray = new long[actualArraySize];
        System.arraycopy(tempArray, 0, writeArray, 0, actualArraySize);
        targetParcel.writeInt(actualArraySize);
        targetParcel.writeLongArray(writeArray);
    }

    public static List<Instant> readInstantListFromParcel(Parcel sourceParcel) {
        Objects.requireNonNull(sourceParcel);
        int listSize = sourceParcel.readInt();
        long[] tempArray = new long[listSize];
        ArrayList<Instant> targetList = new ArrayList<Instant>(listSize);
        sourceParcel.readLongArray(tempArray);
        for (int ii = 0; ii < listSize; ++ii) {
            Instant instantFromMilli;
            try {
                instantFromMilli = Instant.ofEpochMilli(tempArray[ii]);
            }
            catch (Exception exception) {
                LogUtil.w(exception, "Error encountered while unparceling Instant from long %d; skipping element", tempArray[ii]);
                continue;
            }
            targetList.add(instantFromMilli);
        }
        return targetList;
    }

    @FunctionalInterface
    public static interface ParcelWriter<T> {
        public void write(Parcel var1, T var2);
    }

    @FunctionalInterface
    public static interface ParcelReader<T> {
        public T read(Parcel var1);
    }

    @FunctionalInterface
    public static interface StringToObjectConverter<T> {
        public T convertFromString(String var1);
    }
}

