/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import com.android.adservices.AdServicesCommon;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import com.android.internal.annotations.GuardedBy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class AndroidServiceBinder<T>
extends ServiceBinder<T> {
    private static final int BIND_FLAGS = 65;
    private static final int BINDER_CONNECTION_TIMEOUT_MS = 5000;
    private final String mServiceIntentAction;
    private final Function<IBinder, T> mBinderConverter;
    private final Context mContext;
    private CountDownLatch mConnectionCountDownLatch;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private T mService;
    @GuardedBy(value={"mLock"})
    private ServiceConnection mServiceConnection;

    protected AndroidServiceBinder(Context context, String serviceIntentAction, Function<IBinder, T> converter) {
        this.mServiceIntentAction = serviceIntentAction;
        this.mContext = context;
        this.mBinderConverter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != null) {
                return this.mService;
            }
            if (this.mServiceConnection == null) {
                ComponentName componentName = this.getServiceComponentName();
                if (componentName == null) {
                    LogUtil.e("Failed to find AdServices service");
                    return null;
                }
                Intent intent = new Intent(this.mServiceIntentAction).setComponent(componentName);
                LogUtil.d("bindService: " + this.mServiceIntentAction);
                this.mConnectionCountDownLatch = new CountDownLatch(1);
                this.mServiceConnection = new AdServicesServiceConnection();
                try {
                    boolean success = this.mContext.bindService(intent, 65, Runnable::run, this.mServiceConnection);
                    if (!success) {
                        LogUtil.e("Failed to bindService: " + intent);
                        this.mServiceConnection = null;
                        return null;
                    }
                    LogUtil.d("bindService() started...");
                }
                catch (Exception e) {
                    LogUtil.e("Caught unexpected exception during service binding: " + e.getMessage());
                    this.mServiceConnection = null;
                    return null;
                }
            } else {
                LogUtil.d("There is already a pending connection!");
            }
        }
        try {
            this.mConnectionCountDownLatch.await(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread interrupted");
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mService == null) {
                throw new IllegalStateException("Service is not available.");
            }
            return this.mService;
        }
    }

    private ComponentName getServiceComponentName() {
        if (!(this.mServiceIntentAction.equals("android.adservices.TOPICS_SERVICE") || this.mServiceIntentAction.equals("android.adservices.MEASUREMENT_SERVICE") || this.mServiceIntentAction.equals("android.adservices.customaudience.CUSTOM_AUDIENCE_SERVICE") || this.mServiceIntentAction.equals("android.adservices.adselection.AD_SELECTION_SERVICE") || this.mServiceIntentAction.equals("android.adservices.ADID_SERVICE") || this.mServiceIntentAction.equals("android.adservices.adid.AdIdProviderService") || this.mServiceIntentAction.equals("android.adservices.APPSETID_SERVICE") || this.mServiceIntentAction.equals("android.adservices.appsetid.AppSetIdProviderService") || this.mServiceIntentAction.equals("android.adservices.AD_SERVICES_COMMON_SERVICE"))) {
            LogUtil.e("Bad service intent action: " + this.mServiceIntentAction);
            return null;
        }
        Intent intent = new Intent(this.mServiceIntentAction);
        List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentServices(intent, 0x100000);
        ServiceInfo serviceInfo = AdServicesCommon.resolveAdServicesService(resolveInfos, this.mServiceIntentAction);
        if (serviceInfo == null) {
            LogUtil.e("Failed to find serviceInfo for adServices service");
            return null;
        }
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFromService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                LogUtil.d("unbinding...");
                this.mContext.unbindService(this.mServiceConnection);
            }
            this.mServiceConnection = null;
            this.mService = null;
        }
    }

    private class AdServicesServiceConnection
    implements ServiceConnection {
        private AdServicesServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            LogUtil.d("onServiceConnected " + AndroidServiceBinder.this.mServiceIntentAction);
            Object object = AndroidServiceBinder.this.mLock;
            synchronized (object) {
                AndroidServiceBinder.this.mService = AndroidServiceBinder.this.mBinderConverter.apply(service);
            }
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            LogUtil.d("onServiceDisconnected " + AndroidServiceBinder.this.mServiceIntentAction);
            AndroidServiceBinder.this.unbindFromService();
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }

        @Override
        public void onBindingDied(ComponentName name) {
            LogUtil.d("onBindingDied " + AndroidServiceBinder.this.mServiceIntentAction);
            AndroidServiceBinder.this.unbindFromService();
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }

        @Override
        public void onNullBinding(ComponentName name) {
            LogUtil.e("onNullBinding " + AndroidServiceBinder.this.mServiceIntentAction);
            AndroidServiceBinder.this.unbindFromService();
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }
    }
}

