/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.util.Log;
import java.util.Locale;

public class LoggerFactory {
    public static final String TAG = "adservices";
    public static final String TOPICS_TAG = "adservices.topics";
    public static final String FLEDGE_TAG = "adservices.fledge";
    public static final String MEASUREMENT_TAG = "adservices.measurement";
    public static final String UI_TAG = "adservices.ui";
    public static final String ADID_TAG = "adservices.adid";
    public static final String APPSETID_TAG = "adservices.appsetid";
    private static final Logger sLogger = new Logger("adservices");
    private static final Logger sTopicsLogger = new Logger("adservices.topics");
    private static final Logger sFledgeLogger = new Logger("adservices.fledge");
    private static final Logger sMeasurementLogger = new Logger("adservices.measurement");
    private static final Logger sUILogger = new Logger("adservices.ui");
    private static final Logger sAdIDLogger = new Logger("adservices.adid");
    private static final Logger sAppSetIDLogger = new Logger("adservices.appsetid");

    public static Logger getLogger() {
        return sLogger;
    }

    public static Logger getTopicsLogger() {
        return sTopicsLogger;
    }

    public static Logger getFledgeLogger() {
        return sFledgeLogger;
    }

    public static Logger getMeasurementLogger() {
        return sMeasurementLogger;
    }

    public static Logger getUILogger() {
        return sUILogger;
    }

    public static Logger getAdIDLogger() {
        return sAdIDLogger;
    }

    public static Logger getAppSetIDLogger() {
        return sAppSetIDLogger;
    }

    public static class Logger {
        private final String mTag;

        private Logger(String mTag) {
            this.mTag = mTag;
        }

        public int v(String msg) {
            if (Log.isLoggable(this.mTag, 2)) {
                return Log.v(this.mTag, msg);
            }
            return 0;
        }

        public int v(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 2)) {
                String msg = Logger.format(format, params);
                return Log.v(this.mTag, msg);
            }
            return 0;
        }

        public int d(String msg) {
            if (Log.isLoggable(this.mTag, 3)) {
                return Log.d(this.mTag, msg);
            }
            return 0;
        }

        public int d(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 3)) {
                String msg = Logger.format(format, params);
                return Log.d(this.mTag, msg);
            }
            return 0;
        }

        public int d(Throwable tr, String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 3)) {
                String msg = Logger.format(format, params);
                return Log.d(this.mTag, msg, tr);
            }
            return 0;
        }

        public int i(String msg) {
            if (Log.isLoggable(this.mTag, 4)) {
                return Log.i(this.mTag, msg);
            }
            return 0;
        }

        public int i(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 4)) {
                String msg = Logger.format(format, params);
                return Log.i(this.mTag, msg);
            }
            return 0;
        }

        public int w(String msg) {
            if (Log.isLoggable(this.mTag, 5)) {
                return Log.w(this.mTag, msg);
            }
            return 0;
        }

        public int w(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 5)) {
                String msg = Logger.format(format, params);
                return Log.w(this.mTag, msg);
            }
            return 0;
        }

        public int e(String msg) {
            if (Log.isLoggable(this.mTag, 6)) {
                return Log.e(this.mTag, msg);
            }
            return 0;
        }

        public int e(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 6)) {
                String msg = Logger.format(format, params);
                return Log.e(this.mTag, msg);
            }
            return 0;
        }

        public int e(Throwable tr, String msg) {
            if (Log.isLoggable(this.mTag, 6)) {
                if (Log.isLoggable(this.mTag, 3)) {
                    return Log.e(this.mTag, msg, tr);
                }
                msg = msg + ": " + tr;
                return Log.e(this.mTag, msg);
            }
            return 0;
        }

        public int e(Throwable tr, String format, Object ... params) {
            return Log.isLoggable(this.mTag, 6) ? this.e(tr, Logger.format(format, params)) : 0;
        }

        public int w(Throwable tr, String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 5)) {
                if (Log.isLoggable(this.mTag, 3)) {
                    String msg = Logger.format(format, params);
                    return Log.w(this.mTag, msg, tr);
                }
                String msg = Logger.format(format, params) + ": " + tr;
                return Log.w(this.mTag, msg);
            }
            return 0;
        }

        @Deprecated
        public int d(String msg, Throwable tr) {
            return this.d(tr, msg, new Object[0]);
        }

        @Deprecated
        public int w(String msg, Throwable tr) {
            return this.w(tr, msg, new Object[0]);
        }

        @Deprecated
        public int e(String msg, Throwable tr) {
            return this.e(tr, msg);
        }

        private static String format(String format, Object ... args) {
            return String.format(Locale.US, format, args);
        }
    }
}

